/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvAbstractDocument;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.docview.project.DataContainerEvent;
import ilog.views.appframe.docview.project.DataContainerListener;
import ilog.views.appframe.docview.project.IlvAddNodeEdit;
import ilog.views.appframe.docview.project.IlvDataContainer;
import ilog.views.appframe.docview.project.IlvDataContainerDocument;
import ilog.views.appframe.docview.project.IlvDataContainerProvider;
import ilog.views.appframe.docview.project.IlvProjectDataContainer;
import ilog.views.appframe.docview.project.IlvProjectDocument;
import ilog.views.appframe.docview.project.IlvRemoveNodeEdit;
import ilog.views.appframe.docview.project.IlvWorkspaceDataContainer;
import ilog.views.appframe.docview.project.NodePropertyChangeEvent;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.settings.IlvSettingsQuery;
import ilog.views.appframe.swing.IlvPopupMenu;
import ilog.views.appframe.swing.IlvTreeView;
import ilog.views.appframe.swing.util.IlvNewFolderDialog;
import ilog.views.appframe.util.IlvFileChooserSelection;
import ilog.views.appframe.util.IlvUtil;
import ilog.views.util.internal.IlvURLUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.CompoundEdit;

public class IlvExplorerView
extends IlvTreeView {
    PropertyChangeListener a;
    IlvDocument b;
    IlvDataContainer c;
    DataContainerListener d;
    HashMap e = new HashMap();
    HashMap f = new HashMap();
    public static final String DEFAULT_SETTINGS_TYPE = "explorerView";
    public static final String DEFAULT_SETTINGS_NAME = "default";
    public static final String INSERT_FOLDER_CMD = "InsertFolder";
    public static final String INSERT_FILE_CMD = "InsertFile";
    public static final String INSERT_PROJECT_CMD = "InsertProject";
    public static final String REMOVE_NODE_CMD = "RemoveProjecItem";
    public static final String OPEN_PROJECT_NODE_CMD = "OpenProjectNode";

    protected IlvExplorerView(String string, String string2) {
        super(string, string2);
    }

    public IlvExplorerView() {
        this(DEFAULT_SETTINGS_TYPE, DEFAULT_SETTINGS_NAME);
    }

    @Override
    public void initializeView(IlvDocument ilvDocument) {
        super.initializeView(ilvDocument);
        if (this.b != null) {
            this.b.removePropertyChangeListener(this.a);
        }
        this.b = ilvDocument;
        if (this.b != null) {
            ilvDocument.addPropertyChangeListener(this.a());
            if (ilvDocument instanceof IlvDataContainerProvider) {
                this.initializeView(((IlvDataContainerProvider)((Object)ilvDocument)).getDataContainer());
            }
        }
    }

    protected void initializeView(IlvDataContainer ilvDataContainer) {
        if (this.c != null) {
            this.c.removeDataContainerListener(this.d);
        }
        this.c = ilvDataContainer;
        ilvDataContainer.addDataContainerListener(this.b());
        this.e = new HashMap();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ilvDataContainer);
        this.a(defaultMutableTreeNode, null);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.getTree().setModel(defaultTreeModel);
    }

    @Override
    protected void initializeTree(JTree jTree) {
        super.initializeTree(jTree);
        jTree.setRootVisible(false);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                IlvApplication ilvApplication = IlvExplorerView.this.getApplication();
                if (ilvApplication != null) {
                    ilvApplication.updateActionsByCategory("Action.Category.Project");
                }
            }
        });
    }

    void a(MutableTreeNode mutableTreeNode, Object object) {
        int n = this.c.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = this.c.getChildAt(object, i);
            MutableTreeNode mutableTreeNode2 = this.a(object2);
            this.a(mutableTreeNode2, object2);
            mutableTreeNode.insert(mutableTreeNode2, i);
            this.e.put(object2, mutableTreeNode2);
        }
    }

    MutableTreeNode a(Object object) {
        return new DefaultMutableTreeNode(object);
    }

    public IlvDataContainer getDataContainer() {
        return this.c;
    }

    PropertyChangeListener a() {
        if (this.a != null) {
            return this.a;
        }
        this.a = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("DataContainer")) {
                    IlvExplorerView.this.initializeView((IlvDataContainer)propertyChangeEvent.getNewValue());
                }
            }
        };
        return this.a;
    }

    DataContainerListener b() {
        if (this.d != null) {
            return this.d;
        }
        this.d = new DataContainerListener(){

            @Override
            public void nodeAdded(DataContainerEvent dataContainerEvent) {
                MutableTreeNode mutableTreeNode = IlvExplorerView.this.a(dataContainerEvent.getNode());
                if (mutableTreeNode == null) {
                    return;
                }
                MutableTreeNode mutableTreeNode2 = null;
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)IlvExplorerView.this.getTree().getModel();
                boolean bl = true;
                if (dataContainerEvent.getParent() != null) {
                    mutableTreeNode2 = (MutableTreeNode)IlvExplorerView.this.e.get(dataContainerEvent.getParent());
                    bl = IlvExplorerView.this.getTree().isVisible(IlvExplorerView.this.a(mutableTreeNode2));
                } else {
                    mutableTreeNode2 = (MutableTreeNode)defaultTreeModel.getRoot();
                }
                defaultTreeModel.insertNodeInto(mutableTreeNode, mutableTreeNode2, dataContainerEvent.getIndex() > defaultTreeModel.getChildCount(mutableTreeNode2) ? defaultTreeModel.getChildCount(mutableTreeNode2) : dataContainerEvent.getIndex());
                if (bl) {
                    IlvExplorerView.this.b(IlvExplorerView.this.a(mutableTreeNode));
                }
                IlvExplorerView.this.e.put(dataContainerEvent.getNode(), mutableTreeNode);
            }

            @Override
            public void nodeRemoved(DataContainerEvent dataContainerEvent) {
                MutableTreeNode mutableTreeNode = (MutableTreeNode)IlvExplorerView.this.e.get(dataContainerEvent.getNode());
                if (mutableTreeNode != null) {
                    ((DefaultTreeModel)IlvExplorerView.this.getTree().getModel()).removeNodeFromParent(mutableTreeNode);
                    IlvExplorerView.this.e.remove(dataContainerEvent.getNode());
                }
            }

            @Override
            public void nodePropertyChanged(NodePropertyChangeEvent nodePropertyChangeEvent) {
                DefaultTreeModel defaultTreeModel;
                TreeNode treeNode;
                if (nodePropertyChangeEvent.getPropertyName().equals("Title") && (treeNode = (TreeNode)IlvExplorerView.this.e.get(nodePropertyChangeEvent.getNode())) != null && (defaultTreeModel = (DefaultTreeModel)IlvExplorerView.this.getTree().getModel()) != null) {
                    defaultTreeModel.nodeChanged(treeNode);
                }
            }
        };
        return this.d;
    }

    protected Icon getNodeIcon(Object object, boolean bl) {
        if (this.c == null) {
            return null;
        }
        String string = this.c.getCategory(object);
        if (string == null) {
            return null;
        }
        CategoryProperties categoryProperties = (CategoryProperties)this.f.get(string);
        if (categoryProperties == null) {
            return null;
        }
        return categoryProperties.getIcon(bl);
    }

    protected String getNodeText(Object object) {
        if (this.c == null) {
            return null;
        }
        String string = this.c.getTitle(object);
        IlvApplication ilvApplication = this.getApplication();
        return ilvApplication == null ? string : ilvApplication.getString(string);
    }

    @Override
    protected TreeCellRenderer createTreeCellRenderer(JTree jTree) {
        return new ExplorerRenderer();
    }

    @Override
    protected void readSettings(IlvSettingsElement ilvSettingsElement) {
        IlvApplication ilvApplication = this.getApplication();
        IlvSettingsQuery ilvSettingsQuery = new IlvSettingsQuery();
        ilvSettingsQuery.selectChildren("categories");
        ilvSettingsQuery.selectChildren("category");
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren(ilvSettingsQuery);
        this.f = new HashMap();
        for (int i = 0; i < ilvSettingsElementArray.length; ++i) {
            CategoryProperties categoryProperties = new CategoryProperties(ilvSettingsElementArray[i], ilvApplication);
            this.f.put(categoryProperties.getName(), categoryProperties);
        }
    }

    @Override
    protected void writeSettings(IlvSettingsElement ilvSettingsElement) {
    }

    @Override
    protected void nodeDoubleClicked(MouseEvent mouseEvent, TreeNode treeNode, Object object) {
        if (this.getDocument() instanceof IlvProjectDocument && object != null) {
            this.openNodes(new Object[]{object});
        }
    }

    @Override
    protected void nodeRightClicked(MouseEvent mouseEvent, TreeNode treeNode, Object object) {
        if (this.c == null) {
            return;
        }
        String string = this.c.getCategory(object);
        if (string == null) {
            return;
        }
        CategoryProperties categoryProperties = (CategoryProperties)this.f.get(string);
        if (categoryProperties == null) {
            return;
        }
        IlvPopupMenu ilvPopupMenu = categoryProperties.getPopupMenu();
        if (ilvPopupMenu != null) {
            ilvPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public boolean isProcessingAction(String string) {
        block2: {
            block3: {
                if (!this.c()) break block2;
                if (string.equals(INSERT_FOLDER_CMD)) break block3;
                if (string.equals(INSERT_FILE_CMD)) break block3;
                if (string.equals(INSERT_PROJECT_CMD)) break block3;
                if (string.equals(REMOVE_NODE_CMD)) break block3;
                if (!string.equals(OPEN_PROJECT_NODE_CMD)) break block2;
            }
            return true;
        }
        return super.isProcessingAction(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean updateAction(Action action) {
        String string = (String)action.getValue("ActionCommandKey");
        if (!this.c()) return super.updateAction(action);
        if (INSERT_FOLDER_CMD.equals(string)) {
            action.setEnabled(this.a(IlvProjectDataContainer.FOLDER_CATEGORY));
            return true;
        } else if (INSERT_FILE_CMD.equals(string)) {
            action.setEnabled(this.a(IlvProjectDataContainer.FILE_CATEGORY));
            return true;
        } else if (INSERT_PROJECT_CMD.equals(string)) {
            action.setEnabled(this.a(IlvProjectDataContainer.PROJECT_FILE_CATEGORY));
            return true;
        } else if (REMOVE_NODE_CMD.equals(string)) {
            action.setEnabled(this.canRemoveNodes(this.g()));
            return true;
        } else {
            if (!OPEN_PROJECT_NODE_CMD.equals(string)) return false;
            action.setEnabled(this.canOpenNodes(this.g()));
        }
        return true;
    }

    boolean c() {
        return this.c != null && this.c instanceof IlvProjectDataContainer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.c()) {
            if (INSERT_FOLDER_CMD.equals(string)) {
                if (this.a(IlvProjectDataContainer.FOLDER_CATEGORY)) {
                    this.insertNewFolder(this.f());
                }
            } else if (INSERT_FILE_CMD.equals(string)) {
                if (this.a(IlvProjectDataContainer.FILE_CATEGORY)) {
                    this.insertNewFiles(this.f());
                }
            } else if (INSERT_PROJECT_CMD.equals(string)) {
                if (this.a(IlvProjectDataContainer.PROJECT_FILE_CATEGORY)) {
                    this.insertNewProject(this.f());
                }
            } else if (REMOVE_NODE_CMD.equals(string)) {
                this.removeNodes(this.g());
            } else if (OPEN_PROJECT_NODE_CMD.equals(string)) {
                this.openNodes(this.g());
            }
        }
    }

    protected Object insertNewFolder(Object object) {
        String string = this.getNewFolderName(object);
        if (string == null) {
            return null;
        }
        Object object2 = ((IlvProjectDataContainer)this.getDataContainer()).insertFolder(object, string, -1);
        if (object2 == null) {
            return null;
        }
        if (this.b instanceof IlvAbstractDocument) {
            ((IlvAbstractDocument)this.b).addEdit(new IlvAddNodeEdit(this.getDataContainer(), object, object2, -1));
        }
        return object2;
    }

    protected Object[] insertNewFiles(Object object) {
        IlvFileChooserSelection[] ilvFileChooserSelectionArray = this.getApplication().showFileChooser(null, this.getApplication().getString("Swing.Project.InsertFile.Title"), 0, null, this.d());
        if (ilvFileChooserSelectionArray == null || ilvFileChooserSelectionArray.length == 0) {
            return new Object[0];
        }
        CompoundEdit compoundEdit = new CompoundEdit();
        Object[] objectArray = new Object[]{};
        IlvProjectDataContainer ilvProjectDataContainer = (IlvProjectDataContainer)this.getDataContainer();
        for (int i = 0; i < ilvFileChooserSelectionArray.length; ++i) {
            Object object2 = ilvProjectDataContainer.insertFileReference(object, ilvFileChooserSelectionArray[i].getURL(), -1);
            if (object2 == null) continue;
            compoundEdit.addEdit(new IlvAddNodeEdit(ilvProjectDataContainer, object, object2, -1));
            objectArray = IlvUtil.AddToArray(objectArray, object2);
        }
        IlvDocument ilvDocument = this.getDocument();
        if (ilvDocument instanceof IlvAbstractDocument) {
            ((IlvAbstractDocument)ilvDocument).addEdit(compoundEdit);
        }
        return objectArray;
    }

    protected Object[] insertNewProject(Object object) {
        if (!(this.getDataContainer() instanceof IlvWorkspaceDataContainer)) {
            return new Object[0];
        }
        IlvWorkspaceDataContainer ilvWorkspaceDataContainer = (IlvWorkspaceDataContainer)this.getDataContainer();
        IlvFileChooserSelection[] ilvFileChooserSelectionArray = this.getApplication().showFileChooser(null, this.getApplication().getString("Swing.Project.InsertProject.Title"), 0, null, this.d());
        if (ilvFileChooserSelectionArray == null || ilvFileChooserSelectionArray.length == 0) {
            return new Object[0];
        }
        CompoundEdit compoundEdit = new CompoundEdit();
        Object[] objectArray = new Object[]{};
        for (int i = 0; i < ilvFileChooserSelectionArray.length; ++i) {
            Object object2 = ilvWorkspaceDataContainer.addFileProjectReference(object, IlvURLUtil.convertFileURLToFilename(ilvFileChooserSelectionArray[i].getURL()), -1);
            if (object2 == null) continue;
            compoundEdit.addEdit(new IlvAddNodeEdit(ilvWorkspaceDataContainer, object, object2, -1));
            objectArray = IlvUtil.AddToArray(objectArray, object2);
        }
        IlvDocument ilvDocument = this.getDocument();
        if (ilvDocument instanceof IlvAbstractDocument) {
            ((IlvAbstractDocument)ilvDocument).addEdit(compoundEdit);
        }
        return objectArray;
    }

    protected boolean removeNodes(Object[] objectArray) {
        IlvDataContainer ilvDataContainer = this.getDataContainer();
        if (ilvDataContainer == null) {
            return false;
        }
        CompoundEdit compoundEdit = new CompoundEdit();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = ilvDataContainer.getParent(objectArray[i]);
            ilvDataContainer.removeNode(object, objectArray[i]);
            compoundEdit.addEdit(new IlvRemoveNodeEdit(ilvDataContainer, object, objectArray[i]));
        }
        IlvDocument ilvDocument = this.getDocument();
        if (ilvDocument instanceof IlvAbstractDocument) {
            ((IlvAbstractDocument)ilvDocument).addEdit(compoundEdit);
        }
        return true;
    }

    protected boolean canRemoveNodes(Object[] objectArray) {
        IlvDataContainer ilvDataContainer = this.getDataContainer();
        if (ilvDataContainer == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (ilvDataContainer.canRemove(ilvDataContainer.getParent(objectArray[i]), objectArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean openNodes(Object[] objectArray) {
        if (!this.canOpenNodes(objectArray)) {
            return false;
        }
        IlvDataContainerDocument ilvDataContainerDocument = (IlvDataContainerDocument)this.getDocument();
        if (ilvDataContainerDocument == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ilvDataContainerDocument.openDocument(objectArray[i]);
        }
        return true;
    }

    protected boolean canOpenNodes(Object[] objectArray) {
        IlvDocument ilvDocument = this.getDocument();
        if (ilvDocument == null || !(ilvDocument instanceof IlvDataContainerDocument)) {
            return false;
        }
        IlvDataContainerDocument ilvDataContainerDocument = (IlvDataContainerDocument)ilvDocument;
        for (int i = 0; i < objectArray.length; ++i) {
            if (ilvDataContainerDocument.canOpenDocument(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    protected String getNewFolderName(Object object) {
        IlvNewFolderDialog ilvNewFolderDialog = new IlvNewFolderDialog(this.getApplication(), this.getDataContainer(), object);
        Component component = this.d();
        Rectangle rectangle = component.getBounds();
        ((Component)ilvNewFolderDialog).setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        ilvNewFolderDialog.setVisible(true);
        String string = ilvNewFolderDialog.getInputText();
        return string != null && string.length() != 0 ? string : null;
    }

    Component d() {
        Component component = this.getApplication().getMainComponent();
        if (component != null) {
            return component;
        }
        return this;
    }

    TreeNode e() {
        JTree jTree = this.getTree();
        if (jTree.getSelectionCount() == 0) {
            return null;
        }
        TreePath treePath = jTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null || !(object instanceof TreeNode)) {
            return null;
        }
        return (TreeNode)object;
    }

    Object f() {
        TreeNode treeNode = this.e();
        if (treeNode == null) {
            return null;
        }
        if (!(treeNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return ((DefaultMutableTreeNode)treeNode).getUserObject();
    }

    boolean a(String string) {
        Object object = this.f();
        if (object == null) {
            return false;
        }
        return this.c.acceptChild(object, string);
    }

    Object[] g() {
        JTree jTree = this.getTree();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = null;
        for (int i = 0; i < treePathArray.length; ++i) {
            Object object = this.a(treePathArray[i]);
            if (object == null) continue;
            objectArray = IlvUtil.AddToArray(objectArray, object);
        }
        return objectArray == null ? new Object[]{} : objectArray;
    }

    protected boolean canRemoveTreeNode(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        return this.canRemoveDataContainerNode(this.getDataContainerNode(treeNode.getParent()), this.getDataContainerNode(treeNode));
    }

    Object a(TreePath treePath) {
        return this.getDataContainerNode(treePath.getLastPathComponent());
    }

    protected Object getDataContainerNode(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return ((DefaultMutableTreeNode)object).getUserObject();
    }

    protected boolean canRemoveDataContainerNode(Object object, Object object2) {
        return this.getDataContainer().canRemove(object, object2);
    }

    private TreePath a(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(0, treeNode);
            treeNode = treeNode.getParent();
        }
        return new TreePath(arrayList.toArray());
    }

    private void b(TreePath treePath) {
        if (treePath.getPathCount() != 1) {
            this.b(treePath.getParentPath());
        }
        this.getTree().expandPath(treePath);
    }

    static class CategoryProperties {
        String a;
        Icon b;
        Icon c;
        IlvPopupMenu d;

        public CategoryProperties(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) {
            this.readSettings(ilvSettingsElement, ilvApplication);
        }

        public void readSettings(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) {
            this.a = ilvSettingsElement.getString("name");
            String string = ilvSettingsElement.getString("icon");
            this.b = string == null ? null : ilvApplication.getImageIcon(string);
            string = ilvSettingsElement.getString("expandedIcon");
            this.c = string == null ? null : ilvApplication.getImageIcon(string);
            IlvSettingsElement ilvSettingsElement2 = ilvSettingsElement.getFirstChild("popupMenu");
            if (ilvSettingsElement2 != null) {
                this.d = new IlvPopupMenu();
                this.d.setApplication(ilvApplication);
                this.d.setSettingsElement(ilvSettingsElement2);
            } else {
                this.d = null;
            }
        }

        public String getName() {
            return this.a;
        }

        public Icon getIcon(boolean bl) {
            return bl ? (this.c != null ? this.c : this.b) : this.b;
        }

        public Icon getExpandedIcon() {
            return this.c;
        }

        public IlvPopupMenu getPopupMenu() {
            return this.d;
        }
    }

    class ExplorerRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode) {
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                Icon icon = IlvExplorerView.this.getNodeIcon(object2, bl2);
                if (icon != null) {
                    this.setIcon(icon);
                }
                this.setText(IlvExplorerView.this.getNodeText(object2));
            }
            return this;
        }
    }
}

