/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.bars;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.swing.bars.IlvAbstractConfiguration;
import ilog.views.appframe.swing.bars.IlvDockedComponentConfiguration;
import ilog.views.appframe.swing.bars.IlvDockedConfiguration;
import ilog.views.appframe.swing.bars.IlvSeparatorConfiguration;
import ilog.views.appframe.swing.bars.InsertionPoint;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;

public class IlvMultiRowPanelConfiguration {
    private int a;
    private Dimension b;
    private ArrayList c;
    private ArrayList d;
    private transient int e;
    private boolean f;
    private Dimension g;
    private boolean h;
    private static final Dimension i = new Dimension(15, 15);
    static final String j = "separator";
    private static final String k = "position";
    private static final String l = "row";

    public IlvMultiRowPanelConfiguration(int n) {
        this.a = n;
    }

    public IlvMultiRowPanelConfiguration(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration) {
        this.a = ilvMultiRowPanelConfiguration.a;
        if (ilvMultiRowPanelConfiguration.c == null) {
            this.c = null;
            this.d = null;
        } else {
            this.c = new ArrayList(ilvMultiRowPanelConfiguration.c);
            if (ilvMultiRowPanelConfiguration.d == null) {
                this.d = null;
            } else {
                this.d = new ArrayList(ilvMultiRowPanelConfiguration.d.size());
                for (int i = 0; i < ilvMultiRowPanelConfiguration.d.size(); ++i) {
                    Row row = ilvMultiRowPanelConfiguration.b(i);
                    this.d.add(new Row(row, this));
                }
            }
        }
        this.b = ilvMultiRowPanelConfiguration.b == null ? null : new Dimension(ilvMultiRowPanelConfiguration.b);
    }

    public IlvMultiRowPanelConfiguration(IlvSettingsElement ilvSettingsElement) {
        this.readSettings(ilvSettingsElement);
    }

    public final int getConfigurationCount() {
        return this.c == null ? 0 : this.c.size();
    }

    public final IlvDockedConfiguration getConfiguration(int n) {
        return (IlvDockedConfiguration)this.c.get(n);
    }

    public final IlvDockedComponentConfiguration getConfiguration(String string) {
        if (this.c == null) {
            return null;
        }
        for (int i = 0; i < this.c.size(); ++i) {
            IlvDockedConfiguration ilvDockedConfiguration = (IlvDockedConfiguration)this.c.get(i);
            if (ilvDockedConfiguration.isSeparator() || !ilvDockedConfiguration.getName().equals(string)) continue;
            return (IlvDockedComponentConfiguration)ilvDockedConfiguration;
        }
        return null;
    }

    public boolean containsConfiguration(String string) {
        return this.getConfiguration(string) != null;
    }

    public void removeConfiguration(IlvDockedConfiguration ilvDockedConfiguration) {
        Row row = this.b(ilvDockedConfiguration.getRow());
        if (row.removeConfiguration(ilvDockedConfiguration)) {
            this.c.remove(ilvDockedConfiguration);
            this.invalidate();
        }
    }

    public void setConfigurationVisible(IlvDockedConfiguration ilvDockedConfiguration, boolean bl) {
        if (ilvDockedConfiguration.isVisible() != bl) {
            ilvDockedConfiguration.setVisible(bl);
            this.invalidate();
        }
    }

    public void resizeConfiguration(IlvDockedConfiguration ilvDockedConfiguration, Dimension dimension) {
        if (!ilvDockedConfiguration.sameSize(dimension)) {
            ilvDockedConfiguration.setSize(dimension);
            this.invalidate();
        }
    }

    public int getOrientation() {
        return this.a;
    }

    public boolean isHorizontal() {
        return this.a == 1 || this.a == 3;
    }

    public boolean isValid() {
        return this.h;
    }

    public void invalidate() {
        this.setValid(false);
    }

    public void setValid(boolean bl) {
        this.h = bl;
    }

    public IlvDockedComponentConfiguration addConfiguration(String string, IlvDockedComponentConfiguration ilvDockedComponentConfiguration) {
        if (ilvDockedComponentConfiguration == null) {
            ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
        } else {
            ilvDockedComponentConfiguration.setRow(this.d == null ? 0 : this.d.size());
        }
        ilvDockedComponentConfiguration.setVisible(true);
        if (this.c == null) {
            this.c = new ArrayList();
        }
        this.c.add(ilvDockedComponentConfiguration);
        Row row = new Row();
        row.addConfiguration(ilvDockedComponentConfiguration);
        if (this.d == null) {
            this.d = new ArrayList();
        }
        this.d.add(row);
        this.invalidate();
        return ilvDockedComponentConfiguration;
    }

    public void readSettings(IlvSettingsElement ilvSettingsElement) {
        this.a = IlvMultiRowPanelConfiguration.a(ilvSettingsElement.getString("orientation", "top"));
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren(k);
        if (ilvSettingsElementArray == null || ilvSettingsElementArray.length == 0) {
            this.a(ilvSettingsElement);
            this.invalidate();
            return;
        }
        this.c = new ArrayList(ilvSettingsElementArray.length);
        this.d = new ArrayList();
        for (int i = 0; i < ilvSettingsElementArray.length; ++i) {
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(ilvSettingsElementArray[i]);
            this.c.add(ilvDockedComponentConfiguration);
            int n = ilvDockedComponentConfiguration.getRow();
            if (n == -1) {
                n = this.d.size();
                ilvDockedComponentConfiguration.setRow(n);
            }
            if (n >= this.d.size()) {
                for (int j = this.d.size(); j <= n; ++j) {
                    this.d.add(new Row());
                }
            }
            Row row = this.b(n);
            row.addConfiguration(ilvDockedComponentConfiguration);
        }
        this.invalidate();
    }

    private void a(IlvSettingsElement ilvSettingsElement) {
        this.f = true;
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren(l);
        if (ilvSettingsElementArray == null || ilvSettingsElementArray.length == 0) {
            this.c = new ArrayList();
            this.d = new ArrayList();
            return;
        }
        this.c = new ArrayList();
        this.d = new ArrayList(ilvSettingsElementArray.length);
        for (int i = 0; i < ilvSettingsElementArray.length; ++i) {
            IlvSettingsElement[] ilvSettingsElementArray2 = ilvSettingsElementArray[i].getChildren();
            if (ilvSettingsElementArray2 == null || ilvSettingsElementArray2.length == 0) {
                this.d.add(new Row());
                continue;
            }
            Row row = new Row(ilvSettingsElementArray2.length);
            for (int j = 0; j < ilvSettingsElementArray2.length; ++j) {
                IlvDockedConfiguration ilvDockedConfiguration = null;
                ilvDockedConfiguration = ilvSettingsElementArray2[j].getType().equals(j) ? new IlvSeparatorConfiguration(ilvSettingsElementArray2[j]) : new IlvDockedComponentConfiguration(ilvSettingsElementArray2[j]);
                this.c.add(ilvDockedConfiguration);
                row.addConfiguration(ilvDockedConfiguration);
                ilvDockedConfiguration.setRow(i);
            }
            this.d.add(row);
        }
    }

    public void writeSettings(IlvSettingsElement ilvSettingsElement) {
        IlvSettings ilvSettings = ilvSettingsElement.getSettings();
        ilvSettingsElement.setString("orientation", IlvMultiRowPanelConfiguration.a(this.a));
        ilvSettingsElement.removeAll(null);
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            Row row = this.b(i);
            IlvSettingsElement ilvSettingsElement2 = ilvSettings.createSettingsElement(l);
            for (int j = 0; j < row.size(); ++j) {
                IlvDockedConfiguration ilvDockedConfiguration = row.getConfiguration(j);
                IlvSettingsElement ilvSettingsElement3 = ilvSettings.createSettingsElement(ilvDockedConfiguration.isSeparator() ? j : k);
                ilvDockedConfiguration.writeSettings(ilvSettingsElement3);
                ilvSettingsElement2.add(ilvSettingsElement3);
            }
            ilvSettingsElement.add(ilvSettingsElement2);
        }
    }

    static String a(int n) {
        switch (n) {
            case 2: {
                return "left";
            }
            case 4: {
                return "right";
            }
            case 3: {
                return "bottom";
            }
            case 1: {
                return "top";
            }
        }
        return "top";
    }

    static int a(String string) {
        if (string.equals("top")) {
            return 1;
        }
        if (string.equals("left")) {
            return 2;
        }
        if (string.equals("right")) {
            return 4;
        }
        if (string.equals("bottom")) {
            return 3;
        }
        IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Unknown orientation " + string + ". Should use 'left', 'top', 'right' or 'bottom' values");
        return 1;
    }

    boolean a() {
        return this.e != 0;
    }

    void b() {
        ++this.e;
    }

    void c() {
        --this.e;
    }

    public Dimension getSize() {
        return this.b;
    }

    public void setSize(Dimension dimension) {
        this.b = dimension == null ? null : new Dimension(dimension);
    }

    public Dimension getComponentInterspaces() {
        return this.g;
    }

    public int getComponentInterspace() {
        return this.g == null ? 0 : (this.isHorizontal() ? this.g.width : this.g.height);
    }

    public void setComponentInterspaces(Dimension dimension) {
        if (dimension == null) {
            if (this.g == null) {
                return;
            }
            if (this.g.width == 0 && this.g.height == 0) {
                return;
            }
            this.g = new Dimension(0, 0);
            this.invalidate();
            return;
        }
        if (this.g != null && dimension.equals(this.g)) {
            return;
        }
        this.g = new Dimension(dimension);
        this.invalidate();
    }

    public int getRowCount() {
        return this.d == null ? 0 : this.d.size();
    }

    public Collection getConfigurations(int n) {
        if (this.d == null || this.d.size() <= n) {
            return null;
        }
        return this.b(n).getConfigurations();
    }

    private final Row b(int n) {
        if (this.d == null || n < 0 || n >= this.d.size()) {
            throw new IllegalArgumentException("Try to access to a row in a multi row panel with a bad index:" + n);
        }
        return (Row)this.d.get(n);
    }

    private Row c(int n) {
        Row row = null;
        if (this.d == null || this.d.size() == 0) {
            if (n != 0 && n != -1) {
                throw new IllegalArgumentException("Bad insertion index for a new row in a multi row panel configuration:" + n);
            }
            if (this.d == null) {
                this.d = new ArrayList();
            }
            row = new Row();
            this.d.add(row);
        } else {
            if (n == -1) {
                n = this.d.size();
            }
            if (n < 0 || n > this.d.size()) {
                throw new IllegalArgumentException("Bad insertion index for a new row in a multi row panel configuration:" + n);
            }
            row = new Row();
            this.d.add(n, row);
        }
        for (int i = n + 1; i < this.d.size(); ++i) {
            Row row2 = this.b(i);
            for (int j = 0; j < row2.size(); ++j) {
                IlvDockedConfiguration ilvDockedConfiguration = row2.getConfiguration(j);
                ilvDockedConfiguration.setRow(i);
            }
        }
        return row;
    }

    public void setRowBounds(int n, Rectangle rectangle) {
        this.b(n).setBounds(rectangle);
    }

    public Rectangle getRowBounds(int n) {
        return this.b(n).getBounds();
    }

    InsertionPoint a(Point point, Dimension dimension) {
        int n;
        int n2;
        Rectangle rectangle = new Rectangle(0, 0, this.b.width, this.b.height);
        boolean bl = this.isHorizontal();
        int n3 = 0;
        if (bl) {
            if (point.y < rectangle.y) {
                if (point.y < rectangle.y - IlvMultiRowPanelConfiguration.i.height) {
                    return null;
                }
                return new NewRowInsertPoint(this.a(rectangle, point.x, dimension), 0);
            }
            if (point.y > rectangle.y + rectangle.height) {
                if (point.y > rectangle.y + rectangle.height + IlvMultiRowPanelConfiguration.i.height) {
                    return null;
                }
                return new NewRowInsertPoint(this.a(rectangle, point.x, dimension), this.getRowCount());
            }
            if (point.x < rectangle.x - IlvMultiRowPanelConfiguration.i.width) {
                return null;
            }
            if (point.x >= rectangle.x + rectangle.width + IlvMultiRowPanelConfiguration.i.width) {
                return null;
            }
            n3 = this.a(rectangle, point.x, dimension);
        } else {
            if (point.x < rectangle.x) {
                if (point.x < rectangle.x - IlvMultiRowPanelConfiguration.i.width) {
                    return null;
                }
                return new NewRowInsertPoint(this.b(rectangle, point.y, dimension), 0);
            }
            if (point.x > rectangle.x + rectangle.width) {
                if (point.x > rectangle.x + rectangle.width + IlvMultiRowPanelConfiguration.i.width) {
                    return null;
                }
                return new NewRowInsertPoint(this.b(rectangle, point.y, dimension), this.getRowCount());
            }
            if (point.y < rectangle.y - IlvMultiRowPanelConfiguration.i.height) {
                return null;
            }
            if (point.y >= rectangle.y + rectangle.height + IlvMultiRowPanelConfiguration.i.height) {
                return null;
            }
            n3 = this.b(rectangle, point.y, dimension);
        }
        Row row = null;
        for (n2 = 0; n2 < this.d.size(); ++n2) {
            row = this.b(n2);
            Rectangle rectangle2 = row.getBounds();
            if (!bl && point.x >= rectangle2.x && point.x < rectangle2.x + rectangle2.width || bl && point.y >= rectangle2.y && point.y < rectangle2.y + rectangle2.height) break;
        }
        if (n2 == this.d.size()) {
            return null;
        }
        for (n = 0; n < row.size(); ++n) {
            IlvDockedConfiguration ilvDockedConfiguration = row.getConfiguration(n);
            Rectangle rectangle3 = ilvDockedConfiguration.getBounds();
            int n4 = bl ? rectangle3.x : rectangle3.y;
            if (n3 >= n4 + (bl ? rectangle3.width : rectangle3.height)) continue;
            return new InsertInRow(n2, n, n3 - n4, dimension);
        }
        n = row.getConfiguration(row.size() - 1).getRight();
        return new AppendInRow(n2, n3 - n);
    }

    private int a(Rectangle rectangle, int n, Dimension dimension) {
        if (n < rectangle.x) {
            return 0;
        }
        int n2 = rectangle.x + rectangle.width - dimension.width;
        if (n > n2) {
            return n2;
        }
        return n;
    }

    private int b(Rectangle rectangle, int n, Dimension dimension) {
        if (n < rectangle.y) {
            return 0;
        }
        int n2 = rectangle.y + rectangle.height - dimension.height;
        if (n > n2) {
            return n2;
        }
        return n;
    }

    private static class AppendInRow
    extends InsertionPoint {
        private int a;
        private int b;

        public AppendInRow(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        @Override
        public IlvDockedComponentConfiguration insert(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, String string) {
            Row row = ilvMultiRowPanelConfiguration.b(this.a);
            ilvMultiRowPanelConfiguration.invalidate();
            if (this.b > ilvMultiRowPanelConfiguration.getComponentInterspace()) {
                row.add(new IlvSeparatorConfiguration(this.b, ilvMultiRowPanelConfiguration.isHorizontal()));
            }
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
            row.add(ilvDockedComponentConfiguration);
            return ilvDockedComponentConfiguration;
        }

        public String toString() {
            return "Append component in the row [" + this.a + "] after a new separator [" + this.b + "]";
        }
    }

    private static class InsertInRow
    extends InsertionPoint {
        private int a;
        private int b;
        private int c;
        private Dimension d;

        public InsertInRow(int n, int n2, int n3, Dimension dimension) {
            this.a = n;
            this.b = n2;
            this.c = n3;
            this.d = dimension;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public IlvDockedComponentConfiguration insert(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, String string) {
            Row row = ilvMultiRowPanelConfiguration.b(this.a);
            ilvMultiRowPanelConfiguration.invalidate();
            int n = ilvMultiRowPanelConfiguration.getComponentInterspace();
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
            int n2 = 0;
            int n3 = 0;
            int n4 = this.b - 1;
            int n5 = this.b + 1;
            boolean bl = ilvMultiRowPanelConfiguration.isHorizontal();
            int n6 = bl ? this.d.width : this.d.height;
            IlvDockedConfiguration ilvDockedConfiguration = row.getConfiguration(this.b);
            if (this.c < 0) {
                if (this.b == 0) {
                    row.addConfiguration(ilvDockedComponentConfiguration, 0);
                    return ilvDockedComponentConfiguration;
                }
                n2 = -this.c;
                n3 = n6 + n;
                row.addConfiguration(ilvDockedComponentConfiguration, this.b);
            } else if (ilvDockedConfiguration.isSeparator()) {
                IlvSeparatorConfiguration ilvSeparatorConfiguration = (IlvSeparatorConfiguration)ilvDockedConfiguration;
                if (this.c <= n) {
                    n2 = n - this.c;
                    n3 = n6;
                    row.addConfiguration(ilvDockedComponentConfiguration, this.b);
                } else {
                    n2 = 0;
                    n3 = n6 + this.c + n - ilvSeparatorConfiguration.getLength(bl);
                    ilvSeparatorConfiguration.setLength(bl, this.c);
                    row.addConfiguration(ilvDockedComponentConfiguration, this.b + 1);
                    if (n3 == 0) {
                        return ilvDockedComponentConfiguration;
                    }
                    if (n3 < 0) {
                        row.addConfiguration(new IlvSeparatorConfiguration(-n3 + n, bl), this.b + 2);
                        return ilvDockedComponentConfiguration;
                    }
                    n4 = this.b;
                    n5 = this.b + 2;
                }
            } else {
                row.addConfiguration(ilvDockedComponentConfiguration, this.b + 1);
                n4 = this.b;
                n5 = this.b + 2;
                n2 = ilvDockedConfiguration.getLength(bl) - this.c + n;
                n3 = n6 - ilvDockedConfiguration.getLength(bl) + this.c;
            }
            if (n2 > 0) {
                n2 = row.shrinkSeparators(ilvMultiRowPanelConfiguration, n2, n4, -1);
                n3 += n2;
            }
            if (n3 > 0 && (n3 = row.shrinkSeparators(ilvMultiRowPanelConfiguration, n3, n5, 1)) > 0 && n2 != 0) {
                n3 = row.shrinkSeparators(ilvMultiRowPanelConfiguration, n3, n4, -1);
            }
            return ilvDockedComponentConfiguration;
        }

        public String toString() {
            return "Insert component in the row [" + this.a + "] in the component [" + this.b + "] at the offset [" + this.c + "]";
        }
    }

    private static class NewRowInsertPoint
    extends InsertionPoint {
        private int a;
        private int b;

        public NewRowInsertPoint(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        @Override
        public IlvDockedComponentConfiguration insert(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, String string) {
            ilvMultiRowPanelConfiguration.c(this.b);
            Row row = ilvMultiRowPanelConfiguration.b(0);
            if (this.a != 0) {
                row.addConfiguration(new IlvSeparatorConfiguration(this.a, ilvMultiRowPanelConfiguration.isHorizontal()));
            }
            IlvDockedComponentConfiguration ilvDockedComponentConfiguration = new IlvDockedComponentConfiguration(string, null);
            row.add(ilvDockedComponentConfiguration);
            ilvMultiRowPanelConfiguration.invalidate();
            return ilvDockedComponentConfiguration;
        }

        public String toString() {
            return "Insert component in a new row at the index " + this.b + " and at the offset " + this.a;
        }
    }

    private static class Row
    extends ArrayList {
        private Rectangle a;

        public Row(int n) {
            super(n);
        }

        public Row() {
            super(3);
        }

        public Row(Row row, IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration) {
            super(row.size());
            this.a = row.a == null ? null : new Rectangle(row.a);
            for (int i = 0; i < row.size(); ++i) {
                IlvAbstractConfiguration ilvAbstractConfiguration = row.getConfiguration(i);
                ilvAbstractConfiguration = ilvAbstractConfiguration.cloneConfiguration();
                ilvMultiRowPanelConfiguration.c.add(ilvAbstractConfiguration);
                this.add(ilvAbstractConfiguration);
            }
        }

        public Rectangle getBounds() {
            return this.a;
        }

        public void setBounds(Rectangle rectangle) {
            this.a = new Rectangle(rectangle);
        }

        public final IlvDockedConfiguration getConfiguration(int n) {
            return (IlvDockedConfiguration)this.get(n);
        }

        public boolean removeConfiguration(IlvAbstractConfiguration ilvAbstractConfiguration) {
            return this.remove(ilvAbstractConfiguration);
        }

        public void addConfiguration(IlvAbstractConfiguration ilvAbstractConfiguration, int n) {
            if (n == -1) {
                this.add(ilvAbstractConfiguration);
            } else {
                this.add(n, ilvAbstractConfiguration);
            }
        }

        public void addConfiguration(IlvAbstractConfiguration ilvAbstractConfiguration) {
            this.add(ilvAbstractConfiguration);
        }

        public Collection getConfigurations() {
            return this;
        }

        public int shrinkSeparators(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, int n, int n2, int n3) {
            int n4 = ilvMultiRowPanelConfiguration.getComponentInterspace();
            boolean bl = ilvMultiRowPanelConfiguration.isHorizontal();
            int n5 = n2;
            while (n5 >= 0 && n5 < this.size()) {
                int n6;
                IlvDockedConfiguration ilvDockedConfiguration = this.getConfiguration(n5);
                if (!ilvDockedConfiguration.isSeparator()) {
                    n5 += n3;
                    continue;
                }
                if (n5 == 0) {
                    n4 = 0;
                }
                if ((n6 = ilvDockedConfiguration.getLength(bl)) - n4 <= n) {
                    this.a(ilvMultiRowPanelConfiguration, n6 - n4);
                    this.remove(n5);
                    if ((n -= n6 - n4) == 0) {
                        return 0;
                    }
                    if (n3 != -1) continue;
                    --n5;
                    continue;
                }
                this.a(ilvMultiRowPanelConfiguration, n);
                ilvDockedConfiguration.setLength(bl, n6 - n);
                return 0;
            }
            return n;
        }

        private final void a(IlvMultiRowPanelConfiguration ilvMultiRowPanelConfiguration, int n) {
            if (this.a != null) {
                if (ilvMultiRowPanelConfiguration.isHorizontal()) {
                    this.a.width -= n;
                } else {
                    this.a.height -= n;
                }
            }
        }
    }
}

