/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.docview;

import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.swing.IlvPanelView;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.builder.editor.IlvCSSCustomizer;
import ilog.views.builder.editor.IlvRuleDeclarationEditorSupport;
import ilog.views.builder.event.BuilderSelectionEvent;
import ilog.views.builder.event.BuilderSelectionListener;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeEvent;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.builder.gui.IlvCustomizerHandler;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.swing.SwingFactories;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;

public abstract class IlvRuleDeclarationEditorView
extends IlvPanelView {
    protected IlvStyleChangeSupport _ssupport = new IlvStyleChangeSupport(this);
    protected IlvRule _rule;
    protected IlvCSSCustomizer _customizer;
    private IlvCSSCustomizer a;
    private IlvCustomizerHandler b;
    private boolean c = true;
    private StyleChangeListener d;
    private StyleChangeListener e = new StyleChangeListener(){

        @Override
        public void styleChange(StyleChangeEvent styleChangeEvent) {
            IlvRuleDeclarationEditorView.this.styleChangeCallback(styleChangeEvent);
        }
    };
    private MultiListener f = new MultiListener();
    private JLabel g;
    private JLabel h;
    protected int _weight;

    public IlvRuleDeclarationEditorView() {
        this.setLayout(new BorderLayout());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Document")) {
                    IlvRuleDeclarationEditorView.this.changeDocument((IlvBuilderDocument)propertyChangeEvent.getOldValue(), (IlvBuilderDocument)propertyChangeEvent.getNewValue());
                }
            }
        });
        SwingFactories.init();
    }

    protected boolean needsStyleChangeMultiListener() {
        return false;
    }

    public void deleteProperty(String string) {
        this.deletePreviousAtRule(this._rule, string, this);
        Declaration declaration = this._rule.getDOMImplementation().createDeclaration(string);
        declaration.setValue("");
        StyleChangeEvent.Remove remove = new StyleChangeEvent.Remove(this, this._rule, new IlvCSSDeclaration[]{declaration}, null);
        this.styleChangeCallback(remove);
    }

    protected void deletePreviousAtRule(IlvRule ilvRule, String string, Object object) {
        String string2;
        IlvCSSDeclaration ilvCSSDeclaration = ilvRule.getDeclaration(string);
        if (ilvCSSDeclaration != null && (string2 = IlvRuleUtils.getSharpRuleReference(ilvCSSDeclaration)) != null) {
            IlvBuilderDocument ilvBuilderDocument = this.getBuilderDocument();
            IlvRule[] ilvRuleArray = ilvBuilderDocument.getCSS().getRulesFromId(ilvBuilderDocument.getRulesSubset(true), string2);
            StyleChangeEvent.Remove remove = new StyleChangeEvent.Remove(object, null, null, ilvRuleArray);
            remove.setSeverity(-10);
            this.styleChangeCallback(remove);
        }
    }

    public IlvCSSCustomizer getCustomizer() {
        return this._customizer;
    }

    public IlvCustomizerHandler getCustomizerHandler() {
        return this.b;
    }

    protected void changeDocument(IlvBuilderDocument ilvBuilderDocument, IlvBuilderDocument ilvBuilderDocument2) {
        if (ilvBuilderDocument != null) {
            ilvBuilderDocument.getSelectionManager().removeSelectionListener(this.f);
            this.removeStyleChangeListener(ilvBuilderDocument);
            if (this.needsStyleChangeMultiListener()) {
                ilvBuilderDocument.removeStyleChangeListener(this.f);
            }
        }
        if (ilvBuilderDocument2 != null) {
            ilvBuilderDocument2.getSelectionManager().addSelectionListener(this.f, this._weight);
            this.addStyleChangeListener(ilvBuilderDocument2);
            if (this.needsStyleChangeMultiListener()) {
                ilvBuilderDocument2.addStyleChangeListener(this.f);
            }
        }
    }

    protected String getNoSelectionText() {
        return this.getApplication().getString("Builder.RuleEditorView.NoSelection");
    }

    protected abstract String getUnavailableText();

    @Override
    public void initializeView(IlvDocument ilvDocument) {
        Object object;
        if (this.g == null) {
            this.g = new JLabel(this.getNoSelectionText(), 0);
            this.h = new JLabel(this.getUnavailableText(), 0);
        }
        if (this.g.getParent() != this) {
            this.add(this.g);
        }
        Object object2 = object = ilvDocument != null ? ((IlvBuilderDocument)ilvDocument).getSelectionManager().getSelection() : null;
        if (object != null) {
            IlvBuilderDocument ilvBuilderDocument = this.getBuilderDocument();
            this.unfill(ilvBuilderDocument);
            if (object instanceof IlvRule) {
                IlvRule ilvRule;
                this._rule = ilvRule = (IlvRule)object;
                this.fillRule(ilvBuilderDocument, this._rule, true);
            }
        } else {
            this.unfill((IlvBuilderDocument)ilvDocument);
        }
        super.initializeView(ilvDocument);
        if (IlvRuleDeclarationEditorSupport.INHERITED_ICON_TOOLTIPTEXT == null) {
            IlvRuleDeclarationEditorSupport.initToolTipTexts(this.getApplication());
        }
        this.repaint();
    }

    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this._ssupport.addStyleChangeListener(styleChangeListener);
    }

    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this._ssupport.removeStyleChangeListener(styleChangeListener);
    }

    protected StyleChangeListener getStyleChangeCallback() {
        return this.e;
    }

    protected IlvBuilderDocument getBuilderDocument() {
        return (IlvBuilderDocument)this.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void styleChangeCallback(StyleChangeEvent styleChangeEvent) {
        if (!this.c) {
            return;
        }
        try {
            Object object;
            this.c = false;
            IlvCustomizerHandler ilvCustomizerHandler = this.getCustomizerHandler();
            if (ilvCustomizerHandler != null && (object = ilvCustomizerHandler.getRule(styleChangeEvent)) != styleChangeEvent.getRule()) {
                styleChangeEvent.setRule((IlvRule)object);
            }
            if ((object = styleChangeEvent.getRule()) == null) {
                object = styleChangeEvent.getBean();
            }
            if (object == null) {
                object = this._rule;
                int n = styleChangeEvent.getSeverity();
                styleChangeEvent = styleChangeEvent.isDeleteMode() ? new StyleChangeEvent.Remove(styleChangeEvent.getSource(), object, styleChangeEvent.getDeclarations(), styleChangeEvent.getAdditionalRules()) : new StyleChangeEvent.Add(styleChangeEvent.getSource(), object, styleChangeEvent.getDeclarations(), styleChangeEvent.getAdditionalRules());
                styleChangeEvent.setSeverity(n);
            }
            this._ssupport.fireStyleChangeEvent(styleChangeEvent);
        }
        finally {
            this.c = true;
        }
    }

    protected abstract IlvCSSCustomizer getRuleCustomizer(IlvCustomizerHandler var1, IlvBuilderDocument var2, Object var3, boolean var4);

    protected Object getTargetBean(IlvCustomizerHandler ilvCustomizerHandler, IlvBuilderDocument ilvBuilderDocument, Object object) {
        return object;
    }

    public void fillRule(IlvBuilderDocument ilvBuilderDocument, IlvRule ilvRule, boolean bl) {
        if (ilvRule == null) {
            this.unfill(ilvBuilderDocument);
        }
        this._rule = ilvRule;
        if (ilvRule != null) {
            Object object = ilvBuilderDocument.makeBeanFromRule2(ilvRule);
            this.fillBean(ilvBuilderDocument, ilvRule, object, bl);
        }
    }

    public IlvRule getRule() {
        return this._rule;
    }

    protected void fillBean(IlvBuilderDocument ilvBuilderDocument, IlvRule ilvRule, Object object, boolean bl) {
        if (this.g.getParent() == this) {
            this.remove(this.g);
        }
        IlvCustomizerHandler ilvCustomizerHandler = null;
        if (object != null) {
            ilvCustomizerHandler = this.getCustomizerHandler(ilvBuilderDocument, object);
            if (ilvCustomizerHandler == null) {
                this.h.setText(this.getUnavailableText());
                this.add(this.h);
                return;
            }
            object = this.getTargetBean(ilvCustomizerHandler, ilvBuilderDocument, object);
            if (bl) {
                this.b = ilvCustomizerHandler;
            } else if (this.b != null && object != null && this.b.match(object, object.getClass())) {
                this.b = ilvCustomizerHandler;
            } else {
                ilvCustomizerHandler = this.b;
            }
            this._customizer = this.getRuleCustomizer(ilvCustomizerHandler, ilvBuilderDocument, object, bl);
        }
        if (this._customizer != null) {
            StyleChangeListener styleChangeListener;
            if (this._customizer != this.a) {
                this._customizer.removeStyleChangeListener(this.e);
                this._customizer.addStyleChangeListener(this.e);
            }
            StyleChangeListener styleChangeListener2 = styleChangeListener = ilvCustomizerHandler != null ? ilvCustomizerHandler.getListener(this._customizer) : null;
            if (styleChangeListener != this.d) {
                if (this.d != null && styleChangeListener == null) {
                    ilvBuilderDocument.removeStyleChangeListener(this.d);
                } else if (styleChangeListener != null) {
                    ilvBuilderDocument.removeStyleChangeListener(styleChangeListener);
                    ilvBuilderDocument.addStyleChangeListener(styleChangeListener);
                }
            }
            this.d = styleChangeListener;
            this._customizer.setEventTarget(ilvRule);
            this._customizer.setObject(object);
            this._customizer.updateDeclarationIcons(ilvBuilderDocument);
            this.addGUI(this._customizer);
            this._customizer.customizerActivated(true);
        } else {
            this.h.setText(this.getUnavailableText());
            this.add(this.h);
        }
        this.a = this._customizer;
    }

    protected abstract void addGUI(IlvCSSCustomizer var1);

    protected void unfill(IlvBuilderDocument ilvBuilderDocument) {
        this._rule = null;
        if (this.h.getParent() == this) {
            this.remove(this.h);
        }
        if (this._customizer != null) {
            this._customizer.prepareForDeactivation();
            this._customizer.removeStyleChangeListener(this.e);
            this.remove((Component)((Object)this._customizer));
            this.add(this.g);
            this._customizer.customizerActivated(false);
            this._customizer.setEventTarget(null);
            this._customizer = null;
            this.a = null;
            this.b = null;
        }
        if (this.d != null) {
            if (ilvBuilderDocument != null) {
                ilvBuilderDocument.removeStyleChangeListener(this.d);
            }
            this.d = null;
        }
    }

    public IlvCustomizerHandler getCustomizerHandler(IlvBuilderDocument ilvBuilderDocument, Object object) {
        return ilvBuilderDocument.getCustomizerHandler(object);
    }

    protected boolean handlePropertySheetEvent(PropertyChangeEvent propertyChangeEvent) {
        return false;
    }

    protected void refreshAfterStyleChange(StyleChangeEvent styleChangeEvent) {
    }

    private class MultiListener
    implements BuilderSelectionListener,
    StyleChangeListener {
        private MultiListener() {
        }

        @Override
        public void selectionChanged(BuilderSelectionEvent builderSelectionEvent) {
            IlvRule ilvRule;
            Object object = builderSelectionEvent.getNewSelection();
            IlvBuilderDocument ilvBuilderDocument = IlvRuleDeclarationEditorView.this.getBuilderDocument();
            IlvRuleDeclarationEditorView.this.unfill(ilvBuilderDocument);
            if (object instanceof IlvRule && ((ilvRule = (IlvRule)object).isEnabled() || ilvRule.isConfigurationRule())) {
                IlvRuleDeclarationEditorView.this._rule = ilvRule;
                IlvRuleDeclarationEditorView.this.fillRule(ilvBuilderDocument, IlvRuleDeclarationEditorView.this._rule, true);
            }
            IlvRuleDeclarationEditorView.this.validate();
            IlvRuleDeclarationEditorView.this.repaint();
        }

        @Override
        public void styleChange(StyleChangeEvent styleChangeEvent) {
            if (styleChangeEvent instanceof StyleChangeEvent.AddRemove) {
                IlvRuleDeclarationEditorView.this.refreshAfterStyleChange(styleChangeEvent);
            }
        }
    }
}

