/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.linkconnector;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.linkconnector.IlvFreeLinkConnector;

public class IlvClippingLinkConnector
extends IlvFreeLinkConnector {
    private boolean a = false;

    public IlvClippingLinkConnector() {
        this.setConnectionPointMoveAllowed(true);
    }

    public IlvClippingLinkConnector(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
        this.setConnectionPointMoveAllowed(true);
    }

    public IlvClippingLinkConnector(IlvLinkImage ilvLinkImage, boolean bl) {
        super(ilvLinkImage, bl);
    }

    public IlvClippingLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setConnectionPointMoveAllowed(true);
    }

    @Override
    protected boolean useCache() {
        return true;
    }

    @Override
    protected boolean zoomable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IlvPoint calcConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = this.getUnclippedConnectionPoint(ilvLinkImage, bl, ilvTransformer);
        if (this.a) {
            return ilvPoint;
        }
        IlvPoint ilvPoint2 = null;
        this.a = true;
        try {
            ilvPoint2 = this.a(ilvLinkImage, ilvPoint, bl, ilvTransformer);
        }
        finally {
            this.a = false;
        }
        if (ilvPoint == null || ilvPoint2 == null) {
            return ilvPoint;
        }
        return this.getClippedPoint(this.getNode(), ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, bl);
    }

    private IlvPoint a(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
        int n = ilvLinkImage.getPointsCardinal();
        if (n >= 2) {
            IlvTransformer ilvTransformer2 = this.a(ilvLinkImage, ilvTransformer);
            int n2 = n - 1;
            IlvRect ilvRect = this.getNodeBoundingBox(ilvTransformer);
            int n3 = this.a(ilvRect, ilvPoint) ? 1 : n2;
            IlvPoint ilvPoint2 = null;
            try {
                for (int i = 1; i <= n3; ++i) {
                    ilvPoint2 = ilvLinkImage.getPointAt(bl ? i : n2 - i, ilvTransformer2);
                    if (ilvPoint2.equals(ilvPoint)) continue;
                    return ilvPoint2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean a(IlvRect ilvRect, IlvPoint ilvPoint) {
        float f = ilvRect.x;
        float f2 = ilvRect.y;
        float f3 = ilvPoint.x;
        float f4 = ilvPoint.y;
        return f3 > f && f4 > f2 && f3 < f + ilvRect.width && f4 < f2 + ilvRect.height;
    }

    public IlvPoint getUnclippedConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = super.calcConnectionPoint(ilvLinkImage, bl, ilvTransformer);
        if (ilvPoint != null) {
            return ilvPoint;
        }
        IlvRect ilvRect = this.getNodeBoundingBox(ilvTransformer);
        return new IlvPoint(ilvRect.x + ilvRect.width * 0.5f, ilvRect.y + ilvRect.height * 0.5f);
    }

    private final IlvTransformer a(IlvLinkImage ilvLinkImage, IlvTransformer ilvTransformer) {
        if (this.getNode().getGraphicBag() != ilvLinkImage.getGraphicBag()) {
            IlvTransformer ilvTransformer2 = new IlvTransformer();
            this.a(ilvLinkImage).computeInverse(ilvTransformer2);
            ilvTransformer2.compose(ilvTransformer);
            return ilvTransformer2;
        }
        return ilvTransformer;
    }

    private final IlvTransformer a(IlvLinkImage ilvLinkImage) {
        return IlvLinkImage.getLocalTransformerOf(this.getNode(), ilvLinkImage.getGraphicBag(), new IlvTransformer());
    }

    public IlvPoint getClippedPoint(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, Object object, IlvPoint ilvPoint, IlvPoint ilvPoint2, boolean bl) {
        return IlvClippingUtil.getClippedPoint(ilvGraphic, ilvTransformer, ilvPoint, ilvPoint2);
    }
}

