/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes;

import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvGroupElement;
import ilog.views.prototypes.IlvValueException;
import ilog.views.prototypes.IlvValueSource;
import ilog.views.prototypes.Timer;
import ilog.views.prototypes.TimerManager;
import java.io.IOException;
import java.util.Vector;

public class IlvClockValueSource
extends IlvValueSource
implements Timer {
    long a;
    long b;
    long c;

    public IlvClockValueSource(String string, long l, long l2) {
        super(string);
        this.setPeriod(l);
        this.b = l2;
    }

    public IlvClockValueSource(IlvClockValueSource ilvClockValueSource) {
        super(ilvClockValueSource);
        this.a = ilvClockValueSource.a;
        this.b = ilvClockValueSource.b;
    }

    public IlvClockValueSource(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readInt("period");
        this.b = ilvInputStream.readInt("initialTime");
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("period", this.a);
        ilvOutputStream.write("initialTime", this.b);
    }

    @Override
    public IlvGroupElement copy() {
        return new IlvClockValueSource(this);
    }

    @Override
    protected void start() {
        this.c = this.b;
        TimerManager.getSingleton().addTimer(this);
    }

    @Override
    protected void stop() {
        TimerManager.getSingleton().removeTimer(this);
    }

    @Override
    protected void suspend() {
        TimerManager.getSingleton().removeTimer(this);
    }

    @Override
    protected void resume() {
        TimerManager.getSingleton().addTimer(this);
    }

    protected void tick(Vector vector, Vector vector2) {
    }

    public void setPeriod(long l) {
        this.a = l;
        if (this.a == 0L) {
            this.a = 1000L;
        }
    }

    public long getPeriod() {
        return this.a;
    }

    public void setInitialTime(long l) {
        this.b = l;
    }

    public long getInitialTime() {
        return this.b;
    }

    @Override
    public String[] getValueNames(boolean bl) throws IlvValueException {
        int n;
        String[] stringArray = super.getValueNames(bl);
        String[] stringArray2 = new String[stringArray.length + 7];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        int n2 = n++;
        stringArray2[n2] = "time";
        int n3 = n++;
        stringArray2[n3] = "hours";
        int n4 = n++;
        stringArray2[n4] = "minutes";
        int n5 = n++;
        stringArray2[n5] = "seconds";
        int n6 = n++;
        stringArray2[n6] = "totalMinutes";
        int n7 = n++;
        stringArray2[n7] = "totalSeconds";
        int n8 = n++;
        stringArray2[n8] = "milliseconds";
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOutput(String string) {
        if (string.equals("time")) return true;
        if (string.equals("hours")) return true;
        if (string.equals("minutes")) return true;
        if (string.equals("seconds")) return true;
        if (string.equals("totalMinutes")) return true;
        if (string.equals("totalSeconds")) return true;
        if (!string.equals("milliseconds")) return false;
        return true;
    }

    @Override
    public long getTimerPeriod() {
        return this.getPeriod();
    }

    @Override
    public void timerTicked() {
        this.c += this.a;
        long l = this.c;
        long l2 = l / 60000L;
        long l3 = l / 1000L;
        long l4 = l / 3600000L;
        long l5 = (l %= 3600000L) / 60000L;
        long l6 = (l %= 60000L) / 1000L;
        l %= 1000L;
        Vector<String> vector = new Vector<String>();
        Vector<Long> vector2 = new Vector<Long>();
        vector.addElement("time");
        vector2.addElement(new Long(this.c));
        vector.addElement("hours");
        vector2.addElement(new Long(l4));
        vector.addElement("minutes");
        vector2.addElement(new Long(l5));
        vector.addElement("seconds");
        vector2.addElement(new Long(l6));
        vector.addElement("totalMinutes");
        vector2.addElement(new Long(l2));
        vector.addElement("totalSeconds");
        vector2.addElement(new Long(l2));
        vector.addElement("milliseconds");
        vector2.addElement(new Long(l));
        this.tick(vector, vector2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new Object[vector2.size()];
        vector2.copyInto(objectArray2);
        try {
            this.pushValues((String[])objectArray, objectArray2);
        }
        catch (Exception exception) {
            IlvGroup.a("exception caught by clock source: " + exception.getMessage());
        }
    }

    @Override
    public int getSynchronizationCount() {
        return 0;
    }

    public static void setRealTimeMode(boolean bl) {
        TimerManager.getSingleton().setRealTime(bl);
    }

    public static boolean getRealTimeMode() {
        return TimerManager.getSingleton().isRealTime();
    }
}

