/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbol.util.dashboard;

import ilog.views.symbol.util.IlvDashboardReaderException;
import ilog.views.symbol.util.dashboard.DashboardIO;
import ilog.views.util.internal.IlvURLUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;

public abstract class DashboardParser
extends DashboardIO {
    private boolean a;
    private boolean b;
    private PaletteSymbolInfo[] c;
    private PaletteInfo[] d;
    private int e;
    private int f;
    private SymbolInfo g = new SymbolInfo();
    public static boolean capitalizingJavaClass = true;

    protected abstract void paletteSymbolsRead() throws IlvDashboardReaderException;

    protected abstract void prepareReadingNodes(int var1);

    protected abstract void addSymbol(SymbolInfo var1);

    protected abstract void insertBackgroundObjects(InputStream var1) throws IOException, IlvDashboardReaderException;

    protected abstract void setLinkLayoutEnabled(boolean var1);

    protected DashboardParser() {
    }

    protected int getNumberOfPalettes() {
        return this.d.length;
    }

    protected PaletteInfo getPaletteInfo(int n) {
        return this.d[n];
    }

    protected int getNumberOfPaletteSymbols() {
        return this.c.length;
    }

    protected PaletteSymbolInfo getPaletteSymbolInfo(int n) {
        return this.c[n];
    }

    protected void addPalette(int n, String string, String string2, String string3) {
        this.d[n] = new PaletteInfo(string, string2, string3);
    }

    protected abstract boolean isLinkLayoutEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDashboard(URL uRL) throws IlvDashboardReaderException, IOException {
        InputStream inputStream;
        try {
            inputStream = uRL.getProtocol().equals("file") ? new FileInputStream(IlvURLUtil.convertFileURLToFilename(uRL)) : IlvURLUtil.openConnection(uRL).getInputStream();
        }
        catch (Exception exception) {
            throw new IlvDashboardReaderException(exception);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            this.readDashboard(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
    }

    public void readDashboard(InputStream inputStream) throws IlvDashboardReaderException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        String string = objectInputStream.readUTF();
        if (!"Rogue WaveJViewsDashboardFile".equals(string)) {
            throw new IlvDashboardReaderException("Bad file header");
        }
        int n = objectInputStream.readInt();
        if (n > 870000) {
            throw new IlvDashboardReaderException("Not supported dashboard file version: " + n);
        }
        this.setReadingVersion(n);
        this.a(objectInputStream);
        this.b(objectInputStream);
        this.c(objectInputStream);
        this.d(objectInputStream);
        this.h(objectInputStream);
        this.readExtendedProperties(objectInputStream);
    }

    boolean a() {
        return this.b;
    }

    boolean b() {
        return this.a;
    }

    private void a(ObjectInputStream objectInputStream) throws IOException {
        this.a = objectInputStream.readBoolean();
        this.b = objectInputStream.readBoolean();
        boolean bl = objectInputStream.readBoolean();
        if (bl != this.isLinkLayoutEnabled()) {
            this.setLinkLayoutEnabled(bl);
        }
        this.readInternalProperties(objectInputStream);
        int n = objectInputStream.readInt();
        ArrayList<Object> arrayList = null;
        if (n > 0) {
            arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                try {
                    arrayList.add(objectInputStream.readObject());
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
            }
        }
        this.setProperties(arrayList);
    }

    private void b(ObjectInputStream objectInputStream) throws IOException, IlvDashboardReaderException {
        int n = objectInputStream.readInt();
        if (n != 2000) {
            throw new IlvDashboardReaderException("Palettes key expected");
        }
        int n2 = objectInputStream.readInt();
        this.d = new PaletteInfo[n2];
        for (int i = 0; i < n2; ++i) {
            String string = objectInputStream.readUTF();
            String string2 = objectInputStream.readUTF();
            String string3 = objectInputStream.readUTF();
            this.addPalette(i, string, string2, string3);
        }
    }

    private void c(ObjectInputStream objectInputStream) throws IOException, IlvDashboardReaderException {
        int n = objectInputStream.readInt();
        if (n != 2500) {
            throw new IlvDashboardReaderException("Palette symbols key expected");
        }
        int n2 = objectInputStream.readInt();
        this.c = new PaletteSymbolInfo[n2];
        for (int i = 0; i < n2; ++i) {
            this.readPaletteSymbol(i, objectInputStream);
        }
        this.paletteSymbolsRead();
    }

    protected void readPaletteSymbol(int n, ObjectInputStream objectInputStream) throws IOException {
        int n2;
        int n3;
        PaletteSymbolInfo paletteSymbolInfo = new PaletteSymbolInfo();
        paletteSymbolInfo.a = objectInputStream.readInt();
        paletteSymbolInfo.b = objectInputStream.readUTF();
        paletteSymbolInfo.c = objectInputStream.readUTF();
        paletteSymbolInfo.d = objectInputStream.readUTF();
        paletteSymbolInfo.e = n3 = objectInputStream.readInt();
        paletteSymbolInfo.f = new String[n3];
        paletteSymbolInfo.g = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            paletteSymbolInfo.f[n2] = objectInputStream.readUTF();
            paletteSymbolInfo.g[n2] = objectInputStream.readUTF();
        }
        n2 = paletteSymbolInfo.d.lastIndexOf(46);
        String string = n2 == -1 ? paletteSymbolInfo.d : paletteSymbolInfo.d.substring(n2 + 1);
        String string2 = capitalizingJavaClass && !Character.isUpperCase(string.charAt(0)) ? string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1) : string;
        paletteSymbolInfo.h = this.d[paletteSymbolInfo.a].b.replace('/', '.') + string2;
        this.c[n] = paletteSymbolInfo;
    }

    private void d(ObjectInputStream objectInputStream) throws IOException, IlvDashboardReaderException {
        int n = objectInputStream.readInt();
        if (n != 20000) {
            throw new IlvDashboardReaderException("Symbols key expected");
        }
        this.e = objectInputStream.readInt();
        this.readNodes(objectInputStream);
        this.readLinks(objectInputStream);
    }

    protected void readNodes(ObjectInputStream objectInputStream) throws IOException, IlvDashboardReaderException {
        this.f = objectInputStream.readInt();
        this.prepareReadingNodes(this.f);
        for (int i = 0; i < this.f; ++i) {
            this.a(objectInputStream, false);
        }
    }

    protected int getNumberOfNodes() {
        return this.f;
    }

    protected void readLinks(ObjectInputStream objectInputStream) throws IOException, IlvDashboardReaderException {
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.a(objectInputStream, true);
        }
    }

    private void a(ObjectInputStream objectInputStream, boolean bl) throws IOException, IlvDashboardReaderException {
        this.g.a();
        this.g.c = bl;
        this.g.a = objectInputStream.readUTF();
        this.g.b = objectInputStream.readInt();
        if (bl) {
            this.e(objectInputStream);
        } else {
            this.f(objectInputStream);
        }
        this.g.f = objectInputStream.readUTF();
        this.g(objectInputStream);
        this.addSymbol(this.g);
    }

    private void e(ObjectInputStream objectInputStream) throws IOException {
        int n;
        LinkInfo linkInfo = this.g.d;
        linkInfo.a = objectInputStream.readInt();
        linkInfo.b = objectInputStream.readInt();
        linkInfo.c = objectInputStream.readUTF();
        linkInfo.d = objectInputStream.readUTF();
        linkInfo.e = objectInputStream.readBoolean();
        if (linkInfo.e) {
            linkInfo.f = objectInputStream.readFloat();
            linkInfo.g = objectInputStream.readFloat();
        }
        linkInfo.h = objectInputStream.readBoolean();
        if (linkInfo.h) {
            linkInfo.i = objectInputStream.readFloat();
            linkInfo.j = objectInputStream.readFloat();
        }
        if ((n = objectInputStream.readInt()) > 0) {
            if (n > linkInfo.l) {
                linkInfo.l = n;
                linkInfo.m = new float[n];
                linkInfo.n = new float[n];
            }
            for (int i = 0; i < n; ++i) {
                linkInfo.m[i] = objectInputStream.readFloat();
                linkInfo.n[i] = objectInputStream.readFloat();
            }
        }
        linkInfo.k = n;
    }

    private void f(ObjectInputStream objectInputStream) throws IOException {
        this.g.e.a = objectInputStream.readFloat();
        this.g.e.b = objectInputStream.readFloat();
        this.g.e.c = objectInputStream.readFloat();
        this.g.e.d = objectInputStream.readFloat();
    }

    private void g(ObjectInputStream objectInputStream) throws IOException, IlvDashboardReaderException {
        this.g.g = this.c[this.g.b].e;
        if (this.g.g > this.g.h) {
            this.g.h = this.g.g;
            this.g.i = new String[this.g.g];
            this.g.j = new Object[this.g.g];
        }
        for (int i = 0; i < this.g.g; ++i) {
            String string;
            DashboardIO.ValueIO valueIO;
            this.g.i[i] = objectInputStream.readUTF();
            if ("".equals(this.g.i[i])) {
                this.g.i[i] = null;
            }
            if ((valueIO = this.getValueIO(string = this.c[this.g.b].g[i])) != null) {
                this.g.j[i] = valueIO.read(objectInputStream);
                continue;
            }
            try {
                this.g.j[i] = objectInputStream.readObject();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IlvDashboardReaderException(classNotFoundException);
            }
        }
    }

    private void h(ObjectInputStream objectInputStream) throws IlvDashboardReaderException, IOException {
        if (this.b) {
            String string = this.readUTF8StringBytes(objectInputStream);
            if (!"".equals(string)) {
                StringReaderInputStream stringReaderInputStream = new StringReaderInputStream(string);
                this.insertBackgroundObjects(stringReaderInputStream);
            }
        }
    }

    private static class StringReaderInputStream
    extends InputStream {
        private Reader a;

        public StringReaderInputStream(Reader reader) {
            this.a = reader;
        }

        public StringReaderInputStream(String string) {
            this.a = new StringReader(string);
        }

        @Override
        public int read() throws IOException {
            return this.a.read();
        }
    }

    protected static class LinkInfo {
        int a;
        int b;
        String c;
        String d;
        boolean e;
        float f;
        float g;
        boolean h;
        float i;
        float j;
        int k = 0;
        private int l = 0;
        float[] m;
        float[] n;

        LinkInfo() {
        }

        void a() {
            this.k = 0;
        }

        int b() {
            return this.k;
        }
    }

    protected static class GeometryInfo {
        float a;
        float b;
        float c;
        float d;

        protected GeometryInfo() {
        }
    }

    protected static class SymbolInfo {
        String a;
        int b;
        boolean c;
        LinkInfo d;
        GeometryInfo e;
        String f;
        int g = 0;
        int h = 20;
        String[] i = new String[this.h];
        Object[] j = new Object[this.h];

        SymbolInfo() {
            this.e = new GeometryInfo();
            this.d = new LinkInfo();
        }

        void a() {
            this.g = 0;
            this.d.a();
        }

        void a(Object object) {
            if (this.g == this.h) {
                Object[] objectArray = this.j;
                this.h += this.h / 2;
                this.j = new Object[this.h];
                System.arraycopy(objectArray, 0, this.j, 0, this.g);
            }
            this.j[this.g++] = object;
        }
    }

    protected static class PaletteSymbolInfo {
        int a;
        String b;
        String c;
        String d;
        int e;
        String[] f;
        String[] g;
        String h;

        protected PaletteSymbolInfo() {
        }
    }

    protected static class PaletteInfo {
        String a;
        String b;
        String c;

        PaletteInfo(String string, String string2, String string3) {
            this.a = string;
            this.b = string2;
            this.c = string3;
        }
    }
}

