/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.palettes;

import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.symbology.palettes.IlvPaletteXMLConstants;
import ilog.views.symbology.palettes.internal.IlvPaletteUtil;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.internal.IlvURLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IlvPaletteDocumentation
implements IlvPaletteXMLConstants {
    private static final Charset a = Charset.forName("UTF-8");
    private static final String b = "index.html";
    private File c;
    private DocumentBuilderFactory d;
    private DocumentBuilder e;
    private Document f;

    public IlvPaletteDocumentation(File file) {
        block3: {
            block2: {
                this.c = null;
                this.d = null;
                this.e = null;
                this.f = null;
                if (file == null || !file.exists()) break block2;
                if (file.isDirectory()) break block3;
            }
            System.err.println("Can not write documentation to invalid directory");
        }
        this.c = file;
        this.a();
    }

    private void a() {
        this.d = DocumentBuilderFactory.newInstance();
        try {
            this.e = this.d.newDocumentBuilder();
            this.f = this.e.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public URL createPaletteDocumentation(IlvPalette ilvPalette) {
        this.a();
        Element element = this.a(ilvPalette);
        String string = this.a(this.f);
        URL uRL = this.a(string, ilvPalette);
        return uRL;
    }

    public URL createPaletteObjectsDocumentation(IlvPaletteObject[] ilvPaletteObjectArray) {
        if (ilvPaletteObjectArray != null) {
            this.a();
            Element element = this.f.createElement("paletteobjects");
            for (int i = 0; i < ilvPaletteObjectArray.length; ++i) {
                this.a(ilvPaletteObjectArray[i], element);
            }
            this.f.appendChild(element);
            String string = this.a(this.f);
            URL uRL = this.a(string, ilvPaletteObjectArray);
            return uRL;
        }
        return null;
    }

    private Element a(IlvPalette ilvPalette) {
        Element element = null;
        try {
            element = this.f.createElement(IlvPaletteXMLConstants.PALETTE_ELEMENT);
            if (ilvPalette.getName() != null) {
                element.setAttribute(IlvPaletteXMLConstants.NAME_ATTRIBUTE, ilvPalette.getName() + " ");
            }
            if (ilvPalette.getDescription() != null) {
                element.setAttribute("description", ilvPalette.getDescription());
            }
            if (ilvPalette.getIconResourceName() != null) {
                element.setAttribute(IlvPaletteXMLConstants.ICON_ATTRIBUTE, ilvPalette.getIconResourceName());
            }
            this.f.appendChild(element);
            this.a(ilvPalette.getRoot(), this.f, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return element;
    }

    private void a(IlvPaletteObject ilvPaletteObject, Element element) {
        this.a(ilvPaletteObject, this.f, element);
    }

    private String a(Document document) {
        DOMSource dOMSource = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Locale locale = IlvLocaleUtil.getCurrentLocale();
        URL uRL = this.a(locale);
        StreamSource streamSource = new StreamSource(uRL.toExternalForm());
        try {
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            transformer.setParameter("Lang", locale);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            return string;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return null;
    }

    private URL a(String string, Object object) {
        Object object2;
        Object object3;
        boolean bl;
        boolean bl2;
        URL uRL = null;
        File file = new File(this.c, "doc");
        if (!file.exists() && !(bl2 = file.mkdir())) {
            return null;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        File file2 = new File(file, "images");
        if (!file2.exists() && !(bl = file2.mkdir())) {
            return null;
        }
        File[] fileArray2 = file2.listFiles();
        for (int i = 0; i < fileArray2.length; ++i) {
            fileArray2[i].delete();
        }
        File file3 = new File(file, b);
        try {
            object3 = new FileOutputStream(file3);
            object2 = this.a((OutputStream)object3);
            ((PrintWriter)object2).write(string);
            ((PrintWriter)object2).close();
            object3.close();
            uRL = IlvURLUtil.convertFileToAbsoluteURL(file3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (object instanceof IlvPalette) {
            object3 = (IlvPalette)object;
            object2 = this.a(object3.getIconResourceName());
            if (object2 != null) {
                File file4 = new File(file2, (String)object2);
                this.a(object3.getIconURL(), file4);
            }
            this.a((Object)object3.getRoot(), file2);
        }
        if (object instanceof IlvPaletteObject[]) {
            object3 = (IlvPaletteObject[])object;
            for (int i = 0; i < ((IlvPaletteObject[])object3).length; ++i) {
                this.a((Object)object3[i], file2);
            }
        }
        return uRL;
    }

    private void a(Object object, File file) {
        IlvPaletteSymbol ilvPaletteSymbol;
        String string;
        if (object instanceof IlvPaletteCategory) {
            IlvPaletteCategory ilvPaletteCategory = (IlvPaletteCategory)object;
            int n = ilvPaletteCategory.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                IlvPaletteObject ilvPaletteObject = ilvPaletteCategory.getChild(i);
                this.a((Object)ilvPaletteObject, file);
            }
        } else if (object instanceof IlvPaletteSymbol && (string = this.a((ilvPaletteSymbol = (IlvPaletteSymbol)object).getIconResourceName())) != null) {
            File file2 = new File(file, string);
            this.a(ilvPaletteSymbol.getIconURL(), file2);
        }
    }

    private String a(String string) {
        if (string != null) {
            int n = string.lastIndexOf("/");
            if (n > -1) {
                return string.substring(n + 1);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(URL uRL, File file) {
        if (uRL == null || file == null) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[4096];
            try {
                URLConnection uRLConnection = IlvURLUtil.openConnection(uRL);
                uRLConnection.setUseCaches(false);
                InputStream inputStream = uRLConnection.getInputStream();
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    inputStream.close();
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveTo(File file) {
        File file2 = new File(this.c, "doc");
        if (file2.exists()) {
            File file3 = new File(file2, b);
            this.a(file3, file);
            File file4 = file.isDirectory() ? file : file.getParentFile();
            File file5 = new File(file4, "images");
            file5.mkdir();
            File file6 = new File(file2, "images");
            File[] fileArray = file6.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.a(fileArray[i], file5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file, File file2) {
        try {
            String string;
            File file3;
            if (file2.isDirectory()) {
                file3 = file2;
                string = file.getName();
            } else {
                file3 = file2.getParentFile();
                string = file2.getName();
                if (!string.endsWith(".html")) {
                    string = string + ".html";
                }
            }
            File file4 = new File(file3, string);
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            try {
                FileChannel fileChannel2 = new FileOutputStream(file4).getChannel();
                try {
                    fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
                }
                finally {
                    fileChannel2.close();
                }
            }
            finally {
                fileChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private URL a(Locale locale) {
        URL uRL;
        if (locale.getVariant().length() > 0) {
            uRL = this.getClass().getResource("outputdoc_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant() + ".xslt");
            if (uRL != null) {
                return uRL;
            }
        }
        if (locale.getCountry().length() > 0) {
            uRL = this.getClass().getResource("outputdoc_" + locale.getLanguage() + "_" + locale.getCountry() + ".xslt");
            if (uRL != null) {
                return uRL;
            }
        }
        if ((uRL = this.getClass().getResource("outputdoc_" + locale.getLanguage() + ".xslt")) != null) {
            return uRL;
        }
        return this.getClass().getResource("outputdoc.xslt");
    }

    private void a(Object object, Document document, Element element) {
        if (object instanceof IlvPaletteCategory) {
            IlvPaletteCategory ilvPaletteCategory = (IlvPaletteCategory)object;
            Element element2 = document.createElement(IlvPaletteXMLConstants.CATEGORY_ELEMENT);
            element2.setAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE, ilvPaletteCategory.getID());
            element.appendChild(element2);
            int n = ilvPaletteCategory.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                IlvPaletteObject ilvPaletteObject = ilvPaletteCategory.getChild(i);
                this.a(ilvPaletteObject, document, element2);
            }
        } else if (object instanceof IlvPaletteSymbol) {
            String string;
            IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)object;
            Element element3 = document.createElement(IlvPaletteXMLConstants.SYMBOL_ELEMENT);
            element3.setAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE, ilvPaletteSymbol.getID());
            if (ilvPaletteSymbol.getCSSResourceName() != null) {
                element3.setAttribute(IlvPaletteXMLConstants.CSS_ATTRIBUTE, ilvPaletteSymbol.getCSSResourceName());
            }
            if (ilvPaletteSymbol.getClassName() != null) {
                element3.setAttribute(IlvPaletteXMLConstants.CLASSNAME_ATTRIBUTE, ilvPaletteSymbol.getClassName());
            }
            if ((string = this.a(ilvPaletteSymbol.getIconResourceName())) != null) {
                element3.setAttribute(IlvPaletteXMLConstants.ICON_ATTRIBUTE, string);
            }
            if (ilvPaletteSymbol.getVersion() != null) {
                element3.setAttribute(IlvPaletteXMLConstants.VERSION_ATTRIBUTE, ilvPaletteSymbol.getVersion());
            }
            if (ilvPaletteSymbol.getShortDescription() != null) {
                element3.setAttribute("shortdescription", ilvPaletteSymbol.getShortDescription());
            }
            if (ilvPaletteSymbol.getLongDescription() != null) {
                element3.setAttribute("longdescription", ilvPaletteSymbol.getLongDescription());
            }
            element.appendChild(element3);
            int n = ilvPaletteSymbol.getParameterCount();
            for (int i = 0; i < n; ++i) {
                IlvPaletteSymbolParameter ilvPaletteSymbolParameter = ilvPaletteSymbol.getParameter(i);
                this.a(ilvPaletteSymbolParameter, document, element3);
            }
        } else if (object instanceof IlvPaletteSymbolParameter) {
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = (IlvPaletteSymbolParameter)object;
            String string = IlvPaletteUtil.getValueAsString(ilvPaletteSymbolParameter);
            Element element4 = document.createElement(IlvPaletteXMLConstants.PARAM_ELEMENT);
            element4.setAttribute(IlvPaletteXMLConstants.ID_ATTRIBUTE, ilvPaletteSymbolParameter.getID());
            if (string != null) {
                element4.setAttribute(IlvPaletteXMLConstants.VALUE_ATTRIBUTE, string);
            }
            if (ilvPaletteSymbolParameter.getType() != null) {
                element4.setAttribute(IlvPaletteXMLConstants.TYPE_ATTRIBUTE, ilvPaletteSymbolParameter.getType());
            }
            if (ilvPaletteSymbolParameter.getEditorClassName() != null) {
                element4.setAttribute(IlvPaletteXMLConstants.EDITOR_ATTRIBUTE, ilvPaletteSymbolParameter.getEditorClassName());
            }
            if (ilvPaletteSymbolParameter.getValueSet() != null) {
                element4.setAttribute(IlvPaletteXMLConstants.VALUESET_ATTRIBUTE, ilvPaletteSymbolParameter.getValueSet().getID());
            }
            if (ilvPaletteSymbolParameter.getShortDescription() != null) {
                element4.setAttribute("shortdescription", ilvPaletteSymbolParameter.getShortDescription());
            }
            if (ilvPaletteSymbolParameter.getLongDescription() != null) {
                element4.setAttribute("longdescription", ilvPaletteSymbolParameter.getLongDescription());
            }
            element.appendChild(element4);
        }
    }

    private PrintWriter a(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, a);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        return printWriter;
    }
}

