/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.beans.editor.IlvInternationalizedPropertyEditor;
import ilog.views.util.text.IlvDateFormatFactory;
import ilog.views.util.text.internal.IlvFormatUtil;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class IlvDatePropertyEditor
extends PropertyEditorSupport
implements IlvInternationalizedPropertyEditor {
    private ULocale a;

    public IlvDatePropertyEditor() {
        this(IlvLocaleUtil.getCurrentULocale());
    }

    public IlvDatePropertyEditor(Locale locale) {
        this.a = ULocale.forLocale((Locale)locale);
    }

    public IlvDatePropertyEditor(ULocale uLocale) {
        this.a = uLocale;
    }

    @Override
    public String getJavaInitializationString() {
        Date date = (Date)this.getValue();
        return "new java.util.Date(" + date.getTime() + "L)";
    }

    @Override
    public String getAsText() {
        Date date = (Date)this.getValue();
        if (date != null) {
            return String.valueOf(date.getTime());
        }
        return "";
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        Date date = null;
        if (string != null) {
            try {
                date = new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (date == null) {
            throw new IllegalArgumentException("Could not create a Date from " + string);
        }
        this.setValue(date);
    }

    @Override
    public String getAsLocalizedText() {
        Date date = (Date)this.getValue();
        String string = "";
        if (date != null) {
            string = IlvDateFormatFactory.getDateInstance(1, this.a).format(date);
        }
        return string;
    }

    @Override
    public String[] getValuesAsLocalizedText() {
        return null;
    }

    @Override
    public void setAsLocalizedText(String string) throws IllegalArgumentException {
        Date date = null;
        if (string != null) {
            String string2 = string;
            DateFormat dateFormat = IlvDateFormatFactory.getDateInstance(1, this.a);
            try {
                date = IlvFormatUtil.parseFully(dateFormat, string2);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            if (date == null) {
                throw new IllegalArgumentException("Could not create a Date from " + string);
            }
            this.setValue(date);
        }
    }
}

