/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import ilog.views.util.java2d.IlvAdaptablePaint;
import ilog.views.util.java2d.IlvBlinkingDrawingResource;
import ilog.views.util.java2d.IlvMultipleGradientPaintConstants;
import ilog.views.util.java2d.internal.IlvGradientUtil;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class IlvMultipleGradientPaint
implements Paint,
Serializable,
IlvAdaptablePaint,
IlvMultipleGradientPaintConstants {
    private int a = 1;
    float[] b;
    Color[] c;
    transient AffineTransform d;
    short e;
    short f;
    boolean g;

    IlvMultipleGradientPaint(float[] fArray, Color[] colorArray, short s, short s2, AffineTransform affineTransform, boolean bl) {
        int n;
        if (colorArray.length < 2) {
            throw new IllegalArgumentException("User must specify at least 2 colors");
        }
        if (s2 != 1 && s2 != 0) {
            throw new IllegalArgumentException("Invalid colorspace for interpolation");
        }
        for (n = 0; n < colorArray.length; ++n) {
            IlvMultipleGradientPaint.a(colorArray[n]);
        }
        if (s != 1 && s != 2 && s != 3) {
            throw new IllegalArgumentException("Invalid spread method");
        }
        n = fArray.length;
        this.b = new float[n];
        System.arraycopy(fArray, 0, this.b, 0, n);
        for (int i = 0; i < n; ++i) {
            if (this.b[i] < 0.0f) {
                this.b[i] = 0.0f;
            } else if (this.b[i] > 1.0f) {
                this.b[i] = 1.0f;
            }
            if (i <= 0 || !(this.b[i] < this.b[i - 1])) continue;
            this.b[i] = this.b[i - 1];
        }
        this.c = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, this.c, 0, colorArray.length);
        this.f = s2;
        this.e = s;
        this.d = affineTransform == null ? null : (AffineTransform)affineTransform.clone();
        this.g = bl;
        this.initTransparency();
    }

    private static Color a(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null color not allowed as color of IlvMultipleGradientPaint");
        }
        if (color instanceof IlvBlinkingDrawingResource) {
            throw new IllegalArgumentException("IlvBlinkingDrawingResource not allowed as color of IlvMultipleGradientPaint");
        }
        return color;
    }

    protected final void initTransparency() {
        for (int i = 0; i < this.c.length; ++i) {
            if (this.c[i].getAlpha() == 255) continue;
            this.a = 3;
            break;
        }
    }

    public IlvMultipleGradientPaint(IlvMultipleGradientPaint ilvMultipleGradientPaint) {
        this(ilvMultipleGradientPaint.getStops(), ilvMultipleGradientPaint.getColors(), ilvMultipleGradientPaint.getSpreadMethod(), ilvMultipleGradientPaint.getColorSpace(), ilvMultipleGradientPaint.getTransform(), ilvMultipleGradientPaint.isAdapting());
    }

    public final Color[] getColors() {
        Color[] colorArray = new Color[this.c.length];
        System.arraycopy(this.c, 0, colorArray, 0, this.c.length);
        return colorArray;
    }

    public final float[] getStops() {
        float[] fArray = new float[this.b.length];
        System.arraycopy(this.b, 0, fArray, 0, this.b.length);
        return fArray;
    }

    @Override
    public final int getTransparency() {
        return this.a;
    }

    @Override
    public final boolean isAdapting() {
        return this.g;
    }

    public final short getSpreadMethod() {
        return this.e;
    }

    public final short getColorSpace() {
        return this.f;
    }

    public final AffineTransform getTransform() {
        if (this.d != null) {
            return new AffineTransform(this.d);
        }
        return null;
    }

    Color a(float f) {
        if (f <= this.b[0]) {
            return this.c[0];
        }
        int n = this.b.length;
        if (f >= this.b[n - 1]) {
            return this.c[n - 1];
        }
        for (int i = 1; i < n; ++i) {
            if (!(f <= this.b[i])) continue;
            float f2 = (f - this.b[i - 1]) / (this.b[i] - this.b[i - 1]);
            int n2 = this.c[i - 1].getRGB();
            int n3 = this.c[i].getRGB();
            if (this.f == 1) {
                n2 = IlvGradientUtil.convertEntireColorSRGBtoLinearRGB(n2);
                n3 = IlvGradientUtil.convertEntireColorSRGBtoLinearRGB(n3);
            }
            int n4 = IlvGradientUtil.interpolate(n2, n3, f2);
            if (this.f == 1) {
                n4 = IlvGradientUtil.convertEntireColorLinearRGBtoSRGB(n4);
            }
            return new Color(n4);
        }
        return Color.black;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AffineTransform affineTransform = this.d;
        boolean bl = affineTransform != null;
        objectOutputStream.writeBoolean(bl);
        if (bl) {
            objectOutputStream.writeDouble(affineTransform.getScaleX());
            objectOutputStream.writeDouble(affineTransform.getShearY());
            objectOutputStream.writeDouble(affineTransform.getShearX());
            objectOutputStream.writeDouble(affineTransform.getScaleY());
            objectOutputStream.writeDouble(affineTransform.getTranslateX());
            objectOutputStream.writeDouble(affineTransform.getTranslateY());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            double d = objectInputStream.readDouble();
            double d2 = objectInputStream.readDouble();
            double d3 = objectInputStream.readDouble();
            double d4 = objectInputStream.readDouble();
            double d5 = objectInputStream.readDouble();
            double d6 = objectInputStream.readDouble();
            this.d = new AffineTransform(d, d2, d3, d4, d5, d6);
        } else {
            this.d = null;
        }
    }
}

