/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.servlet;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.internal.IlvEnvironmentUtil;
import ilog.views.util.servlet.IlvServletRunnable;
import ilog.views.util.servlet.internal.IlvServletRuntimeException;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;

public class IlvServletThreadUtil {
    public static void invokeAndWait(final IlvServletRunnable ilvServletRunnable) throws IOException, ServletException {
        if (EventQueue.isDispatchThread()) {
            ilvServletRunnable.run();
        } else {
            final boolean bl = IlvEnvironmentUtil.isWebServerThread();
            final ULocale uLocale = IlvLocaleUtil.getCurrentULocale();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IlvEnvironmentUtil.setWebServerThread(bl);
                        if (uLocale != null) {
                            IlvLocaleUtil.setThreadULocale(uLocale);
                        }
                        try {
                            ilvServletRunnable.run();
                        }
                        finally {
                            if (uLocale != null) {
                                IlvLocaleUtil.setThreadULocale(null);
                            }
                            IlvEnvironmentUtil.setWebServerThread(false);
                        }
                    }
                    catch (IOException iOException) {
                        throw new IlvServletRuntimeException(iOException);
                    }
                    catch (ServletException servletException) {
                        throw new IlvServletRuntimeException(servletException);
                    }
                }
            };
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                throw new ServletException((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IlvServletRuntimeException) {
                    Exception exception = ((IlvServletRuntimeException)throwable).getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    if (exception instanceof ServletException) {
                        throw (ServletException)((Object)exception);
                    }
                    ServletException servletException = new ServletException((Throwable)exception);
                    if (servletException.getCause() == null) {
                        servletException.initCause((Throwable)exception);
                    }
                    throw servletException;
                }
                ServletException servletException = new ServletException(throwable);
                if (servletException.getCause() == null) {
                    servletException.initCause(throwable);
                }
                throw servletException;
            }
        }
    }

    private IlvServletThreadUtil() {
    }
}

