/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.schemabrowser.model.FilterableObject;
import oracle.dbtools.raptor.schemabrowser.model.SBType;
import oracle.ide.model.DefaultDisplayable;
import oracle.javatools.util.ModelUtil;

public final class SBSchema
extends DefaultDisplayable
implements Comparable<SBSchema>,
FilterableObject {
    private DBSchemaInstance m_instance;
    private List<SBType> m_types;

    public SBSchema(DBSchemaInstance dBSchemaInstance) {
        this.m_instance = dBSchemaInstance;
    }

    public Icon getIcon() {
        return this.m_instance.getDescriptor().getIcon();
    }

    public String getShortLabel() {
        return this.getSchemaName();
    }

    @Override
    public int compareTo(SBSchema sBSchema) {
        if (sBSchema == this) {
            return 0;
        }
        String string = this.getShortLabel();
        String string2 = sBSchema.getShortLabel();
        return string.compareTo(string2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SBSchema) {
            SBSchema sBSchema = (SBSchema)object;
            return this.m_instance.equals(sBSchema.m_instance);
        }
        return false;
    }

    public int hashCode() {
        return this.m_instance.hashCode();
    }

    public List<SBType> getTypes() {
        if (this.m_types == null) {
            this.m_types = new ArrayList<SBType>();
            for (DBFolderInstance dBFolderInstance : this.m_instance.listTypeFolders()) {
                this.m_types.add(new SBType(dBFolderInstance));
            }
            Collections.sort(this.m_types);
        }
        return this.m_types;
    }

    public SBType getTypeByName(String string, boolean bl) {
        if (this.m_types == null && !bl) {
            return null;
        }
        for (SBType sBType : this.getTypes()) {
            if (!ModelUtil.areEqual((Object)string, (Object)sBType.getTypeName())) continue;
            return sBType;
        }
        return null;
    }

    String getSchemaName() {
        return (String)this.m_instance.getProperty("SCHEMA");
    }

    @Override
    public boolean canHaveFilter() {
        return true;
    }

    @Override
    public void clearFilter() {
        this.m_instance.clearFilter();
        this.resetAllTypes();
    }

    @Override
    public boolean isFiltered() {
        return this.m_instance.isSchemaFiltered();
    }

    @Override
    public boolean promptForFilter() {
        if (this.m_instance.promptForSchemaFilter()) {
            this.resetAllTypes();
            return true;
        }
        return false;
    }

    private void resetAllTypes() {
        if (this.m_types != null) {
            for (SBType sBType : this.m_types) {
                sBType.markForRefresh();
            }
        }
    }
}

