/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.schemabrowser.SchemaBrowserResources;
import oracle.dbtools.raptor.schemabrowser.model.SBSearchCategory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class SchemaFilterPanel
extends DefaultTraversablePanel
implements ItemListener,
DocumentListener {
    public static final String CATEGORY_KEY = "SchemaFilterPanel.CATEGORY";
    public static final String VALUE_KEY = "SchemaFilterPanel.VALUE";
    private DefaultComboBoxModel m_typeModel = new DefaultComboBoxModel<SBSearchCategory>(SBSearchCategory.getCategories());
    private JComboBox m_typeCombo = new JComboBox(this.m_typeModel);
    private JTextField m_value = new JTextField();
    private DialogCallbacks m_callbacks;

    public SchemaFilterPanel() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_typeCombo, (String)SchemaBrowserResources.getString("SCHEMA_FILTER_PANEL_LABEL"));
        this.m_typeCombo.addItemListener(this);
        this.m_typeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof SBSearchCategory) {
                    object = ((SBSearchCategory)((Object)object)).getLabel();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.m_value.getDocument().addDocumentListener(this);
        GridBagConstraints gridBagConstraints = this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5));
        this.add(jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add(this.m_typeCombo, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.m_value, gridBagConstraints);
    }

    public void onEntry(TraversableContext traversableContext) {
        SBSearchCategory sBSearchCategory = (SBSearchCategory)((Object)traversableContext.get(CATEGORY_KEY));
        if (sBSearchCategory != null) {
            this.m_typeModel.setSelectedItem((Object)sBSearchCategory);
        } else {
            this.m_typeModel.setSelectedItem(this.m_typeModel.getElementAt(0));
        }
        String string = (String)traversableContext.get(VALUE_KEY);
        this.m_value.setText(string);
        this.m_callbacks = traversableContext.getDialogCallbacks();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaFilterPanel.this.updateOK();
            }
        });
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (!this.validateState()) {
            throw new TraversalException(SchemaBrowserResources.getString("SCHEMA_FILTER_PANEL_VALIDATION"));
        }
        traversableContext.put(CATEGORY_KEY, this.m_typeModel.getSelectedItem());
        traversableContext.put(VALUE_KEY, (Object)this.m_value.getText());
    }

    public Component getInitialFocusComponent() {
        return this.m_value;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOK();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOK();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOK();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateOK();
    }

    private boolean validateState() {
        boolean bl = false;
        if (this.m_typeModel.getSelectedItem() != null) {
            bl = ModelUtil.hasLength((String)this.m_value.getText());
        }
        return bl;
    }

    private void updateOK() {
        if (this.m_callbacks != null) {
            this.m_callbacks.enableOKButton(this.validateState());
        }
    }
}

