/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.ui.GlassPaneTaskViewer;
import oracle.dbtools.raptor.hadoop.core.HadoopFileHelper;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import org.apache.sshd.client.session.ClientSession;

public class HadoopFileChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int ERROR_OPTION = -1;
    public static int APPROVE_OPTION = 0;
    public static int CANCEL_OPTION = 2;
    public static int FILES_ONLY = 0;
    public static int DIRECTORIES_ONLY = 1;
    public static int DIRECTORIES_OR_FILES = 2;
    public static int OPEN_DIALOG = 0;
    public static final String APPLY = "APPLY";
    public static final String RESET = "RESET";
    private static final String DIR_SEP = "/";
    private PropertyChangeSupport propertyChangeSupport;
    private int _selectionScope = DIRECTORIES_ONLY;
    private int _chooserType = OPEN_DIALOG;
    private HadoopFileHelper _fileHelper;
    private ClientSession _clientSession;
    String _title;
    String _initialDirectory;
    String _currentDirectory;
    String _helpId = "f1_browse_hdfs_files_html";
    boolean _isShowLabel = true;
    String _selectedFile;
    private JLabel _uiLabel = new JLabel();
    private JTextField _uiTextCmp;
    private JButton _uiButton = new JButton();
    private String _uiButtonString = HadoopWizArb.getString("BROWSE");
    private JList<String> _dirsList;
    private JComboBox<String> _filesCmp;
    private JLabel _filesLabel = new JLabel();
    private JLabel _locationLabel = new JLabel(HadoopWizArb.getString("S_HDFS_DIR"));
    private JTextField _locationCmp;
    private JButton _locationUpCmp;
    private JEWTDialog _dialog;
    private MouseListener _dirsListMouseListener;
    DefaultListModel<String> _dirsListModel;
    protected DocumentListener _uiTextCmpTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.valueChanged(documentEvent);
        }

        void valueChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            HadoopFileChooserPanel.this._fileHelper.setRootDir(string);
            if (HadoopFileChooserPanel.this.propertyChangeSupport != null) {
                HadoopFileChooserPanel.this.propertyChangeSupport.firePropertyChange(HadoopFileChooserPanel.RESET, null, string);
            }
        }
    };
    final GlassPaneTaskViewer glassPaneTaskViewer = new GlassPaneTaskViewer();

    public HadoopFileChooserPanel(String string, HadoopFileHelper hadoopFileHelper, String string2) {
        this(string, OPEN_DIALOG, DIRECTORIES_ONLY, hadoopFileHelper, string2, true);
    }

    public HadoopFileChooserPanel(String string, HadoopFileHelper hadoopFileHelper, String string2, boolean bl) {
        this(string, OPEN_DIALOG, DIRECTORIES_ONLY, hadoopFileHelper, string2, bl);
    }

    public HadoopFileChooserPanel(String string, int n, HadoopFileHelper hadoopFileHelper, String string2, boolean bl) {
        this(string, OPEN_DIALOG, n, hadoopFileHelper, string2, bl);
    }

    public HadoopFileChooserPanel(String string, int n, int n2, HadoopFileHelper hadoopFileHelper, String string2, boolean bl) {
        this._isShowLabel = bl;
        this._title = string;
        this._fileHelper = hadoopFileHelper;
        this._initialDirectory = this._fileHelper.getRootDir();
        this._clientSession = hadoopFileHelper.getClientSession();
        if (string2 == null || string2.length() > 0) {
            // empty if block
        }
        this._uiButton.setEnabled(this._clientSession != null);
        this._uiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HadoopFileChooserPanel.this.browse();
            }
        });
        this._uiTextCmp = new JTextField(this._fileHelper.getRootDir());
        ResourceUtils.resLabel((JLabel)this._uiLabel, (Component)this._uiTextCmp, (String)HadoopWizArb.getString("SAMPLE_FILE"));
        ResourceUtils.resButton((AbstractButton)this._uiButton, (String)this._uiButtonString);
        this.setLayout(new GridBagLayout());
        int n3 = 0;
        if (this._isShowLabel) {
            this.add((Component)this._uiLabel, LayoutControl.GBC.gbc((int)0, (int)n3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE));
            this.add((Component)this._uiTextCmp, LayoutControl.GBC.gbc((int)1, (int)n3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        } else {
            this.add((Component)this._uiTextCmp, LayoutControl.GBC.gbc((int)1, (int)n3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        }
        this.add((Component)this._uiButton, LayoutControl.GBC.gbc((int)2, (int)n3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
        LayoutControl.GBC.addVSpring((JPanel)this, (int)(++n3));
    }

    public String getText() {
        return this._uiTextCmp.getText() != null ? this._uiTextCmp.getText() : "";
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void browse() {
        this._filesCmp = new JComboBox();
        ResourceUtils.resLabel((JLabel)this._filesLabel, this._filesCmp, (String)HadoopWizArb.getString("HDFS_FILES"));
        this._uiTextCmp.getDocument().removeDocumentListener(this._uiTextCmpTextListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, this._helpId);
        this._currentDirectory = this._uiTextCmp.getText();
        if (this._currentDirectory == null || this._currentDirectory.trim().isEmpty()) {
            this._currentDirectory = DIR_SEP;
        }
        this._fileHelper.setRootDir(this._currentDirectory);
        boolean bl = true;
        if (!this._fileHelper.isLoaded()) {
            boolean bl2 = false;
            this.glassPaneTaskViewer.setVisible(false);
            bl2 = this._fileHelper.loadHadoopFiles();
            if (!bl2) {
                bl = false;
            } else {
                this.setFiles();
            }
            this.glassPaneTaskViewer.setVisible(true);
        } else {
            this.setFiles();
        }
        if (bl) {
            this._dirsList = new JList<String>(this._fileHelper.getDirs());
            this._dirsListMouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getClickCount();
                    if (n == 2) {
                        String string = HadoopFileChooserPanel.this._dirsList.getSelectedValue();
                        String string2 = string == null ? HadoopFileChooserPanel.this._currentDirectory : string;
                        HadoopFileChooserPanel.this.setNewDirectory(string2);
                        HadoopFileChooserPanel.this.setFiles();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }
            };
            this._dirsList.addMouseListener(this._dirsListMouseListener);
            this._dirsList.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this._dirsList);
            TitledPane titledPane = new TitledPane((Component)new JLabel(HadoopWizArb.getString("HDFS_DIRS")), (Component)jScrollPane);
            this._locationCmp = new JTextField(this._currentDirectory);
            this._locationCmp.setEnabled(false);
            this._locationUpCmp = new JButton();
            this._locationUpCmp.setIcon(RaptorImagesArb.getIcon((String)"SHUTTLE_UP"));
            this._locationUpCmp.setEnabled(this._currentDirectory != null && !this._currentDirectory.trim().isEmpty() && !this._currentDirectory.equals(DIR_SEP));
            this._locationUpCmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "";
                    if (HadoopFileChooserPanel.this._currentDirectory != null) {
                        if (!HadoopFileChooserPanel.this._currentDirectory.isEmpty()) {
                            String string2 = HadoopFileChooserPanel.this._currentDirectory;
                            if (HadoopFileChooserPanel.this._currentDirectory.endsWith(HadoopFileChooserPanel.DIR_SEP)) {
                                string2 = HadoopFileChooserPanel.this._currentDirectory.substring(0, HadoopFileChooserPanel.this._currentDirectory.length() - 1);
                            }
                            int n = string2.lastIndexOf(HadoopFileChooserPanel.DIR_SEP);
                            if (string2.isEmpty()) {
                                string = HadoopFileChooserPanel.DIR_SEP;
                            } else if (n == 0) {
                                string = string2.substring(0, 1);
                            } else if (n != -1) {
                                string = string2.substring(0, n);
                            }
                        }
                        HadoopFileChooserPanel.this.setNewDirectory(string);
                        HadoopFileChooserPanel.this.setFiles();
                    }
                }
            });
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this._locationLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel2.add((Component)this._locationCmp, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel2.add((Component)this._locationUpCmp, LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)titledPane, "Center");
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.add((Component)this._filesLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE));
            jPanel3.add(this._filesCmp, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel.add((Component)jPanel3, "South");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        String string = HadoopFileChooserPanel.this._dirsList.getSelectedValue();
                        String string2 = string == null ? HadoopFileChooserPanel.this._currentDirectory : string;
                        HadoopFileChooserPanel.this._uiTextCmp.setText(string2);
                        HadoopFileChooserPanel.this._uiTextCmp.getDocument().addDocumentListener(HadoopFileChooserPanel.this._uiTextCmpTextListener);
                        if (HadoopFileChooserPanel.this.propertyChangeSupport != null) {
                            HadoopFileChooserPanel.this.propertyChangeSupport.firePropertyChange(HadoopFileChooserPanel.APPLY, null, string2);
                        }
                    } else {
                        HadoopFileChooserPanel.this._uiTextCmp.getDocument().addDocumentListener(HadoopFileChooserPanel.this._uiTextCmpTextListener);
                    }
                    HadoopFileChooserPanel.this._dialog.setVisible(false);
                    HadoopFileChooserPanel.this._dialog.dispose();
                }
            };
            this._dialog = this.getDialog(jPanel, this._title);
            this.glassPaneTaskViewer.setBackground(this._dialog.getBackground());
            this._dialog.setGlassPane((Component)this.glassPaneTaskViewer);
            if (WizardLauncher.runDialog((JDialog)this._dialog)) {
                String string = this._dirsList.getSelectedValue();
                String string2 = string == null ? this._currentDirectory : string;
                this.setNewDirectory(string2);
                this._uiTextCmp.setText(string2);
                this._uiTextCmp.getDocument().addDocumentListener(this._uiTextCmpTextListener);
                if (this.propertyChangeSupport != null) {
                    this.propertyChangeSupport.firePropertyChange(APPLY, null, string2);
                }
            }
        }
    }

    private void setNewDirectory(String string) {
        this._locationUpCmp.setEnabled(string != null && !string.isEmpty() && !string.equals(DIR_SEP));
        this._fileHelper.setRootDir(string);
        this._fileHelper.loadHadoopFiles();
        this._currentDirectory = string;
        this._locationCmp.setEnabled(true);
        this._locationCmp.setText(string);
        this._locationCmp.setEnabled(false);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string2 : this._fileHelper.getDirs()) {
            defaultListModel.addElement(string2);
        }
        this._dirsList.setModel(defaultListModel);
        this._dirsList.clearSelection();
        this._dialog.validate();
        this._dialog.repaint();
    }

    private void setFiles() {
        this._filesCmp.setEnabled(this._currentDirectory != null && !this._currentDirectory.isEmpty());
        this._filesCmp.removeAllItems();
        for (String string : this._fileHelper.getFiles()) {
            this._filesCmp.addItem(string);
        }
    }

    boolean checkIfFileExists() {
        return true;
    }

    private JEWTDialog getDialog(Component component, String string) {
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, null, (String)string, (int)7);
        Dimension dimension = jEWTDialog.getPreferredSize();
        jEWTDialog.setPreferredSize(new Dimension((int)dimension.getWidth() + 150, (int)dimension.getHeight() + 150));
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(true);
        return jEWTDialog;
    }
}

