/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.execute.OSCHExec;
import oracle.dbtools.raptor.hadoop.ui.HadoopIGeneralPage;
import oracle.dbtools.raptor.hadoop.ui.HadoopUIUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.sshd.client.session.ClientSession;

public abstract class OSCHUtilityPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JEWTDialog _dlg;
    private JTabbedPane _summaryTabbedPane = new JTabbedPane();
    private JButton _execCmp = new JButton();
    private JPanel _actionPanel;
    protected JLabel _dHostLabel;
    protected JComboBox<String> _dHostCmp;
    private JCheckBox _deleteDeployCheckBox;
    private JCheckBox _walletCheckBox;
    private JLabel _walletCredentialsLabel;
    private JTextField _walletCredentialsCmp;
    private JTextArea _instructions1;
    private JTextComponent _xTabPane;
    private JTextComponent _msgsPane;
    private boolean _init;
    private OSCHExec _exec = new OSCHExec();
    protected HadoopProperties _hProps;
    protected String _hostName = "";
    protected ClientSession _clientSession;
    private OSCHExec.Action _action;
    protected ItemListener _hostItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                try {
                    OSCHUtilityPanel.this._hostName = (String)((JComboBox)itemEvent.getSource()).getSelectedItem();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (OSCHUtilityPanel.this._hostName != null && !OSCHUtilityPanel.this._hostName.isEmpty()) {
                    OSCHUtilityPanel.this.setExecCmpEnabled(false);
                    final HadoopUtils.SshTask sshTask = HadoopUtils.getOpenSshConnectionTask(HadoopUtils.setSshHostProperties(OSCHUtilityPanel.this._hProps, OSCHUtilityPanel.this._hostName));
                    sshTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            try {
                                HostConnection hostConnection = (HostConnection)sshTask.getResult();
                                if (hostConnection != null) {
                                    OSCHUtilityPanel.this._clientSession = hostConnection.getSession();
                                    if (OSCHUtilityPanel.this._clientSession != null) {
                                        OSCHUtilityPanel.this.setExecCmpEnabled(true);
                                        OSCHUtilityPanel.this._hProps.put(HadoopKeys.SSH_SESSION, OSCHUtilityPanel.this._clientSession);
                                        HadoopUtils.getSSHSessionLocation(OSCHUtilityPanel.this._hProps);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                Logger.severe(HadoopUtils.class, (String)HadoopWizArb.getString("SSH_ERROR1"), (Throwable)exception);
                                ExceptionHandler.handleException((Throwable)exception);
                            }
                        }

                        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                            this.cleanSsh();
                        }

                        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            Logger.severe(HadoopIGeneralPage.class, (String)HadoopWizArb.getString("SSH_ERROR1"), (Throwable)throwable);
                            ExceptionHandler.handleException((Throwable)throwable);
                            this.cleanSsh();
                        }

                        private void cleanSsh() {
                            OSCHUtilityPanel.this._hProps.put(HadoopKeys.SSH_SESSION, null);
                            OSCHUtilityPanel.this._hProps.put(HadoopKeys.SSH_HOST, null);
                            OSCHUtilityPanel.this._hProps.put(HadoopKeys.SSH_USER, null);
                            OSCHUtilityPanel.this._dHostCmp.setSelectedIndex(-1);
                        }
                    });
                    RaptorTaskManager.getInstance().addTask((RaptorTask)sshTask);
                }
            }
        }
    };

    protected abstract String getUtilityName();

    protected abstract OSCHExec.Action getAction();

    protected abstract String getExecuteText();

    protected abstract String getInstructionsText();

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dlg = jEWTDialog;
    }

    public void onEntry(HadoopProperties hadoopProperties) {
        this._hProps = hadoopProperties;
        if (!this._init) {
            this.build();
            this._init = true;
        }
    }

    protected void onExit() {
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this.initHost();
        this._actionPanel = new JPanel(new BorderLayout());
        this._actionPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this._actionPanel.add((Component)this.getUtilityPanel(), "North");
        this._actionPanel.add((Component)this.createExecPanel(), "South");
        this._summaryTabbedPane.add(HadoopWizArb.getString("OSCHU_ACTION"), this._actionPanel);
        this._xTabPane = this.createTextPane(false);
        this._summaryTabbedPane.add(HadoopWizArb.getString("OSCHU_SCRIPT"), new JScrollPane(this._xTabPane, 20, 30));
        this._msgsPane = this.createTextPane(false);
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_MSGS_TITLE"), new JScrollPane(this._msgsPane, 20, 30));
        this.add((Component)this._summaryTabbedPane, "Center");
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (OSCHUtilityPanel.this._summaryTabbedPane.getSelectedIndex() == 1) {
                    OSCHUtilityPanel.this.doScript();
                }
            }
        };
        this._summaryTabbedPane.addChangeListener(changeListener);
    }

    protected JPanel getUtilityPanel() {
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.createInstructions1(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        jPanel.add((Component)this.createActionPanel(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        jPanel.add((Component)this.createCredentialsPanel(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        jPanel.add((Component)this.createHostPanel(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        return jPanel;
    }

    private void doScript() {
        this.onExit();
        if (this._dHostCmp != null) {
            this._hostName = (String)this._dHostCmp.getSelectedItem();
            boolean bl = true;
            if (this._hostName == null || this._hostName.isEmpty()) {
                bl = false;
            }
            if (this._walletCheckBox.isSelected() && this._walletCredentialsCmp.getText().length() == 0) {
                bl = false;
            }
            if (!this._walletCheckBox.isSelected()) {
                try {
                    bl = HadoopUIUtils.updateConnectionInfo(this._hProps, (String)this._hProps.get(HadoopKeys.DEST_CONN_NAME));
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)this);
                    bl = false;
                }
            } else if (this._walletCredentialsCmp.getText().length() == 0) {
                // empty if block
            }
            if (bl) {
                this._hProps.put(HadoopKeys.IS_USE_WALLET, this._walletCheckBox.isSelected());
                this._hProps.put(HadoopKeys.WALLET_CREDENTIAL, this._walletCredentialsCmp.getText());
                this._hostName = (String)this._dHostCmp.getSelectedItem();
                this._hProps.put(HadoopKeys.DELETE_DEPLOY, this._deleteDeployCheckBox.isSelected());
                this._exec.start(this._hProps);
                this._exec.doScriptUtility(this._action);
                this._xTabPane.setText(this._exec.getScript());
            } else {
                this._xTabPane.setText("");
            }
        }
    }

    protected JComponent createInstructions1() {
        this.initInstructions();
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this._instructions1);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel.add((Component)jScrollPane, "Center");
        return jScrollPane;
    }

    private void initInstructions() {
        this._instructions1 = new JTextArea();
        this._instructions1.setEditable(false);
        this._instructions1.setOpaque(false);
        this._instructions1.setRequestFocusEnabled(false);
        this._instructions1.setFocusable(false);
        this._instructions1.setLineWrap(true);
        this._instructions1.setWrapStyleWord(true);
        this._instructions1.setBorder(BorderFactory.createEmptyBorder());
        this._instructions1.setText(this.getInstructionsText());
    }

    protected JPanel createHostPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        int n = 0;
        jPanel.add((Component)this._dHostLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add(this._dHostCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._deleteDeployCheckBox = new JCheckBox();
        this._deleteDeployCheckBox.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this._deleteDeployCheckBox, (String)HadoopWizArb.getString("DELETE_DEPLOY"));
        this._deleteDeployCheckBox.setToolTipText(HadoopWizArb.getString("DELETE_DEPLOY_TIP"));
        jPanel.add((Component)this._deleteDeployCheckBox, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("SSH_CONN")));
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private void initHost() {
        if (this._dHostLabel == null) {
            this._dHostLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("HOST")));
            this._dHostLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("HOST")));
            Store store = Client.getInstance().getStore();
            Collection collection = store.listHosts();
            this._dHostCmp = new JComboBox();
            this._dHostLabel.setLabelFor(this._dHostCmp);
            for (String string : collection) {
                this._dHostCmp.addItem(string);
            }
            this._dHostCmp.setSelectedIndex(-1);
        }
    }

    protected JPanel createCredentialsPanel() {
        this._walletCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._walletCheckBox, (String)HadoopWizArb.getString("USE_WALLET"));
        this._walletCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                OSCHUtilityPanel.this._walletCredentialsCmp.setEnabled(jCheckBox.isSelected());
                OSCHUtilityPanel.this._walletCredentialsLabel.setEnabled(jCheckBox.isSelected());
            }
        });
        this._walletCredentialsLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._walletCredentialsLabel, (Component)this._walletCredentialsCmp, (String)HadoopWizArb.getString("WALLET_CREDENTIALS"));
        this._walletCredentialsCmp = new JTextField();
        this._walletCheckBox.setSelected(false);
        this._walletCredentialsCmp.setEnabled(false);
        this._walletCredentialsLabel.setEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(null, "Destination Connection", 0, 0, null, null));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        int n = 0;
        jPanel2.add((Component)this._walletCheckBox, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this._walletCredentialsLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this._walletCredentialsCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected JPanel createActionPanel() {
        JLabel jLabel = new JLabel(this.getUtilityName());
        JLabel jLabel2 = new JLabel(HadoopWizArb.getString("OSCHU_OWNER"));
        DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        JLabel jLabel3 = new JLabel(dBObject.getSchemaName());
        JLabel jLabel4 = new JLabel(HadoopWizArb.getString("OSCHU_NAME"));
        JLabel jLabel5 = new JLabel(dBObject.getObjectName());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("OSCHU_UTILITY_ACTIONS")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("OSCHU_UTILITY_ACTIONS")));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        int n = 0;
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)jLabel3, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)jLabel5, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jPanel2, "North");
        this._action = this.getAction();
        return jPanel;
    }

    protected void setExecCmpEnabled(boolean bl) {
        this._execCmp.setEnabled(bl);
    }

    private JPanel createExecPanel() {
        this._execCmp.setText(StringUtils.stripMnemonic((String)this.getExecuteText()));
        this._execCmp.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.getExecuteText()));
        this._execCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                OSCHUtilityPanel.this._hostName = (String)OSCHUtilityPanel.this._dHostCmp.getSelectedItem();
                if (OSCHUtilityPanel.this._hostName == null || OSCHUtilityPanel.this._hostName.isEmpty()) {
                    MessageDialog.error((Component)OSCHUtilityPanel.this._dlg, (Object)HadoopWizArb.getString("HOST_REQUIRED"), (String)HadoopWizArb.getString("ERROR"), null);
                    bl = false;
                }
                if (!OSCHUtilityPanel.this._walletCheckBox.isSelected()) {
                    try {
                        bl = HadoopUIUtils.updateConnectionInfo(OSCHUtilityPanel.this._hProps, (String)OSCHUtilityPanel.this._hProps.get(HadoopKeys.DEST_CONN_NAME));
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog((Component)OSCHUtilityPanel.this._dlg);
                        bl = false;
                    }
                } else if (OSCHUtilityPanel.this._walletCredentialsCmp.getText().length() == 0) {
                    MessageDialog.error((Component)OSCHUtilityPanel.this._dlg, (Object)HadoopWizArb.getString("WALLET_CREDENTIALS_MISSING"), (String)HadoopWizArb.getString("ERROR"), null);
                    bl = false;
                }
                if (bl) {
                    OSCHUtilityPanel.this.doScript();
                    OSCHUtilityPanel.this._exec.doExecUtility(OSCHUtilityPanel.this._action);
                    String string = OSCHUtilityPanel.this._exec.getLogFromTest();
                    OSCHUtilityPanel.this._exec.finish();
                    if (string != null) {
                        OSCHUtilityPanel.this._msgsPane.setText("*** SCRIPT ***\n" + OSCHUtilityPanel.this._exec.getScript() + "\n\n" + string);
                        OSCHUtilityPanel.this._msgsPane.setCaretPosition(0);
                        String string2 = OSCHUtilityPanel.this._exec.getScript();
                        if (string2 != null && !string2.isEmpty()) {
                            OSCHUtilityPanel.this._xTabPane.setText(string2);
                        }
                        OSCHUtilityPanel.this._summaryTabbedPane.setSelectedIndex(2);
                        OSCHUtilityPanel.this._xTabPane.setCaretPosition(0);
                    }
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 0));
        jPanel.add((Component)this._execCmp, "North");
        return jPanel;
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }
}

