/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgorithmIdentifier;

public class SmimeCapabilities
implements ASN1Object {
    private Vector capabilities = new Vector();
    private ASN1Sequence contents;

    public void addCapability(ASN1ObjectID capabilityID) {
        this.capabilities.addElement(new Capability(capabilityID));
        this.update();
    }

    public void addCapability(ASN1ObjectID capabilityID, ASN1Object parameters) {
        this.capabilities.addElement(new Capability(capabilityID, parameters));
        this.update();
    }

    public void addCapability(AlgorithmIdentifier algID) {
        this.capabilities.addElement(new Capability(algID.getOID()));
        this.update();
    }

    public void addCapability(AlgorithmIdentifier algID, int parameter) {
        this.capabilities.addElement(new Capability(algID.getOID(), (ASN1Object)new ASN1Integer((long)parameter)));
        this.update();
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        while (seq.hasMoreData()) {
            ASN1SequenceInputStream seq1 = new ASN1SequenceInputStream((InputStream)seq);
            ASN1ObjectID objID = new ASN1ObjectID((InputStream)seq1);
            ASN1Object obj = null;
            if (seq1.hasMoreData()) {
                obj = ASN1Utils.inputASN1Object((InputStream)seq1);
            }
            seq1.terminate();
            if (obj == null) {
                this.capabilities.addElement(new Capability(objID));
                continue;
            }
            this.capabilities.addElement(new Capability(objID, obj));
        }
        seq.terminate();
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            int size = this.capabilities.size();
            for (int i = 0; i < size; ++i) {
                Capability c = (Capability)this.capabilities.elementAt(i);
                ASN1Sequence cseq = new ASN1Sequence();
                cseq.addElement((ASN1Object)c.capabilityID);
                if (c.parameters != null) {
                    cseq.addElement(c.parameters);
                }
                s.addElement((ASN1Object)cseq);
            }
            this.contents = s;
        }
        return this.contents;
    }

    private static class Capability {
        ASN1ObjectID capabilityID;
        ASN1Object parameters;

        Capability(ASN1ObjectID capabilityID, ASN1Object parameters) {
            this.capabilityID = capabilityID;
            this.parameters = parameters;
        }

        Capability(ASN1ObjectID capabilityID) {
            this(capabilityID, null);
        }
    }
}

