/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.smime.BodyPartUpdater;
import oracle.security.crypto.smime.MultipartFileDataSource;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;

public class SmimeUtils {
    public static final String DEFAULT_Cert_HASH_ALG = "SHA1";

    public static void updateHeaders(MimeBodyPart bodyPart) throws MessagingException {
        new BodyPartUpdater(bodyPart);
    }

    public static byte[] toBytes(MimeBodyPart bodyPart) throws MessagingException, IOException {
        SmimeUtils.canonicalize((MimePart)bodyPart);
        UnsyncByteArrayOutputStream buff = new UnsyncByteArrayOutputStream();
        bodyPart.writeTo((OutputStream)buff);
        return buff.toByteArray();
    }

    public static byte[] toBytes(MimeBodyPart bodyPart, int length) throws MessagingException, IOException {
        SmimeUtils.canonicalize((MimePart)bodyPart);
        UnsyncByteArrayOutputStream buff = new UnsyncByteArrayOutputStream(length);
        bodyPart.writeTo((OutputStream)buff);
        return buff.toByteArray();
    }

    public static FileDataSource createFileDataSource(File file, String contentTypeHeader) {
        if (contentTypeHeader == null) {
            return new MultipartFileDataSource(file);
        }
        return new MultipartFileDataSource(file, contentTypeHeader);
    }

    public static FileDataSource createFileDataSource(String name, String contentTypeHeader) {
        if (contentTypeHeader == null) {
            return new MultipartFileDataSource(name);
        }
        return new MultipartFileDataSource(name, contentTypeHeader);
    }

    public static void canonicalize(MimePart mp) throws MessagingException {
        String cType = mp.getContentType().toLowerCase();
        if (cType == null) {
            return;
        }
        try {
            Object obj;
            if (cType.startsWith("text/")) {
                mp.setContent((Object)SmimeUtils.canonicalizeText((String)mp.getContent()), cType);
                mp.setHeader("Content-Type", cType);
            } else if (cType.startsWith("multipart/")) {
                MimeMultipart mmp = (MimeMultipart)mp.getContent();
                int nParts = mmp.getCount();
                for (int i = 0; i < nParts; ++i) {
                    BodyPart obj2 = mmp.getBodyPart(i);
                    if (!(obj2 instanceof MimePart)) continue;
                    SmimeUtils.canonicalize((MimePart)obj2);
                }
            } else if (cType.startsWith("message/") && (obj = mp.getContent()) instanceof MimePart) {
                SmimeUtils.canonicalize((MimePart)obj);
            }
        }
        catch (IOException ex) {
            throw new MessagingException(ex.toString());
        }
    }

    private static String canonicalizeText(String s) {
        StringBuffer sb = new StringBuffer();
        boolean gotCR = false;
        boolean thisLoop = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\r') {
                gotCR = true;
                thisLoop = true;
                sb.append("\r\n");
            } else if (c == '\n') {
                if (gotCR) {
                    gotCR = false;
                } else {
                    sb.append("\r\n");
                }
            } else {
                sb.append(c);
            }
            if (!gotCR) continue;
            if (thisLoop) {
                thisLoop = false;
                continue;
            }
            gotCR = false;
        }
        return sb.toString();
    }

    static void checkEmailAddress(X509Certificate cert, Address[] addresses) throws AuthenticationException {
        try {
            X509 certX509 = CMSUtils.convertX509((X509Certificate)cert);
            String email = certX509.getSubject().getEmail();
            if (email == null) {
                throw new AuthenticationException("Certificate does not contain an email address.");
            }
            boolean found = false;
            for (int i = 0; i < addresses.length; ++i) {
                String addr = addresses[i] instanceof InternetAddress ? ((InternetAddress)addresses[i]).getAddress() : addresses[i].toString();
                if (!email.equals(addr)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new AuthenticationException("E-mail address on certificate is not correct");
            }
        }
        catch (CertificateEncodingException e) {
            throw new AuthenticationException("Error while encoding the certificate");
        }
    }
}

