/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.javafx.scene;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public abstract class CustomControl
extends Region {
    private static Logger LOGGER = Logger.getLogger(CustomControl.class.getName());
    private Node root;
    private ArrayList<Class<?>> classes = new ArrayList();

    public CustomControl() {
        this.loadFXML();
        this.setSnapToPixel(true);
        this.setStyleClasses();
        this.loadCSS();
    }

    private void loadFXML() {
        FXMLLoader fXMLLoader = new FXMLLoader();
        fXMLLoader.setController((Object)this);
        fXMLLoader.setLocation(Resource.FXML.getURL(((Object)((Object)this)).getClass()));
        try {
            fXMLLoader.setResources(ResourceBundle.getBundle(Resource.PROPERTIES.getName(((Object)((Object)this)).getClass())));
        }
        catch (MissingResourceException missingResourceException) {
            LOGGER.log(Level.FINER, "(properties file is optional)", missingResourceException);
        }
        try {
            this.root = (Node)fXMLLoader.load();
            this.setMaxSize(this.root);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, null, iOException);
        }
    }

    private void setMaxSize(Node node) {
        if (node != null && node instanceof Region) {
            Region region = (Region)node;
            region.setMaxWidth(Double.MAX_VALUE);
            region.setMaxHeight(Double.MAX_VALUE);
        }
    }

    private void setStyleClasses() {
        this.initClasses();
        ObservableList observableList = this.getStyleClass();
        for (Class<?> clazz : this.classes) {
            observableList.add((Object)clazz.getSimpleName());
        }
    }

    private void initClasses() {
        if (this.classes.isEmpty()) {
            for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != Region.class; clazz = clazz.getSuperclass()) {
                this.classes.add(clazz);
            }
            Collections.reverse(this.classes);
        }
    }

    private void loadCSS() {
        this.initClasses();
        ObservableList observableList = this.getStylesheets();
        for (Class<?> clazz : this.classes) {
            if (Resource.CSS.getURL(clazz) == null) continue;
            observableList.add((Object)Resource.CSS.getName(clazz));
        }
    }

    protected void layoutChildren() {
        this.layoutInArea(this.root, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.LEFT, VPos.TOP);
    }

    private static enum Resource {
        FXML(".fxml"),
        CSS(".css"),
        PROPERTIES("_en.properties");

        private final String extension;

        private Resource(String string2) {
            this.extension = string2;
        }

        public URL getURL(Class<?> clazz) {
            return clazz.getResource(this.getName(clazz));
        }

        public String getName(Class<?> clazz) {
            return clazz.getSimpleName() + this.extension;
        }
    }
}

