/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.resource.ConnBundle;

public class ConnectionPickerButton
extends MenuToolButton
implements ActionListener {
    private static final String DEFAULT_TEXT = " ";
    private Collection<ItemListener> m_listeners;
    private boolean m_useNameAsText = true;
    private String m_defaultStoreName;
    private Context m_ideContext;
    private ConnectionInfo m_connInfo;

    public ConnectionPickerButton(ConnectionInfo connectionInfo) {
        this(connectionInfo, null);
    }

    public ConnectionPickerButton(ConnectionInfo connectionInfo, ToggleAction toggleAction) {
        super((ToggleAction)(toggleAction == null ? new DummyAction() : toggleAction));
        this.m_useNameAsText = toggleAction == null;
        this.m_connInfo = connectionInfo == null ? new ConnectionInfo(null, null) : connectionInfo;
        this.setFocusable(true);
        this.setFocusPainted(true);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                MenuToolButton.MenuToolButtonModel menuToolButtonModel = (MenuToolButton.MenuToolButtonModel)ConnectionPickerButton.this.getModel();
                menuToolButtonModel.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                MenuToolButton.MenuToolButtonModel menuToolButtonModel = (MenuToolButton.MenuToolButtonModel)ConnectionPickerButton.this.getModel();
                menuToolButtonModel.setSelected(false);
            }
        });
        this.makeDefaultSelection();
    }

    private void makeDefaultSelection() {
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        ConnectionInfo connectionInfo = databaseConnectionStores.getCurrentConnectionInfo(this.m_ideContext);
        if (connectionInfo == null || !connectionInfo.isValid() || !this.setSelectedConnection(connectionInfo)) {
            StoreMenu storeMenu;
            boolean bl = false;
            DatabaseConnections databaseConnections = databaseConnectionStores.getCurrentStore(this.m_ideContext);
            if (databaseConnections != null && (storeMenu = this.findStore(databaseConnections.getStoreName())) != null && this.selectFirstConnection(storeMenu.getPopupMenu())) {
                bl = true;
            }
            if (!bl) {
                this.selectFirstConnection(this.getPopupMenu());
            }
            if (!bl) {
                this.selectConnection(null);
            }
        }
    }

    private boolean selectFirstConnection(JPopupMenu jPopupMenu) {
        for (MenuElement menuElement : jPopupMenu.getSubElements()) {
            if (menuElement instanceof ConnectionMenuItem) {
                this.selectConnection((ConnectionMenuItem)menuElement);
                return true;
            }
            if (!(menuElement instanceof StoreMenu) || !this.selectFirstConnection(((StoreMenu)menuElement).getPopupMenu())) continue;
            return true;
        }
        return false;
    }

    public final void addConnectionListener(ItemListener itemListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new HashSet<ItemListener>();
        }
        this.m_listeners.add(itemListener);
    }

    public final void removeConnectionListener(ItemListener itemListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(itemListener);
        }
    }

    private Context getContext() {
        return this.m_ideContext == null ? Context.newIdeContext() : this.m_ideContext;
    }

    public final void setContext(Context context) {
        this.m_ideContext = context;
        this.resetConnections();
    }

    protected final void resetConnections() {
        this.removeAllPopupItems();
        if (this.m_useNameAsText) {
            this.setText(DEFAULT_TEXT);
        }
        this.populateMenu(this.getPopupMenu());
        this.makeDefaultSelection();
    }

    protected Collection<String> listStores() {
        return DatabaseConnectionStores.getInstance().listStores(this.m_ideContext);
    }

    protected Collection<String> listConnections(DatabaseConnections databaseConnections) {
        return databaseConnections.listConnections();
    }

    protected DatabaseConnections getDefaultStore() {
        Collection<String> collection = this.listStores();
        if (collection.size() == 1) {
            return DatabaseConnectionStores.getInstance().getStore(collection.iterator().next());
        }
        return null;
    }

    protected final JPopupMenu createPopupMenu() {
        this._popup = new JPopupMenu();
        this.populateMenu(this._popup);
        return this._popup;
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.m_useNameAsText) {
            JPopupMenu jPopupMenu = this.getPopupMenu();
            jPopupMenu.setMinimumSize(new Dimension(n3, jPopupMenu.getMinimumSize().height));
            jPopupMenu.setPreferredSize(new Dimension(n3, jPopupMenu.getPreferredSize().height));
        }
    }

    private void populateMenu(JPopupMenu jPopupMenu) {
        DatabaseConnections databaseConnections = this.getDefaultStore();
        this.m_defaultStoreName = null;
        boolean bl = false;
        if (databaseConnections != null) {
            this.m_defaultStoreName = databaseConnections.getStoreName();
            for (String object22 : this.listConnections(databaseConnections)) {
                ConnectionMenuItem connectionMenuItem = this.createConnectionMenuItem(this.m_defaultStoreName, object22);
                connectionMenuItem.addActionListener(this);
                jPopupMenu.add(connectionMenuItem);
                bl = true;
            }
        }
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        Collection<String> collection = this.listStores();
        for (String string : collection) {
            if (!ModelUtil.areDifferent((Object)this.m_defaultStoreName, (Object)string)) continue;
            StoreMenu storeMenu = this.createStoreMenu(string);
            DatabaseConnections databaseConnections2 = databaseConnectionStores.getStore(string);
            this.populateMenu(databaseConnections2, storeMenu);
            if (bl) {
                jPopupMenu.add(new JSeparator());
                bl = false;
            }
            jPopupMenu.add(storeMenu);
        }
    }

    private boolean populateMenu(DatabaseConnections databaseConnections, JMenu jMenu) {
        boolean bl = false;
        TreeSet<String> treeSet = new TreeSet<String>(this.listConnections(databaseConnections));
        for (String string : treeSet) {
            ConnectionMenuItem connectionMenuItem = this.createConnectionMenuItem(databaseConnections.getStoreName(), string);
            connectionMenuItem.addActionListener(this);
            jMenu.add(connectionMenuItem);
            bl = true;
        }
        return bl;
    }

    private StoreMenu createStoreMenu(String string) {
        return new StoreMenu(string);
    }

    private ConnectionMenuItem createConnectionMenuItem(String string, String string2) {
        return new ConnectionMenuItem(string, string2);
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof ConnectionMenuItem) {
            this.selectConnection((ConnectionMenuItem)object);
            MenuToolButton.MenuToolButtonModel menuToolButtonModel = (MenuToolButton.MenuToolButtonModel)this.getModel();
            menuToolButtonModel.setSelected(false);
        }
    }

    private String getSelectedText(ConnectionMenuItem connectionMenuItem) {
        if (connectionMenuItem == null) {
            return DEFAULT_TEXT;
        }
        StringBuilder stringBuilder = new StringBuilder(connectionMenuItem.getConnectionName());
        String string = connectionMenuItem.getStoreName();
        if (ModelUtil.areDifferent((Object)this.m_defaultStoreName, (Object)string)) {
            stringBuilder.append(" (");
            stringBuilder.append(DatabaseConnectionStores.getInstance().getShortLabel(string));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public final ConnectionInfo getConnectionInfo() {
        return this.m_connInfo;
    }

    public final void setConnectionInfo(ConnectionInfo connectionInfo) {
        if (connectionInfo != null) {
            this.setSelectedConnection(connectionInfo);
            this.m_connInfo = connectionInfo;
        }
    }

    private boolean setSelectedConnection(ConnectionInfo connectionInfo) {
        return this.setSelectedConnection(connectionInfo.getStoreName(), connectionInfo.getConnectionName());
    }

    private boolean setSelectedConnection(String string, String string2) {
        if (ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string2)) {
            ConnectionMenuItem connectionMenuItem;
            JMenuItem jMenuItem;
            JPopupMenu jPopupMenu = this.getPopupMenu();
            if ((string == null || ModelUtil.areEqual((Object)this.m_defaultStoreName, (Object)string)) && (jMenuItem = this.findConnection(jPopupMenu.getSubElements(), string2)) != null) {
                this.selectConnection((ConnectionMenuItem)jMenuItem);
                return true;
            }
            jMenuItem = this.findStore(string);
            if (jMenuItem != null && (connectionMenuItem = this.findConnection(((JMenu)jMenuItem).getPopupMenu().getSubElements(), string2)) != null) {
                this.selectConnection(connectionMenuItem);
                return true;
            }
        }
        return false;
    }

    private void selectConnection(ConnectionMenuItem connectionMenuItem) {
        String string = connectionMenuItem == null ? null : connectionMenuItem.getStoreName();
        String string2 = connectionMenuItem == null ? null : connectionMenuItem.getConnectionName();
        String string3 = this.m_connInfo.getStoreName();
        String string4 = this.m_connInfo.getConnectionName();
        if (ModelUtil.areDifferent((Object)string3, (Object)string) || ModelUtil.areDifferent((Object)string4, (Object)string2)) {
            this.m_connInfo.setStoreName(string);
            this.m_connInfo.setConnectionName(string2);
            if (this.m_useNameAsText) {
                this.setText(this.getSelectedText(connectionMenuItem));
            }
            if (this.m_listeners != null) {
                for (ItemListener itemListener : this.m_listeners) {
                    itemListener.itemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 1, (Object)this.m_connInfo, 1));
                }
            }
            this.connectionSelected(this.m_connInfo);
        }
    }

    protected void connectionSelected(ConnectionInfo connectionInfo) {
    }

    private ConnectionMenuItem findConnection(MenuElement[] menuElementArray, String string) {
        for (MenuElement menuElement : menuElementArray) {
            String string2;
            if (!(menuElement instanceof ConnectionMenuItem) || !string.equals(string2 = ((ConnectionMenuItem)menuElement).getConnectionName())) continue;
            return (ConnectionMenuItem)menuElement;
        }
        return null;
    }

    private StoreMenu findStore(String string) {
        for (MenuElement menuElement : this.getPopupMenu().getSubElements()) {
            String string2;
            if (!(menuElement instanceof StoreMenu) || !string.equals(string2 = ((StoreMenu)menuElement).getStoreName())) continue;
            return (StoreMenu)menuElement;
        }
        return null;
    }

    private static class DummyAction
    extends ToggleAction {
        public DummyAction() {
            super("", null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ConnectionMenuItem
    extends JMenuItem {
        private String m_storeName;
        private String m_connName;

        public ConnectionMenuItem(String string, String string2) {
            super(string2);
            this.m_connName = string2;
            this.m_storeName = string;
        }

        public String getStoreName() {
            return this.m_storeName;
        }

        public String getConnectionName() {
            return this.m_connName;
        }
    }

    private class StoreMenu
    extends JMenu {
        private String m_storeName;

        public StoreMenu(String string) {
            super("IdeConnections".equals(string) ? DatabaseConnectionStores.getInstance().getShortLabel(string) : ConnBundle.format("STORE_CONNECTIONS", DatabaseConnectionStores.getInstance().getShortLabel(string)));
            this.m_storeName = string;
        }

        public String getStoreName() {
            return this.m_storeName;
        }
    }
}

