/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import oracle.pgql.lang.CommonTranslationUtil;
import oracle.pgql.lang.ModifiedParseUnit;
import oracle.pgql.lang.PgqlVersion;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import oracle.pgql.lang.metadata.BinaryOperation;
import oracle.pgql.lang.metadata.DataTypeSynonym;
import oracle.pgql.lang.metadata.EdgeLabel;
import oracle.pgql.lang.metadata.FunctionSignature;
import oracle.pgql.lang.metadata.GraphSchema;
import oracle.pgql.lang.metadata.Label;
import oracle.pgql.lang.metadata.Property;
import oracle.pgql.lang.metadata.UnaryOperation;
import oracle.pgql.lang.metadata.VertexLabel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.LookupTranslator;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.TermVisitor;

public class MetadataToAstUtil {
    private static final int POS_AST_PLUS_METADATA_AST_EXPRESSIONS = 0;
    private static final String AST_PLUS_METADATA_CONSTRUCTOR_NAME = "AstPlusMetadata";
    public static final CharSequenceTranslator UNESCAPE_LEGACY_IDENTIFIER;

    static ISpoofaxParseUnit addMetadata(ISpoofaxParseUnit parseResult, AbstractMetadataProvider metadataProvider, ITermFactory f, boolean allowReferencingAnyProperty) {
        List<IStrategoTerm> functionSignatureTerms;
        List<IStrategoTerm> dataTypeSynonymTerms;
        List<IStrategoTerm> binaryOperations;
        List<IStrategoTerm> unaryOperations;
        String type;
        Optional graphSchema;
        PgqlVersion pgqlVersion;
        switch (((IStrategoAppl)parseResult.ast()).getConstructor().getName()) {
            case "Query": {
                pgqlVersion = PgqlVersion.V_1_3_OR_UP;
                break;
            }
            case "Pgql11Query": {
                pgqlVersion = PgqlVersion.V_1_1_OR_V_1_2;
                break;
            }
            case "Pgql10Query": {
                pgqlVersion = PgqlVersion.V_1_0;
                break;
            }
            default: {
                return parseResult;
            }
        }
        if (metadataProvider == null) {
            return parseResult;
        }
        Set<SchemaQualifiedName> graphNames = MetadataToAstUtil.extractGraphNames(parseResult.ast(), pgqlVersion);
        if (graphNames.size() > 1) {
            return parseResult;
        }
        if (graphNames.size() == 1) {
            SchemaQualifiedName graphName = graphNames.iterator().next();
            graphSchema = metadataProvider.getGraphSchema(graphName);
        } else {
            graphSchema = metadataProvider.getGraphSchema();
        }
        HashSet<String> allTypes = new HashSet<String>();
        Optional dataTypeSynonyms = metadataProvider.getDataTypeSynonyms();
        allTypes.addAll(MetadataToAstUtil.extractDataTypesFromCastStatements(parseResult.ast(), dataTypeSynonyms));
        Optional functionSignatures = metadataProvider.getFunctionSignatures();
        allTypes.addAll(MetadataToAstUtil.extractDataTypesFromUdfs(functionSignatures));
        ArrayList<IStrategoAppl> metadataTerm = new ArrayList<IStrategoAppl>();
        if (graphSchema.isPresent()) {
            ArrayList<IStrategoTerm> vertexLabelTerms = new ArrayList<IStrategoTerm>();
            for (VertexLabel vertexLabel : ((GraphSchema)graphSchema.get()).getVertexLabels()) {
                vertexLabelTerms.add(MetadataToAstUtil.translateLabel((Label)vertexLabel, f, allTypes));
            }
            IStrategoAppl vertexLabelsTerm = f.makeAppl("VertexLabels", new IStrategoTerm[]{f.makeList(vertexLabelTerms)});
            metadataTerm.add(vertexLabelsTerm);
            ArrayList<IStrategoTerm> edgeLabelTerms = new ArrayList<IStrategoTerm>();
            for (EdgeLabel edgeLabel : ((GraphSchema)graphSchema.get()).getEdgeLabels()) {
                edgeLabelTerms.add(MetadataToAstUtil.translateLabel((Label)edgeLabel, f, allTypes));
            }
            IStrategoAppl edgeLabelsTerm = f.makeAppl("EdgeLabels", new IStrategoTerm[]{f.makeList(edgeLabelTerms)});
            metadataTerm.add(edgeLabelsTerm);
        }
        if (metadataProvider.getDefaultStringType().isPresent()) {
            type = (String)metadataProvider.getDefaultStringType().get();
            IStrategoAppl defaultStringType = f.makeAppl("DefaultStringType", new IStrategoTerm[]{f.makeString(type)});
            metadataTerm.add(defaultStringType);
            allTypes.add(type);
        }
        if (metadataProvider.getDefaultShortIntegerType().isPresent()) {
            type = (String)metadataProvider.getDefaultShortIntegerType().get();
            IStrategoAppl defaultShortIntegerType = f.makeAppl("DefaultShortIntegerType", new IStrategoTerm[]{f.makeString(type)});
            metadataTerm.add(defaultShortIntegerType);
            allTypes.add(type);
        }
        if (metadataProvider.getDefaultLongIntegerType().isPresent()) {
            type = (String)metadataProvider.getDefaultLongIntegerType().get();
            IStrategoAppl defaultLongIntegerType = f.makeAppl("DefaultLongIntegerType", new IStrategoTerm[]{f.makeString(type)});
            metadataTerm.add(defaultLongIntegerType);
            allTypes.add(type);
        }
        if (metadataProvider.getDefaultDecimalType().isPresent()) {
            type = (String)metadataProvider.getDefaultDecimalType().get();
            IStrategoAppl defaultDecimalType = f.makeAppl("DefaultDecimalType", new IStrategoTerm[]{f.makeString(type)});
            metadataTerm.add(defaultDecimalType);
            allTypes.add(type);
        }
        allTypes.add("BOOLEAN");
        allTypes.add("DATE");
        allTypes.add("TIME");
        allTypes.add("TIME WITH TIME ZONE");
        allTypes.add("TIMESTAMP");
        allTypes.add("TIMESTAMP WITH TIME ZONE");
        allTypes.add("VERTEX");
        allTypes.add("EDGE");
        List<Pair<String, String>> allPairsOfTypes = MetadataToAstUtil.getAllPairsOfTypes(allTypes);
        List<IStrategoTerm> unionTypes = MetadataToAstUtil.getUnionCompatibleTypes(allPairsOfTypes, metadataProvider, f);
        if (!unionTypes.isEmpty()) {
            metadataTerm.add(f.makeAppl("UnionTypes", new IStrategoTerm[]{f.makeList(unionTypes)}));
        }
        if (!(unaryOperations = MetadataToAstUtil.getUnaryOperationsWithTypes(allTypes, metadataProvider, f)).isEmpty()) {
            metadataTerm.add(f.makeAppl("UnaryOperations", new IStrategoTerm[]{f.makeList(unaryOperations)}));
        }
        if (!(binaryOperations = MetadataToAstUtil.getBinaryOperationsWithTypes(allPairsOfTypes, metadataProvider, f)).isEmpty()) {
            metadataTerm.add(f.makeAppl("BinaryOperations", new IStrategoTerm[]{f.makeList(binaryOperations)}));
        }
        if (!(dataTypeSynonymTerms = MetadataToAstUtil.getDataTypeSynonyms(dataTypeSynonyms, f)).isEmpty()) {
            metadataTerm.add(f.makeAppl("DataTypeSynonyms", new IStrategoTerm[]{f.makeList(dataTypeSynonymTerms)}));
        }
        if (!(functionSignatureTerms = MetadataToAstUtil.getFunctionSignatures(functionSignatures, f)).isEmpty()) {
            metadataTerm.add(f.makeAppl("FunctionSignatures", new IStrategoTerm[]{f.makeList(functionSignatureTerms)}));
        }
        if (allowReferencingAnyProperty) {
            metadataTerm.add(f.makeAppl("AllowReferencingAnyProperty", new IStrategoTerm[0]));
        }
        IStrategoAppl metadataExtendedAst = f.makeAppl(AST_PLUS_METADATA_CONSTRUCTOR_NAME, new IStrategoTerm[]{parseResult.ast(), f.makeList(metadataTerm)});
        ModifiedParseUnit extendedParseUnit = new ModifiedParseUnit(parseResult, (IStrategoTerm)metadataExtendedAst);
        return extendedParseUnit;
    }

    static IStrategoTerm translateLabel(Label label, ITermFactory f, Set<String> allTypes) {
        ArrayList<IStrategoAppl> propertyTerms = new ArrayList<IStrategoAppl>();
        for (Property property : label.getProperties()) {
            propertyTerms.add(f.makeAppl("Property", new IStrategoTerm[]{f.makeString(property.getName()), f.makeString(property.getType())}));
            allTypes.add(property.getType());
        }
        return f.makeAppl("Label", new IStrategoTerm[]{f.makeString(label.getLabel()), f.makeList(propertyTerms)});
    }

    static IStrategoTerm removeMetadata(ISpoofaxAnalyzeUnit analysisResult) {
        IStrategoTerm analyizedAst = ((IStrategoAppl)analysisResult.ast()).getConstructor().getName().equals(AST_PLUS_METADATA_CONSTRUCTOR_NAME) ? analysisResult.ast().getSubterm(0) : analysisResult.ast();
        return analyizedAst;
    }

    static Set<SchemaQualifiedName> extractGraphNames(IStrategoTerm ast, final PgqlVersion pgqlVersion) {
        final HashSet<SchemaQualifiedName> graphNames = new HashSet<SchemaQualifiedName>();
        new TermVisitor(){

            public void preVisit(IStrategoTerm t) {
                String constructor;
                if (t.getType() == TermType.APPL && ((constructor = ((IStrategoAppl)t).getConstructor().getName()).equals("OnClause") || constructor.equals("IntoClause") || constructor.equals("Pgql11FromClause"))) {
                    IStrategoTerm nameT = t.getSubterm(0);
                    IStrategoTerm schemaNameT = nameT.getSubterm(0);
                    String schemaName = CommonTranslationUtil.isSome(schemaNameT) ? MetadataToAstUtil.identifierToString(schemaNameT.getSubterm(0).getSubterm(0), pgqlVersion) : null;
                    String localName = MetadataToAstUtil.identifierToString(nameT.getSubterm(1), pgqlVersion);
                    graphNames.add(new SchemaQualifiedName(schemaName, localName));
                }
            }
        }.visit(ast);
        return graphNames;
    }

    static Set<String> extractDataTypesFromCastStatements(IStrategoTerm ast, final Optional<List<DataTypeSynonym>> dataTypeSynonyms) {
        final HashSet<String> dataTypes = new HashSet<String>();
        new TermVisitor(){

            public void preVisit(IStrategoTerm t) {
                String constructor;
                if (t.getType() == TermType.APPL && (constructor = ((IStrategoAppl)t).getConstructor().getName()).equals("Cast")) {
                    IStrategoString dataTypeT = (IStrategoString)t.getSubterm(1);
                    String dataType = dataTypeT.stringValue().toUpperCase();
                    if (dataTypeSynonyms.isPresent()) {
                        for (DataTypeSynonym synonym : (List)dataTypeSynonyms.get()) {
                            if (!dataType.equals(synonym.getSynonym())) continue;
                            dataType = synonym.getDataType();
                        }
                    }
                    dataTypes.add(dataType);
                }
            }
        }.visit(ast);
        return dataTypes;
    }

    private static Collection<? extends String> extractDataTypesFromUdfs(Optional<List<FunctionSignature>> optionalFunctionSignatures) {
        HashSet<String> result = new HashSet<String>();
        if (optionalFunctionSignatures.isPresent()) {
            List<FunctionSignature> functionSignatures = optionalFunctionSignatures.get();
            for (FunctionSignature signature : functionSignatures) {
                result.addAll(signature.getArgumentTypes());
                result.add(signature.getReturnType());
            }
        }
        return result;
    }

    static String identifierToString(IStrategoTerm t, PgqlVersion pgqlVersion) {
        String constructorName = ((IStrategoAppl)t).getConstructor().getName();
        String identifier = CommonTranslationUtil.getString(t);
        switch (constructorName) {
            case "RegularIdentifier": {
                if (pgqlVersion == PgqlVersion.V_1_0 || pgqlVersion == PgqlVersion.V_1_1_OR_V_1_2) {
                    return identifier;
                }
                return identifier.toUpperCase();
            }
            case "DelimitedIdentifier": {
                String unquotedPart = identifier.substring(1, identifier.length() - 1);
                if (pgqlVersion == PgqlVersion.V_1_0 || pgqlVersion == PgqlVersion.V_1_1_OR_V_1_2) {
                    return UNESCAPE_LEGACY_IDENTIFIER.translate((CharSequence)unquotedPart);
                }
                return unquotedPart.replaceAll("\"\"", "\"");
            }
        }
        throw new IllegalStateException("Unsupported identifier type: " + constructorName);
    }

    private static List<Pair<String, String>> getAllPairsOfTypes(Set<String> allTypes) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (String type1 : allTypes) {
            for (String type2 : allTypes) {
                result.add((Pair<String, String>)Pair.of((Object)type1, (Object)type2));
            }
        }
        return result;
    }

    private static List<IStrategoTerm> getUnionCompatibleTypes(List<Pair<String, String>> allPairsOfTypes, AbstractMetadataProvider metadataProvider, ITermFactory f) {
        ArrayList<IStrategoTerm> unionTypes = new ArrayList<IStrategoTerm>();
        for (Pair<String, String> pair : allPairsOfTypes) {
            Optional optionalUnionType = metadataProvider.getUnionType((String)pair.getLeft(), (String)pair.getRight());
            if (!optionalUnionType.isPresent()) continue;
            String unionType = (String)optionalUnionType.get();
            unionTypes.add((IStrategoTerm)f.makeAppl("UnionType", new IStrategoTerm[]{f.makeString((String)pair.getLeft()), f.makeString((String)pair.getRight()), f.makeString(unionType)}));
        }
        return unionTypes;
    }

    private static List<IStrategoTerm> getUnaryOperationsWithTypes(Set<String> allTypes, AbstractMetadataProvider metadataProvider, ITermFactory f) {
        ArrayList<IStrategoTerm> unaryOperationsWithTypes = new ArrayList<IStrategoTerm>();
        for (String type : allTypes) {
            UnaryOperation[] unaryOperations = UnaryOperation.values();
            for (int i = 0; i < unaryOperations.length; ++i) {
                String constructorName;
                UnaryOperation operation = unaryOperations[i];
                Optional optionalReturnType = metadataProvider.getOperationReturnType(operation, type);
                if (!optionalReturnType.isPresent()) continue;
                String returnType = (String)optionalReturnType.get();
                switch (operation) {
                    case NOT: {
                        constructorName = "Not";
                        break;
                    }
                    case UMIN: {
                        constructorName = "UMin";
                        break;
                    }
                    case SUM: 
                    case MIN: 
                    case MAX: 
                    case AVG: 
                    case LISTAGG: {
                        constructorName = operation.name();
                        break;
                    }
                    case ARRAY_AGG: {
                        constructorName = "ARRAY-AGG";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported operation: " + operation);
                    }
                }
                unaryOperationsWithTypes.add((IStrategoTerm)f.makeAppl("UnaryOperation", new IStrategoTerm[]{f.makeString(constructorName), f.makeString(type), f.makeString(returnType)}));
            }
        }
        return unaryOperationsWithTypes;
    }

    private static List<IStrategoTerm> getBinaryOperationsWithTypes(List<Pair<String, String>> allPairsOfTypes, AbstractMetadataProvider metadataProvider, ITermFactory f) {
        ArrayList<IStrategoTerm> binaryOperationsWithTypes = new ArrayList<IStrategoTerm>();
        for (Pair<String, String> pair : allPairsOfTypes) {
            BinaryOperation[] binaryOperations = BinaryOperation.values();
            for (int i = 0; i < binaryOperations.length; ++i) {
                String constructorName;
                BinaryOperation operation = binaryOperations[i];
                Optional optionalReturnType = metadataProvider.getOperationReturnType(operation, (String)pair.getLeft(), (String)pair.getRight());
                if (!optionalReturnType.isPresent()) continue;
                String returnType = (String)optionalReturnType.get();
                switch (operation) {
                    case ADD: {
                        constructorName = "Add";
                        break;
                    }
                    case SUB: {
                        constructorName = "Sub";
                        break;
                    }
                    case MUL: {
                        constructorName = "Mul";
                        break;
                    }
                    case DIV: {
                        constructorName = "Div";
                        break;
                    }
                    case MOD: {
                        constructorName = "Mod";
                        break;
                    }
                    case EQUAL: {
                        constructorName = "Eq";
                        break;
                    }
                    case NOT_EQUAL: {
                        constructorName = "Neq";
                        break;
                    }
                    case GREATER: {
                        constructorName = "Gt";
                        break;
                    }
                    case GREATER_EQUAL: {
                        constructorName = "Gte";
                        break;
                    }
                    case LESS: {
                        constructorName = "Lt";
                        break;
                    }
                    case LESS_EQUAL: {
                        constructorName = "Lte";
                        break;
                    }
                    case AND: {
                        constructorName = "And";
                        break;
                    }
                    case OR: {
                        constructorName = "Or";
                        break;
                    }
                    case STRING_CONCAT: {
                        constructorName = "Cct";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported operation: " + operation);
                    }
                }
                binaryOperationsWithTypes.add((IStrategoTerm)f.makeAppl("BinaryOperation", new IStrategoTerm[]{f.makeString(constructorName), f.makeString((String)pair.getLeft()), f.makeString((String)pair.getRight()), f.makeString(returnType)}));
            }
        }
        return binaryOperationsWithTypes;
    }

    private static List<IStrategoTerm> getDataTypeSynonyms(Optional<List<DataTypeSynonym>> optionalDataTypeSynonyms, ITermFactory f) {
        ArrayList<IStrategoTerm> dataTypeSynonyms = new ArrayList<IStrategoTerm>();
        if (optionalDataTypeSynonyms.isPresent()) {
            for (DataTypeSynonym synonym : optionalDataTypeSynonyms.get()) {
                dataTypeSynonyms.add((IStrategoTerm)f.makeAppl("DataTypeSynonym", new IStrategoTerm[]{f.makeString(synonym.getSynonym()), f.makeString(synonym.getDataType())}));
            }
        }
        return dataTypeSynonyms;
    }

    private static List<IStrategoTerm> getFunctionSignatures(Optional<List<FunctionSignature>> optionalFunctionSignatures, ITermFactory f) {
        ArrayList<IStrategoTerm> functionSignatures = new ArrayList<IStrategoTerm>();
        if (optionalFunctionSignatures.isPresent()) {
            for (FunctionSignature function : optionalFunctionSignatures.get()) {
                IStrategoAppl schemaName = function.getSchemaName() == null ? f.makeAppl("None", new IStrategoTerm[0]) : f.makeAppl("Some", new IStrategoTerm[]{f.makeString(function.getSchemaName())});
                IStrategoAppl packageName = function.getPackageName() == null ? f.makeAppl("None", new IStrategoTerm[0]) : f.makeAppl("Some", new IStrategoTerm[]{f.makeString(function.getPackageName())});
                IStrategoString functionName = f.makeString(function.getFunctionName());
                ArrayList<IStrategoString> argumentTypes = new ArrayList<IStrategoString>();
                for (String argumentType : function.getArgumentTypes()) {
                    argumentTypes.add(f.makeString(argumentType));
                }
                IStrategoString returnType = f.makeString(function.getReturnType());
                functionSignatures.add((IStrategoTerm)f.makeAppl("FunctionSignature", new IStrategoTerm[]{schemaName, packageName, functionName, f.makeList(argumentTypes), returnType}));
            }
        }
        return functionSignatures;
    }

    static {
        HashMap<String, String> unescapeJavaMap = new HashMap<String, String>();
        unescapeJavaMap.put("\\\\", "\\");
        unescapeJavaMap.put("\\\"", "\"");
        unescapeJavaMap.put("\\'", "'");
        unescapeJavaMap.put("\\", "");
        unescapeJavaMap.put("\"\"", "\"");
        UNESCAPE_LEGACY_IDENTIFIER = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE), new LookupTranslator(Collections.unmodifiableMap(unescapeJavaMap))});
    }
}

