/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.pgql.lang.CommonTranslationUtil;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.TranslationContext;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class TranslateCreatePropertyGraph {
    private static int CREATE_PROPERTY_GRAPH_NAME = 0;
    private static int CREATE_PROPERTY_GRAPH_VERTEX_TABLES = 1;
    private static int CREATE_PROPERTY_GRAPH_EDGE_TABLES = 2;
    private static int CREATE_PROPERTY_GRAPH_OPTIONS = 3;
    private static int VERTEX_TABLES_TABLES_LIST = 0;
    private static int EDGE_TABLES_TABLES_LIST = 0;
    private static int VERTEX_TABLE_NAME = 0;
    private static int VERTEX_TABLE_ALIAS = 1;
    private static int VERTEX_TABLE_KEY = 2;
    private static int VERTEX_TABLE_LABEL_AND_PROPERTIES = 3;
    private static int EDGE_TABLE_NAME = 0;
    private static int EDGE_TABLE_ALIAS = 1;
    private static int EDGE_TABLE_KEY = 2;
    private static int KEY_CLAUSE_COLUMN_NAMES = 0;
    private static int EDGE_TABLE_SOURCE_VERTEX_TABLE = 3;
    private static int EDGE_TABLE_DESTINATION_VERTEX_TABLE = 4;
    private static int EDGE_TABLE_LABEL_AND_PROPERTIES = 5;
    private static int SOURCE_VERTEX_KEY = 0;
    private static int SOURCE_VERTEX_TABLE_NAME = 1;
    private static int DESTINATION_VERTEX_KEY = 0;
    private static int DESTINATION_VERTEX_TABLE_NAME = 1;
    private static int LABEL_AND_PROPERTIES_CLAUSE_LABEL_AND_PROPERTIES_LIST = 0;
    private static int LABEL_AND_PROPERTIES_LABEL_CLAUSE = 0;
    private static int LABEL_AND_PROPERTIES_PROPERTIES_CLAUSE = 1;
    private static int PROPERTIES_CLAUSE_PROPERTIES_LIST = 0;
    private static int PROPERTIES_ARE_ALL_COLUMNS_EXCEPT_PART = 1;
    private static int EXCEPT_COLUMNS_LIST = 0;
    private static int EXP_AS_VAR_EXP = 0;
    private static int EXP_AS_VAR_VAR = 1;

    protected static PgqlStatement translateCreatePropertyGraph(IStrategoTerm ast) throws PgqlException {
        IStrategoTerm graphNameT = ast.getSubterm(CREATE_PROPERTY_GRAPH_NAME);
        SchemaQualifiedName graphName = CommonTranslationUtil.getSchemaQualifiedName(graphNameT);
        List<VertexTable> vertexTables = TranslateCreatePropertyGraph.getVertexTables(ast.getSubterm(CREATE_PROPERTY_GRAPH_VERTEX_TABLES));
        List<EdgeTable> edgeTables = TranslateCreatePropertyGraph.getEdgeTables(ast.getSubterm(CREATE_PROPERTY_GRAPH_EDGE_TABLES), vertexTables);
        IStrategoTerm optionsT = ast.getSubterm(CREATE_PROPERTY_GRAPH_OPTIONS);
        List<String> options = CommonTranslationUtil.isNone(optionsT) ? null : TranslateCreatePropertyGraph.getOptions(optionsT);
        CreatePropertyGraph cpg = new CreatePropertyGraph(graphName, vertexTables, edgeTables);
        cpg.setOptions(options);
        return cpg;
    }

    private static List<VertexTable> getVertexTables(IStrategoTerm vertexTablesT) throws PgqlException {
        IStrategoTerm vertexTablesListT = vertexTablesT.getSubterm(VERTEX_TABLES_TABLES_LIST);
        ArrayList<VertexTable> result = new ArrayList<VertexTable>();
        for (IStrategoTerm vertexTableT : vertexTablesListT) {
            IStrategoTerm tableNameT = vertexTableT.getSubterm(VERTEX_TABLE_NAME);
            SchemaQualifiedName tableName = CommonTranslationUtil.getSchemaQualifiedName(tableNameT);
            String tableAlias = CommonTranslationUtil.getString(vertexTableT.getSubterm(VERTEX_TABLE_ALIAS));
            Key vertexKey = TranslateCreatePropertyGraph.getKey(vertexTableT.getSubterm(VERTEX_TABLE_KEY));
            List<Label> labels = TranslateCreatePropertyGraph.getLabels(vertexTableT.getSubterm(VERTEX_TABLE_LABEL_AND_PROPERTIES));
            result.add(new VertexTable(tableName, tableAlias, vertexKey, labels));
        }
        return result;
    }

    private static List<EdgeTable> getEdgeTables(IStrategoTerm edgeTablesT, List<VertexTable> vertexTables) throws PgqlException {
        IStrategoTerm edgeTablesListT = edgeTablesT.getSubterm(EDGE_TABLES_TABLES_LIST);
        ArrayList<EdgeTable> result = new ArrayList<EdgeTable>();
        for (IStrategoTerm edgeTableT : edgeTablesListT) {
            IStrategoTerm tableNameT = edgeTableT.getSubterm(EDGE_TABLE_NAME);
            SchemaQualifiedName tableName = CommonTranslationUtil.getSchemaQualifiedName(tableNameT);
            String tableAlias = CommonTranslationUtil.getString(edgeTableT.getSubterm(EDGE_TABLE_ALIAS));
            Key edgeKey = TranslateCreatePropertyGraph.getKey(edgeTableT.getSubterm(EDGE_TABLE_KEY));
            IStrategoTerm sourceVertexTableT = edgeTableT.getSubterm(EDGE_TABLE_SOURCE_VERTEX_TABLE);
            Key edgeSourceKey = TranslateCreatePropertyGraph.getKey(sourceVertexTableT.getSubterm(SOURCE_VERTEX_KEY));
            IStrategoTerm sourceVertexTableNameT = sourceVertexTableT.getSubterm(SOURCE_VERTEX_TABLE_NAME);
            String sourceVertexTableName = CommonTranslationUtil.getSchemaQualifiedName(sourceVertexTableNameT).getName();
            VertexTable sourceVertexTable = TranslateCreatePropertyGraph.getVertexTable(vertexTables, sourceVertexTableName);
            Key sourceVertexKey = null;
            IStrategoTerm destinationVertexTableT = edgeTableT.getSubterm(EDGE_TABLE_DESTINATION_VERTEX_TABLE);
            Key edgeDestinationKey = TranslateCreatePropertyGraph.getKey(destinationVertexTableT.getSubterm(DESTINATION_VERTEX_KEY));
            IStrategoTerm destinationVertexTableNameT = destinationVertexTableT.getSubterm(DESTINATION_VERTEX_TABLE_NAME);
            String destinationVertexTableName = CommonTranslationUtil.getSchemaQualifiedName(destinationVertexTableNameT).getName();
            VertexTable destinationVertexTable = TranslateCreatePropertyGraph.getVertexTable(vertexTables, destinationVertexTableName);
            Key destinationVertexKey = null;
            List<Label> labels = TranslateCreatePropertyGraph.getLabels(edgeTableT.getSubterm(EDGE_TABLE_LABEL_AND_PROPERTIES));
            result.add(new EdgeTable(tableName, tableAlias, edgeKey, sourceVertexTable, edgeSourceKey, sourceVertexKey, destinationVertexTable, edgeDestinationKey, destinationVertexKey, labels));
        }
        return result;
    }

    private static VertexTable getVertexTable(List<VertexTable> vertexTables, String tableAlias) {
        for (VertexTable vertexTable : vertexTables) {
            if (!vertexTable.getTableAlias().equals(tableAlias)) continue;
            return vertexTable;
        }
        return null;
    }

    private static Key getKey(IStrategoTerm keyClauseT) {
        if (CommonTranslationUtil.isNone(keyClauseT)) {
            return null;
        }
        keyClauseT = CommonTranslationUtil.getSomeValue(keyClauseT).getSubterm(KEY_CLAUSE_COLUMN_NAMES);
        ArrayList<String> columnNames = new ArrayList<String>();
        for (IStrategoTerm columnReference : keyClauseT) {
            columnNames.add(CommonTranslationUtil.getString(columnReference));
        }
        return new Key(columnNames);
    }

    private static List<Label> getLabels(IStrategoTerm labelAndPropertiesClauseT) throws PgqlException {
        IStrategoTerm labelAndPropertiesListT = labelAndPropertiesClauseT.getSubterm(LABEL_AND_PROPERTIES_CLAUSE_LABEL_AND_PROPERTIES_LIST);
        ArrayList<Label> result = new ArrayList<Label>();
        for (IStrategoTerm labelAndPropertiesT : labelAndPropertiesListT) {
            String labelName = CommonTranslationUtil.getString(labelAndPropertiesT.getSubterm(LABEL_AND_PROPERTIES_LABEL_CLAUSE));
            Label label = TranslateCreatePropertyGraph.getLabel(labelName, labelAndPropertiesT.getSubterm(LABEL_AND_PROPERTIES_PROPERTIES_CLAUSE));
            result.add(label);
        }
        return result;
    }

    private static Label getLabel(String labelName, IStrategoTerm propertiesClauseT) throws PgqlException {
        String propertiesSpecificationType;
        if (CommonTranslationUtil.isNone(propertiesClauseT)) {
            return null;
        }
        IStrategoTerm propertiesSpecificationT = CommonTranslationUtil.getSomeValue(propertiesClauseT);
        switch (propertiesSpecificationType = ((IStrategoAppl)propertiesSpecificationT).getConstructor().getName()) {
            case "PropertyExpressions": {
                IStrategoTerm propertiesListT = propertiesSpecificationT.getSubterm(PROPERTIES_CLAUSE_PROPERTIES_LIST);
                ArrayList<Property> properties = new ArrayList<Property>();
                for (IStrategoTerm expAsVarT : propertiesListT) {
                    TranslationContext translationContext = new TranslationContext(Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
                    QueryExpression valueExpression = CommonTranslationUtil.translateExp(expAsVarT.getSubterm(EXP_AS_VAR_EXP), translationContext);
                    IStrategoTerm propertyNameT = expAsVarT.getSubterm(EXP_AS_VAR_VAR);
                    String propertyName = CommonTranslationUtil.isNone(propertyNameT) ? null : CommonTranslationUtil.getString(expAsVarT.getSubterm(EXP_AS_VAR_VAR));
                    properties.add(new Property(valueExpression, propertyName));
                }
                return new Label(labelName, properties);
            }
            case "PropertiesAreAllColumns": {
                IStrategoTerm exceptColumnsT = propertiesSpecificationT.getSubterm(PROPERTIES_ARE_ALL_COLUMNS_EXCEPT_PART);
                boolean propertiesAreAllColumns = true;
                if (CommonTranslationUtil.isNone(exceptColumnsT)) {
                    return new Label(labelName, propertiesAreAllColumns);
                }
                IStrategoTerm exceptColumnsListT = CommonTranslationUtil.getSomeValue(exceptColumnsT).getSubterm(EXCEPT_COLUMNS_LIST);
                ArrayList<String> columnNames = new ArrayList<String>();
                for (IStrategoTerm columnNameT : exceptColumnsListT) {
                    columnNames.add(CommonTranslationUtil.getString(columnNameT));
                }
                return new Label(labelName, propertiesAreAllColumns, columnNames);
            }
        }
        throw new IllegalArgumentException(propertiesSpecificationType);
    }

    private static List<String> getOptions(IStrategoTerm optionsT) throws PgqlException {
        IStrategoTerm optionsListT = CommonTranslationUtil.getList(optionsT);
        ArrayList<String> options = new ArrayList<String>();
        for (IStrategoTerm optionT : optionsListT) {
            options.add(CommonTranslationUtil.getString(optionT));
        }
        return options;
    }
}

