/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;

public final class DebugHeapSubsetClasses
extends DebugHeapSubset {
    private List classes = new ArrayList();
    private List subclasses = new ArrayList();

    public DebugHeapSubsetClasses() {
        this(null, null);
    }

    public DebugHeapSubsetClasses(String name, DebugClassInfo classInfo) {
        super(name, classInfo);
    }

    public synchronized int countClasses() {
        return this.classes.size();
    }

    public synchronized String[] getClasses() {
        String[] array = new String[this.classes.size()];
        return this.classes.toArray(array);
    }

    public synchronized void addClass(String classname, boolean includeSubclasses) {
        this.classes.add(classname);
        this.subclasses.add(new Boolean(includeSubclasses));
    }

    public synchronized void removeClass(String classname) {
        int i = this.classes.indexOf(classname);
        if (i != -1) {
            this.classes.remove(i);
            this.subclasses.remove(i);
        }
    }

    public synchronized void removeClass(int position) {
        this.classes.remove(position);
        this.subclasses.remove(position);
    }

    public synchronized boolean getIncludeSubclasses(String classname) {
        int i = this.classes.indexOf(classname);
        if (i != -1) {
            return (Boolean)this.subclasses.get(i);
        }
        return false;
    }

    public synchronized void setIncludeSubclasses(String classname, boolean includeSubclasses) {
        int i = this.classes.indexOf(classname);
        if (i != -1) {
            this.subclasses.set(i, new Boolean(includeSubclasses));
        }
    }

    public synchronized void removeAllClasses() {
        this.classes.clear();
        this.subclasses.clear();
    }
}

