/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.internal.debugger.extender.breakpoint;

import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.debugger.extender.DebuggerExtenderAPIVersion;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderBreakpoint;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderBreakpointLogEntry;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderExceptionBreakpoint;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderFileLineBreakpoint;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderMethodBreakpoint;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderPropertiesBreakpoint;
import oracle.ide.debugger.extender.breakpoint.DebuggerExtenderURLLineBreakpoint;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointLogEntry;
import oracle.ide.runner.DebuggerExceptionBreakpoint;
import oracle.ide.runner.DebuggerFileLineBreakpoint;
import oracle.ide.runner.DebuggerMethodBreakpoint;
import oracle.ide.runner.DebuggerPropertiesBreakpoint;
import oracle.ide.runner.DebuggerURLLineBreakpoint;
import oracle.ideimpl.debugger.extender.breakpoint.CommonBreakpointLogEntryBase;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.internal.debugger.extender.ExtenderManager;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;

public class ExtenderBreakpoint {
    protected CoreBreakpoint breakpoint;
    protected CommonBreakpointLogEntryBase logEntry;
    protected DebuggerExtenderAPIVersion apiVersion;
    protected ExtenderBreakpointVersion13 v13;
    protected ExtenderBreakpointVersion12 v12;

    public ExtenderBreakpointVersion13 ExtenderBreakpointVersion13() {
        if (this instanceof ExtenderBreakpointVersion13) {
            return (ExtenderBreakpointVersion13)this;
        }
        if (this instanceof ExtenderBreakpointVersion12) {
            return null;
        }
        return this.v13;
    }

    public ExtenderBreakpointVersion12 ExtenderBreakpointVersion12() {
        if (this instanceof ExtenderBreakpointVersion12) {
            return (ExtenderBreakpointVersion12)this;
        }
        if (this instanceof ExtenderBreakpointVersion13) {
            return null;
        }
        return this.v12;
    }

    private ExtenderBreakpoint(CoreBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Need valid breakpoint");
        }
        this.breakpoint = breakpoint;
        String extenderId = breakpoint.getDebuggerExtenderID();
        this.apiVersion = ExtenderManager.getAPIVersionForExtenderId(extenderId);
        if (this.apiVersion == DebuggerExtenderAPIVersion.V13) {
            this.v13 = new ExtenderBreakpointVersion13(breakpoint);
        } else if (this.apiVersion == DebuggerExtenderAPIVersion.V12) {
            this.v12 = new ExtenderBreakpointVersion12(breakpoint);
        }
    }

    private ExtenderBreakpoint() {
    }

    public static ExtenderBreakpointVersion12 createExtenderBreakpointVersion12(CoreBreakpoint breakpoint) {
        return new ExtenderBreakpoint(breakpoint).ExtenderBreakpointVersion12();
    }

    public static ExtenderBreakpointVersion13 createExtenderBreakpointVersion13(CoreBreakpoint breakpoint) {
        return new ExtenderBreakpoint(breakpoint).ExtenderBreakpointVersion13();
    }

    public DebuggerExtenderAPIVersion version() {
        return this.apiVersion;
    }

    public CoreBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    String getDebuggerExtenderID() {
        return this.breakpoint.getDebuggerExtenderID();
    }

    public void enableBreakpoint(boolean enable) {
        this.breakpoint.setEnabled(enable);
    }

    public Icon getIcon() {
        return BreakpointRuntimeSupport.getIcon(this.breakpoint);
    }

    public boolean isEnabled() {
        return this.breakpoint.isEnabled();
    }

    public URL getScope() {
        return this.breakpoint.getOwnerURL();
    }

    public String getCondition() {
        return this.breakpoint.getCondition();
    }

    public boolean canEditCondition() {
        return this.breakpoint.isEditCondition();
    }

    public String getHiddenCondition() {
        return this.breakpoint.getHiddenCondition();
    }

    public int getPassCount() {
        return this.breakpoint.getPassCount();
    }

    public boolean canEditPassCount() {
        return this.breakpoint.isEditPassCount();
    }

    public String getGroupName() {
        return this.breakpoint.getGroupName();
    }

    public boolean canEditGroupName() {
        return this.breakpoint.isEditGroupName();
    }

    public String getCustomDescription() {
        return this.breakpoint.getCustomDescription();
    }

    public String getCustomTypeString() {
        return this.breakpoint.getCustomTypeString();
    }

    public String getBreakForThreadNamed() {
        return this.breakpoint.getThreadName();
    }

    public String getBreakForThreadNotNamed() {
        return this.breakpoint.getThreadNameNot();
    }

    public boolean canEditBreakForThreads() {
        return this.breakpoint.isEditBreakForThreads();
    }

    public boolean isHaltOnBreakpointHit() {
        return this.breakpoint.isActionHalt();
    }

    public boolean isBeepOnBreakpointHit() {
        return this.breakpoint.isActionBeep();
    }

    public String getEnableBreakpointGroupOnBreakpointHit() {
        return this.breakpoint.getActionEnableOther();
    }

    public String getDisableBreakpointGroupOnBreakpointHit() {
        return this.breakpoint.getActionDisableOther();
    }

    public boolean canEditBreakpointHitActions() {
        return this.breakpoint.isEditBreakpointHitActions();
    }

    public Map<String, String> getProperties() {
        return this.breakpoint.getProperties();
    }

    public String getMethodName() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.METHOD || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.METHOD) {
            return this.breakpoint.getMethod();
        }
        return null;
    }

    public String getPackage() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.FILE_LINE || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE) {
            return this.breakpoint.getPackage();
        }
        return null;
    }

    public String getFileName() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.FILE_LINE || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE) {
            return this.breakpoint.getFile();
        }
        return null;
    }

    public int getLine() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.FILE_LINE || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE || this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.URL_LINE || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.URL_LINE) {
            return this.breakpoint.getLine();
        }
        return -1;
    }

    public String getExceptionName() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.EXCEPTION || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.getException();
        }
        return null;
    }

    public boolean isBreakOnCaughtExceptions() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.EXCEPTION || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.isCaught();
        }
        return false;
    }

    public boolean isBreakOnUncaughtExceptions() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.EXCEPTION || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.isUncaught();
        }
        return false;
    }

    public URL getURL() {
        if (this.ExtenderBreakpointVersion13() != null && this.ExtenderBreakpointVersion13().getKind() == DebuggerExtenderBreakpoint.BreakpointKind.URL_LINE || this.ExtenderBreakpointVersion12() != null && this.ExtenderBreakpointVersion12().getKind() == DebuggerBreakpoint.BreakpointKind.URL_LINE) {
            return this.breakpoint.getURL();
        }
        return null;
    }

    protected class ExtenderBreakpointLogEntry
    implements DebuggerBreakpointLogEntry,
    DebuggerExtenderBreakpointLogEntry {
        protected ExtenderBreakpointLogEntry() {
        }

        public boolean isEnabled() {
            return ExtenderBreakpoint.this.breakpoint.isActionLog();
        }

        public boolean isLogStackTrace() {
            return ExtenderBreakpoint.this.breakpoint.isActionLogStack();
        }

        public String getLogTag() {
            return ExtenderBreakpoint.this.breakpoint.getActionLogTag();
        }

        public String getLogExpression() {
            return ExtenderBreakpoint.this.breakpoint.getActionLogExpression();
        }
    }

    public class ExtenderBreakpointVersion12
    extends ExtenderBreakpoint
    implements DebuggerMethodBreakpoint,
    DebuggerFileLineBreakpoint,
    DebuggerExceptionBreakpoint,
    DebuggerURLLineBreakpoint,
    DebuggerPropertiesBreakpoint {
        private ExtenderBreakpointVersion12(CoreBreakpoint breakpoint) {
            this.breakpoint = breakpoint;
        }

        public DebuggerBreakpoint.BreakpointKind getKind() {
            switch (this.breakpoint.getType()) {
                case 2: {
                    return DebuggerBreakpoint.BreakpointKind.EXCEPTION;
                }
                case 0: {
                    return DebuggerBreakpoint.BreakpointKind.FILE_LINE;
                }
                case 5: {
                    return DebuggerBreakpoint.BreakpointKind.URL_LINE;
                }
                case 1: {
                    return DebuggerBreakpoint.BreakpointKind.METHOD;
                }
                case 8: {
                    return DebuggerBreakpoint.BreakpointKind.PROPERTIES;
                }
            }
            return null;
        }

        public DebuggerBreakpoint.BreakpointState getActiveState() {
            int state = BreakpointRuntimeSupport.getRuntimeStatus(this.breakpoint, null);
            switch (state) {
                case 0: {
                    return DebuggerBreakpoint.BreakpointState.DISABLED;
                }
                case 1: {
                    return DebuggerBreakpoint.BreakpointState.ENABLED;
                }
                case 2: {
                    return DebuggerBreakpoint.BreakpointState.UNVERIFIED;
                }
                case 3: {
                    return DebuggerBreakpoint.BreakpointState.VERIFIED;
                }
            }
            return null;
        }

        public DebuggerBreakpointLogEntry getLogEntryOnBreakpointHit() {
            if (this.logEntry == null) {
                this.logEntry = new ExtenderBreakpointLogEntry();
            }
            return (DebuggerBreakpointLogEntry)this.logEntry;
        }
    }

    public class ExtenderBreakpointVersion13
    extends ExtenderBreakpoint
    implements DebuggerExtenderBreakpoint,
    DebuggerExtenderMethodBreakpoint,
    DebuggerExtenderFileLineBreakpoint,
    DebuggerExtenderExceptionBreakpoint,
    DebuggerExtenderURLLineBreakpoint,
    DebuggerExtenderPropertiesBreakpoint {
        private ExtenderBreakpointVersion13(CoreBreakpoint breakpoint) {
            this.breakpoint = breakpoint;
        }

        public DebuggerExtenderBreakpoint.BreakpointKind getKind() {
            switch (this.breakpoint.getType()) {
                case 2: {
                    return DebuggerExtenderBreakpoint.BreakpointKind.EXCEPTION;
                }
                case 0: {
                    return DebuggerExtenderBreakpoint.BreakpointKind.FILE_LINE;
                }
                case 5: {
                    return DebuggerExtenderBreakpoint.BreakpointKind.URL_LINE;
                }
                case 1: {
                    return DebuggerExtenderBreakpoint.BreakpointKind.METHOD;
                }
                case 8: {
                    return DebuggerExtenderBreakpoint.BreakpointKind.PROPERTIES;
                }
            }
            return null;
        }

        public DebuggerExtenderBreakpoint.BreakpointState getActiveState() {
            int state = BreakpointRuntimeSupport.getRuntimeStatus(this.breakpoint, null);
            switch (state) {
                case 0: {
                    return DebuggerExtenderBreakpoint.BreakpointState.DISABLED;
                }
                case 1: {
                    return DebuggerExtenderBreakpoint.BreakpointState.ENABLED;
                }
                case 2: {
                    return DebuggerExtenderBreakpoint.BreakpointState.UNVERIFIED;
                }
                case 3: {
                    return DebuggerExtenderBreakpoint.BreakpointState.VERIFIED;
                }
            }
            return null;
        }

        public DebuggerExtenderBreakpointLogEntry getLogEntryOnBreakpointHit() {
            if (this.logEntry == null) {
                this.logEntry = new ExtenderBreakpointLogEntry();
            }
            return (DebuggerExtenderBreakpointLogEntry)this.logEntry;
        }
    }
}

