/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.EnvironmentVariable;
import oracle.jdevimpl.runner.RunMgrArb;

@Deprecated
public class EnvVariablesPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private DefaultTableModel envVarsModel;
    private transient List<TransientEnvironmentVariable> profilesEnvVars;
    private List<String> envVarNames;
    private JTable envVarsTable;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private EnvVarTableCellEditor cellEditor;

    public EnvVariablesPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_editrun_env_var_html");
        JLabel envVarsLabel = new JLabel();
        this.envVarsModel = new DefaultTableModel();
        this.envVarsModel.setColumnCount(2);
        this.profilesEnvVars = new ArrayList<TransientEnvironmentVariable>();
        this.envVarNames = new ArrayList<String>();
        this.envVarsTable = new JTable(this.envVarsModel);
        this.envVarsTable.setTableHeader(null);
        this.envVarsTable.setSelectionMode(0);
        this.envVarsTable.setShowGrid(false);
        this.cellEditor = new EnvVarTableCellEditor();
        this.envVarsTable.getColumnModel().getColumn(0).setCellEditor(this.cellEditor);
        this.envVarsTable.getColumnModel().getColumn(1).setCellEditor(this.cellEditor);
        JScrollPane envVarsScrollPane = new JScrollPane(this.envVarsTable);
        JViewport viewport = envVarsScrollPane.getViewport();
        envVarsScrollPane.setOpaque(true);
        viewport.setOpaque(true);
        envVarsScrollPane.setBackground(this.envVarsTable.getBackground());
        viewport.setBackground(this.envVarsTable.getBackground());
        Border border = envVarsScrollPane.getBorder();
        if (border == null || border instanceof UIResource) {
            envVarsScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
        envVarsScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.editButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        ResourceUtils.resLabel((JLabel)envVarsLabel, (Component)this.envVarsTable, (String)RunMgrArb.getString(103));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(108));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)RunMgrArb.getString(109));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)RunMgrArb.getString(110));
        this.envVarsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EnvVariablesPanel.this.updateButtons();
            }
        });
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add(envVarsLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(envVarsScrollPane, new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editButton, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.newButton, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.deleteButton, new GridBagConstraints(1, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        this.loadFrom(runConfiguration);
    }

    public void onExit(TraversableContext tc) {
        this.cellEditor.cancelCellEditing();
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        this.commitTo(runConfiguration);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cellEditor.cancelCellEditing();
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editEnvVar();
        } else if (source == this.newButton) {
            this.newEnvVar();
        } else if (source == this.deleteButton) {
            this.deleteEnvVar();
        }
    }

    private void loadFrom(RunConfiguration runConfig) {
        List<EnvironmentVariable> evs = runConfig.getEnvironmentVariables();
        this.profilesEnvVars.clear();
        this.envVarNames.clear();
        for (int i = this.envVarsModel.getRowCount() - 1; i >= 0; --i) {
            this.envVarsModel.removeRow(i);
        }
        if (evs == null) {
            this.updateButtons();
            return;
        }
        for (EnvironmentVariable ev : evs) {
            String name = ev.getName();
            this.envVarsModel.addRow(new Object[]{ev.getName(), ev.getValue()});
            TransientEnvironmentVariable tev = new TransientEnvironmentVariable(ev);
            this.profilesEnvVars.add(tev);
            this.envVarNames.add(name);
        }
        this.updateButtons();
    }

    private void commitTo(RunConfiguration runConfig) {
        int size = this.envVarsTable.getRowCount();
        TransientEnvironmentVariable[] envVarDefs = this.profilesEnvVars.toArray(new TransientEnvironmentVariable[size]);
        ListStructure envVars = ListStructure.newInstance();
        for (int i = 0; i < this.envVarsModel.getRowCount(); ++i) {
            envVarDefs[i].commit();
            envVars.add((Object)envVarDefs[i].getHash());
        }
        runConfig.setEnvironmentVariables(envVars);
    }

    private TransientEnvironmentVariable getSelectedEnvVar() {
        int index = this.envVarsTable.getSelectionModel().getMinSelectionIndex();
        if (index >= 0 && index < this.profilesEnvVars.size()) {
            return this.profilesEnvVars.get(index);
        }
        return null;
    }

    private void updateButtons() {
        TransientEnvironmentVariable envVar = this.getSelectedEnvVar();
        boolean envVarSelected = envVar != null;
        this.editButton.setEnabled(envVarSelected);
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(108));
        this.deleteButton.setEnabled(envVarSelected);
    }

    private void editEnvVar() {
        TransientEnvironmentVariable selected = this.getSelectedEnvVar();
        if (selected != null) {
            this.editEnvVar(selected);
            this.updateButtons();
        }
    }

    private void editEnvVar(TransientEnvironmentVariable envVar) {
        TreeSet<String> usedNames = new TreeSet<String>();
        usedNames.addAll(this.envVarNames);
        EnvVarDefinitionDialog editDialog = new EnvVarDefinitionDialog(envVar.getName(), usedNames);
        editDialog.showEditDialog(envVar);
        int row = this.envVarsTable.getSelectionModel().getMinSelectionIndex();
        this.envVarsModel.setValueAt(envVar.getName(), row, 0);
        this.envVarsModel.setValueAt(envVar.getValue(), row, 1);
    }

    private void newEnvVar() {
        TreeSet<String> usedNames = new TreeSet<String>();
        usedNames.addAll(this.envVarNames);
        TransientEnvironmentVariable envVar = this.getSelectedEnvVar();
        EnvVarDefinitionDialog newDialog = new EnvVarDefinitionDialog(null, usedNames);
        String name = newDialog.showNewDialog();
        if (name != null) {
            String profileName;
            int insertRow;
            TransientEnvironmentVariable newEV = new TransientEnvironmentVariable(name);
            newEV.setValue(newDialog.getValue());
            for (insertRow = 0; insertRow < this.envVarNames.size() && (profileName = this.envVarNames.get(insertRow)).compareTo(name) <= 0; ++insertRow) {
            }
            if (insertRow < this.envVarNames.size()) {
                this.envVarsModel.insertRow(insertRow, new Object[]{newEV.getName(), newEV.getValue()});
                this.profilesEnvVars.add(insertRow, newEV);
                this.envVarNames.add(insertRow, newEV.getName());
            } else {
                this.envVarsModel.addRow(new Object[]{newEV.getName(), newEV.getValue()});
                this.profilesEnvVars.add(newEV);
                this.envVarNames.add(newEV.getName());
            }
            this.envVarsTable.getSelectionModel().setSelectionInterval(insertRow, insertRow);
            this.updateButtons();
        }
    }

    private void deleteEnvVar() {
        int index = this.envVarsTable.getSelectionModel().getMinSelectionIndex();
        if (index != -1) {
            String name = (String)this.envVarsModel.getValueAt(index, 0);
            this.envVarsModel.removeRow(index);
            this.profilesEnvVars.remove(index);
            this.envVarNames.remove(index);
            if (index >= this.envVarsModel.getRowCount()) {
                --index;
            }
            this.envVarsTable.getSelectionModel().setSelectionInterval(index, index);
            this.updateButtons();
        }
    }

    public String getDataKey() {
        return null;
    }

    public String[] getPropertyKeys() {
        return new String[0];
    }

    private class TransientEnvironmentVariable {
        private EnvironmentVariable persistentVersion;
        private String name;
        private String value;
        private HashStructure _hash;

        TransientEnvironmentVariable(EnvironmentVariable ev) {
            this.name = ev.getName();
            this.value = ev.getValue();
            this.persistentVersion = ev;
            this._hash = ev.getProperties();
        }

        TransientEnvironmentVariable(String name) {
            this.name = name;
            this._hash = null;
        }

        private void commit() {
            if (this._hash == null) {
                this.persistentVersion = new EnvironmentVariable();
                this._hash = this.persistentVersion.getProperties();
            }
            this.persistentVersion.setName(this.name);
        }

        private String getName() {
            return this.name;
        }

        private String getValue() {
            return this.value;
        }

        private HashStructure getHash() {
            return this._hash;
        }

        private void setName(String name) {
            this.name = name;
        }

        private void setValue(String value) {
            this.value = value;
        }
    }

    private class EnvVarTableCellEditor
    extends DefaultCellEditor {
        private Object currentValue;
        private boolean editing;
        private int column;

        EnvVarTableCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = value;
            this.editing = true;
            this.column = column;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            if (!this.editing) {
                return true;
            }
            String newValue = this.getCellEditorValue().toString().trim();
            if (newValue.equals(this.currentValue.toString())) {
                return false;
            }
            TransientEnvironmentVariable currentEnvVar = EnvVariablesPanel.this.getSelectedEnvVar();
            switch (this.column) {
                case 0: {
                    if (newValue.length() <= 0) {
                        MessageDialog.error((Component)((Object)EnvVariablesPanel.this), (Object)RunMgrArb.getString(116), (String)RunMgrArb.getString(115), null);
                        this.delegate.setValue(this.currentValue);
                        this.editing = true;
                        return true;
                    }
                    if (EnvVariablesPanel.this.envVarNames.contains(newValue)) {
                        MessageDialog.error((Component)((Object)EnvVariablesPanel.this), (Object)RunMgrArb.format(120, newValue), (String)RunMgrArb.format(119, newValue), null);
                        this.delegate.setValue(this.currentValue);
                        this.editing = true;
                        return true;
                    }
                    EnvVariablesPanel.this.envVarNames.remove(this.currentValue);
                    EnvVariablesPanel.this.envVarNames.add(newValue);
                    currentEnvVar.setName(newValue);
                    break;
                }
                case 1: {
                    if (newValue.length() <= 0) {
                        MessageDialog.error((Component)((Object)EnvVariablesPanel.this), (Object)RunMgrArb.getString(117), (String)RunMgrArb.getString(115), null);
                        this.delegate.setValue(this.currentValue);
                        this.editing = true;
                        return true;
                    }
                    currentEnvVar.setValue(newValue);
                }
            }
            this.editing = false;
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this.editing) {
                this.editing = false;
                super.cancelCellEditing();
            }
        }
    }

    class EnvVarDefinitionDialog
    extends JPanel
    implements DocumentListener {
        private JTextField nameTextField;
        private JTextField valueTextField;
        private JEWTDialog dlg;
        private Set usedNames;

        EnvVarDefinitionDialog(String name, Set usedNames) {
            super(new GridBagLayout());
            this.usedNames = usedNames;
            if (name != null && this.usedNames.contains(name)) {
                this.usedNames.remove(name);
            }
            JLabel nameLabel = new JLabel();
            this.nameTextField = new JTextField();
            JLabel valueLabel = new JLabel();
            this.valueTextField = new JTextField();
            ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameTextField, (String)RunMgrArb.getString(111));
            ResourceUtils.resLabel((JLabel)valueLabel, (Component)this.valueTextField, (String)RunMgrArb.getString(112));
            this.nameTextField.getDocument().addDocumentListener(this);
            this.valueTextField.getDocument().addDocumentListener(this);
            int y = 0;
            this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)valueLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.valueTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String showNewDialog() {
            String title = RunMgrArb.getString(113);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_editrun_new_env_var_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return this.getNewName();
            }
            return null;
        }

        void showEditDialog(TransientEnvironmentVariable envVar) {
            String title = RunMgrArb.getString(114);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_editrun_edit_env_var_html");
            this.nameTextField.setText(envVar.getName());
            this.valueTextField.setText(envVar.getValue());
            dlg.setOKButtonEnabled(this.canOk());
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                envVar.setName(this.nameTextField.getText());
                envVar.setValue(this.valueTextField.getText());
                return;
            }
        }

        String getValue() {
            return this.valueTextField.getText();
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && EnvVarDefinitionDialog.this.veto()) {
                        throw new PropertyVetoException("no", evt);
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0 && this.valueTextField.getText().length() > 0;
        }

        private boolean veto() {
            String name = this.nameTextField.getText();
            if (this.usedNames.contains(name)) {
                MessageDialog.error((Component)this, (Object)RunMgrArb.format(120, name), (String)RunMgrArb.format(119, this.dlg.getTitle()), null);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }
    }
}

