/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.runner.res.ExtensionResources;

public final class RunManager
implements Addin,
Controller,
Observer {
    private Project activeProject;
    private Workspace activeWorkspace;
    private static final int MANAGE_RUN_CONFIGURATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"ManageRunConfigurations");
    private static RunManager instance;

    private RunManager() {
        instance = this;
    }

    static RunManager getInstance() {
        return instance;
    }

    public void initialize() {
        Ide.getSystem().attach((Observer)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        return true;
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID = change.getMessageID();
        if (observed == Ide.getSystem()) {
            if (messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                this.activeProjectChanged();
            }
        } else if (observed instanceof Project) {
            if (messageID == UpdateMessage.CHILD_REMOVED) {
                RunManager.projectFilesRemoved((Project)observed, change.getRemoveObjects());
            } else if (messageID == UpdateMessage.CHILD_RENAMED) {
                RunManager.projectFileRenamed((Project)observed, change);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Assert.check((boolean)action.isEnabled());
        int cmdId = action.getCommandId();
        if (action.getValue("UserData") != null && action.getValue("UserData").toString().startsWith("RunConfigurationName:")) {
            RunConfiguration runConfiguration;
            String runConfigurationName = action.getValue("UserData").toString().substring(21);
            if (runConfigurationName != null && (runConfiguration = RunConfigurations.getRunConfigurationByName(this.activeProject, runConfigurationName)) != null) {
                RunConfigurations.setActiveRunConfiguration(this.activeProject, this.activeWorkspace, runConfiguration);
            }
            return true;
        }
        if (cmdId == MANAGE_RUN_CONFIGURATIONS_CMD_ID) {
            this.manageRunConfigurations(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    private void activeProjectChanged() {
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        this.activeProject = Ide.getActiveProject();
        this.activeWorkspace = Ide.getActiveWorkspace();
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
    }

    private static void projectFilesRemoved(Project jproject, List removed) {
        try {
            RunConfiguration rc = RunConfiguration.getInstance((PropertyStorage)jproject);
            URL targetURL = rc.getTargetURL();
            if (targetURL != null) {
                for (Object o : removed) {
                    if (!(o instanceof Locatable) || !((Locatable)o).getURL().equals(targetURL)) continue;
                    rc.setTargetURL(null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void projectFileRenamed(Project jproject, UpdateMessage change) {
        try {
            Node newNode;
            URL oldURL;
            RunConfiguration rc = RunConfiguration.getInstance((PropertyStorage)jproject);
            URL targetURL = rc.getTargetURL();
            if (targetURL != null && (oldURL = RenameMessage.getOldURL((UpdateMessage)change)) != null && URLFileSystem.equals((URL)oldURL, (URL)targetURL) && (newNode = RenameMessage.getRenamedNode((UpdateMessage)change)) != null) {
                rc.setTargetURL(newNode.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void manageRunConfigurations(Context context) {
        Project project = context.getProject();
        if (project != null) {
            String[] path = new String[]{ExtensionResources.get("PROJECT_PROPERTIES_RUN_DEBUG")};
            ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)project, (String[])path);
        }
    }
}

