/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.insight.completion.DefaultCompletionSupport;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLTextField;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.SeparatorListCellRenderer;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.BreakpointsWindowSettings;
import oracle.jdevimpl.debugger.DebugObjectFactory;
import oracle.jdevimpl.debugger.breakpoint.BreakpointSettings;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerHelperHook;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerLanguageHelper;
import oracle.jdevimpl.debugger.support.XSLTDebugHelper;
import oracle.jdevimpl.internal.debugger.extender.ExtenderManager;
import oracle.jdevimpl.internal.debugger.extender.breakpoint.BreakpointDefinitionPanel;
import oracle.jdevimpl.runner.debug.BreakpointActionsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.xml.JDevXmlIntegrationUtils;

final class BreakpointOptionsDialog
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener,
ChangeListener {
    private final String USERDATA_CLASSNAME_COMPONENT = "classname_component";
    private final String USERDATA_PACKAGENAME_COMPONENT = "packagename_component";
    private Project jproject = Ide.getActiveProject();
    private JEWTDialog dlg;
    private URL ownerURL;
    private CoreBreakpoint bp;
    private CoreBreakpoint[] group;
    private CoreBreakpoint[] breakpoints;
    private String[] groupNames;
    private JTabbedPane tabbedPane;
    private JPanel definitionPane;
    private JPanel conditionsPane;
    private JPanel actionsPane;
    private int currentType;
    private BreakpointTypeItem currentTypeItem;
    private HistoryList packageHistoryList;
    private JComboBox packageComboBox;
    private JTextField packageEditor;
    private HistoryList fileHistoryList;
    private JComboBox fileComboBox;
    private JTextField fileEditor;
    private JTextField lineTextField;
    private HistoryList methodHistoryList;
    private JComboBox methodComboBox;
    private JTextField methodEditor;
    private HistoryList exceptionHistoryList;
    private JComboBox exceptionComboBox;
    private JTextField exceptionEditor;
    private JButton exceptionBrowseButton;
    private JCheckBox caughtCheckBox;
    private JCheckBox uncaughtCheckBox;
    private HistoryList classHistoryList;
    private JComboBox classComboBox;
    private JTextField classEditor;
    private JButton classBrowseButton;
    private URLTextField urlTextField;
    private JButton urlBrowseButton;
    private JTextField lineTextField2;
    private HistoryList watchpointClassHistoryList;
    private JComboBox watchpointClassComboBox;
    private JTextField watchpointClassEditor;
    private JButton watchpointClassBrowseButton;
    private HistoryList watchpointFieldHistoryList;
    private JComboBox watchpointFieldComboBox;
    private JTextField watchpointFieldEditor;
    private JCheckBox accessCheckBox;
    private JCheckBox modifyCheckBox;
    private JLabel groupNameLabel;
    private HistoryList groupNameHistoryList;
    private JComboBox groupNameComboBox;
    private JTextField groupNameEditor;
    private JCheckBox groupNameCheckBox;
    private JTextField groupNameTextField;
    private HistoryList conditionHistoryList;
    private JComboBox conditionComboBox;
    private JTextField conditionEditor;
    private JRadioButton radioAllThreads;
    private JRadioButton radioOneThread;
    private HistoryList threadHistoryList;
    private JComboBox threadComboBox;
    private JTextField threadEditor;
    private JRadioButton radioNotThread;
    private HistoryList notThreadHistoryList;
    private JComboBox notThreadComboBox;
    private JTextField notThreadEditor;
    private NumericSpinBox passCountBox;
    private BreakpointActionsPanel bpActionsPanel;
    private BreakpointSettings bpTemplate;
    private static final String packageHistoryName = "DebugBreakpointPackage";
    private static final String fileHistoryName = "DebugBreakpointFile";
    private static final String methodHistoryName = "DebugBreakpointMethod";
    private static final String exceptionHistoryName = "DebugBreakpointException";
    private static final String classHistoryName = "DebugBreakpointClass";
    private static final String watchpointClassHistoryName = "DebugBreakpointWatchpointClass";
    private static final String watchpointFieldHistoryName = "DebugBreakpointWatchpointField";
    private static final String groupNameHistoryName = "DebugBreakpointGroupName";
    private static final String conditionHistoryName = "DebugBreakpointCondition";
    private static final String threadHistoryName = "DebugBreakpointThread";
    private static final String notThreadHistoryName = "DebugBreakpointThreadNot";
    static final int INITIAL_FOCUS_DONT_CARE = 0;
    static final int INITIAL_FOCUS_DEFINITIONS = 1;
    static final int INITIAL_FOCUS_CONDITIONS = 2;
    static final int INITIAL_FOCUS_ACTIONS = 3;
    static final int INITIAL_FOCUS_GROUPS = 4;
    private int initialFocus;
    private boolean preferClassPickerOverInsight = true;
    private boolean canBrowseClasses = false;

    static BreakpointOptionsDialog showBreakpointOptionsDialog(URL ownerURL, CoreBreakpoint bp, BreakpointSettings bpTemplate, String[] groupNames, int initialFocus) {
        BreakpointOptionsDialog panel = new BreakpointOptionsDialog(ownerURL, bp, bpTemplate, groupNames, initialFocus);
        String title = bp == null ? DbgArb.format(386, bpTemplate.getTypeString()) : DbgArb.format(387, bp.getTypeString());
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getInitialFocus(), (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_new_edit_breakptdialog_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel;
        }
        return null;
    }

    static BreakpointOptionsDialog showBreakpointOptionsDialog(CoreBreakpoint[] breakpoints, boolean group, String[] groupNames, int initialFocus) {
        BreakpointOptionsDialog panel = new BreakpointOptionsDialog(breakpoints, group, groupNames, initialFocus);
        String title = group ? DbgArb.getString(388) : DbgArb.getString(389);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getInitialFocus(), (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel;
        }
        return null;
    }

    private BreakpointOptionsDialog(String[] groupNames, int initialFocus) {
        super(new BorderLayout());
        if (this.jproject == null) {
            this.jproject = Ide.getDefaultProject();
        }
        this.groupNames = groupNames;
        this.initialFocus = initialFocus;
    }

    private BreakpointOptionsDialog(URL ownerURL, CoreBreakpoint bp, BreakpointSettings bpTemplate, String[] groupNames, int initialFocus) {
        this(groupNames, initialFocus);
        this.ownerURL = ownerURL;
        this.bp = bp;
        this.bpTemplate = bpTemplate;
        this.currentType = bpTemplate.getType();
        this.currentTypeItem = new BreakpointTypeItem(this.currentType, bpTemplate.getTypeString(), bpTemplate.isCustom());
        this.init();
    }

    private BreakpointOptionsDialog(CoreBreakpoint[] breakpoints, boolean group, String[] groupNames, int initialFocus) {
        this(groupNames, initialFocus);
        this.bp = breakpoints[0];
        BreakpointSettings breakpointSettings = this.bpTemplate = this.bp != null ? this.bp.getBreakpointSettings() : new BreakpointSettings();
        if (group) {
            this.group = breakpoints;
        } else {
            this.breakpoints = breakpoints;
        }
        this.init();
    }

    private void init() {
        this.tabbedPane = new JTabbedPane();
        this.definitionPane = this.makeDefinitionPane();
        this.conditionsPane = this.makeConditionsPane();
        this.actionsPane = this.makeActionsPane(this.groupNames);
        this.tabbedPane.addTab(DbgArb.getString(390), this.definitionPane);
        this.tabbedPane.addTab(DbgArb.getString(391), this.conditionsPane);
        this.tabbedPane.addTab(DbgArb.getString(392), this.actionsPane);
        this.add((Component)this.tabbedPane, "Center");
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canBrowseClassOrPackage()) continue;
            this.canBrowseClasses = true;
            break;
        }
        switch (this.initialFocus) {
            case 1: 
            case 4: {
                this.tabbedPane.setSelectedComponent(this.definitionPane);
                break;
            }
            case 2: {
                this.tabbedPane.setSelectedComponent(this.conditionsPane);
                break;
            }
            case 3: {
                this.tabbedPane.setSelectedComponent(this.actionsPane);
            }
        }
        this.addListeners();
    }

    private void addListeners() {
        this.tabbedPane.addChangeListener(this);
        if (this.group != null) {
            this.groupNameTextField.getDocument().addDocumentListener(this);
        } else if (this.breakpoints != null) {
            this.groupNameCheckBox.addItemListener(this);
            this.groupNameComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.groupNameComboBox, (DocumentListener)this);
        } else {
            this.groupNameComboBox.addActionListener(this);
        }
        this.conditionComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.conditionComboBox, (DocumentListener)this);
        this.radioAllThreads.addActionListener(this);
        this.radioAllThreads.addItemListener(this);
        this.radioOneThread.addActionListener(this);
        this.radioOneThread.addItemListener(this);
        this.radioNotThread.addActionListener(this);
        this.radioNotThread.addItemListener(this);
        this.threadComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.threadComboBox, (DocumentListener)this);
        this.notThreadComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.notThreadComboBox, (DocumentListener)this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    if (BreakpointOptionsDialog.this.veto()) {
                        throw new PropertyVetoException("no", evt);
                    }
                    BreakpointOptionsDialog.this.doOk();
                }
            }
        });
    }

    private boolean showXSLTMessage() {
        String[] messages = new String[]{DbgArb.format(753, this.currentTypeItem.toString()), DbgArb.getString(754)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(752, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private boolean findClass(String className) {
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canFindClassByName()) continue;
            return helper.findClassByName(this.jproject, className);
        }
        return false;
    }

    private boolean showClassNotFoundMessage(String className) {
        String[] messages = new String[]{DbgArb.format(756, className), DbgArb.getString(757)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(755, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private boolean findMethod(String bpMethodName) {
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canFindMethodByName()) continue;
            return helper.findMethodByName(this.jproject, bpMethodName);
        }
        return false;
    }

    private boolean showMethodNotFoundMessage(String bpMethodName) {
        String[] messages = new String[]{DbgArb.format(759, bpMethodName), DbgArb.getString(760)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(758, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private boolean findField(String className, String fieldName) {
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canFindFieldByName()) continue;
            return helper.findFieldByName(this.jproject, className, fieldName);
        }
        return false;
    }

    private boolean showFieldNotFoundMessage(String className, String fieldName) {
        String[] messages = new String[]{DbgArb.format(762, fieldName, className), DbgArb.getString(763)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(761, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private Component getInitialFocus() {
        switch (this.initialFocus) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                return this.group == null ? this.groupNameComboBox : this.groupNameTextField;
            }
        }
        if (this.group != null) {
            return this.groupNameTextField;
        }
        if (this.breakpoints != null) {
            return this.groupNameCheckBox;
        }
        switch (this.currentType) {
            default: {
                return this.packageEditor;
            }
            case 1: {
                return this.methodEditor;
            }
            case 7: {
                return this.groupNameEditor;
            }
            case 2: {
                return this.exceptionEditor;
            }
            case 3: {
                return this.groupNameEditor;
            }
            case 4: {
                return this.classEditor;
            }
            case 5: {
                return this.urlTextField;
            }
            case 6: 
        }
        return this.watchpointClassEditor;
    }

    private JPanel makeDefinitionPane() {
        JLabel groupLabel;
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        if (this.group != null) {
            groupLabel = new JLabel(DbgArb.getString(429));
            this.groupNameLabel = new JLabel();
            this.groupNameTextField = new JTextField();
            this.groupNameTextField.setText(this.bp.getGroupName());
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameTextField, (String)DbgArb.getString(432));
            panel.add((Component)groupLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            FastStringBuffer fsb = new FastStringBuffer();
            for (int i = 0; i < this.group.length; ++i) {
                fsb.append(this.group[i].getDescription());
                fsb.append("\n");
            }
            MultiLineLabel label = new MultiLineLabel(fsb.toString());
            JScrollPane scrollPane = new JScrollPane((Component)label);
            panel.add((Component)scrollPane, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        } else if (this.breakpoints != null) {
            groupLabel = new JLabel(DbgArb.getString(430));
            this.groupNameCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.groupNameCheckBox, (String)DbgArb.getString(431));
            this.groupNameLabel = new JLabel();
            this.groupNameHistoryList = Ide.loadHistoryList((String)groupNameHistoryName);
            String[] choices = JDebugger.filterBlanksFromHistoryList(this.groupNameHistoryList.getHistory());
            this.groupNameComboBox = new JComboBox<String>(choices);
            this.groupNameEditor = (JTextField)this.groupNameComboBox.getEditor().getEditorComponent();
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameEditor, (String)DbgArb.getString(432));
            this.groupNameComboBox.setEditable(true);
            String groupName = this.bp.getGroupName();
            JDebugger.selectHistoryString(this.groupNameComboBox, groupName);
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameTextField, (String)DbgArb.getString(432));
            this.groupNameCheckBox.setSelected(false);
            this.groupNameLabel.setEnabled(false);
            this.groupNameComboBox.setEnabled(false);
            panel.add((Component)groupLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            FastStringBuffer fsb = new FastStringBuffer();
            for (int i = 0; i < this.breakpoints.length; ++i) {
                fsb.append(this.breakpoints[i].getDescription());
                fsb.append("\n");
            }
            MultiLineLabel label = new MultiLineLabel(fsb.toString());
            JScrollPane scrollPane = new JScrollPane((Component)label);
            panel.add((Component)scrollPane, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 25, 0, 5), 0, 0));
            panel.add((Component)this.groupNameCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        } else {
            this.groupNameLabel = new JLabel();
            this.groupNameHistoryList = Ide.loadHistoryList((String)groupNameHistoryName);
            String[] choices = JDebugger.filterBlanksFromHistoryList(this.groupNameHistoryList.getHistory());
            this.groupNameComboBox = new JComboBox<String>(choices);
            this.groupNameEditor = (JTextField)this.groupNameComboBox.getEditor().getEditorComponent();
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameEditor, (String)DbgArb.getString(432));
            this.groupNameComboBox.setEditable(true);
            String groupName = this.bpTemplate.getGroupName();
            JDebugger.selectHistoryString(this.groupNameComboBox, groupName);
            if (!this.bpTemplate.isEditGroupName()) {
                this.groupNameComboBox.setEditable(false);
                this.groupNameComboBox.setEnabled(false);
            }
            panel.add((Component)this.currentTypeItem.panel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel(), new GridBagConstraints(0, y++, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.groupNameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameComboBox, new GridBagConstraints(0, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        String providerID = "debugger.breakpointOptionsDialog.breakpointgroupname";
        if (this.jproject != null) {
            DefaultCompletionSupport insight;
            Context context = Context.newIdeContext();
            context.setProject(this.jproject);
            if (this.groupNameTextField != null) {
                insight = new DefaultCompletionSupport(context, (JTextComponent)this.groupNameTextField, providerID);
                insight.setAutoPopup(true);
            } else if (this.groupNameEditor != null) {
                insight = new DefaultCompletionSupport(context, (JTextComponent)this.groupNameEditor, providerID);
                insight.setAutoPopup(true);
            }
        }
        return panel;
    }

    private JPanel makePackageFileLineCard() {
        String pkg = this.bpTemplate.getPkg();
        String file = this.bpTemplate.getFile();
        String line = Integer.toString(this.bpTemplate.getLine());
        JLabel packageLabel = new JLabel();
        this.packageHistoryList = Ide.loadHistoryList((String)packageHistoryName);
        String[] choices = JDebugger.filterBlanksFromHistoryList(this.packageHistoryList.getHistory());
        this.packageComboBox = new JComboBox<String>(choices);
        this.packageComboBox.setEditable(true);
        this.packageComboBox.addActionListener(this);
        this.packageEditor = (JTextField)this.packageComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)packageLabel, (Component)this.packageEditor, (String)DbgArb.getString(403));
        Context context = Context.newIdeContext();
        if (this.jproject != null) {
            context.setProject(this.jproject);
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
            for (DebuggerLanguageHelper debuggerLanguageHelper : helpers) {
                if (!debuggerLanguageHelper.canProvideCompletionSupportFor(DebuggerLanguageHelper.InsightType.PACKAGE)) continue;
                CompletionSupport insight = debuggerLanguageHelper.getCompletionSupport(context, DebuggerLanguageHelper.InsightType.PACKAGE, this.packageEditor);
                insight.setAutoPopup(true);
            }
        }
        JDebugger.selectHistoryString(this.packageComboBox, pkg);
        JLabel fileLabel = new JLabel();
        this.fileHistoryList = Ide.loadHistoryList((String)fileHistoryName);
        choices = JDebugger.filterBlanksFromHistoryList(this.fileHistoryList.getHistory());
        this.fileComboBox = new JComboBox<String>(choices);
        this.fileComboBox.setEditable(true);
        this.fileComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.fileComboBox, (DocumentListener)this);
        this.fileEditor = (JTextField)this.fileComboBox.getEditor().getEditorComponent();
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canProvideCompletionSupportFor(DebuggerLanguageHelper.InsightType.FILE)) continue;
            CompletionSupport insight = helper.getCompletionSupport(context, DebuggerLanguageHelper.InsightType.FILE, this.fileEditor);
            if (insight instanceof DefaultCompletionSupport) {
                ((DefaultCompletionSupport)insight).putObject("packagename_component", (Object)this.packageEditor);
            }
            insight.setAutoPopup(true);
        }
        ResourceUtils.resLabel((JLabel)fileLabel, (Component)this.fileEditor, (String)DbgArb.getString(404));
        JDebugger.selectHistoryString(this.fileComboBox, file);
        JLabel jLabel = new JLabel();
        this.lineTextField = new JTextField(line, 6);
        this.lineTextField.setHorizontalAlignment(4);
        this.lineTextField.getDocument().addDocumentListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.lineTextField, (String)DbgArb.getString(405));
        if (this.bpTemplate.isCustom()) {
            this.packageComboBox.setEnabled(false);
            this.packageComboBox.setEditable(false);
            this.fileComboBox.setEnabled(false);
            this.fileComboBox.setEditable(false);
            this.lineTextField.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)packageLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.packageComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)fileLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)jLabel, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        panel.add((Component)this.fileComboBox, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.lineTextField, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeMethodCard() {
        String method = this.bpTemplate.getMethod();
        JLabel methodLabel = new JLabel();
        this.methodHistoryList = Ide.loadHistoryList((String)methodHistoryName);
        String[] choices = JDebugger.filterBlanksFromHistoryList(this.methodHistoryList.getHistory());
        this.methodComboBox = new JComboBox<String>(choices);
        this.methodComboBox.setEditable(true);
        this.methodComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.methodComboBox, (DocumentListener)this);
        this.methodEditor = (JTextField)this.methodComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)methodLabel, (Component)this.methodEditor, (String)DbgArb.getString(406));
        if (this.jproject != null) {
            Context context = Context.newIdeContext();
            context.setProject(this.jproject);
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
            for (DebuggerLanguageHelper helper : helpers) {
                if (!helper.canProvideCompletionSupportFor(DebuggerLanguageHelper.InsightType.METHOD)) continue;
                CompletionSupport insight = helper.getCompletionSupport(context, DebuggerLanguageHelper.InsightType.METHOD, this.methodEditor);
                insight.setAutoPopup(true);
                break;
            }
        }
        JLabel example1 = new JLabel(DbgArb.getString(407));
        JLabel example2 = new JLabel(DbgArb.getString(408));
        JLabel example3 = new JLabel(DbgArb.getString(409));
        JDebugger.selectHistoryString(this.methodComboBox, method);
        if (this.bpTemplate.isCustom()) {
            this.methodComboBox.setEnabled(false);
            this.methodComboBox.setEditable(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)methodLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.methodComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)example3, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        return panel;
    }

    private JPanel makeMethodOffsetCard() {
        JLabel fqMethodLabel = new JLabel();
        JTextField fqMethodTextField = new JTextField(this.bpTemplate.getMethod());
        fqMethodTextField.setEditable(false);
        ResourceUtils.resLabel((JLabel)fqMethodLabel, (Component)fqMethodTextField, (String)DbgArb.getString(410));
        JLabel offsetLabel = new JLabel();
        JTextField offsetTextField = new JTextField(Integer.toString(this.bpTemplate.getOffset()), 6);
        offsetTextField.setEditable(false);
        offsetTextField.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)offsetLabel, (Component)offsetTextField, (String)DbgArb.getString(411));
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)fqMethodLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)fqMethodTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)offsetLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)offsetTextField, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeExceptionCard() {
        String exception = this.bpTemplate.getException();
        boolean caught = this.bpTemplate.isCaught();
        boolean uncaught = this.bpTemplate.isUncaught();
        JLabel exceptionLabel = new JLabel();
        this.exceptionHistoryList = Ide.loadHistoryList((String)exceptionHistoryName);
        if (this.exceptionHistoryList.getSize() == 0) {
            String[] x = new String[]{"java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.ArrayStoreException", "java.lang.ClassCastException", "java.lang.Exception", "java.lang.IllegalAccessException", "java.lang.IllegalArgumentException", "java.lang.IllegalStateException", "java.lang.IndexOutOfBoundsException", "java.lang.NumberFormatException", "java.lang.RuntimeException", "java.lang.SecurityException", "java.lang.StringIndexOutOfBoundsException", "java.lang.UnsupportedOperationException", "java.lang.Error", "java.lang.Throwable", "oracle.jbo.JboException", "$Oracle.EXCEPTION_ORA_6502"};
            this.exceptionHistoryList.fill(x);
        }
        String[] choices = JDebugger.filterBlanksFromHistoryList(this.exceptionHistoryList.getHistory());
        this.exceptionComboBox = new JComboBox<String>(choices);
        this.exceptionComboBox.setEditable(true);
        this.exceptionComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.exceptionComboBox, (DocumentListener)this);
        this.exceptionEditor = (JTextField)this.exceptionComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)exceptionLabel, (Component)this.exceptionEditor, (String)DbgArb.getString(412));
        if (this.jproject != null) {
            List<DebuggerLanguageHelper> helpers;
            Context context = Context.newIdeContext();
            context.setProject(this.jproject);
            if (this.preferClassPickerOverInsight) {
                helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
                for (DebuggerLanguageHelper helper : helpers) {
                    if (!helper.canAttachClassPickerToField()) continue;
                    boolean useExceptionFilter = true;
                    helper.attachClassPickerToField(this.jproject, context, this.exceptionEditor, useExceptionFilter);
                }
            } else {
                helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
                for (DebuggerLanguageHelper helper : helpers) {
                    if (!helper.canProvideCompletionSupportFor(DebuggerLanguageHelper.InsightType.EXCEPTION)) continue;
                    CompletionSupport insight = helper.getCompletionSupport(context, DebuggerLanguageHelper.InsightType.EXCEPTION, this.exceptionEditor);
                    if (insight instanceof DefaultCompletionSupport) {
                        ((DefaultCompletionSupport)insight).putObject("historyList", (Object)this.exceptionHistoryList);
                    }
                    insight.setAutoPopup(true);
                }
            }
        }
        JLabel example1 = new JLabel(DbgArb.getString(413));
        JLabel example2 = new JLabel(DbgArb.getString(414));
        JDebugger.selectHistoryString(this.exceptionComboBox, exception);
        this.exceptionBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.exceptionBrowseButton, (String)DbgArb.getString(415));
        this.exceptionBrowseButton.addActionListener(this);
        this.exceptionBrowseButton.setEnabled(this.jproject != null && this.canBrowseClasses);
        this.caughtCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.caughtCheckBox, (String)DbgArb.getString(416));
        this.caughtCheckBox.setSelected(caught);
        this.uncaughtCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.uncaughtCheckBox, (String)DbgArb.getString(417));
        this.uncaughtCheckBox.setSelected(uncaught);
        if (this.bpTemplate.isCustom()) {
            this.exceptionComboBox.setEnabled(false);
            this.exceptionComboBox.setEditable(false);
            this.exceptionBrowseButton.setEnabled(false);
            this.caughtCheckBox.setEnabled(false);
            this.uncaughtCheckBox.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)exceptionLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.exceptionComboBox, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (!Product.isRaptor()) {
            panel.add((Component)this.exceptionBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        }
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.caughtCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.uncaughtCheckBox, new GridBagConstraints(0, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeDeadlockCard() {
        JPanel panel = new JPanel();
        return panel;
    }

    private JPanel makeClassCard() {
        String className = this.bpTemplate.getClassName();
        JLabel classLabel = new JLabel();
        this.classHistoryList = Ide.loadHistoryList((String)classHistoryName);
        String[] choices = JDebugger.filterBlanksFromHistoryList(this.classHistoryList.getHistory());
        this.classComboBox = new JComboBox<String>(choices);
        this.classComboBox.setEditable(true);
        this.classComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.classComboBox, (DocumentListener)this);
        this.classEditor = (JTextField)this.classComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)classLabel, (Component)this.classEditor, (String)DbgArb.getString(418));
        if (this.jproject != null) {
            List<DebuggerLanguageHelper> helpers;
            Context context = Context.newIdeContext();
            context.setProject(this.jproject);
            if (this.preferClassPickerOverInsight) {
                helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
                for (DebuggerLanguageHelper helper : helpers) {
                    if (!helper.canAttachClassPickerToField()) continue;
                    boolean useExceptionFilter = false;
                    helper.attachClassPickerToField(this.jproject, context, this.classEditor, useExceptionFilter);
                }
            } else {
                helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
                for (DebuggerLanguageHelper helper : helpers) {
                    if (!helper.canProvideCompletionSupportFor(DebuggerLanguageHelper.InsightType.CLASS)) continue;
                    CompletionSupport insight = helper.getCompletionSupport(context, DebuggerLanguageHelper.InsightType.CLASS, this.classEditor);
                    insight.setAutoPopup(true);
                }
            }
        }
        JLabel example1 = new JLabel(DbgArb.getString(413));
        JLabel example2 = new JLabel(DbgArb.getString(419));
        JDebugger.selectHistoryString(this.classComboBox, className);
        this.classBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.classBrowseButton, (String)DbgArb.getString(420));
        this.classBrowseButton.addActionListener(this);
        this.classBrowseButton.setEnabled(this.canBrowseClasses);
        if (this.bpTemplate.isCustom()) {
            this.classComboBox.setEnabled(false);
            this.classComboBox.setEditable(false);
            this.classBrowseButton.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)classLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.classComboBox, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.classBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeURLLineCard() {
        URL url = this.bpTemplate.getURL();
        String line = Integer.toString(this.bpTemplate.getLine());
        JLabel urlLabel = new JLabel();
        this.urlTextField = new URLTextField(url, false, false);
        ResourceUtils.resLabel((JLabel)urlLabel, (Component)this.urlTextField, (String)DbgArb.getString(421));
        this.urlTextField.getDocument().addDocumentListener(this);
        this.urlBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.urlBrowseButton, (String)DbgArb.getString(422));
        this.urlBrowseButton.addActionListener((ActionListener)this.urlTextField);
        JLabel lineLabel = new JLabel();
        this.lineTextField2 = new JTextField(line, 6);
        this.lineTextField2.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)lineLabel, (Component)this.lineTextField2, (String)DbgArb.getString(405));
        this.lineTextField2.getDocument().addDocumentListener(this);
        if (this.bpTemplate.isCustom()) {
            this.urlTextField.setEnabled(false);
            this.urlBrowseButton.setEnabled(false);
            this.lineTextField2.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)urlLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.urlTextField, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.urlBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        panel.add((Component)lineLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.lineTextField2, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeWatchpointCard() {
        String className = this.bpTemplate.getClassName();
        String fieldName = this.bpTemplate.getFieldName();
        boolean access = this.bpTemplate.isAccess();
        boolean modify = this.bpTemplate.isModify();
        JLabel watchpointClassLabel = new JLabel();
        this.watchpointClassHistoryList = Ide.loadHistoryList((String)watchpointClassHistoryName);
        String[] choices = JDebugger.filterBlanksFromHistoryList(this.watchpointClassHistoryList.getHistory());
        this.watchpointClassComboBox = new JComboBox<String>(choices);
        this.watchpointClassComboBox.setEditable(true);
        this.watchpointClassComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.watchpointClassComboBox, (DocumentListener)this);
        this.watchpointClassEditor = (JTextField)this.watchpointClassComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)watchpointClassLabel, (Component)this.watchpointClassEditor, (String)DbgArb.getString(423));
        Context context = Context.newIdeContext();
        if (this.jproject != null) {
            List<DebuggerLanguageHelper> helpers;
            if (this.preferClassPickerOverInsight) {
                context.setProject(this.jproject);
                helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
                for (DebuggerLanguageHelper helper : helpers) {
                    if (!helper.canAttachClassPickerToField()) continue;
                    boolean useExceptionFilter = false;
                    helper.attachClassPickerToField(this.jproject, context, this.watchpointClassEditor, useExceptionFilter);
                }
            } else {
                helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
                for (DebuggerLanguageHelper helper : helpers) {
                    if (!helper.canProvideCompletionSupportFor(DebuggerLanguageHelper.InsightType.CLASS)) continue;
                    CompletionSupport insight = helper.getCompletionSupport(context, DebuggerLanguageHelper.InsightType.CLASS, this.watchpointClassEditor);
                    insight.setAutoPopup(true);
                }
            }
        }
        JLabel example1 = new JLabel(DbgArb.getString(413));
        JLabel example2 = new JLabel(DbgArb.getString(424));
        JDebugger.selectHistoryString(this.watchpointClassComboBox, className);
        this.watchpointClassBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.watchpointClassBrowseButton, (String)DbgArb.getString(425));
        this.watchpointClassBrowseButton.addActionListener(this);
        this.watchpointClassBrowseButton.setEnabled(this.canBrowseClasses);
        JLabel watchpointFieldLabel = new JLabel();
        this.watchpointFieldHistoryList = Ide.loadHistoryList((String)watchpointFieldHistoryName);
        choices = JDebugger.filterBlanksFromHistoryList(this.watchpointFieldHistoryList.getHistory());
        this.watchpointFieldComboBox = new JComboBox<String>(choices);
        this.watchpointFieldComboBox.setEditable(true);
        this.watchpointFieldComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.watchpointFieldComboBox, (DocumentListener)this);
        this.watchpointFieldEditor = (JTextField)this.watchpointFieldComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)watchpointFieldLabel, (Component)this.watchpointFieldEditor, (String)DbgArb.getString(426));
        JDebugger.selectHistoryString(this.watchpointFieldComboBox, fieldName);
        if (this.jproject != null) {
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
            for (DebuggerLanguageHelper helper : helpers) {
                if (!helper.canProvideCompletionSupportFor(DebuggerLanguageHelper.InsightType.FIELD)) continue;
                CompletionSupport insight = helper.getCompletionSupport(context, DebuggerLanguageHelper.InsightType.FIELD, this.watchpointClassEditor);
                if (insight instanceof DefaultCompletionSupport) {
                    ((DefaultCompletionSupport)insight).putObject("classname_component", (Object)this.watchpointClassEditor);
                }
                insight.setAutoPopup(true);
            }
        }
        this.accessCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.accessCheckBox, (String)DbgArb.getString(427));
        this.accessCheckBox.setSelected(access);
        this.modifyCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.modifyCheckBox, (String)DbgArb.getString(428));
        this.modifyCheckBox.setSelected(modify);
        if (this.bpTemplate.isCustom()) {
            this.watchpointClassComboBox.setEnabled(false);
            this.watchpointClassComboBox.setEditable(false);
            this.watchpointClassBrowseButton.setEnabled(false);
            this.watchpointFieldComboBox.setEnabled(false);
            this.watchpointFieldComboBox.setEditable(false);
            this.accessCheckBox.setEnabled(false);
            this.modifyCheckBox.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)watchpointClassLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.watchpointClassComboBox, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.watchpointClassBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)watchpointFieldLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.watchpointFieldComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.accessCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.modifyCheckBox, new GridBagConstraints(0, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeConditionsPane() {
        String condition = this.bpTemplate.getCondition();
        int passCount = this.bpTemplate.getPassCount();
        JLabel conditionLabel = new JLabel();
        this.conditionHistoryList = Ide.loadHistoryList((String)conditionHistoryName);
        String[] historyStrings = JDebugger.filterBlanksFromHistoryList(this.conditionHistoryList.getHistory());
        this.conditionComboBox = new JComboBox<String>(historyStrings);
        if (!this.bpTemplate.isEditCondition()) {
            this.conditionComboBox.setEditable(false);
            this.conditionComboBox.setEnabled(false);
        } else {
            this.conditionComboBox.setEditable(true);
        }
        this.conditionEditor = (JTextField)this.conditionComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)conditionLabel, (Component)this.conditionEditor, (String)DbgArb.getString(433));
        JDebugger.selectHistoryString(this.conditionComboBox, condition);
        JPanel threadPanel = this.makeThreadPanel();
        JLabel passCountLabel = new JLabel();
        this.passCountBox = new NumericSpinBox(0, Integer.MAX_VALUE);
        this.passCountBox.setIntValue(passCount);
        SpinBuddy buddy = this.passCountBox.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        ResourceUtils.resLabel((JLabel)passCountLabel, (Component)this.passCountBox, (String)DbgArb.getString(438));
        if (!this.bpTemplate.isEditPassCount()) {
            this.passCountBox.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)conditionLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.conditionComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)threadPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)passCountLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)this.passCountBox, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeThreadPanel() {
        String threadName = this.bpTemplate.getThreadName();
        String notThreadName = this.bpTemplate.getThreadNameNot();
        List<String> currentThreadNames = JDebugger.getInstance().getCurrentThreadNames();
        Collections.sort(currentThreadNames);
        this.radioAllThreads = new JRadioButton();
        this.radioOneThread = new JRadioButton();
        this.radioNotThread = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radioAllThreads, (String)DbgArb.getString(435));
        ResourceUtils.resButton((AbstractButton)this.radioOneThread, (String)DbgArb.getString(436));
        ResourceUtils.resButton((AbstractButton)this.radioNotThread, (String)DbgArb.getString(437));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioAllThreads);
        buttonGroup.add(this.radioOneThread);
        buttonGroup.add(this.radioNotThread);
        this.threadHistoryList = Ide.loadHistoryList((String)threadHistoryName);
        this.threadComboBox = this.createThreadNameComboBox(this.threadHistoryList, currentThreadNames, threadName);
        this.threadEditor = (JTextField)this.threadComboBox.getEditor().getEditorComponent();
        this.threadEditor.getAccessibleContext().setAccessibleName(this.radioOneThread.getText());
        this.notThreadHistoryList = Ide.loadHistoryList((String)notThreadHistoryName);
        this.notThreadComboBox = this.createThreadNameComboBox(this.notThreadHistoryList, currentThreadNames, notThreadName);
        this.notThreadEditor = (JTextField)this.notThreadComboBox.getEditor().getEditorComponent();
        this.notThreadEditor.getAccessibleContext().setAccessibleName(this.radioNotThread.getText());
        if (threadName.length() > 0) {
            this.radioOneThread.setSelected(true);
        } else if (notThreadName.length() > 0) {
            this.radioNotThread.setSelected(true);
        } else {
            this.radioAllThreads.setSelected(true);
        }
        this.threadComboBox.setEnabled(this.radioOneThread.isSelected());
        this.notThreadComboBox.setEnabled(this.radioNotThread.isSelected());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(434));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.radioAllThreads, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.radioOneThread, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.threadComboBox, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.radioNotThread, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.notThreadComboBox, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        boolean enableThreadOptions = true;
        if (this.bpTemplate.getURL() != null) {
            Node node = null;
            try {
                node = NodeFactory.findOrCreate((URL)this.bpTemplate.getURL());
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (!enableThreadOptions) {
            panel.setEnabled(false);
            titleLabel.setEnabled(false);
            this.radioAllThreads.setEnabled(false);
            this.radioOneThread.setEnabled(false);
            this.radioNotThread.setEnabled(false);
            this.radioAllThreads.setSelected(true);
        } else {
            panel.setEnabled(true);
            titleLabel.setEnabled(true);
            this.radioAllThreads.setEnabled(true);
            this.radioOneThread.setEnabled(true);
            this.radioNotThread.setEnabled(true);
        }
        if (!this.bpTemplate.isEditBreakForThreads()) {
            this.radioAllThreads.setEnabled(false);
            this.radioNotThread.setEnabled(false);
            this.radioOneThread.setEnabled(false);
            this.threadComboBox.setEnabled(false);
            this.threadComboBox.setEditable(false);
            this.notThreadComboBox.setEnabled(false);
            this.notThreadComboBox.setEditable(false);
        }
        return panel;
    }

    private JComboBox createThreadNameComboBox(HistoryList previousList, List<String> currentNames, String threadName) {
        Object[] previousNames = previousList.getHistory();
        Arrays.sort(previousNames);
        ArrayList<Object> nameList = new ArrayList<Object>();
        for (Object name : previousNames) {
            if (((String)name).trim().length() == 0) {
                previousList.remove((String)name);
                previousList.save();
                continue;
            }
            if (currentNames.contains(name)) continue;
            nameList.add(name);
        }
        int previousNamesSize = nameList.size();
        nameList.addAll(currentNames);
        int currentNamesSize = currentNames.size();
        JComboBox<String> combobox = new JComboBox<String>(nameList.toArray(new String[nameList.size()]));
        if (previousNamesSize > 0 && currentNamesSize > 0) {
            final String lastPreviousName = (String)nameList.get(previousNamesSize - 1);
            SeparatorListCellRenderer renderer = new SeparatorListCellRenderer((ListCellRenderer)new DefaultListCellRenderer(), new SeparatorListCellRenderer.SeparatorModel(){

                public boolean hasTrailingSeparator(int index, Object value) {
                    return value == lastPreviousName;
                }
            });
            combobox.setRenderer((ListCellRenderer<String>)renderer);
        }
        combobox.setEditable(true);
        JDebugger.selectHistoryString(combobox, threadName);
        return combobox;
    }

    private JPanel makeActionsPane(String[] groupNames) {
        this.bpActionsPanel = new BreakpointActionsPanel(groupNames, true, this);
        this.bpActionsPanel.loadFrom(this.bpTemplate, BreakpointsWindowSettings.getInstance());
        return this.bpActionsPanel;
    }

    void typeChanged() {
        switch (this.currentType) {
            case 0: 
            case 5: {
                this.bpActionsPanel.setLog(false);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.bpActionsPanel.setLog(true);
            }
        }
    }

    void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    private boolean canOk() {
        String msg = this.anythingInvalidInDefinition();
        if (msg != null) {
            return false;
        }
        msg = this.anythingInvalidInConditions();
        if (msg != null) {
            return false;
        }
        msg = this.anythingInvalidInActions();
        return msg == null;
    }

    private String anythingInvalidInDefinition() {
        if (this.group != null) {
            String s = this.groupNameTextField.getText();
            if (s.length() == 0) {
                return DbgArb.getString(448);
            }
            if (!s.equals(this.bp.getGroupName())) {
                int length = this.groupNames.length;
                for (int i = 0; i < length; ++i) {
                    if (!s.equals(this.groupNames[i])) continue;
                    return DbgArb.getString(449);
                }
            }
        } else if (this.breakpoints != null) {
            if (this.groupNameCheckBox.isSelected() && this.groupNameEditor.getText().length() == 0) {
                return DbgArb.getString(448);
            }
        } else {
            return this.currentTypeItem.canOk();
        }
        return null;
    }

    private String anythingInvalidInConditions() {
        String condition = this.conditionEditor.getText().trim();
        if (condition.length() > 0) {
            EvaluatorProxy evaluator = DebugObjectFactory.create(EvaluatorProxy.class);
            evaluator.setAllowMethodInvocation(false);
            if (!evaluator.validate(condition)) {
                return DbgArb.getString(456);
            }
        }
        if (this.radioOneThread.isSelected() && this.threadEditor.getText().trim().length() == 0) {
            return DbgArb.getString(457);
        }
        if (this.radioNotThread.isSelected() && this.notThreadEditor.getText().trim().length() == 0) {
            return DbgArb.getString(458);
        }
        return null;
    }

    private String anythingInvalidInActions() {
        return this.bpActionsPanel.anythingInvalid();
    }

    CoreBreakpoint getBreakpoint() {
        return this.bp;
    }

    private void doOk() {
        if (this.group != null) {
            for (CoreBreakpoint bpInGroup : this.group) {
                bpInGroup.setShallow(true);
                bpInGroup.setGroupName(this.groupNameTextField.getText());
                this.doOkForConditions(bpInGroup);
                this.doOkForActions(bpInGroup);
                bpInGroup.setShallow(false);
            }
        } else if (this.breakpoints != null) {
            for (CoreBreakpoint bpInMulti : this.breakpoints) {
                bpInMulti.setShallow(true);
                if (this.groupNameCheckBox.isSelected()) {
                    bpInMulti.setGroupName(this.groupNameHistoryList.comboBoxGetSelectedItem(this.groupNameEditor));
                }
                this.doOkForConditions(bpInMulti);
                this.doOkForActions(bpInMulti);
                bpInMulti.setShallow(false);
            }
        } else {
            this.bp = this.currentTypeItem.doOk();
            this.bp.setShallow(true);
            this.doOkForConditions(this.bp);
            this.doOkForActions(this.bp);
            this.bp.setShallow(false);
        }
    }

    private boolean veto() {
        if (this.group == null && this.breakpoints == null) {
            RunConfiguration rc;
            if (XSLTDebugHelper.isXSLTDebuggingSupported() && this.bp == null && this.currentType != 5 && this.jproject != null && (rc = RunConfiguration.getInstance((PropertyStorage)this.jproject)) != null) {
                URL target = rc.getTargetURL();
                try {
                    Node node = NodeFactory.findOrCreate((URL)target);
                    if (JDevXmlIntegrationUtils.getInstance().isXmlSource(node) && JDevXmlIntegrationUtils.getInstance().isXSLT(node)) {
                        return !this.showXSLTMessage();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.currentTypeItem.veto();
        }
        return false;
    }

    private void doOkForConditions(CoreBreakpoint bp) {
        String newCondition = this.conditionHistoryList.comboBoxGetSelectedItem(this.conditionEditor);
        bp.setCondition(newCondition.trim());
        if (this.radioOneThread.isSelected()) {
            bp.setThreadName(this.threadHistoryList.comboBoxGetSelectedItem(this.threadEditor));
        } else {
            bp.setThreadName(null);
        }
        if (this.radioNotThread.isSelected()) {
            bp.setThreadNameNot(this.notThreadHistoryList.comboBoxGetSelectedItem(this.notThreadEditor));
        } else {
            bp.setThreadNameNot(null);
        }
        bp.setPassCount(this.passCountBox.getIntValue());
    }

    private void doOkForActions(CoreBreakpoint bp) {
        this.bpActionsPanel.commitTo(bp, BreakpointsWindowSettings.getInstance());
    }

    public void cancel() {
        this.setVisible(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component comp = this.tabbedPane.getSelectedComponent();
        String topic = comp == this.definitionPane ? "f1_deb_new_edit_breakptdialog_html" : (comp == this.conditionsPane ? "f1_deb_new_edit_breakpt_conditions_html" : (comp == this.actionsPane ? "f1_deb_new_edit_breakpt_actions_html" : "f1_deb_new_edit_breakptdialog_html"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, topic);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.radioAllThreads) {
            this.threadComboBox.setEnabled(false);
            this.notThreadComboBox.setEnabled(false);
        } else if (source == this.radioOneThread) {
            this.threadComboBox.setEnabled(true);
            this.notThreadComboBox.setEnabled(false);
        } else if (source == this.radioNotThread) {
            this.threadComboBox.setEnabled(false);
            this.notThreadComboBox.setEnabled(true);
        } else if (source == this.exceptionBrowseButton) {
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
            for (DebuggerLanguageHelper helper : helpers) {
                boolean useExceptionFilter;
                String s;
                if (!helper.canBrowseClassOrPackage() || (s = helper.browseClassOrPackage(this.jproject, this, useExceptionFilter = true)) == null) continue;
                this.exceptionEditor.setText(s);
            }
        } else if (source == this.classBrowseButton) {
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
            for (DebuggerLanguageHelper helper : helpers) {
                boolean useExceptionFilter;
                String s;
                if (!helper.canBrowseClassOrPackage() || (s = helper.browseClassOrPackage(this.jproject, this, useExceptionFilter = false)) == null) continue;
                this.classEditor.setText(s);
            }
        } else if (source == this.watchpointClassBrowseButton) {
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(this.jproject);
            for (DebuggerLanguageHelper helper : helpers) {
                boolean useExceptionFilter;
                String s;
                if (!helper.canBrowseClassOrPackage() || (s = helper.browseClassOrPackage(this.jproject, this, useExceptionFilter = false)) == null) continue;
                this.watchpointClassEditor.setText(s);
            }
        } else if (source == this.groupNameComboBox) {
            this.groupNameEditor.setText((String)this.groupNameComboBox.getSelectedItem());
        } else if (source == this.packageComboBox) {
            this.packageEditor.setText((String)this.packageComboBox.getSelectedItem());
        } else if (source == this.fileComboBox) {
            this.fileEditor.setText((String)this.fileComboBox.getSelectedItem());
        } else if (source == this.methodComboBox) {
            this.methodEditor.setText((String)this.methodComboBox.getSelectedItem());
        } else if (source == this.exceptionComboBox) {
            this.exceptionEditor.setText((String)this.exceptionComboBox.getSelectedItem());
        } else if (source == this.classComboBox) {
            this.classEditor.setText((String)this.classComboBox.getSelectedItem());
        } else if (source == this.groupNameComboBox) {
            this.groupNameEditor.setText((String)this.groupNameComboBox.getSelectedItem());
        } else if (source == this.conditionComboBox) {
            this.conditionEditor.setText((String)this.conditionComboBox.getSelectedItem());
        } else if (source == this.threadComboBox) {
            this.threadEditor.setText((String)this.threadComboBox.getSelectedItem());
        } else if (source == this.notThreadComboBox) {
            this.notThreadEditor.setText((String)this.notThreadComboBox.getSelectedItem());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.enableOk();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableOk();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableOk();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.groupNameCheckBox) {
            boolean enabled = this.groupNameCheckBox.isSelected();
            this.groupNameLabel.setEnabled(enabled);
            this.groupNameComboBox.setEnabled(enabled);
            this.enableOk();
        } else if (source == this.radioAllThreads || source == this.radioOneThread || source == this.radioNotThread) {
            this.enableOk();
        }
    }

    private class BreakpointTypeItem {
        final int breakpointType;
        String name;
        BreakpointDefinitionPanel customPanel;
        JPanel panel;
        boolean isCustom;
        ChangeListener customPanelListener;

        BreakpointTypeItem(int breakpointType, String breakpointTypeName, boolean isCustom) {
            this.breakpointType = breakpointType;
            this.name = breakpointTypeName;
            this.panel = null;
            this.isCustom = isCustom;
            this.customPanel = null;
            if (isCustom) {
                this.customPanelListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        BreakpointOptionsDialog.this.enableOk();
                    }
                };
                this.customPanel = ExtenderManager.getInstance().getCustomBreakpointPanel(breakpointTypeName, BreakpointOptionsDialog.this.bp, this.customPanelListener);
                if (this.customPanel != null) {
                    this.panel = this.customPanel.getPanel();
                }
            }
            if (this.panel == null) {
                this.isCustom = false;
                switch (breakpointType) {
                    default: {
                        this.panel = BreakpointOptionsDialog.this.makePackageFileLineCard();
                        break;
                    }
                    case 2: {
                        this.panel = BreakpointOptionsDialog.this.makeExceptionCard();
                        break;
                    }
                    case 1: {
                        this.panel = BreakpointOptionsDialog.this.makeMethodCard();
                        break;
                    }
                    case 7: {
                        this.panel = BreakpointOptionsDialog.this.makeMethodOffsetCard();
                        break;
                    }
                    case 4: {
                        this.panel = BreakpointOptionsDialog.this.makeClassCard();
                        break;
                    }
                    case 5: {
                        this.panel = BreakpointOptionsDialog.this.makeURLLineCard();
                        break;
                    }
                    case 3: {
                        this.panel = BreakpointOptionsDialog.this.makeDeadlockCard();
                        break;
                    }
                    case 6: {
                        this.panel = BreakpointOptionsDialog.this.makeWatchpointCard();
                    }
                }
            }
        }

        public String toString() {
            return this.name;
        }

        String canOk() {
            if (this.isCustom) {
                return this.customPanel.canOk();
            }
            switch (BreakpointOptionsDialog.this.currentType) {
                case 0: {
                    if (BreakpointOptionsDialog.this.fileEditor.getText().trim().length() == 0) {
                        return DbgArb.getString(450);
                    }
                    try {
                        int line = Integer.parseInt(BreakpointOptionsDialog.this.lineTextField.getText());
                        if (line < 1) {
                            return DbgArb.getString(451);
                        }
                        break;
                    }
                    catch (Exception e) {
                        return DbgArb.getString(451);
                    }
                }
                case 1: {
                    if (BreakpointOptionsDialog.this.methodEditor.getText().trim().length() != 0) break;
                    return DbgArb.getString(452);
                }
                case 4: {
                    if (BreakpointOptionsDialog.this.classEditor.getText().trim().length() != 0) break;
                    return DbgArb.getString(453);
                }
                case 2: {
                    if (BreakpointOptionsDialog.this.exceptionEditor.getText().trim().length() != 0) break;
                    return DbgArb.getString(453);
                }
                case 5: {
                    if (BreakpointOptionsDialog.this.urlTextField.getURL() == null) {
                        return DbgArb.getString(454);
                    }
                    try {
                        int line = Integer.parseInt(BreakpointOptionsDialog.this.lineTextField2.getText());
                        if (line < 1) {
                            return DbgArb.getString(451);
                        }
                        break;
                    }
                    catch (Exception e) {
                        return DbgArb.getString(451);
                    }
                }
                case 6: {
                    if (BreakpointOptionsDialog.this.watchpointClassEditor.getText().trim().length() == 0) {
                        return DbgArb.getString(453);
                    }
                    if (BreakpointOptionsDialog.this.watchpointFieldEditor.getText().trim().length() != 0) break;
                    return DbgArb.getString(455);
                }
            }
            return null;
        }

        boolean veto() {
            if (this.isCustom) {
                return this.customPanel.veto();
            }
            switch (BreakpointOptionsDialog.this.currentType) {
                case 2: {
                    String jlException;
                    String exception = BreakpointOptionsDialog.this.exceptionEditor.getText().trim();
                    if (exception.startsWith("$Oracle.") || BreakpointOptionsDialog.this.findClass(exception)) break;
                    if (exception.indexOf(46) == -1 && BreakpointOptionsDialog.this.findClass(jlException = "java.lang." + exception)) {
                        BreakpointOptionsDialog.this.exceptionEditor.setText(jlException);
                        return false;
                    }
                    return !BreakpointOptionsDialog.this.showClassNotFoundMessage(exception);
                }
                case 4: {
                    String className = BreakpointOptionsDialog.this.classEditor.getText();
                    if (className.length() <= 0 || BreakpointOptionsDialog.this.findClass(className)) break;
                    return !BreakpointOptionsDialog.this.showClassNotFoundMessage(className);
                }
                case 1: {
                    String bpMethodName = BreakpointOptionsDialog.this.methodEditor.getText();
                    if (bpMethodName.length() <= 0 || BreakpointOptionsDialog.this.findMethod(bpMethodName)) break;
                    return !BreakpointOptionsDialog.this.showMethodNotFoundMessage(bpMethodName);
                }
                case 6: {
                    String className = BreakpointOptionsDialog.this.watchpointClassEditor.getText();
                    if (className.length() > 0 && !BreakpointOptionsDialog.this.findClass(className)) {
                        return !BreakpointOptionsDialog.this.showClassNotFoundMessage(className);
                    }
                    String fieldName = BreakpointOptionsDialog.this.watchpointFieldEditor.getText();
                    if (fieldName.length() <= 0 || BreakpointOptionsDialog.this.findField(className, fieldName)) break;
                    return !BreakpointOptionsDialog.this.showFieldNotFoundMessage(className, fieldName);
                }
            }
            return false;
        }

        CoreBreakpoint doOk() {
            if (this.isCustom) {
                BreakpointOptionsDialog.this.bp = this.customPanel.onOk();
                if (BreakpointOptionsDialog.this.bp == null) {
                    BreakpointOptionsDialog.this.bp = new CoreBreakpoint(BreakpointOptionsDialog.this.bpTemplate);
                }
            } else if (BreakpointOptionsDialog.this.bp != null) {
                BreakpointOptionsDialog.this.bp.setShallow(true);
                switch (BreakpointOptionsDialog.this.currentType) {
                    case 0: {
                        BreakpointOptionsDialog.this.bp.setPackageFileLine(BreakpointOptionsDialog.this.packageHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.packageEditor), BreakpointOptionsDialog.this.fileHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.fileEditor), Integer.parseInt(BreakpointOptionsDialog.this.lineTextField.getText()));
                        break;
                    }
                    case 1: {
                        BreakpointOptionsDialog.this.bp.setMethod(BreakpointOptionsDialog.this.methodHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.methodEditor));
                        break;
                    }
                    case 2: {
                        if (BreakpointOptionsDialog.this.exceptionEditor.getText().length() == 0) {
                            BreakpointOptionsDialog.this.exceptionEditor.setText("java.lang.Throwable");
                        }
                        BreakpointOptionsDialog.this.bp.setException(BreakpointOptionsDialog.this.exceptionHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.exceptionEditor), BreakpointOptionsDialog.this.caughtCheckBox.isSelected(), BreakpointOptionsDialog.this.uncaughtCheckBox.isSelected());
                        break;
                    }
                    case 4: {
                        BreakpointOptionsDialog.this.bp.setClassName(BreakpointOptionsDialog.this.classHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.classEditor));
                        break;
                    }
                    case 5: {
                        BreakpointOptionsDialog.this.bp.setURLLine(BreakpointOptionsDialog.this.urlTextField.getURL(), Integer.parseInt(BreakpointOptionsDialog.this.lineTextField2.getText()));
                        break;
                    }
                    case 6: {
                        BreakpointOptionsDialog.this.bp.setWatchpoint(BreakpointOptionsDialog.this.watchpointClassHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.watchpointClassEditor), BreakpointOptionsDialog.this.watchpointFieldHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.watchpointFieldEditor), BreakpointOptionsDialog.this.accessCheckBox.isSelected(), BreakpointOptionsDialog.this.modifyCheckBox.isSelected());
                    }
                }
            }
            if (BreakpointOptionsDialog.this.bp == null) {
                switch (BreakpointOptionsDialog.this.currentType) {
                    case 0: {
                        BreakpointOptionsDialog.this.bp = new CoreBreakpoint(BreakpointOptionsDialog.this.ownerURL, BreakpointOptionsDialog.this.jproject, BreakpointOptionsDialog.this.currentType, null, BreakpointOptionsDialog.this.packageHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.packageEditor), BreakpointOptionsDialog.this.fileHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.fileEditor), Integer.parseInt(BreakpointOptionsDialog.this.lineTextField.getText()));
                        break;
                    }
                    case 1: {
                        BreakpointOptionsDialog.this.bp = new CoreBreakpoint(BreakpointOptionsDialog.this.ownerURL, BreakpointOptionsDialog.this.jproject, BreakpointOptionsDialog.this.currentType, BreakpointOptionsDialog.this.methodHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.methodEditor));
                        break;
                    }
                    case 2: {
                        if (BreakpointOptionsDialog.this.exceptionEditor.getText().length() == 0) {
                            BreakpointOptionsDialog.this.exceptionEditor.setText("java.lang.Throwable");
                        }
                        BreakpointOptionsDialog.this.bp = new CoreBreakpoint(BreakpointOptionsDialog.this.ownerURL, BreakpointOptionsDialog.this.currentType, BreakpointOptionsDialog.this.exceptionHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.exceptionEditor), BreakpointOptionsDialog.this.caughtCheckBox.isSelected(), BreakpointOptionsDialog.this.uncaughtCheckBox.isSelected());
                        break;
                    }
                    case 4: {
                        BreakpointOptionsDialog.this.bp = new CoreBreakpoint(BreakpointOptionsDialog.this.ownerURL, BreakpointOptionsDialog.this.jproject, BreakpointOptionsDialog.this.currentType, BreakpointOptionsDialog.this.classHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.classEditor));
                        break;
                    }
                    case 5: {
                        BreakpointOptionsDialog.this.bp = new CoreBreakpoint(BreakpointOptionsDialog.this.ownerURL, BreakpointOptionsDialog.this.jproject, BreakpointOptionsDialog.this.currentType, BreakpointOptionsDialog.this.urlTextField.getURL(), Integer.parseInt(BreakpointOptionsDialog.this.lineTextField2.getText()));
                        break;
                    }
                    case 6: {
                        BreakpointOptionsDialog.this.bp = new CoreBreakpoint(BreakpointOptionsDialog.this.ownerURL, BreakpointOptionsDialog.this.jproject, BreakpointOptionsDialog.this.currentType, BreakpointOptionsDialog.this.watchpointClassHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.watchpointClassEditor), BreakpointOptionsDialog.this.watchpointFieldHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.watchpointFieldEditor), BreakpointOptionsDialog.this.accessCheckBox.isSelected(), BreakpointOptionsDialog.this.modifyCheckBox.isSelected());
                    }
                }
            }
            BreakpointOptionsDialog.this.bp.setShallow(true);
            BreakpointOptionsDialog.this.bp.setGroupName(BreakpointOptionsDialog.this.groupNameHistoryList.comboBoxGetSelectedItem(BreakpointOptionsDialog.this.groupNameEditor));
            BreakpointOptionsDialog.this.bp.setShallow(false);
            return BreakpointOptionsDialog.this.bp;
        }
    }
}

