/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownServiceException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.IdeWrapperURLStreamHandlerFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.net.EncoderUtils;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleBytecode;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleJava;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

final class BytecodeFileSystemHelper
extends URLFileSystemHelper {
    public static final String DBG_PROTOCOL = "ide.dbg";
    public static final String DBG_BYTECODE_PATH = "bytecode/";
    public static final String DBG_BYTECODE_QUERY = "method=";
    private Map<URL, BytecodeInfo> urlToInfo = new HashMap<URL, BytecodeInfo>();
    private static BytecodeFileSystemHelper instance;

    static synchronized BytecodeFileSystemHelper getInstance(boolean create) {
        if (instance == null && create) {
            instance = new BytecodeFileSystemHelper();
            URLFileSystem.registerHelper((String)DBG_PROTOCOL, (URLFileSystemHelper)instance);
            URLFileSystem.addURLStreamHandlerFactory((String)DBG_PROTOCOL, (URLStreamHandlerFactory)new IdeWrapperURLStreamHandlerFactory());
            JDebugger.getInstance().addStepBytecodeActions();
        }
        return instance;
    }

    private BytecodeFileSystemHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBytecode(DebugMethodInfo method, Workspace workspace, Project project, Map<Integer, Integer> offsetToLineMap, Map<Integer, Integer> lineToOffsetMap) {
        FastStringBuffer fsb = new FastStringBuffer();
        TextNode textNode = null;
        TextBuffer textBuffer = null;
        LineMap lineMap = null;
        try {
            DebugClassInfo clazz = method.getClassInfo();
            URL urlForJava = Source.findSourceFile(workspace, project, clazz.getPackage(), clazz.getPrimarySourceFilename());
            if (urlForJava != null) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)urlForJava);
                    if (node instanceof TextNode) {
                        TextNode tn = (TextNode)node;
                        TextBuffer tb = tn.acquireTextBuffer();
                        textNode = tn;
                        tb.readLock();
                        textBuffer = tb;
                        lineMap = textBuffer.getLineMap();
                    }
                }
                catch (Exception node) {
                    // empty catch block
                }
            }
            boolean java = textBuffer != null && lineMap != null;
            DebugDisassembleInfo[] disass = method.disassembleMethod(java, true, false, project);
            int line = 1;
            for (int index = 0; index < disass.length; ++index) {
                DebugDisassembleInfo d;
                if (disass[index] instanceof DebugDisassembleJava) {
                    d = (DebugDisassembleJava)disass[index];
                    int javaLine = d.getLineNumber();
                    String prepaddedJavaLine = IdeUtil.prepad((String)Integer.toString(javaLine), (char)' ', (int)8);
                    fsb.append(prepaddedJavaLine);
                    String javaCode = "\n";
                    try {
                        int startOffset = lineMap.getLineStartOffset(javaLine - 1);
                        int endOffset = lineMap.getLineEndOffset(javaLine - 1);
                        javaCode = textBuffer.getString(startOffset, endOffset - startOffset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fsb.append(javaCode);
                    ++line;
                    continue;
                }
                if (!(disass[index] instanceof DebugDisassembleBytecode)) continue;
                d = (DebugDisassembleBytecode)disass[index];
                int offset = d.getOffset();
                String prepaddedOffset = IdeUtil.prepad((String)Integer.toString(offset), (char)' ', (int)16);
                fsb.append(prepaddedOffset);
                fsb.append("        ");
                fsb.append(d.getBytecode());
                fsb.append("\n");
                offsetToLineMap.put(offset, line);
                lineToOffsetMap.put(line, offset);
                ++line;
            }
        }
        finally {
            if (textBuffer != null) {
                textBuffer.readUnlock();
            }
            if (textNode != null) {
                textNode.releaseTextBuffer();
            }
        }
        return fsb.toString();
    }

    private static String getWorkspacePart(DebuggingProcess debuggingProcess) {
        String w = "w";
        Workspace workspace = debuggingProcess.getWorkspace();
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            w = w + Integer.toString(workspace.hashCode());
        }
        return w;
    }

    private static String getProjectPart(DebuggingProcess debuggingProcess) {
        String p = "p";
        Project project = debuggingProcess.getProject();
        if (project != null && project != Ide.getDefaultProject()) {
            p = p + Integer.toString(project.hashCode());
        }
        return p;
    }

    private static String getInitialPath(DebuggingProcess debuggingProcess) {
        String path = DBG_BYTECODE_PATH;
        path = path + BytecodeFileSystemHelper.getWorkspacePart(debuggingProcess);
        path = path + "/";
        path = path + BytecodeFileSystemHelper.getProjectPart(debuggingProcess);
        path = path + "/";
        return path;
    }

    private URL makeURL(DebuggingProcess debuggingProcess, DebugMethodInfo method) {
        String path = BytecodeFileSystemHelper.getInitialPath(debuggingProcess);
        path = path + method.getClassInfo().getNameWithoutPackage();
        path = path + ".";
        path = path + method.getNameWithoutClassOrSignature();
        String query = DBG_BYTECODE_QUERY;
        try {
            query = query + EncoderUtils.encodeString((String)method.getName(), (String)Encodings.getDefaultEncoding());
        }
        catch (Exception e) {
            query = query + method.getName();
        }
        URL url = URLFactory.newURL((String)DBG_PROTOCOL, (String)path);
        url = URLFactory.replaceQueryPart((URL)url, (String)query);
        return url;
    }

    URL getURL(DebuggingProcess debuggingProcess, DebugMethodInfo method) {
        URL url = this.makeURL(debuggingProcess, method);
        if (this.urlToInfo.containsKey(url)) {
            return url;
        }
        return null;
    }

    static String getMethodName(URL url) {
        try {
            String query;
            if (url.getProtocol().equals(DBG_PROTOCOL) && url.getPath().startsWith(DBG_BYTECODE_PATH) && (query = url.getQuery()).startsWith(DBG_BYTECODE_QUERY)) {
                String methodName = query.substring(DBG_BYTECODE_QUERY.length());
                methodName = EncoderUtils.decodeString((String)methodName, (String)Encodings.getDefaultEncoding());
                return methodName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    int getBytecodeOffsetFromLine(URL url, int line) {
        Integer offset;
        BytecodeInfo info = this.urlToInfo.get(url);
        if (info != null && info.lineToOffsetMap != null && (offset = info.lineToOffsetMap.get(line)) != null) {
            return offset;
        }
        return -1;
    }

    int getLineFromBytecodeOffset(URL url, int offset) {
        Integer line;
        BytecodeInfo info = this.urlToInfo.get(url);
        if (info != null && info.offsetToLineMap != null && (line = info.offsetToLineMap.get(offset)) != null) {
            return line;
        }
        return 0;
    }

    URL addMethod(DebuggingProcess debuggingProcess, DebugMethodInfo method) {
        URL url = this.makeURL(debuggingProcess, method);
        BytecodeInfo info = this.urlToInfo.get(url);
        if (info == null) {
            info = new BytecodeInfo();
            this.urlToInfo.put(url, info);
        }
        info.setMethod(method, debuggingProcess.getWorkspace(), debuggingProcess.getProject());
        this.updateMethod(url);
        return url;
    }

    void updateMethods(DebuggingProcess debuggingProcess) {
        DebugVirtualMachine vm = debuggingProcess.getVM();
        String initialPath = BytecodeFileSystemHelper.getInitialPath(debuggingProcess);
        for (Map.Entry<URL, BytecodeInfo> entry : this.urlToInfo.entrySet()) {
            String className;
            DebugClassInfo clazz;
            String methodName;
            URL url = entry.getKey();
            String path = url.getPath();
            if (!path.startsWith(initialPath)) continue;
            BytecodeInfo info = entry.getValue();
            if (info.wasCleared() && vm != null && (methodName = BytecodeFileSystemHelper.getMethodName(url)) != null && (clazz = vm.findFirstClassByName(className = DebugShared.getMethodClassName(methodName))) != null) {
                DebugMethodInfo[] methods = clazz.getMethods();
                int methodsLength = methods.length;
                for (int i = 0; i < methodsLength; ++i) {
                    if (!methodName.equals(methods[i].getName())) continue;
                    info.setMethod(methods[i], debuggingProcess.getWorkspace(), debuggingProcess.getProject());
                    break;
                }
            }
            this.updateMethod(url);
        }
    }

    void removeStaleMethods() {
        for (BytecodeInfo info : this.urlToInfo.values()) {
            if (info.method == null || info.method.getVM().isConnected()) continue;
            info.clear();
        }
    }

    private void updateMethod(URL url) {
        final Node node = NodeFactory.find((URL)url);
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RevertNodeCommand.reload((Node)node);
                }
            });
        }
    }

    private synchronized BytecodeInfo fetchSource(URL url) {
        BytecodeInfo info = this.urlToInfo.get(url);
        try {
            if (info != null && info.method != null) {
                HashMap<Integer, Integer> lineToOffsetMap;
                HashMap<Integer, Integer> offsetToLineMap;
                String source;
                boolean needToDisassembleMethod = false;
                if (info.source == null) {
                    needToDisassembleMethod = true;
                } else if (info.method.hasMethodChanged()) {
                    needToDisassembleMethod = true;
                }
                if (needToDisassembleMethod && (source = BytecodeFileSystemHelper.getBytecode(info.method, info.workspace, info.project, offsetToLineMap = new HashMap<Integer, Integer>(), lineToOffsetMap = new HashMap<Integer, Integer>())) != null && source.length() > 0) {
                    info.setSource(source, offsetToLineMap, lineToOffsetMap);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    private synchronized boolean sourceExists(URL url) {
        BytecodeInfo info = this.fetchSource(url);
        return info != null ? info.sourceExists() : false;
    }

    public boolean canRead(URL url) {
        return this.sourceExists(url);
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public boolean canCreate(URL url) {
        return false;
    }

    public boolean canDelete(URL url) {
        return false;
    }

    public boolean isValid(URL url) {
        return this.sourceExists(url);
    }

    public boolean exists(URL url) {
        return this.sourceExists(url);
    }

    public Icon getDefaultIcon(URL url) {
        return OracleIcons.getIcon((String)"method.png");
    }

    public synchronized long getLength(URL url) {
        BytecodeInfo info = this.fetchSource(url);
        return info != null ? info.getSourceLength() : 0;
    }

    public URL getParent(URL url) {
        return null;
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public synchronized long lastModified(URL url) {
        BytecodeInfo info = this.fetchSource(url);
        return info != null ? info.time : -1L;
    }

    public synchronized InputStream openInputStream(URL url) throws IOException {
        BytecodeInfo info = this.fetchSource(url);
        byte[] bytes = info != null ? info.getSourceBytes() : new byte[]{};
        return new ByteArrayInputStream(bytes);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        throw new UnknownServiceException();
    }

    public synchronized Reader createReader(URL url, String encoding) throws IOException {
        BytecodeInfo info = this.fetchSource(url);
        return new StringReader(info != null ? info.getSourceString() : "");
    }

    static class BytecodeInfo {
        DebugMethodInfo method;
        Workspace workspace;
        Project project;
        long time = -1L;
        String source;
        Map<Integer, Integer> offsetToLineMap;
        Map<Integer, Integer> lineToOffsetMap;

        BytecodeInfo() {
        }

        private void setMethod(DebugMethodInfo method, Workspace workspace, Project project) {
            this.method = method;
            this.workspace = workspace;
            this.project = project;
        }

        private void clear() {
            this.method = null;
            this.workspace = null;
            this.project = null;
            this.time = -1L;
        }

        private boolean wasCleared() {
            return this.method == null;
        }

        private void setSource(String source, Map<Integer, Integer> offsetToLineMap, Map<Integer, Integer> lineToOffsetMap) {
            this.time = new Date().getTime();
            this.source = source;
            this.offsetToLineMap = offsetToLineMap;
            this.lineToOffsetMap = lineToOffsetMap;
        }

        private boolean sourceExists() {
            return this.source != null;
        }

        private int getSourceLength() {
            return this.source != null ? this.source.length() : 0;
        }

        private byte[] getSourceBytes() {
            return this.source != null ? this.source.getBytes() : new byte[]{};
        }

        private String getSourceString() {
            return this.source != null ? this.source : "";
        }
    }
}

