/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.ide.controller.Controller;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.jdevimpl.runner.debug.DataCellEditor;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.WatchPanel;

class DataNameCellEditor
extends DataCellEditor
implements Controller {
    private JPanel nameColumnPanel = new JPanel(new BorderLayout(0, 0));
    private JLabel itemIconLabel;
    private JTextField nameField;

    DataNameCellEditor(DataPanel dataPanel) {
        super(dataPanel);
        this.nameColumnPanel.setOpaque(false);
        this.nameField = new JTextField();
        this.nameField.setOpaque(true);
        this.nameField.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        String ACTION_ESCAPE_KEY = "ActionEscape";
        String ACTION_ENTER_KEY = "ActionEnter";
        this.nameField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "ActionEscape");
        this.nameField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ActionEnter");
        this.nameField.getActionMap().put("ActionEscape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataNameCellEditor.this.cancelCellEditing();
            }
        });
        this.nameField.getActionMap().put("ActionEnter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataNameCellEditor.this.stopCellEditing();
            }
        });
        this.nameColumnPanel.add((Component)this.nameField, "Center");
        this.itemIconLabel = new JLabel();
        this.itemIconLabel.setOpaque(true);
        this.itemIconLabel.setBorder(new EmptyBorder(0, 1, 0, 3));
        this.nameColumnPanel.add((Component)this.itemIconLabel, "Before");
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, DataItem dataItem) {
        JFastTreeTable treeTable;
        JTree tree;
        Rectangle r;
        this.nameField.setForeground(table.getForeground());
        this.nameField.setBackground(table.getBackground());
        this.nameField.setFont(table.getFont());
        this.nameField.setText(value == null ? "" : value.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataNameCellEditor.this.nameField.setCaretPosition(0);
                DataNameCellEditor.this.nameField.moveCaretPosition(DataNameCellEditor.this.nameField.getText().length());
                DataNameCellEditor.this.nameField.requestFocus();
            }
        });
        this.itemIconLabel.setIcon(dataItem.getIcon());
        this.itemIconLabel.setBackground(table.getBackground());
        if (table instanceof JFastTreeTable && (r = (tree = (treeTable = (JFastTreeTable)table).getTree()).getUI().getPathBounds(tree, tree.getPathForRow(0))) != null) {
            this.nameColumnPanel.setBorder(BorderFactory.createEmptyBorder(0, r.x, 0, 0));
        }
        this.nameColumnPanel.revalidate();
        return this.nameColumnPanel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (this.dataPanel instanceof WatchPanel) {
            if (anEvent instanceof MouseEvent && anEvent.getSource() instanceof JFastTreeTable) {
                MouseEvent me = (MouseEvent)anEvent;
                JFastTreeTable treeTable = (JFastTreeTable)anEvent.getSource();
                JTree tree = treeTable.getTree();
                int row = treeTable.rowAtPoint(me.getPoint());
                TreePath path = tree.getPathForRow(row);
                if (treeTable.getSelectedRow() == row && path.getPathCount() == 2) {
                    Rectangle r = tree.getUI().getPathBounds(tree, path);
                    TableColumnModel colModel = treeTable.getColumnModel();
                    int treeCol = treeTable.getTreeColumn();
                    int colX = 0;
                    for (int i = 0; i < treeCol; ++i) {
                        colX += colModel.getColumn(i).getWidth();
                    }
                    if (me.getPoint().x >= colX + r.x) {
                        return true;
                    }
                }
                treeTable.forwardEventToTree(me);
                return false;
            }
            if (!(anEvent instanceof MouseEvent) || !(anEvent.getSource() instanceof JTable)) return true;
            MouseEvent me = (MouseEvent)anEvent;
            JTable table = (JTable)anEvent.getSource();
            int row = table.rowAtPoint(me.getPoint());
            TreePath path = this.dataPanel.getSelectedTreePath();
            if (table.getSelectedRow() != row || path == null || path.getPathCount() != 2) return false;
            return true;
        }
        if (!(anEvent instanceof MouseEvent) || !(anEvent.getSource() instanceof JFastTreeTable)) return false;
        JFastTreeTable treeTable = (JFastTreeTable)anEvent.getSource();
        treeTable.forwardEventToTree((MouseEvent)anEvent);
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.nameField.getText();
    }
}

