/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.debugger.plugin.breakpoint.MethodDescriptor;
import oracle.ide.debugger.plugin.tracking.ExecutionTrackingInfo;
import oracle.ide.runner.DebuggerLocation;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;

final class ExecutionTrackingInfoImpl
implements ExecutionTrackingInfo {
    private final long timestamp;
    private final DebugLocation location;
    private final boolean isBackground;
    private final long nanoStepTime;
    private final DebugClassInfo redefinedClass;
    private MethodDescriptor methodEntryDescriptor;

    ExecutionTrackingInfoImpl(DebugLocation location, boolean isBackground) {
        this(location, isBackground, -1L);
    }

    ExecutionTrackingInfoImpl(DebugLocation location, boolean isBackground, long stepElapsedNanos) {
        this.location = location;
        this.timestamp = System.nanoTime();
        this.isBackground = isBackground;
        this.nanoStepTime = stepElapsedNanos;
        this.redefinedClass = null;
    }

    ExecutionTrackingInfoImpl(DebugClassInfo redefinedClass) {
        this.location = null;
        this.timestamp = System.nanoTime();
        this.isBackground = false;
        this.nanoStepTime = -1L;
        this.redefinedClass = redefinedClass;
    }

    public boolean isBackground() {
        return this.isBackground;
    }

    public DebuggerLocation getLocation() {
        return this.location;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getStepNanoTime() {
        return this.nanoStepTime;
    }

    public String getFQClassName() {
        return this.location.getClassInfo().getName();
    }

    public String getClassName() {
        return this.location == null ? "<No Associated Class>" : this.location.getClassInfo().getNameWithoutPackage();
    }

    public String getPackage() {
        return this.location == null ? "<No Associated Package>" : this.location.getClassInfo().getPackage();
    }

    public URL getSourceURL(Context context) {
        try {
            String filename = this.location.getClassInfo().getSourceFilename();
            return Source.findSourceFile(context.getWorkspace(), context.getProject(), this.getPackage(), filename);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMethodName() {
        return this.location == null ? "<No location>" : this.location.getMethod().getNameWithoutClassOrSignature();
    }

    public List<String> getParameterTypes() {
        if (this.location == null) {
            return new ArrayList<String>();
        }
        String signature = this.location.getMethod().getParameterSignature();
        if (signature.length() <= 2) {
            return Collections.emptyList();
        }
        signature = signature.substring(1, signature.length() - 2);
        String[] parms = signature.split(",");
        List<String> parameterTypes = Arrays.asList(parms);
        return parameterTypes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Location " + this.location + " background: " + this.isBackground);
        return sb.toString();
    }

    public Object getUniqueID() {
        int[] lines = this.location.getMethod().getMethodLines();
        if (lines == null || lines.length == 0) {
            return this.getClassName() + " " + this.getMethodName();
        }
        return this.getClassName() + " " + this.getMethodName() + " " + lines[0];
    }

    public String getRedefinedClassSourceFile() {
        return this.redefinedClass.getPrimarySourceFilename();
    }

    public void setMethodDescriptor(MethodDescriptor method) {
        this.methodEntryDescriptor = method;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodEntryDescriptor;
    }
}

