/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTableSwitcher;
import oracle.jdevimpl.runner.debug.HeapController;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MultiViewPanel;

final class HeapPanel
extends MultiViewPanel {
    private HeapWindowSettings heapWindowSettings;

    HeapPanel(HeapWindow heapWindow, HeapWindowSettings heapWindowSettings) {
        super(heapWindow, heapWindowSettings.getDataPanelSettings());
        this.heapWindowSettings = heapWindowSettings;
    }

    @Override
    protected DataController createController(DataPanelSettings dataPanelSettings) {
        return new HeapController(dataPanelSettings, this);
    }

    @Override
    protected Component adjustGUI(Component defaultGui) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 8: 
                    case 127: {
                        if (!((HeapController)HeapPanel.this.getController()).delete(e)) break;
                        e.consume();
                    }
                }
            }
        };
        DataTableSwitcher switcher = (DataTableSwitcher)this.getDataTable();
        switcher.addKeyListener(keyAdapter);
        return defaultGui;
    }

    @Override
    protected void checkDrag(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor()) || e.isDataFlavorSupported(ClassesWindow.getArrayFlavor()) || e.isDataFlavorSupported(DataItem.getHeapObjectFlavor())) {
            e.acceptDrag(1);
            return;
        }
        super.checkDrag(e);
    }

    @Override
    protected void checkDrop(DropTargetDropEvent e) {
        HeapController controller = (HeapController)this.getController();
        if (e.isLocalTransfer()) {
            if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                try {
                    Transferable t = e.getTransferable();
                    ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getClassFlavor());
                    controller.addClass(data.getName());
                    JDebugger.getInstance().viewHeap();
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception t) {}
            } else if (e.isDataFlavorSupported(ClassesWindow.getArrayFlavor())) {
                try {
                    Transferable t = e.getTransferable();
                    ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getArrayFlavor());
                    controller.addClass(data.getName());
                    JDebugger.getInstance().viewHeap();
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception t) {}
            } else if (e.isDataFlavorSupported(DataItem.getHeapObjectFlavor())) {
                try {
                    Transferable t = e.getTransferable();
                    DebugDataCompositeInfo data = (DebugDataCompositeInfo)t.getTransferData(DataItem.getHeapObjectFlavor());
                    controller.showAncestors(data, data.getAddressOfObject());
                    JDebugger.getInstance().viewHeap();
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.checkDrop(e);
    }

    final HeapWindowSettings getHeapWindowSettings() {
        return this.heapWindowSettings;
    }

    @Override
    String getWindowId() {
        return "Debugger.HeapWindow";
    }

    @Override
    public DebuggerWindowOptions.WindowId getWindowIdEnum() {
        return DebuggerWindowOptions.WindowId.HeapWindow;
    }
}

