/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessLifecycleEvent;
import oracle.ide.runner.RunProcessLifecycleListener;
import oracle.ide.runner.Runner;
import oracle.ide.view.View;
import oracle.jdeveloper.runner.JRunProcess;

public class SharedActions
implements Controller,
RunProcessLifecycleListener {
    private static IdeAction actionDebugPause;
    private static IdeAction actionDebugResume;
    private static IdeAction actionDebugGC;
    private static IdeAction actionDebugReset;
    private static IdeAction actionDebugDetach;
    public static final int DEBUG_PAUSE_CMD_ID;
    public static final int DEBUG_RESUME_CMD_ID;
    public static final int DEBUG_RESET_CMD_ID;
    public static final int DEBUG_GC_CMD_ID;
    public static final int DEBUG_DETACH_CMD_ID;
    private ArrayList<Controller> controllers = new ArrayList();
    private static final SharedActions instance;
    private List<JRunProcess> runProcessList = new ArrayList<JRunProcess>();

    private SharedActions() {
    }

    public static synchronized SharedActions getInstance() {
        return instance;
    }

    public void addController(Controller controller) {
        if (!this.controllers.contains(controller)) {
            this.controllers.add(controller);
        }
    }

    public void removeController(Controller controller) {
        this.controllers.remove(controller);
    }

    public synchronized void processStarted(JRunProcess runProcess) {
        if (this.runProcessList.isEmpty()) {
            Runner.getRunner().addLifecycleListener((RunProcessLifecycleListener)this);
            this.toggleActionButtonsVisibility(true);
        }
        this.runProcessList.add(runProcess);
    }

    public void initialize() {
        this.getSuspendAction();
        this.getResumeAction();
        this.getTerminateAction();
        this.getGcAction();
    }

    void toggleActionButtonsVisibility(boolean visible) {
        Toolbar tb = Ide.getToolbar();
        for (int i = 0; i < tb.getComponentCount(); ++i) {
            IdeAction ideAction;
            Action action;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || !((action = ((AbstractButton)c).getAction()) instanceof IdeAction) || !this.isSharedAction(ideAction = (IdeAction)action)) continue;
            c.setVisible(visible);
        }
    }

    public IdeAction getSuspendAction() {
        if (actionDebugPause == null) {
            actionDebugPause = IdeAction.get((int)DEBUG_PAUSE_CMD_ID);
        }
        return actionDebugPause;
    }

    public IdeAction getResumeAction() {
        if (actionDebugResume == null) {
            actionDebugResume = IdeAction.get((int)DEBUG_RESUME_CMD_ID);
        }
        return actionDebugResume;
    }

    public IdeAction getTerminateAction() {
        if (actionDebugReset == null) {
            actionDebugReset = IdeAction.get((int)DEBUG_RESET_CMD_ID);
        }
        return actionDebugReset;
    }

    public IdeAction getGcAction() {
        if (actionDebugGC == null) {
            actionDebugGC = IdeAction.get((int)DEBUG_GC_CMD_ID);
        }
        return actionDebugGC;
    }

    public IdeAction getDetachAction() {
        if (actionDebugDetach == null) {
            actionDebugDetach = IdeAction.get((int)DEBUG_DETACH_CMD_ID);
        }
        return actionDebugDetach;
    }

    private boolean isSharedAction(IdeAction action) {
        int commandId = action.getCommandId();
        return commandId == DEBUG_PAUSE_CMD_ID || commandId == DEBUG_RESUME_CMD_ID || commandId == DEBUG_RESET_CMD_ID || commandId == DEBUG_GC_CMD_ID || commandId == DEBUG_DETACH_CMD_ID;
    }

    public void preparing(RunProcessLifecycleEvent event, boolean userCanTerminate) {
    }

    public void finishedPreparing(RunProcessLifecycleEvent event) {
    }

    public void started(RunProcessLifecycleEvent event, boolean userCanTerminate) {
    }

    public synchronized void finished(RunProcessLifecycleEvent event) {
        RunProcess runProcess = event.getRunProcess();
        if (this.runProcessList.contains(runProcess)) {
            this.runProcessList.remove(runProcess);
            if (this.runProcessList.isEmpty()) {
                Runner.getRunner().removeLifecycleListener((RunProcessLifecycleListener)this);
                this.toggleActionButtonsVisibility(false);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (this.isSharedAction(action)) {
            Controller controller;
            View view = context.getView();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller instanceof SharedActionController) {
                return controller.handleEvent(action, context);
            }
            for (Controller handler : this.controllers) {
                if (!handler.handleEvent(action, context)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (this.isSharedAction(action)) {
            Controller controller;
            View view = context.getView();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller instanceof SharedActionController) {
                return controller.update(action, context);
            }
            for (Controller handler : this.controllers) {
                if (!handler.update(action, context)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        DEBUG_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPauseCommand");
        DEBUG_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResumeCommand");
        DEBUG_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResetCommand");
        DEBUG_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugGCCommand");
        DEBUG_DETACH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugDetachCommand");
        instance = new SharedActions();
    }

    public static interface SharedActionController
    extends Controller {
    }
}

