/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.jdevimpl.debugger.breakpoint.SourceIcon;
import oracle.jdevimpl.debugger.plugin.evaluator.PluginEvaluatorBase;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.SmartDataLocationInfo;
import oracle.jdevimpl.runner.debug.SmartUtils;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;

public class SmartDataLineLocationInfo
extends SmartDataLocationInfo {
    private CodeEditor codeEditor;
    private int line;
    private int numberOfLines;

    public SmartDataLineLocationInfo(DebuggingProcess debuggingProcess, DebugStackFrameInfo frame) {
        super(frame);
        this.method = this.location != null ? this.location.getMethod() : null;
        SourceIcon sourceIconForIP = debuggingProcess.getSourceIconForIP();
        if (sourceIconForIP != null) {
            this.codeEditor = sourceIconForIP.getCodeEditor();
            this.line = sourceIconForIP.getLine();
        }
    }

    @Override
    List getExpressions(SmartWindowSettings smartWindowSettings, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if (this.expressions == null || this.numberOfLines != smartWindowSettings.getNumberOfLines()) {
            this.expressions = new ArrayList();
            if (this.isAtStartOfMethod()) {
                DebugVariableInfo[] args = frame.listArguments();
                int argsLength = args.length;
                for (int i = 0; i < argsLength; ++i) {
                    this.expressions.add(args[i].getName());
                }
            } else if (this.method != null && (this.method.getAccess() & 8) == 0) {
                this.expressions.add("this");
            }
            if (vm != null && vm.getCurrentThrow() != null) {
                this.expressions.add(PluginEvaluatorBase.getThrowExpressionPart());
            }
            if (thread != null) {
                if (thread.getReturnValue() != null) {
                    this.expressions.add(PluginEvaluatorBase.getReturnExpressionPart());
                } else if (thread.getReturnedValue() != null) {
                    this.expressions.add(PluginEvaluatorBase.getReturnedExpressionPart());
                }
            }
            this.numberOfLines = smartWindowSettings.getNumberOfLines();
            try {
                Context context;
                Node node;
                if (this.codeEditor != null && this.line > 0 && (node = (context = this.codeEditor.getContext()).getNode()) instanceof TextNode) {
                    SmartUtils.getExpressions((TextNode)node, this.line, this.numberOfLines, this.expressions);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.expressions;
    }

    private boolean isAtStartOfMethod() {
        if (this.location != null) {
            int bytecodeOffset = this.location.getBytecodeOffset();
            if (this.method != null && this.method.getNameWithoutClassOrSignature().equals("<init>") ? bytecodeOffset <= 4 : bytecodeOffset == 0) {
                return true;
            }
        }
        return false;
    }
}

