/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.util.Log;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.debugger.support.DebuggerWindowColumnOptions;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.BaseElement;
import oracle.jdevimpl.debugger.plugin.CommonHelperFunctions;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ThreadsPanelSettings;
import oracle.jdevimpl.runner.debug.Utils;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

abstract class ThreadsPanel
implements TreeExpansionListener,
TreeSelectionListener,
Controller,
ContextMenuListener,
Comparator,
ColumnMenuListener {
    public static final Log logger = new Log("ThreadsPanel");
    protected DockableWindow dockableWindow;
    protected ThreadTreeTableModel model;
    protected JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private boolean skippedUpdate = true;
    protected DebuggingProcess debuggingProcess;
    protected DebugVirtualMachine vm;
    protected DebuggerWindowOptions windowOptions;
    private ThreadsPanelSettings threadsPanelSettings;
    protected int preferredVisibleRowCount = 6;
    protected boolean boldCurrentThreadName = true;
    protected boolean boldDeadlockedThreadStatus = true;
    protected IdeAction _actionGoTo;
    protected IdeAction _actionSave;
    protected JMenuItem _menuitemGoTo;
    protected JMenuItem _menuitemSave;
    protected int _GOTO_CMD_ID;
    protected int _SAVE_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_STATUS = 1;
    static final int COLUMN_GROUP = 2;
    static final int COLUMN_PRIORITY = 3;
    static final int COLUMN_DAEMON = 4;
    static final int NUMBER_OF_COLUMNS = 5;
    protected TableColumn[] column = new TableColumn[5];
    protected int[] columnDefaultWidth = new int[5];
    private boolean[] columnShowing = new boolean[5];
    private boolean[] columnNumeric = new boolean[5];
    private static Icon threadGroupIcon = null;
    private static Icon threadIcon = null;
    private static Icon threadIconGray = null;
    private static Icon currentThreadIcon = null;
    private static Icon currentThreadIconGray = null;
    private static final String NOT_AVAILABLE = "";
    private boolean adjustColumnsAlreadyDone = false;
    private Font normalFont;
    private Font boldFont;

    ThreadsPanel(DockableWindow dockableWindow, ThreadsPanelSettings threadsPanelSettings) {
        this.dockableWindow = dockableWindow;
        this.threadsPanelSettings = threadsPanelSettings;
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        threadsPanelSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent e) {
                if (Utils.structureReallyChanged(e)) {
                    ThreadsPanel.this.threadsPanelSettingsChanged(true);
                }
            }
        });
    }

    @Override
    public void showColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = true;
            if (this.threadsPanelSettings != null) {
                this.threadsPanelSettings.setColumnVisible(this.vm.getID(), index, true);
            }
            this.treeTable.addColumn(this.column[index]);
        }
    }

    @Override
    public void hideColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = false;
            if (this.threadsPanelSettings != null) {
                this.threadsPanelSettings.setColumnVisible(this.vm.getID(), index, false);
            }
            this.treeTable.getTableHeader().setDraggedColumn(null);
            this.treeTable.removeColumn(this.column[index]);
        }
    }

    private void createGUI() {
        List modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new ThreadTreeTableModel(modelRoot);
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.dockableWindow.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        TableHelper.setResizeColumnOnDoubleClick((JTable)this.treeTable, (boolean)true);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        for (int i = 0; i < 5; ++i) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
        }
        boolean[] showColumnInMenu = new boolean[5];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        this.columnDefaultWidth[0] = this.columnDefaultWidth[0] * 2;
        this.column[0].setPreferredWidth(this.columnDefaultWidth[0]);
        this.columnDefaultWidth[4] = this.columnDefaultWidth[4] / 2;
        this.column[4].setPreferredWidth(this.columnDefaultWidth[4]);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        TreeSelectionModel treeSelectionModel = tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        tree.addTreeExpansionListener(this);
        tree.addTreeSelectionListener(this);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof ThreadItem) {
                    String accessibleDescription;
                    ThreadItem threadItem = (ThreadItem)((Object)value);
                    this.setIcon(threadItem.getIcon());
                    this.setFont(threadItem.getFont(0));
                    String tooltip = threadItem.getName();
                    this.setToolTipText(tooltip);
                    AccessibleContext ac = this.getAccessibleContext();
                    String accessibleName = ThreadsPanel.this.model.getAccessibleNameAt(threadItem, 0);
                    if (threadItem.mayHaveChildren()) {
                        accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                    }
                    if (accessibleName != null) {
                        ac.setAccessibleName(accessibleName);
                    }
                    if ((accessibleDescription = tooltip) != null) {
                        ac.setAccessibleDescription(accessibleDescription);
                    }
                } else {
                    this.setIcon(null);
                    this.setFont(ThreadsPanel.this.getNormalFont());
                    this.setToolTipText(null);
                }
                return this;
            }
        });
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String accessibleDescription;
                String tooltip;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int modelColumn = table.convertColumnIndexToModel(column);
                TreePath treePath = ThreadsPanel.this.treeTable.getTree().getPathForRow(row);
                ThreadItem threadItem = ThreadsPanel.this.getThreadItemForTreePath(treePath);
                this.setFont(threadItem.getFont(modelColumn));
                int horizontalAlignment = 2;
                if (modelColumn == 3) {
                    horizontalAlignment = 4;
                }
                this.setHorizontalAlignment(horizontalAlignment);
                String string = tooltip = value instanceof String ? (String)value : null;
                if (tooltip != null) {
                    this.setToolTipText(tooltip);
                }
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = ThreadsPanel.this.model.getAccessibleNameAt(threadItem, modelColumn);
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
                if ((accessibleDescription = tooltip) != null) {
                    ac.setAccessibleDescription(accessibleDescription);
                }
                return this;
            }
        });
        TableCellRenderer booleanRenderer = this.treeTable.getDefaultRenderer(Boolean.class);
        if (booleanRenderer instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)((Object)booleanRenderer);
            checkBox.setBorderPaintedFlat(true);
        }
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        final TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (headerRenderer instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)headerRenderer;
                    int modelColumn = table.convertColumnIndexToModel(column);
                    int horizontalAlignment = 2;
                    if (modelColumn == 3) {
                        horizontalAlignment = 4;
                    }
                    defaultTableCellRenderer.setHorizontalAlignment(horizontalAlignment);
                }
                return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ThreadsPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ThreadsPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, ThreadsPanel.this.dockableWindow.getTitleName()));
                }
                if (JDebugger.isDoubleClickInTreeTable(ThreadsPanel.this.treeTable, e)) {
                    Context context = ThreadsPanel.this.getContext(e);
                    ThreadsPanel.this.update(ThreadsPanel.this._actionGoTo, context);
                    if (ThreadsPanel.this._actionGoTo.isEnabled()) {
                        ThreadsPanel.this.handleEvent(ThreadsPanel.this._actionGoTo, context);
                    }
                }
            }
        });
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, ThreadsPanel.this.dockableWindow.getTitleName()));
                }
            }
        });
        this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 10: {
                        ThreadsPanel.this.update(ThreadsPanel.this._actionGoTo, null);
                        if (!ThreadsPanel.this._actionGoTo.isEnabled()) break;
                        ThreadsPanel.this.handleEvent(ThreadsPanel.this._actionGoTo, null);
                        e.consume();
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ThreadsPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ThreadsPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, ThreadsPanel.this.dockableWindow.getTitleName()));
                }
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsPanel.this.adjustColumnsAfterResize();
            }
        });
        this.treeTable.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsPanel.this.treeTable.isShowing()) {
                    ThreadsPanel.this.nowShown();
                }
            }
        });
        this.adjustGUI();
    }

    protected void adjustGUI() {
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.treeTable.getTree().getFont();
        }
        return this.normalFont;
    }

    private Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = this.getNormalFont().deriveFont(1);
        }
        return this.boldFont;
    }

    Component getGUI() {
        if (this.scrollPane == null) {
            this.createGUI();
        }
        return this.scrollPane;
    }

    void setNewVm(DebugVirtualMachine newVM, DebuggerWindowOptions windowOptions) {
        List<String> columnNames;
        String vmID;
        if (this.vm != null) {
            try {
                this.storeVmSettings(this.vm);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.vm = newVM;
        HashStructure hash = this.threadsPanelSettings.getHash();
        boolean forceWriteToSettings = false;
        if (newVM != null && windowOptions != null && (forceWriteToSettings || !WindowSettingsColumnManager.getVMNames(hash).contains(newVM.getID()) || this.threadsPanelSettings.getColumnNamesInPreferences(newVM.getID()).size() == 0)) {
            vmID = newVM.getID();
            WindowSettingsColumnManager.addVMName(hash, vmID);
            columnNames = new ArrayList<String>();
            ArrayList<String> columnNamesInPreferences = new ArrayList<String>();
            boolean alteredColumnOrder = false;
            ArrayList<Object> orderedColumns = new ArrayList<Object>();
            for (int i = 0; i < windowOptions.getNumberOfColumns(); ++i) {
                DebuggerWindowColumnOptions column = windowOptions.getColumnInfo(i);
                this.threadsPanelSettings.setColumnVisible(vmID, i, column.isVisibleByDefault());
                this.threadsPanelSettings.setColumnNumeric(vmID, i, column.isNumeric());
                columnNames.add(column.getColumnName());
                columnNamesInPreferences.add(column.getColumnNameInPrefencePane());
                if (column.getOrderInTable() != -1) {
                    alteredColumnOrder = true;
                    orderedColumns.set(column.getOrderInTable(), column);
                    continue;
                }
                orderedColumns.add(column);
            }
            this.threadsPanelSettings.setColumnNames(vmID, columnNames);
            this.threadsPanelSettings.setColumnNamesInPreferences(vmID, columnNamesInPreferences);
            if (alteredColumnOrder) {
                StringBuilder sb = new StringBuilder();
                for (DebuggerWindowColumnOptions debuggerWindowColumnOptions : orderedColumns) {
                    sb.append(debuggerWindowColumnOptions.getColumnName());
                    sb.append(",");
                }
                this.threadsPanelSettings.setColumnOrder(vmID, sb.toString());
            }
        }
        if (newVM != null) {
            int i;
            vmID = newVM.getID();
            columnNames = this.threadsPanelSettings.getColumnNames(vmID);
            if (columnNames.size() == 0) {
                return;
            }
            for (i = 0; i < 5; ++i) {
                String columnName = columnNames.get(i);
                this.columnNumeric[i] = columnName != null ? this.threadsPanelSettings.getColumnNumeric(vmID, i) : false;
            }
            for (i = 0; i < columnNames.size(); ++i) {
                String columnName = columnNames.get(i);
                columnNames.set(i, StringUtils.stripMnemonic((String)columnName));
            }
            if (this.model != null) {
                this.model.setThreadsPanelSettings(this.threadsPanelSettings);
            }
            for (i = 0; i < 5; ++i) {
                if (columnNames.size() > i && columnNames.get(i) != null && this.column[i] != null) {
                    this.column[i].setHeaderValue(columnNames.get(i));
                    continue;
                }
                Log.error((String)("ThreadsPanel: columnNames for " + vmID + " has no value for column " + i));
            }
            if (this.treeTable != null && this.treeTable.getTableHeader() != null) {
                this.treeTable.getTableHeader().repaint();
            }
            this.threadsPanelSettingsChanged(false);
            for (i = 0; i < 5; ++i) {
                if (this.column[i] == null) continue;
                int width = this.threadsPanelSettings.getColumnWidth(vmID, i);
                if (width > 0) {
                    this.adjustColumnsAlreadyDone = true;
                    this.column[i].setPreferredWidth(width);
                    continue;
                }
                this.column[i].setPreferredWidth(this.columnNumeric[i] ? 37 : 75);
            }
            if (this.treeTable != null) {
                TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
                String order = this.threadsPanelSettings.getColumnOrder(vmID);
                if (order != null) {
                    for (int i2 = 0; i2 < 5; ++i2) {
                        String identifier;
                        int comma = order.indexOf(44);
                        if (comma != -1) {
                            identifier = order.substring(0, comma);
                            order = order.substring(comma + 1);
                        } else {
                            identifier = order;
                        }
                        if (identifier.length() == 0) break;
                        try {
                            int n = tableColumnModel.getColumnIndex(identifier);
                            if (n == i2) continue;
                            this.treeTable.moveColumn(n, i2);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private void storeVmSettings(DebugVirtualMachine vm) {
        if (vm == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (this.column[i] != null) {
                this.threadsPanelSettings.setColumnWidth(vm.getID(), i, this.column[i].getWidth());
            }
            this.threadsPanelSettings.setColumnVisible(vm.getID(), i, this.columnShowing[i]);
            this.threadsPanelSettings.setColumnNumeric(vm.getID(), i, this.columnNumeric[i]);
        }
        TableColumnModel tcModel = this.treeTable.getColumnModel();
        StringBuilder buf = new StringBuilder();
        Enumeration<TableColumn> e = tcModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            buf.append(column.getIdentifier());
            buf.append(',');
        }
        this.threadsPanelSettings.setColumnOrder(vm.getID(), buf.toString());
    }

    void threadsPanelSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        String vmName = this.vm == null ? NOT_AVAILABLE : this.vm.getID();
        for (int i = 0; i < 5; ++i) {
            boolean show = this.threadsPanelSettings.getColumnVisible(vmName, i);
            if (this.columnShowing[i] == show) continue;
            this.columnShowing[i] = show;
            if (show) {
                this.treeTable.addColumn(this.column[i]);
                continue;
            }
            this.treeTable.removeColumn(this.column[i]);
        }
        if (changed && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThreadsPanel.this.everythingChanged();
                }
            });
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    Context getContext() {
        return this.getContext(null);
    }

    Context getContext(EventObject event) {
        Object info;
        ThreadItem threadItem = this.getSelectedThreadItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (threadItem != null && (info = threadItem.getInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)info;
        }
        return ContextBuilder.buildContext((Element)threadItem, (View)this.dockableWindow, event, this.debuggingProcess, jdiInformationProvider);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.model.branchExpanded(event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.model.branchCollapsed(event.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this._GOTO_CMD_ID) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                threadItem.showInSource();
            }
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = this.model.getValueAt((Object)threadItem, column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._GOTO_CMD_ID) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                action.setEnabled(threadItem.canShowInSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(threadItem != null && column != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(final ContextMenu popup) {
        final Context context = popup.getContext();
        if (this.treeTable != null && context.getView() == this.dockableWindow && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ThreadItem threadItem = ThreadsPanel.this.getSelectedThreadItem();
                    if (threadItem != null) {
                        ThreadsPanel.this.addPopupMenuItemsForThreadItem(popup, context);
                    }
                    ThreadsPanel.this.addPopupMenuItemsForThreads(popup, context);
                    ThreadsPanel.this.addPopupMenuItemsForTreeTable(popup, context);
                    ThreadsPanel.this.addPopupMenuItemsForCommon(popup, context);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof DebugThreadGroupInfo) {
            DebugThreadGroupInfo group1 = (DebugThreadGroupInfo)o1;
            DebugThreadGroupInfo group2 = (DebugThreadGroupInfo)o2;
            return group1.getName().compareToIgnoreCase(group2.getName());
        }
        DebugThreadInfo thread1 = (DebugThreadInfo)o1;
        DebugThreadInfo thread2 = (DebugThreadInfo)o2;
        return thread1.getName().compareToIgnoreCase(thread2.getName());
    }

    protected void addPopupMenuItemsForThreadItem(ContextMenu popup, Context context) {
        this.update(this._actionGoTo, context);
        if (this._actionGoTo.isEnabled()) {
            if (this._menuitemGoTo == null) {
                this._menuitemGoTo = popup.createMenuItem((ToggleAction)this._actionGoTo);
            }
            popup.add((Component)this._menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForThreads(ContextMenu popup, Context context) {
    }

    protected void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
    }

    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(this._actionSave, context);
        if (this._actionSave.isEnabled()) {
            if (this._menuitemSave == null) {
                this._menuitemSave = popup.createMenuItem((ToggleAction)this._actionSave);
            }
            popup.add((Component)this._menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, this.dockableWindow, this.treeTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(100, this.dockableWindow.getTitleName());
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        chooser.setHelpID("f1_deb_exportdialog_html");
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, this.dockableWindow.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                this.model.save(out, html);
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            finally {
                wc.hide();
            }
            if (exceptionOccurred != null) {
                String message = DbgArb.format(771, this.dockableWindow.getTitleName(), URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        if (this.model != null) {
            ThreadInfoPath highlight = this.getCurrentHighlight();
            this.model.updateThreads(highlight);
        }
    }

    void invalidatePane() {
        this.everythingChanged();
    }

    void updateCell(int row, int column) {
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, row, row, column);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
    }

    protected ThreadInfoPath getCurrentHighlight() {
        return this.model.getCurrentHighlight();
    }

    void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo highlightThread, DebuggerWindowOptions options) {
        this.debuggingProcess = debuggingProcess;
        this.setNewVm(vm, options);
        ThreadInfoPath highlight = null;
        if (highlightThread != null) {
            highlight = new ThreadInfoPath(debuggingProcess, highlightThread);
        }
        if (this.model != null) {
            this.model.updateThreads(highlight);
        }
    }

    void clearThreads(DebuggerWindowOptions options) {
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.setEnabled(false);
        this.model.clearThreads();
        this.setNewVm(null, options);
    }

    protected abstract void addThreadItems();

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.model.updateThreads(null);
            }
        }
    }

    ThreadItem getThreadItemForTreePath(TreePath treePath) {
        Object node;
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof ThreadItem) {
            return (ThreadItem)((Object)node);
        }
        return null;
    }

    ThreadItem getSelectedThreadItem() {
        if (this.treeTable != null) {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            return this.getThreadItemForTreePath(treePath);
        }
        return null;
    }

    DebugThreadInfo getSelectedThreadInfo() {
        ThreadItem threadItem = this.getSelectedThreadItem();
        if (threadItem != null) {
            return threadItem.getThreadInfo();
        }
        return null;
    }

    protected List getRoot() {
        return (List)this.model.getRoot();
    }

    void resetIcons() {
        this.model.resetIcons();
    }

    String getColumnName(int column) {
        if (this.windowOptions != null) {
            return this.windowOptions.getColumnInfo(column).getColumnName();
        }
        return ThreadsPanel.getDefaultColumnName(column);
    }

    static String getDefaultColumnName(int column) {
        switch (column) {
            case 0: {
                return DbgArb.getString(191);
            }
            case 1: {
                return DbgArb.getString(192);
            }
            case 2: {
                return DbgArb.getString(193);
            }
            case 3: {
                return DbgArb.getString(194);
            }
            case 4: {
                return DbgArb.getString(195);
            }
        }
        return NOT_AVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void threadDump(DebugThreadInfo[] threads, DebuggingProcess debuggingProcess, Context context, String saveDialogTitle, String htmlTitle) {
        URL url;
        int result;
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if ((result = chooser.showSaveDialog((Component)Ide.getMainWindow(), saveDialogTitle)) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, htmlTitle) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                String threadsHeader = ThreadsPanel.getThreadsHeader(html);
                if (html) {
                    out.println("<table border=\"1\">");
                }
                out.println(threadsHeader);
                StringBuffer sb = new StringBuffer();
                for (DebugThreadInfo thread : threads) {
                    sb.setLength(0);
                    if (html) {
                        sb.append("<tr>");
                    }
                    int countThreadColumns = 0;
                    for (int x = 0; x < 5; ++x) {
                        ++countThreadColumns;
                        String columnValue = null;
                        String[] pd = null;
                        switch (x) {
                            case 0: {
                                columnValue = thread.getName();
                                break;
                            }
                            case 1: {
                                columnValue = ThreadsPanel.getThreadStatus(debuggingProcess, thread);
                                if (thread.isThreadSuspended()) {
                                    columnValue = columnValue + ", " + DbgArb.getString(204);
                                }
                                if (!ThreadsPanel.isDeadlocked(thread, debuggingProcess)) break;
                                columnValue = columnValue + ", " + DbgArb.getString(205);
                                break;
                            }
                            case 2: {
                                columnValue = thread.getGroupName();
                                break;
                            }
                            case 3: {
                                if (pd == null) {
                                    pd = ThreadsPanel.getPriorityDaemon(thread);
                                }
                                columnValue = pd[0];
                                break;
                            }
                            case 4: {
                                if (pd == null) {
                                    pd = ThreadsPanel.getPriorityDaemon(thread);
                                }
                                columnValue = pd[1];
                            }
                        }
                        if (html) {
                            sb.append("<td>");
                            if (columnValue != null) {
                                String columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue);
                                if (columnValueString.length() > 0) {
                                    sb.append(columnValueString);
                                } else {
                                    sb.append("&nbsp;");
                                }
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (x > 0) {
                            sb.append(",  ");
                        }
                        if (columnValue == null) continue;
                        sb.append(columnValue);
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                    DebugStackFrameInfo[] frames = thread.listStack();
                    int framesLength = frames.length;
                    if (framesLength > 0) {
                        if (html) {
                            String stackHeader = ThreadsPanel.getStackHeader(html);
                            out.println("<tr><td></td><td colspan=" + (countThreadColumns - 1) + "><table border=\"1\">");
                            out.println(stackHeader);
                        }
                        for (int isf = 0; isf < framesLength; ++isf) {
                            DebugMethodInfo method;
                            DebugStackFrameInfo frame = frames[isf];
                            DebugLocation location = frame.getLocation();
                            if (location == null || (method = location.getMethod()) == null) continue;
                            String methodName = DebugShared.makeCourtesyMethodName(method, true, false, frame);
                            String filename = location.getFilename();
                            int line = location.getLine();
                            sb.setLength(0);
                            if (html) {
                                sb.append("<tr><td>");
                                methodName = IdeUtil.replaceHTMLReservedCharacters((String)methodName);
                                sb.append(methodName);
                                sb.append("</td><td>");
                                if (filename != null) {
                                    filename = IdeUtil.replaceHTMLReservedCharacters((String)filename);
                                    sb.append(filename);
                                } else {
                                    sb.append("&nbsp;");
                                }
                                sb.append("</td><td>");
                                if (line > 0) {
                                    sb.append(line);
                                } else {
                                    sb.append("&nbsp;");
                                }
                                sb.append("</td></tr>");
                            } else {
                                sb.append('\t');
                                sb.append('(');
                                if (filename != null) {
                                    sb.append(filename);
                                }
                                if (line > 0) {
                                    sb.append(':');
                                    sb.append(line);
                                }
                                sb.append(')');
                                sb.append("  ");
                                sb.append(methodName);
                            }
                            out.println(sb.toString());
                        }
                        if (html) {
                            out.println("</table></td><tr>");
                        }
                    }
                    if (html) continue;
                    out.println();
                }
                if (html) {
                    out.println("</table>");
                }
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            finally {
                wc.hide();
            }
            if (exceptionOccurred != null) {
                String message = DbgArb.format(772, URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)saveDialogTitle, (String)message, null);
            }
        }
    }

    private static String getThreadsHeader(boolean html) {
        StringBuffer sb = new StringBuffer();
        if (html) {
            sb.append("<tr>");
        }
        for (int x = 0; x < 5; ++x) {
            String columnName;
            String string = columnName = x == 0 ? DbgArb.getString(774) : ThreadsPanel.getDefaultColumnName(x);
            if (html) {
                sb.append("<th>");
                columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                sb.append(columnName);
                sb.append("</th>");
                continue;
            }
            if (x > 0) {
                sb.append(",  ");
            }
            sb.append(columnName);
        }
        if (html) {
            sb.append("</tr>");
        }
        return sb.toString();
    }

    private static String getStackHeader(boolean html) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        if (html) {
            sb.append("<tr><th colspan=3>");
            sb.append(DbgArb.getString(775));
            sb.append("</th></tr>");
            sb.append("<tr>");
        }
        int nColumns = 3;
        String[] columnNames = new String[]{DbgArb.getString(231), DbgArb.getString(233), DbgArb.getString(234)};
        for (int i = 0; i < 3; ++i) {
            String columnName = columnNames[i];
            if (html) {
                sb.append("<th>");
                columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                sb.append(columnName);
                sb.append("</th>");
                continue;
            }
            sb.append('\t');
            sb.append(columnName);
            sb2.append('\t');
            for (int ii = columnName.length(); ii >= 0; --ii) {
                sb2.append('-');
            }
        }
        if (html) {
            sb.append("</tr>");
        }
        if (!html) {
            sb.append(System.getProperty("line.separator"));
            sb.append(sb2.toString());
        }
        return sb.toString();
    }

    static String getThreadStatus(DebuggingProcess debuggingProcess, DebugThreadInfo info) {
        StringBuilder buf = new StringBuilder();
        if (debuggingProcess != null && debuggingProcess.isCurrentThread(info)) {
            buf.append(DbgArb.getString(849));
            buf.append(", ");
        }
        switch (info.getStatus()) {
            default: {
                buf.append(DbgArb.getString(197));
                break;
            }
            case 1: {
                buf.append(DbgArb.getString(198));
                break;
            }
            case 2: {
                buf.append(DbgArb.getString(199));
                break;
            }
            case 3: {
                buf.append(DbgArb.getString(200));
                break;
            }
            case 4: {
                buf.append(DbgArb.getString(201));
                break;
            }
            case 5: {
                buf.append(DbgArb.getString(202));
                break;
            }
            case 6: {
                buf.append(DbgArb.getString(203));
            }
        }
        return buf.toString();
    }

    static Icon getThreadStatusIcon(DebuggingProcess debuggingProcess, DebugThreadInfo info) {
        if (debuggingProcess != null && debuggingProcess.isCurrentThread(info)) {
            return ThreadsPanel.getCurrentThreadIcon();
        }
        switch (info.getStatus()) {
            default: {
                return OracleIcons.getIcon((String)"debugger/unknownthread.png");
            }
            case 1: {
                return OracleIcons.getIcon((String)"debugger/notstartedthread.png");
            }
            case 2: {
                return OracleIcons.getIcon((String)"debugger/blockedthread.png");
            }
            case 3: {
                return OracleIcons.getIcon((String)"debugger/waitingthread.png");
            }
            case 4: {
                return OracleIcons.getIcon((String)"debugger/waitingthread.png");
            }
            case 5: {
                return OracleIcons.getIcon((String)"debugger/runnablethread.png");
            }
            case 6: 
        }
        return OracleIcons.getIcon((String)"debugger/completedthread.png");
    }

    protected static boolean isDeadlocked(DebugThreadInfo threadInfo, DebuggingProcess debuggingProcess) {
        int length;
        DebugThreadInfo[][] deadlocks = debuggingProcess.getDeadlocks();
        int n = length = deadlocks == null ? 0 : deadlocks.length;
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                int jLength = deadlocks[i].length;
                for (int j = 0; j < jLength; ++j) {
                    DebugThreadInfo t = deadlocks[i][j];
                    if (!t.equals(threadInfo)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected static String[] getPriorityDaemon(DebugThreadInfo threadInfo) {
        String[] a = new String[2];
        DebugDataObjectInfo threadObject = threadInfo.getThreadObject();
        if (threadObject != null && !threadObject.isNull()) {
            DebugDataInfo data = DebugShared.findFieldData(threadObject, "priority", "int", "java.lang.Thread");
            if (data != null) {
                a[0] = data.getValue();
            }
            if ((data = DebugShared.findFieldData(threadObject, "daemon", "boolean", "java.lang.Thread")) != null) {
                a[1] = data.getValue();
            }
        }
        return a;
    }

    protected static String[] getMaxPriorityDaemon(DebugThreadGroupInfo groupInfo) {
        String[] a = new String[2];
        DebugDataObjectInfo threadGroupObject = groupInfo.getThreadGroupObject();
        if (threadGroupObject != null && !threadGroupObject.isNull()) {
            DebugDataInfo data = DebugShared.findFieldData(threadGroupObject, "maxPriority", "int", "java.lang.ThreadGroup");
            if (data != null) {
                a[0] = data.getValue();
            }
            if ((data = DebugShared.findFieldData(threadGroupObject, "daemon", "boolean", "java.lang.ThreadGroup")) != null) {
                a[1] = data.getValue();
            }
        }
        return a;
    }

    private static Icon getThreadGroupIcon() {
        if (threadGroupIcon == null) {
            threadGroupIcon = OracleIcons.getIcon((String)"debugger/threads.png");
        }
        return threadGroupIcon;
    }

    private static Icon getThreadIcon() {
        if (threadIcon == null) {
            threadIcon = OracleIcons.getIcon((String)"debugger/thread.gif");
        }
        return threadIcon;
    }

    private static Icon getThreadIconGray() {
        if (threadIconGray == null) {
            threadIconGray = IdeUtil.grayIcon((Icon)ThreadsPanel.getThreadIcon());
        }
        return threadIconGray;
    }

    private static Icon getCurrentThreadIcon() {
        if (currentThreadIcon == null) {
            currentThreadIcon = OracleIcons.getIcon((String)"debugger/currentthread.png");
        }
        return currentThreadIcon;
    }

    private static Icon getCurrentThreadIconGray() {
        if (currentThreadIconGray == null) {
            currentThreadIconGray = IdeUtil.grayIcon((Icon)ThreadsPanel.getCurrentThreadIcon());
        }
        return currentThreadIconGray;
    }

    protected final class ThreadInfoPath {
        private DebuggingProcess debuggingProcess;
        private Object info;

        ThreadInfoPath(DebuggingProcess debuggingProcess, Object info) {
            this.debuggingProcess = debuggingProcess;
            this.info = info;
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        Object getInfo() {
            return this.info;
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.info.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ThreadInfoPath) {
                ThreadInfoPath other = (ThreadInfoPath)o;
                if (this.debuggingProcess != other.debuggingProcess) {
                    return false;
                }
                if (this.info == null && other.info != null) {
                    return false;
                }
                if (this.info == null && other.info == null) {
                    return true;
                }
                return this.info.equals(other.info);
            }
            return false;
        }
    }

    protected final class ThreadItem
    extends BaseElement {
        private Object info;
        private String accessiblePrefix;
        private DebugThreadGroupInfo[] groups;
        private DebugThreadInfo[] threads;
        private DebugLocation location;
        private int status;
        private boolean deadlocked;
        private ThreadItem[] children;
        private Boolean cachedMayHaveChildren;
        private String cachedName;
        private String cachedGroup;
        private String cachedStatus;
        private String cachedPriority;
        private Boolean cachedDaemon;

        ThreadItem(Object info) {
            this.info = info;
            if (info instanceof DebugThreadGroupInfo) {
                DebugThreadGroupInfo group = (DebugThreadGroupInfo)info;
                this.groups = group.listGroups();
                Arrays.sort(this.groups, ThreadsPanel.this);
                this.threads = group.listThreads();
                Arrays.sort(this.threads, ThreadsPanel.this);
                this.accessiblePrefix = DbgArb.getString(190);
            } else {
                this.groups = new DebugThreadGroupInfo[0];
                this.threads = new DebugThreadInfo[0];
                this.accessiblePrefix = DbgArb.getString(189);
            }
            this.setStatusAndDeadlock();
            this.setIconAppropriately();
        }

        boolean isThreadGroup() {
            return this.info instanceof DebugThreadGroupInfo;
        }

        boolean isThread() {
            return this.info instanceof DebugThreadInfo;
        }

        String getAccessiblePrefix() {
            return this.accessiblePrefix;
        }

        private void setStatusAndDeadlock() {
            if (this.info instanceof DebugThreadInfo) {
                DebugThreadInfo threadInfo = (DebugThreadInfo)this.info;
                this.status = threadInfo.getStatus();
                this.deadlocked = this.status == 2 ? ThreadsPanel.isDeadlocked(threadInfo, ThreadsPanel.this.debuggingProcess) : false;
            }
        }

        private void setIconAppropriately() {
            if (this.info instanceof DebugThreadGroupInfo) {
                this.setIcon(ThreadsPanel.getThreadGroupIcon());
            } else if (this.info instanceof DebugThreadInfo) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                this.setIcon(ThreadsPanel.getThreadStatusIcon(ThreadsPanel.this.debuggingProcess, thread));
            }
        }

        private Font getFont(int column) {
            if (column == 0 ? ThreadsPanel.this.boldCurrentThreadName && this.info instanceof DebugThreadInfo && ThreadsPanel.this.debuggingProcess.isCurrentThread((DebugThreadInfo)this.info) : column == 1 && ThreadsPanel.this.boldDeadlockedThreadStatus && this.deadlocked) {
                return ThreadsPanel.this.getBoldFont();
            }
            return ThreadsPanel.this.getNormalFont();
        }

        void clearThread() {
            this.info = null;
            this.groups = null;
            this.threads = null;
            this.location = null;
        }

        Object getInfo() {
            return this.info;
        }

        ThreadInfoPath getThreadInfoPath() {
            return new ThreadInfoPath(ThreadsPanel.this.debuggingProcess, this.info);
        }

        DebugThreadGroupInfo getThreadGroupInfo() {
            if (this.info instanceof DebugThreadGroupInfo) {
                return (DebugThreadGroupInfo)this.info;
            }
            return null;
        }

        DebugThreadInfo getThreadInfo() {
            if (this.info instanceof DebugThreadInfo) {
                return (DebugThreadInfo)this.info;
            }
            return null;
        }

        public String getShortLabel() {
            return this.getName();
        }

        public Object getData() {
            return this;
        }

        public boolean mayHaveChildren() {
            if (this.cachedMayHaveChildren == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedMayHaveChildren = this.info instanceof DebugThreadGroupInfo ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.cachedMayHaveChildren != null) {
                return this.cachedMayHaveChildren;
            }
            return false;
        }

        public Iterator getChildren() {
            return Arrays.asList(this.getChildNodes()).iterator();
        }

        public String getName() {
            if (this.cachedName == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedName = this.info instanceof DebugThreadGroupInfo ? ((DebugThreadGroupInfo)this.info).getName() : (this.info instanceof DebugThreadInfo ? ((DebugThreadInfo)this.info).getName() : ThreadsPanel.NOT_AVAILABLE);
            }
            if (this.cachedName != null) {
                return this.cachedName;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getGroup() {
            if (this.cachedGroup == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedGroup = this.info instanceof DebugThreadInfo ? ((DebugThreadInfo)this.info).getGroupName() : ThreadsPanel.NOT_AVAILABLE;
            }
            if (this.cachedGroup != null) {
                return this.cachedGroup;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getStatus() {
            if ((this.cachedStatus == null || this.cachedStatus.contains(DbgArb.getString(849))) && ThreadsPanel.this.treeTable.isEnabled()) {
                if (this.info instanceof DebugThreadInfo) {
                    String s = ThreadsPanel.getThreadStatus(ThreadsPanel.this.debuggingProcess, (DebugThreadInfo)this.info);
                    if (((DebugThreadInfo)this.info).isThreadInterrupted()) {
                        s = s + ", " + DbgArb.getString(819);
                    }
                    if (((DebugThreadInfo)this.info).isThreadDebuggerStopped()) {
                        s = s + ", " + DbgArb.getString(822);
                    }
                    if (((DebugThreadInfo)this.info).isThreadSuspended()) {
                        s = s + ", " + DbgArb.getString(204);
                    }
                    if (this.deadlocked) {
                        s = s + ", " + DbgArb.getString(205);
                    }
                    this.cachedStatus = s;
                } else {
                    this.cachedStatus = ThreadsPanel.NOT_AVAILABLE;
                }
            }
            if (this.cachedStatus != null) {
                return this.cachedStatus;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getPriority() {
            if (this.cachedPriority == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.getPriorityAndDaemon();
            }
            if (this.cachedPriority != null) {
                return this.cachedPriority;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public Boolean getDaemon() {
            if (this.cachedDaemon == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.getPriorityAndDaemon();
            }
            if (this.cachedDaemon != null) {
                return this.cachedDaemon;
            }
            return Boolean.FALSE;
        }

        private void getPriorityAndDaemon() {
            this.cachedPriority = ThreadsPanel.NOT_AVAILABLE;
            this.cachedDaemon = Boolean.FALSE;
            if (this.info instanceof DebugThreadGroupInfo) {
                String[] a = ThreadsPanel.getMaxPriorityDaemon((DebugThreadGroupInfo)this.info);
                if (a[0] != null) {
                    this.cachedPriority = DbgArb.format(196, a[0]);
                }
                if (a[1] != null) {
                    this.cachedDaemon = a[1].equals("true") ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (this.info instanceof DebugThreadInfo) {
                String[] a = ThreadsPanel.getPriorityDaemon((DebugThreadInfo)this.info);
                if (a[0] != null) {
                    this.cachedPriority = a[0];
                }
                if (a[1] != null) {
                    this.cachedDaemon = a[1].equals("true") ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }

        int countChildNodes() {
            if (this.children != null) {
                return this.children.length;
            }
            if (this.groups != null && this.threads != null) {
                return this.groups.length + this.threads.length;
            }
            return 0;
        }

        ThreadItem[] getChildNodes() {
            if (this.children == null) {
                int i;
                int count = this.groups.length + this.threads.length;
                this.children = new ThreadItem[count];
                int ichild = 0;
                for (i = 0; i < this.groups.length; ++i) {
                    this.children[ichild++] = new ThreadItem(this.groups[i]);
                }
                for (i = 0; i < this.threads.length; ++i) {
                    this.children[ichild++] = new ThreadItem(this.threads[i]);
                }
            }
            return this.children;
        }

        DebugLocation getLocation() {
            if (this.location == null && this.info instanceof DebugThreadInfo) {
                this.location = DebuggingProcess.getNonNativeLocation((DebugThreadInfo)this.info);
            }
            return this.location;
        }

        boolean canShowInSource() {
            DebugLocation location = this.getLocation();
            return location != null;
        }

        void showInSource() {
            DebugLocation location = this.getLocation();
            if (location != null) {
                ThreadsPanel.this.debuggingProcess.showLocation(location, true);
            }
        }

        boolean canMakeCurrentThread() {
            DebugThreadInfo thread;
            return this.info instanceof DebugThreadInfo && !ThreadsPanel.this.debuggingProcess.isCurrentThread(thread = (DebugThreadInfo)this.info) && this.status != 6;
        }

        void makeCurrentThread() {
            if (this.info instanceof DebugThreadInfo) {
                ThreadsPanel.this.debuggingProcess.setCurrentThread((DebugThreadInfo)this.info);
                this.cachedStatus = null;
                ThreadsPanel.this.resetIcons();
                this.showInSource();
            }
        }

        boolean canSuspendThread() {
            DebugThreadInfo thread;
            return this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && !(thread = (DebugThreadInfo)this.info).isThreadSuspended();
        }

        void suspendThread() {
            DebugThreadInfo thread;
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && !(thread = (DebugThreadInfo)this.info).isThreadSuspended()) {
                thread.suspendThread();
                this.cachedStatus = null;
                ThreadsPanel.this.updateCell(ThreadsPanel.this.treeTable.getSelectedRow(), 1);
            }
        }

        boolean canResumeThread() {
            DebugThreadInfo thread;
            return this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && (thread = (DebugThreadInfo)this.info).isThreadSuspended();
        }

        void resumeThread() {
            DebugThreadInfo thread;
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && (thread = (DebugThreadInfo)this.info).isThreadSuspended()) {
                thread.resumeThread();
                this.cachedStatus = null;
                ThreadsPanel.this.updateCell(ThreadsPanel.this.treeTable.getSelectedRow(), 1);
            }
        }

        boolean canInterruptThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canInterruptThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                return thread == null || !thread.isThreadInterrupted() && (thread.getStatus() == 4 || thread.getStatus() == 3 || thread.getStatus() == 2);
            }
            return false;
        }

        boolean canDebuggerStopThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canDebuggerStopThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                return thread == null || thread.canDebuggerStopThread() && !thread.isThreadDebuggerStopped() && thread.getStatus() != 4 && thread.getStatus() != 3 && thread.getStatus() != 2;
            }
            return false;
        }

        void interruptThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canInterruptThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                if (thread != null && thread.isThreadInterrupted()) {
                    return;
                }
                thread.interruptThread();
                this.cachedStatus = null;
                ThreadsPanel.this.invalidatePane();
            }
        }

        void stopThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canDebuggerStopThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                if (!this.canDebuggerStopThread()) {
                    return;
                }
                thread.stopThread();
                this.cachedStatus = null;
                ThreadsPanel.this.invalidatePane();
            }
        }

        boolean canWatchInspectThread() {
            DebugThreadInfo thread;
            DebugDataObjectInfo threadObject;
            return this.info instanceof DebugThreadInfo && (threadObject = (thread = (DebugThreadInfo)this.info).getThreadObject()) != null && !threadObject.isNull() && threadObject.getFieldCount(-1, false, true) > 0;
        }

        void watchThread() {
            DebugThreadInfo thread;
            DebugDataObjectInfo threadObject;
            if (this.info instanceof DebugThreadInfo && (threadObject = (thread = (DebugThreadInfo)this.info).getThreadObject()) != null && !threadObject.isNull() && threadObject.getFieldCount(-1, false, true) > 0) {
                String name = DbgArb.format(225, Long.toString(CommonHelperFunctions.getObjectNumber(threadObject)));
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, threadObject);
                JDebugger.getInstance().addWatch(ei);
            }
        }

        void inspectThread() {
            DebugThreadInfo thread;
            DebugDataObjectInfo threadObject;
            if (this.info instanceof DebugThreadInfo && (threadObject = (thread = (DebugThreadInfo)this.info).getThreadObject()) != null && !threadObject.isNull() && threadObject.getFieldCount(-1, false, true) > 0) {
                String name = DbgArb.format(225, Long.toString(CommonHelperFunctions.getObjectNumber(threadObject)));
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, threadObject);
                JDebugger.getInstance().inspect(ei);
            }
        }

        boolean canWatchInspectClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugThreadInfo thread;
            DebugClassLoaderInfo classLoader;
            return this.info instanceof DebugThreadInfo && (classLoader = (thread = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull();
        }

        void watchClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugThreadInfo thread;
            DebugClassLoaderInfo classLoader;
            if (this.info instanceof DebugThreadInfo && (classLoader = (thread = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
                String name = ClassesWindow.makeClassLoaderName(classLoader);
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
                JDebugger.getInstance().addWatch(ei);
            }
        }

        void inspectClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugThreadInfo thread;
            DebugClassLoaderInfo classLoader;
            if (this.info instanceof DebugThreadInfo && (classLoader = (thread = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null) {
                String name = ClassesWindow.makeClassLoaderName(classLoader);
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
                JDebugger.getInstance().inspect(ei);
            }
        }
    }

    final class ThreadTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List expanded;
        private ThreadsPanelSettings threadsPanelSettings;

        ThreadTreeTableModel(List root) {
            super((Object)root);
            this.root = root;
            this.expanded = Collections.synchronizedList(new ArrayList());
        }

        void setThreadsPanelSettings(ThreadsPanelSettings settings) {
            this.threadsPanelSettings = settings;
        }

        void updateThreads(ThreadInfoPath highlight) {
            ThreadsPanel.this.treeTable.getSelectionModel().clearSelection();
            ThreadsPanel.this.treeTable.setEnabled(true);
            this.root.clear();
            if (ThreadsPanel.this.treeTable.isShowing()) {
                ThreadsPanel.this.skippedUpdate = false;
                if (ThreadsPanel.this.debuggingProcess != null && ThreadsPanel.this.vm != null) {
                    ThreadsPanel.this.addThreadItems();
                }
            } else {
                ThreadsPanel.this.skippedUpdate = true;
            }
            this.fireChanged(new TreePath(this.root));
            this.restoreExpanded();
            this.restoreHighlight(highlight);
        }

        private void fireChanged(TreePath path) {
            this.fireTreeStructureChanged((Object)this, path.getPath(), null, null);
        }

        void clearThreads() {
            this.clearAll();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            for (int i = this.expanded.size() - 1; i >= 0; --i) {
                ThreadInfoPath threadInfoPath = (ThreadInfoPath)this.expanded.get(i);
                if (threadInfoPath.getDebuggingProcess() != debuggingProcess) continue;
                this.expanded.remove(i);
            }
        }

        private void clearAll() {
            this.clearAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ((ThreadItem)((Object)node)).clearThread();
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                if (child == null) continue;
                this.clearAll(tree, treePath.pathByAddingChild(child));
            }
        }

        private void restoreExpanded() {
            int length = this.expanded.size();
            if (length == 0) {
                this.expandAll();
            } else {
                ThreadInfoPath[] ex = this.expanded.toArray(new ThreadInfoPath[length]);
                for (int i = 0; i < length; ++i) {
                    this.expandBranch(ex[i]);
                }
            }
        }

        private void restoreHighlight(ThreadInfoPath highlight) {
            if (highlight != null) {
                TreePath treePath = this.makeVisible(highlight);
                JDebugger.getInstance().selectTreeTablePath(ThreadsPanel.this.treeTable, treePath, false);
            }
        }

        private TreePath expandBranch(ThreadInfoPath threadInfoPath) {
            return this.expandBranch(new TreePath(this.root), threadInfoPath);
        }

        private TreePath expandBranch(TreePath treePath, ThreadInfoPath threadInfoPath) {
            JTree tree = ThreadsPanel.this.treeTable.getTree();
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)((Object)node);
                if (threadInfoPath.getInfo().equals(threadItem.getInfo())) {
                    tree.expandPath(treePath);
                    return treePath;
                }
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                TreePath result = this.expandBranch(treePath.pathByAddingChild(child), threadInfoPath);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        TreePath makeVisible(ThreadInfoPath threadInfoPath) {
            return this.makeVisible(new TreePath(this.root), threadInfoPath);
        }

        private TreePath makeVisible(TreePath treePath, ThreadInfoPath threadInfoPath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)((Object)node);
                if (threadInfoPath.getInfo().equals(threadItem.getInfo())) {
                    ThreadsPanel.this.treeTable.getTree().makeVisible(treePath);
                    return treePath;
                }
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                TreePath result = this.makeVisible(treePath.pathByAddingChild(child), threadInfoPath);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        void branchExpanded(TreePath treePath) {
            ThreadInfoPath threadInfoPath = this.convertTreePathToThreadInfoPath(treePath);
            if (threadInfoPath != null) {
                int i = this.expanded.indexOf(threadInfoPath);
                if (i != -1) {
                    this.expanded.remove(i);
                }
                this.expanded.add(0, threadInfoPath);
            }
        }

        void branchCollapsed(TreePath treePath) {
            ThreadInfoPath threadInfoPath = this.convertTreePathToThreadInfoPath(treePath);
            if (threadInfoPath != null) {
                this.expanded.remove(threadInfoPath);
            }
        }

        ThreadInfoPath getCurrentHighlight() {
            TreePath treePath;
            if (ThreadsPanel.this.treeTable != null && (treePath = ThreadsPanel.this.treeTable.getTree().getSelectionPath()) != null) {
                return this.convertTreePathToThreadInfoPath(treePath);
            }
            return null;
        }

        ThreadInfoPath convertTreePathToThreadInfoPath(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)((Object)node);
                return threadItem.getThreadInfoPath();
            }
            return null;
        }

        private void resetIcons() {
            this.resetIcons(new TreePath(this.root));
            ThreadsPanel.this.treeTable.repaint(ThreadsPanel.this.treeTable.getVisibleRect());
        }

        private void resetIcons(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ((ThreadItem)((Object)node)).setIconAppropriately();
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                this.resetIcons(treePath.pathByAddingChild(child));
            }
        }

        void expandAll() {
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            try {
                this.expandAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
            }
            finally {
                wc.hide();
            }
        }

        private void expandAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            tree.expandPath(treePath);
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                this.expandAll(tree, treePath.pathByAddingChild(child));
            }
        }

        void collapseAll() {
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            try {
                this.collapseAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
            }
            finally {
                wc.hide();
            }
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                this.collapseAll(tree, treePath.pathByAddingChild(child));
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root), out, html, ThreadsPanel.NOT_AVAILABLE);
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = ThreadsPanel.this.treeTable.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                for (int ii = columnName.length(); ii >= 0; --ii) {
                    sb2.append('-');
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof ThreadItem) {
                    ThreadItem threadItem = (ThreadItem)((Object)node);
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = ThreadsPanel.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = this.getValueAt(node, i);
                        if (columnValue instanceof Boolean) {
                            columnValue = (Boolean)columnValue != false ? "true" : "false";
                        }
                        if (html) {
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (threadItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (threadItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                int count = this.getChildCount(node);
                for (int i = 0; i < count; ++i) {
                    Object child = this.getChild(node, i);
                    this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node instanceof List) {
                    return false;
                }
                ThreadItem threadItem = (ThreadItem)((Object)node);
                return !threadItem.mayHaveChildren();
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent instanceof List) {
                    return ((List)parent).get(index);
                }
                ThreadItem threadItem = (ThreadItem)((Object)parent);
                return threadItem.getChildNodes()[index];
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent instanceof List) {
                    return ((List)parent).size();
                }
                ThreadItem threadItem = (ThreadItem)((Object)parent);
                return threadItem.countChildNodes();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            if (ThreadsPanel.this.debuggingProcess != null && ThreadsPanel.this.debuggingProcess.getVM() != null && this.threadsPanelSettings != null) {
                DebugVirtualMachine vm = ThreadsPanel.this.debuggingProcess.getVM();
                return this.threadsPanelSettings.getColumnNames(vm.getID()).get(column);
            }
            return ThreadsPanel.getDefaultColumnName(column);
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            if (column == 4) {
                return Boolean.class;
            }
            return String.class;
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node instanceof List) {
                    switch (column) {
                        case 0: {
                            return "root";
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            return ThreadsPanel.NOT_AVAILABLE;
                        }
                        case 4: {
                            return Boolean.FALSE;
                        }
                    }
                    return null;
                }
                ThreadItem threadItem = (ThreadItem)((Object)node);
                switch (column) {
                    case 0: {
                        return threadItem.getName();
                    }
                    case 1: {
                        return threadItem.getStatus();
                    }
                    case 2: {
                        return threadItem.getGroup();
                    }
                    case 3: {
                        return threadItem.getPriority();
                    }
                    case 4: {
                        return threadItem.getDaemon();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(ThreadItem threadItem, int column) {
            int id;
            if (threadItem.isThread()) {
                id = 189;
            } else if (threadItem.isThreadGroup()) {
                id = 190;
            } else {
                return null;
            }
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt((Object)threadItem, column);
            if (value.length() == 0) {
                value = DbgArb.getString(797);
            }
            return DbgArb.format(id, columnName, value);
        }
    }
}

