/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.position;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomRange {
    private final DomPosition _startPos;
    private final DomPosition _endPos;

    public static DomRange create(DomPosition startPos, DomPosition endPos, TreeTraversal traversal) {
        if (startPos == null) {
            throw new IllegalArgumentException("null start position");
        }
        if (endPos == null) {
            throw new IllegalArgumentException("null end position");
        }
        if (traversal == null) {
            throw new IllegalArgumentException("null traversal");
        }
        int comparison = startPos.compare(traversal, endPos);
        if (comparison > 0) {
            DomPosition temp = startPos;
            startPos = endPos;
            endPos = temp;
        }
        return new DomRange(startPos, endPos);
    }

    public DomPosition getStart() {
        return this._startPos;
    }

    public DomPosition getEnd() {
        return this._endPos;
    }

    public boolean isEmptyRange() {
        return this.getStart().equals(this.getEnd());
    }

    public boolean isInsideAttributeValue() {
        boolean is = this.getStart().hasAttributeQName();
        assert (this.getEnd().hasAttributeQName() == is);
        return is;
    }

    public int compareTo(TreeTraversal traversal, DomPosition position, boolean endpointsInclusive) {
        if (position == null) {
            throw new IllegalArgumentException("null position");
        }
        if (traversal == null) {
            throw new IllegalArgumentException("null traversal");
        }
        int compareStart = position.compare(traversal, this._startPos);
        if (compareStart < 0 || compareStart == 0 && !endpointsInclusive) {
            return -1;
        }
        int compareEnd = position.compare(traversal, this._endPos);
        if (compareEnd < 0 || compareEnd == 0 && endpointsInclusive) {
            return 0;
        }
        return 1;
    }

    public DomRange getExtendedRange(TreeTraversal traversal, DomPosition position) {
        int compareStart = this._startPos.compare(traversal, position);
        if (compareStart < 0) {
            return new DomRange(position, this._endPos);
        }
        if (compareStart == 0) {
            return this;
        }
        int compareEnd = this._endPos.compare(traversal, position);
        if (compareEnd < 0) {
            throw new IllegalArgumentException("position " + position + " is inside this already! this=" + this);
        }
        if (compareEnd == 0) {
            return this;
        }
        return new DomRange(this._startPos, position);
    }

    public DomRange getRangeWithNewStart(TreeTraversal traversal, DomPosition newStart) {
        if (newStart == null) {
            throw new IllegalStateException("null newStart");
        }
        if (this.getStart().equals(newStart)) {
            return this;
        }
        if (newStart.compare(traversal, this.getEnd()) > 0) {
            throw new IllegalStateException("new start is after end");
        }
        return new DomRange(newStart, this.getEnd());
    }

    public DomRange getRangeWithNewEnd(TreeTraversal traversal, DomPosition newEnd) {
        if (newEnd == null) {
            throw new IllegalStateException("null newEnd");
        }
        if (this.getEnd().equals(newEnd)) {
            return this;
        }
        if (newEnd.compare(traversal, this.getStart()) < 0) {
            throw new IllegalStateException("new end is before start");
        }
        return new DomRange(this.getStart(), newEnd);
    }

    public List<Node> getNodesInRange(TreeTraversal traversal) {
        DomPosition start = this.getStart();
        DomPosition end = this.getEnd();
        Node startNode = start.getTargetNode();
        Node endNode = end.getTargetNode();
        if (start.equals(end) && start.isAfter()) {
            return Collections.singletonList(startNode);
        }
        LinkedList<Node> list = new LinkedList<Node>();
        Node walk = startNode;
        do {
            if (!this.isInRange(traversal, walk)) continue;
            list.add(walk);
        } while ((walk = traversal.getNextNode(walk)) != null && walk != endNode);
        if (walk == endNode && !end.isBefore()) {
            do {
                if (!this.isInRange(traversal, walk)) continue;
                list.add(walk);
            } while ((walk = traversal.getNextNode(walk)) != null && DomUtils.isNodeOrDescendant(traversal, walk, endNode));
        }
        return list;
    }

    public Collection<Node> getNodesEntirelyInRange(TreeTraversal traversal) {
        Node endNode;
        Node target;
        DomPosition start = this.getStart();
        DomPosition end = this.getEnd();
        if (start.hasTextOffset() || end.hasTextOffset()) {
            throw new IllegalArgumentException("range start or end has text offset");
        }
        if (start.isInside()) {
            start = start.getAfterPosition();
        }
        if (end.isInside()) {
            Node targetNode = end.getTargetNode();
            Node lastChild = traversal.getLastChild(targetNode);
            end = lastChild != null ? DomPositionFactory.after(lastChild) : DomPositionFactory.before(targetNode);
        }
        if (start.isAfter()) {
            target = start.getTargetNode();
            Node next = traversal.getNextNode(target);
            start = next == null ? null : DomPositionFactory.before(next);
        }
        if (end.isBefore()) {
            target = end.getTargetNode();
            Node previous = traversal.getPreviousNode(target);
            end = previous == null ? null : DomPositionFactory.after(previous);
        }
        if (start == null || end == null || start.compare(traversal, end) >= 0) {
            return Collections.emptyList();
        }
        Node startNode = start.getTargetNode();
        if (startNode == (endNode = end.getTargetNode())) {
            return Collections.singletonList(startNode);
        }
        LinkedHashSet<Node> ret = new LinkedHashSet<Node>();
        Set<Node> startAncestors = DomUtils.getAncestorSet(traversal, startNode);
        Set<Node> endAncestors = DomUtils.getAncestorSet(traversal, endNode);
        if (!endAncestors.contains(startNode)) {
            ret.add(startNode);
        }
        if (!startAncestors.contains(endNode)) {
            ret.add(endNode);
        }
        this._addSiblingsUpward(ret, traversal, startNode, endAncestors, false);
        this._addSiblingsUpward(ret, traversal, endNode, startAncestors, true);
        return ret;
    }

    private void _addSiblingsUpward(Collection<Node> out, TreeTraversal traversal, Node node, Set stopAtNodes, boolean previous) {
        while (node != null && !stopAtNodes.contains(node)) {
            Node walk = traversal.getSibling(node, previous);
            while (walk != null && !stopAtNodes.contains(walk)) {
                out.add(walk);
                walk = traversal.getSibling(walk, previous);
            }
            node = traversal.getParentNode(node);
        }
    }

    public boolean isInRange(TreeTraversal traversal, Node node) {
        if (this.isInsideAttributeValue()) {
            return this.getStart().getTargetNode() == node;
        }
        if (DomUtils.getOwnerDocument(node) != DomUtils.getOwnerDocument(this.getStart().getTargetNode())) {
            return false;
        }
        if (node.getNodeType() == 9) {
            return node == this.getStart().getTargetNode() || node == this.getEnd().getTargetNode();
        }
        DomPosition afterNode = DomPositionFactory.after(node);
        DomPosition beforeNode = afterNode.getBeforePosition();
        if (beforeNode.compare(traversal, this.getEnd()) > 0) {
            return false;
        }
        return afterNode.compare(traversal, this.getStart()) > 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DomRange) {
            DomRange other = (DomRange)o;
            return this.getStart().equals(other.getStart()) && this.getEnd().equals(other.getEnd());
        }
        return false;
    }

    public int hashCode() {
        return this._startPos.hashCode() ^ this._endPos.hashCode();
    }

    public String toString() {
        return "DomRange[" + this.getStart() + " - " + this.getEnd() + "]";
    }

    private DomRange(DomPosition startPos, DomPosition endPos) {
        this._startPos = startPos;
        this._endPos = endPos;
    }
}

