/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.traversal;

import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import org.w3c.dom.Node;

public abstract class FilteredTreeTraversal
extends TreeTraversal {
    public Node getParentNode(Node node) {
        TreeTraversal beforeTraversal = this.getBeforeTraversal();
        Node currNode = node;
        while (currNode != null) {
            Node parentNode = beforeTraversal.getParentNode(currNode);
            if (parentNode != null && 1 == this.acceptNode(parentNode)) {
                return parentNode;
            }
            currNode = parentNode;
        }
        return null;
    }

    public Node getFirstChild(Node node) {
        TreeTraversal beforeTraversal;
        Node firstChild;
        if (node != null && (firstChild = (beforeTraversal = this.getBeforeTraversal()).getFirstChild(node)) != null) {
            Node currChild = firstChild;
            do {
                Node unfilteredChild;
                short filterState;
                if ((filterState = this.acceptNode(currChild)) == 1) {
                    return currChild;
                }
                if (filterState != 3 || (unfilteredChild = this.getFirstChild(currChild)) == null) continue;
                return unfilteredChild;
            } while ((currChild = beforeTraversal.getNextSibling(currChild)) != null);
        }
        return null;
    }

    public Node getLastChild(Node node) {
        TreeTraversal beforeTraversal;
        Node lastChild;
        if (node != null && (lastChild = (beforeTraversal = this.getBeforeTraversal()).getLastChild(node)) != null) {
            Node currChild = lastChild;
            do {
                Node unfilteredChild;
                short filterState;
                if ((filterState = this.acceptNode(currChild)) == 1) {
                    return currChild;
                }
                if (filterState != 3 || (unfilteredChild = this.getLastChild(currChild)) == null) continue;
                return unfilteredChild;
            } while ((currChild = beforeTraversal.getPreviousSibling(currChild)) != null);
        }
        return null;
    }

    public Node getNextSibling(Node node) {
        Node parentNode;
        TreeTraversal beforeTraversal = this.getBeforeTraversal();
        Node nextSibling = beforeTraversal.getNextSibling(node);
        if (nextSibling != null) {
            nextSibling = this._nextSibling(nextSibling);
        }
        if (nextSibling == null && (parentNode = beforeTraversal.getParentNode(node)) != null && 3 == this.acceptNode(parentNode)) {
            nextSibling = this.getNextSibling(parentNode);
        }
        return nextSibling;
    }

    public Node getPreviousSibling(Node node) {
        Node parentNode;
        TreeTraversal beforeTraversal = this.getBeforeTraversal();
        Node previousSibling = beforeTraversal.getPreviousSibling(node);
        if (previousSibling != null) {
            return this._previousSibling(previousSibling);
        }
        if (previousSibling == null && (parentNode = beforeTraversal.getParentNode(node)) != null && 3 == this.acceptNode(parentNode)) {
            previousSibling = this.getPreviousSibling(parentNode);
        }
        return previousSibling;
    }

    protected abstract short acceptNode(Node var1);

    protected TreeTraversal getBeforeTraversal() {
        return DocumentTreeTraversal.INSTANCE;
    }

    private Node _previousSibling(Node node) {
        if (node != null) {
            Node currSibling = node;
            TreeTraversal beforeTraversal = this.getBeforeTraversal();
            do {
                Node unfilteredChild;
                short filterState;
                if ((filterState = this.acceptNode(currSibling)) == 1) {
                    return currSibling;
                }
                if (filterState != 3 || (unfilteredChild = this._previousSibling(this.getLastChild(currSibling))) == null) continue;
                return unfilteredChild;
            } while ((currSibling = beforeTraversal.getPreviousSibling(currSibling)) != null);
        }
        return null;
    }

    private Node _nextSibling(Node node) {
        if (node != null) {
            Node currSibling = node;
            TreeTraversal beforeTraversal = this.getBeforeTraversal();
            do {
                Node unfilteredChild;
                short filterState;
                if ((filterState = this.acceptNode(currSibling)) == 1) {
                    return currSibling;
                }
                if (filterState != 3 || (unfilteredChild = this._nextSibling(this.getFirstChild(currSibling))) == null) continue;
                return unfilteredChild;
            } while ((currSibling = beforeTraversal.getNextSibling(currSibling)) != null);
        }
        return null;
    }
}

