/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.metadata.el.ELException;

final class Lookups {
    private static ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, PropertyDescriptor>> _sPropInfoMap = new ConcurrentHashMap();

    public static final Object lookupArray(Object array, int index) throws ELException {
        try {
            return Array.get(array, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final Object lookupList(List list, int index) throws ELException {
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final Object lookupMap(Map map, Object key) throws ELException {
        return map.get(key);
    }

    public static final Object lookupBean(Class beanClass, Object bean, String property) throws ELException {
        Method reader = null;
        try {
            PropertyDescriptor pd = Lookups._getPropertyDescriptor(beanClass, property);
            reader = pd.getReadMethod();
            if (reader != null) {
                return reader.invoke(bean, null);
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        if (reader == null) {
            throw new ELException(property + " is not readable");
        }
        return null;
    }

    public static final void updateArray(Object array, int index, Object value) throws ELException {
        try {
            Array.set(array, index, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ELException(e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final void updateList(List list, int index, Object value) throws ELException {
        try {
            list.set(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ELException(e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final void updateMap(Map map, Object key, Object value) throws ELException {
        map.put(key, value);
    }

    public static final void updateBean(Class beanClass, Object bean, String property, Object value) throws ELException {
        Method writer;
        block6: {
            writer = null;
            try {
                PropertyDescriptor pd = Lookups._getPropertyDescriptor(beanClass, property);
                writer = pd.getWriteMethod();
                if (writer == null) break block6;
                try {
                    writer.invoke(bean, value);
                }
                catch (Exception e) {
                    throw new ELException("Error setting value " + value + " on property " + pd.getName() + " of " + bean, e);
                }
            }
            catch (Exception e) {
                if (e instanceof ELException) {
                    throw (ELException)e;
                }
                throw new ELException(e);
            }
        }
        if (writer == null) {
            throw new ELException(property + " is not writable");
        }
    }

    public static final boolean isBeanReadOnly(Class beanClass, Object bean, String property) throws ELException {
        try {
            PropertyDescriptor pd = Lookups._getPropertyDescriptor(beanClass, property);
            Method writer = pd.getWriteMethod();
            return writer == null;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final Class getBeanType(Class beanClass, Object bean, String property) throws ELException {
        try {
            PropertyDescriptor pd = Lookups._getPropertyDescriptor(beanClass, property);
            Method reader = pd.getReadMethod();
            if (reader != null) {
                return reader.getReturnType();
            }
            Method writer = pd.getWriteMethod();
            if (writer != null) {
                return writer.getParameterTypes()[0];
            }
            throw new ELException("No writers or readers for property \"" + property + "\"");
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    private static PropertyDescriptor _getPropertyDescriptor(Class beanClass, String property) throws IntrospectionException {
        PropertyDescriptor cachedPropDescriptor;
        ConcurrentHashMap newBeanMap;
        ConcurrentHashMap<String, PropertyDescriptor> cachedBeanMap = _sPropInfoMap.get(beanClass);
        if (cachedBeanMap == null && (cachedBeanMap = _sPropInfoMap.putIfAbsent(beanClass, newBeanMap = new ConcurrentHashMap())) == null) {
            cachedBeanMap = newBeanMap;
        }
        if ((cachedPropDescriptor = cachedBeanMap.get(property)) == null) {
            PropertyDescriptor newPropDescriptor = null;
            try {
                newPropDescriptor = new PropertyDescriptor(property, beanClass);
            }
            catch (IntrospectionException e) {
                try {
                    String readMethodName = "is" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
                    newPropDescriptor = new PropertyDescriptor(property, beanClass, readMethodName, null);
                }
                catch (IntrospectionException ex) {
                    newPropDescriptor = new PropertyDescriptor(property, beanClass, null, null);
                }
            }
            cachedPropDescriptor = cachedBeanMap.putIfAbsent(property, newPropDescriptor);
            if (cachedPropDescriptor == null) {
                cachedPropDescriptor = newPropDescriptor;
            }
        }
        return cachedPropDescriptor;
    }

    private Lookups() {
    }
}

