/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.Wildcard;

class WildcardContent
implements Wildcard {
    private final String _targetNamesapce;
    private final int _variety;
    private final int _processingRule;
    private final List _nsConstraintList;
    private final Pattern _namePattern;

    public WildcardContent(String targetNamesapce) {
        this(targetNamesapce, 0);
    }

    public WildcardContent(String targetNamesapce, int variety) {
        this(targetNamesapce, variety, Collections.EMPTY_LIST, 0);
    }

    public WildcardContent(String targetNamesapce, int variety, List nsConstraintList, int processingRule) {
        this(targetNamesapce, variety, nsConstraintList, processingRule, null);
    }

    public WildcardContent(String targetNamesapce, int variety, List nsConstraintList, int processingRule, Pattern namePattern) {
        this._targetNamesapce = targetNamesapce;
        this._variety = variety;
        this._nsConstraintList = nsConstraintList;
        this._processingRule = processingRule;
        this._namePattern = namePattern;
    }

    public Annotation getAnnotation() {
        return null;
    }

    public String getTargetNamespace() {
        return this._targetNamesapce;
    }

    public String getName() {
        switch (this.getVariety()) {
            case 0: {
                return "ANY";
            }
            case 1: {
                return "OTHER";
            }
            case 2: {
                return "(...)";
            }
        }
        return "*";
    }

    public int getMinOccurs() {
        return 0;
    }

    public int getMaxOccurs() {
        return -1;
    }

    public int getVariety() {
        return this._variety;
    }

    public List getNamespaceConstraintList() {
        return this._nsConstraintList;
    }

    public Pattern getNamePattern() {
        return this._namePattern;
    }

    public int getProcessingRule() {
        return this._processingRule;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getName());
        if (this.getMinOccurs() == 0) {
            if (this.getMaxOccurs() == 1) {
                buffer.append("?");
            } else {
                buffer.append("*");
            }
        } else if (this.getMinOccurs() == 1 && this.getMaxOccurs() == -1) {
            buffer.append("+");
        }
        return buffer.toString();
    }
}

