/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bm.browse.ElementPicker;
import oracle.bm.browse.res.ModelBrowserResources;
import oracle.bm.util.ui.HintLabel;
import oracle.ide.help.HelpSystem;

public class ModelBrowser {
    private static final ResourceBundle DEFAULT_RESOURCES = ModelBrowserResources.getBundle();
    private static final int TREE_HEIGHT = 200;
    private ElementPicker m_elementPicker;
    private JEWTDialog m_dialog;

    public ModelBrowser(Component parent, TreeModel model, boolean canMultiSelect, boolean canCreate, ResourceBundle bundle, String nlsKey, String helpTopicId) {
        this(parent, model, canMultiSelect, canCreate, bundle, nlsKey);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_dialog.getContent(), helpTopicId);
    }

    public ModelBrowser(Component parent, TreeModel model, boolean canMultiSelect, boolean canCreate, ResourceBundle bundle, String nlsKey) {
        StringBuffer sb = new StringBuffer(nlsKey).append('.');
        int length = sb.length();
        String titleKey = sb.append("dialogtitle").toString();
        sb.setLength(length);
        String hintKey = sb.append("hinttext").toString();
        sb.setLength(length);
        String helpKey = sb.append("helptag").toString();
        int BUTTON_ALL = 7;
        ResourceBundle resources = bundle == null ? DEFAULT_RESOURCES : bundle;
        String title = resources.getString(titleKey);
        while (parent != null) {
            if (parent instanceof Dialog) {
                this.m_dialog = new JEWTDialog((Dialog)parent, title, BUTTON_ALL);
                break;
            }
            if (parent instanceof Frame) {
                this.m_dialog = new JEWTDialog((Frame)parent, title, BUTTON_ALL);
                break;
            }
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (this.m_dialog == null) {
            throw new IllegalArgumentException("Component should have a dialog or frame as a parent");
        }
        this.m_dialog.setName(title);
        this.m_dialog.setResizable(true);
        this.m_elementPicker = new ElementPicker(model, canMultiSelect, canCreate);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModelBrowser.this.m_dialog.setOKButtonEnabled(ModelBrowser.this.m_elementPicker.isItemSelected());
            }
        };
        this.m_elementPicker.addPropertyChangeListener(pcl);
        pcl.propertyChange(null);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        HintLabel hintLabel = new HintLabel(resources.getString(hintKey));
        hintLabel.setBorder(new EmptyBorder(0, 0, 15, 0));
        panel.add((Component)hintLabel, "North");
        JComponent comp = (JComponent)this.m_elementPicker.getComponent();
        comp.setPreferredSize(new Dimension(0, 225));
        panel.add((Component)comp, "Center");
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, resources.getString(helpKey));
        this.m_dialog.setContent((Component)panel);
        this.m_dialog.setPreferredSize(380, 360);
    }

    public boolean show() {
        try {
            boolean bl = this.m_dialog.runDialog();
            return bl;
        }
        finally {
            this.m_dialog.dispose();
        }
    }

    public Transferable[] getSelection() {
        return this.m_elementPicker.getSelectedItems();
    }

    public Object[] getDefaultSelection() {
        Transferable[] transferables = this.getSelection();
        ArrayList<Object> items = new ArrayList<Object>(transferables.length);
        for (Transferable transferable : transferables) {
            try {
                DataFlavor[] flavors = transferable.getTransferDataFlavors();
                if (flavors == null || flavors.length <= 0) continue;
                items.add(transferable.getTransferData(flavors[0]));
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return items.toArray();
    }

    public Object[] getSelection(DataFlavor flavor) {
        Transferable[] selection = this.getSelection();
        ArrayList<Object> items = new ArrayList<Object>(selection.length);
        for (int i = selection.length - 1; i >= 0; --i) {
            try {
                Object item;
                if (!selection[i].isDataFlavorSupported(flavor) || (item = selection[i].getTransferData(flavor)) == null) continue;
                items.add(item);
                continue;
            }
            catch (IOException io) {
                io.printStackTrace();
                continue;
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
            }
        }
        return items.toArray((Object[])Array.newInstance(flavor.getRepresentationClass(), items.size()));
    }
}

