/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;
import oracle.bm.util.ui.table.CellUtils;

public class BooleanEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private final JToggleButton m_button;

    public BooleanEditor(int type) {
        this(BooleanEditor.createButton(type));
    }

    public BooleanEditor(JToggleButton button) {
        if (button == null) {
            throw new IllegalArgumentException("Missing button for editor");
        }
        this.m_button = button;
        this.m_button.addActionListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_button.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        CellUtils.setUpRenderer(this.m_button, table, isSelected, true, true);
        this.setValue(this.m_button, value);
        return this.m_button;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.m_button.hasFocus()) {
            this.m_button.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    BooleanEditor.this.m_button.removeFocusListener(this);
                    BooleanEditor.this.stopCellEditing();
                }
            });
        } else {
            this.stopCellEditing();
        }
    }

    protected void setValue(Component component, Object value) {
        ((JToggleButton)component).setSelected(value != null && (Boolean)value != false);
    }

    private static JToggleButton createButton(int type) {
        switch (type) {
            case 0: {
                return CellUtils.initCheckBox(new JCheckBox());
            }
            case 1: {
                return CellUtils.initRadioButton(new JRadioButton());
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }
}

