/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;

public class BreadcrumbsPlugin
implements EditorPlugin {
    protected JBreadcrumbs breadcrumbs;
    protected BasicEditorPane editor;
    public static final String BREADCRUMB_PLUGIN_PROPERTY = "BREADCRUMB_PLUGIN_PROPERTY";
    private StructureChangeListener breadcrumbsChangeListener;

    protected JBreadcrumbs createBreadcrumbs() {
        return new JBreadcrumbs();
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.putProperty(BREADCRUMB_PLUGIN_PROPERTY, (Object)this);
        Preferences preferences = Preferences.getPreferences();
        DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)preferences);
        if (this.breadcrumbsChangeListener != null) {
            displayOptions.removeStructureChangeListener(this.breadcrumbsChangeListener);
        }
        this.breadcrumbs = this.createBreadcrumbs();
        CodeEditor.getCodeEditor(editor).setFixedBottomMarginComponent((JComponent)this.breadcrumbs);
        this.breadcrumbs.setVisible(DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs());
        this.breadcrumbsChangeListener = new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent e) {
                if (BreadcrumbsPlugin.this.breadcrumbs != null) {
                    Preferences preferences = Preferences.getPreferences();
                    BreadcrumbsPlugin.this.breadcrumbs.setVisible(DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs());
                }
            }
        };
        displayOptions.addStructureChangeListener(this.breadcrumbsChangeListener);
    }

    public void deinstall(BasicEditorPane editor) {
        if (this.breadcrumbsChangeListener != null) {
            Preferences preferences = Preferences.getPreferences();
            DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)preferences);
            displayOptions.removeStructureChangeListener(this.breadcrumbsChangeListener);
            editor.putProperty(BREADCRUMB_PLUGIN_PROPERTY, null);
            this.breadcrumbsChangeListener = null;
        }
        editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

