/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ceditor.options.CaretOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.JLabelListCellRenderer;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class CaretOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener,
ItemListener {
    private JCheckBox checkbox_enableBlink;
    private JSlider slider_blinkRate;
    private JLabel label_blinkRateText;
    private JLabel label_insertShape;
    private JComboBox combobox_insertShape;
    private JLabel label_overwriteShape;
    private JComboBox combobox_overwriteShape;
    private CustomColorChoice colorchoice_caretColor;
    private Map textToShapeMap;
    private Map shapeToTextMap;
    private NumberFormat numberFormatter;

    public CaretOptionsPanel() {
        this.setHelpID("f1_idedidesetcaretbehavior_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        CaretOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        CaretOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private CaretOptions findOptions(TraversableContext tc) {
        CaretOptions options = CaretOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        CaretOptions options = this.findOptions(tc);
        CaretOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(CaretOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean enableBlink = options.getEnableBlink();
        properties.putBooleanProperty("caret-enable-blink", enableBlink);
        int blinkRate = options.getBlinkRate();
        properties.putIntegerProperty("caret-blink-rate", blinkRate);
        int insertShape = options.getInsertShape();
        properties.putIntegerProperty("caret-shape-insert", insertShape);
        int overwriteShape = options.getOverwriteShape();
        properties.putIntegerProperty("caret-shape-overwrite", overwriteShape);
        int caretColor = options.getCaretColor();
        Color color = new Color(caretColor);
        properties.putProperty("caret-color", (Object)color);
        boolean rightClickSection = options.getRightClickSelection();
        properties.putBooleanProperty("caret-right-click-selection", rightClickSection);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        float value = (float)this.slider_blinkRate.getValue() / 10.0f;
        String valueStr = OptionsArb.format(116, this.numberFormatter.format(value));
        this.slider_blinkRate.setToolTipText(valueStr);
        this.label_blinkRateText.setText(valueStr);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        Object item = event.getItem();
        int selected = event.getStateChange();
        if (source == this.combobox_insertShape ? selected == 1 : source != this.combobox_overwriteShape || selected == 1) {
            // empty if block
        }
    }

    void loadSettingsFrom(CaretOptions options) {
        boolean enableBlink = options.getEnableBlink();
        int blinkRate = options.getBlinkRate();
        int insertShape = options.getInsertShape();
        int overwriteShape = options.getOverwriteShape();
        int caretColor = options.getCaretColor();
        this.checkbox_enableBlink.setSelected(enableBlink);
        this.slider_blinkRate.setValue(blinkRate / 100);
        this.stateChanged(null);
        Object insertItem = this.shapeToTextMap.get(new Integer(insertShape));
        Object overwriteItem = this.shapeToTextMap.get(new Integer(overwriteShape));
        this.combobox_insertShape.setSelectedItem(insertItem);
        this.combobox_overwriteShape.setSelectedItem(overwriteItem);
        this.colorchoice_caretColor.setClosestSelectedColor(new Color(caretColor));
    }

    void saveSettingsTo(CaretOptions options) {
        boolean enableBlink = this.checkbox_enableBlink.isSelected();
        int blinkRate = this.slider_blinkRate.getValue() * 100;
        Object insertItem = this.combobox_insertShape.getSelectedItem();
        Object overwriteItem = this.combobox_overwriteShape.getSelectedItem();
        Color caretColor = this.colorchoice_caretColor.getSelectedColor();
        options.setEnableBlink(enableBlink);
        options.setBlinkRate(blinkRate);
        Integer insertShape = (Integer)this.textToShapeMap.get(insertItem);
        Integer overwriteShape = (Integer)this.textToShapeMap.get(overwriteItem);
        options.setInsertShape(insertShape);
        options.setOverwriteShape(overwriteShape);
        options.setCaretColor(caretColor.getRGB());
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String enableBlinkText = OptionsArb.getString(113);
        this.checkbox_enableBlink = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_enableBlink, (String)enableBlinkText);
        String blinkRateText = OptionsArb.getString(114);
        JLabel label_blinkRate = new JLabel();
        this.slider_blinkRate = new JSlider(1, 20, 10);
        this.slider_blinkRate.addChangeListener(this);
        this.label_blinkRateText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_blinkRate, (Component)this.slider_blinkRate, (String)blinkRateText);
        String minValue = OptionsArb.getString(117);
        String maxValue = OptionsArb.getString(118);
        JLabel label_minValue = new JLabel(minValue);
        JLabel label_maxValue = new JLabel(maxValue);
        this.slider_blinkRate.setPaintLabels(false);
        this.slider_blinkRate.setPaintTicks(true);
        this.slider_blinkRate.setMajorTickSpacing(10);
        this.slider_blinkRate.setMinorTickSpacing(1);
        this.slider_blinkRate.setSnapToTicks(true);
        Component[] dependents = new Component[]{this.slider_blinkRate, label_blinkRate, label_minValue, label_maxValue, this.label_blinkRateText};
        ItemSelectableTracker completionTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_enableBlink, dependents);
        this.checkbox_enableBlink.addItemListener((ItemListener)completionTracker);
        this.slider_blinkRate.setValue(1);
        JLabel verticalBarText = new JLabel(OptionsArb.getString(121), OptionsArb.getIcon(131), 10);
        JLabel verticalBar2Text = new JLabel(OptionsArb.getString(122), OptionsArb.getIcon(132), 10);
        JLabel verticalBar3Text = new JLabel(OptionsArb.getString(123), OptionsArb.getIcon(133), 10);
        JLabel verticalBar4Text = new JLabel(OptionsArb.getString(124), OptionsArb.getIcon(134), 10);
        JLabel underBarText = new JLabel(OptionsArb.getString(125), OptionsArb.getIcon(135), 10);
        JLabel underBar2Text = new JLabel(OptionsArb.getString(126), OptionsArb.getIcon(136), 10);
        JLabel underBar3Text = new JLabel(OptionsArb.getString(127), OptionsArb.getIcon(137), 10);
        JLabel underBar4Text = new JLabel(OptionsArb.getString(128), OptionsArb.getIcon(138), 10);
        JLabel outlineBoxText = new JLabel(OptionsArb.getString(129), OptionsArb.getIcon(140), 10);
        JLabel solidBoxText = new JLabel(OptionsArb.getString(130), OptionsArb.getIcon(139), 10);
        Object[] shapes = new Object[]{verticalBarText, verticalBar2Text, verticalBar3Text, verticalBar4Text, underBarText, underBar2Text, underBar3Text, underBar4Text, outlineBoxText, solidBoxText};
        this.textToShapeMap = new HashMap();
        this.textToShapeMap.put(verticalBarText, new Integer(1));
        this.textToShapeMap.put(verticalBar2Text, new Integer(2));
        this.textToShapeMap.put(verticalBar3Text, new Integer(7));
        this.textToShapeMap.put(verticalBar4Text, new Integer(8));
        this.textToShapeMap.put(underBarText, new Integer(3));
        this.textToShapeMap.put(underBar2Text, new Integer(4));
        this.textToShapeMap.put(underBar3Text, new Integer(9));
        this.textToShapeMap.put(underBar4Text, new Integer(10));
        this.textToShapeMap.put(outlineBoxText, new Integer(5));
        this.textToShapeMap.put(solidBoxText, new Integer(6));
        this.shapeToTextMap = new HashMap();
        this.shapeToTextMap.put(new Integer(1), verticalBarText);
        this.shapeToTextMap.put(new Integer(2), verticalBar2Text);
        this.shapeToTextMap.put(new Integer(7), verticalBar3Text);
        this.shapeToTextMap.put(new Integer(8), verticalBar4Text);
        this.shapeToTextMap.put(new Integer(3), underBarText);
        this.shapeToTextMap.put(new Integer(4), underBar2Text);
        this.shapeToTextMap.put(new Integer(9), underBar3Text);
        this.shapeToTextMap.put(new Integer(10), underBar4Text);
        this.shapeToTextMap.put(new Integer(5), outlineBoxText);
        this.shapeToTextMap.put(new Integer(6), solidBoxText);
        JLabelListCellRenderer renderer = new JLabelListCellRenderer();
        String insertShapeText = OptionsArb.getString(119);
        JLabel label_insertShape = new JLabel();
        NonNullableComboBoxModel insertModel = new NonNullableComboBoxModel(shapes);
        this.combobox_insertShape = new JComboBox(insertModel);
        this.combobox_insertShape.setEditable(false);
        this.combobox_insertShape.setSelectedItem(shapes[0]);
        this.combobox_insertShape.addItemListener(this);
        this.combobox_insertShape.setRenderer(renderer);
        ResourceUtils.resLabel((JLabel)label_insertShape, (Component)this.combobox_insertShape, (String)insertShapeText);
        String overwriteShapeText = OptionsArb.getString(120);
        JLabel label_overwriteShape = new JLabel();
        NonNullableComboBoxModel overwriteModel = new NonNullableComboBoxModel(shapes);
        this.combobox_overwriteShape = new JComboBox(overwriteModel);
        this.combobox_overwriteShape.setEditable(false);
        this.combobox_overwriteShape.setSelectedItem(shapes[0]);
        this.combobox_overwriteShape.addItemListener(this);
        this.combobox_overwriteShape.setRenderer(renderer);
        ResourceUtils.resLabel((JLabel)label_overwriteShape, (Component)this.combobox_overwriteShape, (String)overwriteShapeText);
        String caretColorText = OptionsArb.getString(115);
        JLabel label_caretColor = new JLabel();
        this.colorchoice_caretColor = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_caretColor, (Component)this.colorchoice_caretColor, (String)caretColorText);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets defaultInsets = new Insets(0, 0, 5, 5);
        Insets indentedInsets = new Insets(0, 18, 5, 0);
        Insets indentedHeaderInsets = new Insets(0, 18, 7, 5);
        JPanel blinkPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        blinkPanel.add((Component)this.checkbox_enableBlink, constraints);
        constraints = new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, indentedHeaderInsets, 0, 0);
        blinkPanel.add((Component)label_blinkRate, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, indentedInsets, 0, 0);
        blinkPanel.add((Component)label_minValue, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, emptyInsets, 0, 0);
        blinkPanel.add((Component)this.slider_blinkRate, constraints);
        constraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, defaultInsets, 0, 0);
        blinkPanel.add((Component)label_maxValue, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        blinkPanel.add((Component)this.label_blinkRateText, constraints);
        JPanel shapePanel = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        shapePanel.add((Component)label_insertShape, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 10, 0);
        shapePanel.add((Component)this.combobox_insertShape, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        shapePanel.add((Component)label_overwriteShape, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 10, 0);
        shapePanel.add((Component)this.combobox_overwriteShape, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        shapePanel.add((Component)label_caretColor, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        shapePanel.add((Component)this.colorchoice_caretColor, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(blinkPanel, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(shapePanel, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

