/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Caret;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.Selection;

final class DocumentEdit
extends AbstractUndoableEdit {
    private int mergeCount = 1;
    private List<Selection> startSels = new ArrayList<Selection>();
    private List<Selection> endSels = new ArrayList<Selection>();
    private Point startDotPoint;
    private Point endDotPoint;
    private Point startMarkPoint;
    private Point endMarkPoint;
    private boolean forceMerge = false;
    private UndoableEdit wrappedEdit = null;
    private Reference editorReference = null;
    private EditDescriptor editDescriptor = null;

    DocumentEdit() {
    }

    void recordCaretStart(BasicEditorPane editorPane, EditDescriptor editDescriptor) {
        EditorSelection edSel;
        Caret caret = editorPane.getCaret();
        this.startSels.clear();
        this.startSels.add(new Selection(caret.getDot(), caret.getMark()));
        this.startSels.addAll(editorPane.getMultiSelections());
        if (editorPane.getCaret() instanceof BasicCaret && (edSel = ((BasicCaret)editorPane.getCaret()).getEditorSelection()) instanceof EditorSelectionColumns) {
            EditorSelectionColumns colSel = (EditorSelectionColumns)edSel;
            this.startDotPoint = colSel.getDotPoint();
            this.startMarkPoint = colSel.getMarkPoint();
        }
        this.editorReference = editorPane.getReference();
        this.editDescriptor = editDescriptor;
    }

    void requestForceMerge() {
        this.forceMerge = true;
    }

    void recordEdit(UndoableEdit edit) {
        this.wrappedEdit = edit;
        if (this.wrappedEdit == null) {
            this.die();
        }
    }

    void recordCaretEnd(BasicEditorPane editorPane) {
        EditorSelection edSel;
        Caret caret = editorPane.getCaret();
        this.endSels.clear();
        this.endSels.add(new Selection(caret.getDot(), caret.getMark()));
        this.endSels.addAll(editorPane.getMultiSelections());
        if (editorPane.getCaret() instanceof BasicCaret && (edSel = ((BasicCaret)editorPane.getCaret()).getEditorSelection()) instanceof EditorSelectionColumns) {
            EditorSelectionColumns colSel = (EditorSelectionColumns)edSel;
            this.endDotPoint = colSel.getDotPoint();
            this.endMarkPoint = colSel.getMarkPoint();
        }
    }

    @Override
    public boolean canUndo() {
        boolean canUndo = super.canUndo();
        if (canUndo) {
            canUndo = this.wrappedEdit.canUndo();
        }
        return canUndo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
        EditorSelectionColumns edSelCol = null;
        editorPane.setUndoInProgress(true);
        try {
            super.undo();
            this.mergeCount = -1;
            Rectangle visibleRect = null;
            if (editorPane != null && editorPane.hasSelection()) {
                visibleRect = new Rectangle();
                editorPane.computeVisibleRect(visibleRect);
                editorPane.setCaretPosition(0);
            }
            this.wrappedEdit.undo();
            if (editorPane != null) {
                EditorSelection edSel;
                if (visibleRect != null) {
                    editorPane.scrollRectToVisible(visibleRect);
                }
                editorPane.requestFocus();
                Selection mainSel = this.startSels.get(0);
                if (editorPane.getCaret() instanceof BasicCaret && (edSel = ((BasicCaret)editorPane.getCaret()).getEditorSelection()) instanceof EditorSelectionColumns) {
                    edSelCol = (EditorSelectionColumns)edSel;
                    if (this.startMarkPoint != null) {
                        edSel.setMarkPoint(this.startMarkPoint);
                    }
                    if (this.startDotPoint != null) {
                        edSel.setDotPoint(this.startDotPoint);
                    }
                    edSelCol.update();
                    edSelCol.setAdjusting(true);
                }
                editorPane.setCaretPositionCenter(mainSel.getMark());
                editorPane.moveCaretPositionCenter(mainSel.getDot());
                if (this.startSels.size() > 1) {
                    editorPane.setMultiSelections(this.startSels.subList(1, this.startSels.size()));
                }
            }
        }
        finally {
            if (edSelCol != null) {
                edSelCol.setAdjusting(false);
            }
            editorPane.setUndoInProgress(false);
        }
    }

    @Override
    public boolean canRedo() {
        boolean canRedo = super.canRedo();
        if (canRedo) {
            canRedo = this.wrappedEdit.canRedo();
        }
        return canRedo;
    }

    @Override
    public void redo() throws CannotRedoException {
        BasicEditorPane editorPane = (BasicEditorPane)this.editorReference.get();
        editorPane.setUndoInProgress(true);
        try {
            super.redo();
            this.wrappedEdit.redo();
            if (editorPane != null) {
                EditorSelection edSel;
                editorPane.requestFocus();
                if (editorPane.getCaret() instanceof BasicCaret && (edSel = ((BasicCaret)editorPane.getCaret()).getEditorSelection()) instanceof EditorSelectionColumns) {
                    if (this.endMarkPoint != null) {
                        edSel.setMarkPoint(this.endMarkPoint);
                    }
                    if (this.endDotPoint != null) {
                        edSel.setDotPoint(this.endDotPoint);
                    }
                }
                Selection mainSel = this.endSels.get(0);
                editorPane.setCaretPositionCenter(mainSel.getMark());
                editorPane.moveCaretPositionCenter(mainSel.getDot());
            }
        }
        finally {
            editorPane.setUndoInProgress(false);
        }
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof DocumentEdit) {
            boolean merged;
            DocumentEdit secondEdit = (DocumentEdit)anEdit;
            boolean canMerge = false;
            if (secondEdit.forceMerge) {
                canMerge = true;
            } else if (this.editDescriptor.canMergeWith(secondEdit.editDescriptor)) {
                int maxCount;
                EditorProperties properties = EditorProperties.getProperties();
                Integer value = (Integer)properties.getProperty("edit-merge-count");
                int n = maxCount = value != null ? value : 1;
                if (this.mergeCount < maxCount) {
                    canMerge = true;
                }
            }
            if (canMerge && this.mergeCount != -1 && this.wrappedEdit != null && (merged = this.wrappedEdit.addEdit(secondEdit.wrappedEdit))) {
                this.endSels = secondEdit.endSels;
                secondEdit.wrappedEdit = null;
                secondEdit.die();
                if (!this.forceMerge) {
                    ++this.mergeCount;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.editorReference = null;
        if (this.wrappedEdit != null) {
            this.wrappedEdit.die();
            this.wrappedEdit = null;
        }
    }

    @Override
    public String getPresentationName() {
        return this.editDescriptor.getEditName();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Start: ");
        for (Selection sel : this.startSels) {
            s.append(sel.getDot()).append(", ").append(sel.getMark()).append(" | ");
        }
        s.append("\nWrapped Edit: ");
        s.append(this.wrappedEdit.toString());
        s.append("\nEnd: ");
        for (Selection sel : this.endSels) {
            s.append(sel.getDot()).append(", ").append(sel.getMark()).append(" | ");
        }
        return s.toString();
    }
}

