/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicView;
import oracle.javatools.editor.FoldedCollapsedBlocks;
import oracle.javatools.editor.FoldedRenderFragmentGenerator;
import oracle.javatools.editor.LineRowMap;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.language.StyledFragmentsList;

class FoldedRowMap
extends LineRowMap {
    private static final CollapsedInfo[] UNCOLLAPSED_VIEW_INFO = new CollapsedInfo[0];
    protected FoldedCollapsedBlocks _collapsedBlocks = UNCOLLAPSED_VIEW;
    protected int _collapsedLines = 0;
    protected int _maxFoldedWidth = 0;
    protected CollapsedInfo[] _collapsedInfo = UNCOLLAPSED_VIEW_INFO;
    private static final FoldedCollapsedBlocks UNCOLLAPSED_VIEW = new FoldedCollapsedBlocks(null);

    FoldedRowMap(BasicView basicView) {
        super(basicView);
    }

    @Override
    protected BasicView.RenderFragmentGenerator createRenderFragmentGenerator(StyledFragmentsList styledList, HighlightFragmentsList highlightList) {
        return new FoldedRenderFragmentGenerator(styledList, highlightList, this._collapsedBlocks, this._view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildFoldedMap() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FoldedRowMap.this.rebuildFoldedMap();
                }
            });
            return;
        }
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            FoldedCollapsedBlocks collapsedBlocks = UNCOLLAPSED_VIEW;
            CollapsedInfo[] collapsedInfo = UNCOLLAPSED_VIEW_INFO;
            int collapsedLines = 0;
            if (this._view.getFoldingModel() != null) {
                try {
                    collapsedBlocks = new FoldedCollapsedBlocks(this._view.getFoldingModel());
                    collapsedInfo = this.rebuildCollapsedInfo(collapsedBlocks);
                    collapsedLines = this.getCollapsedLineCount(collapsedInfo);
                }
                catch (RuntimeException e) {
                    System.err.println("Failed to build folding model: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            FoldedRowMap foldedRowMap = this;
            synchronized (foldedRowMap) {
                this._collapsedBlocks = collapsedBlocks;
                this._collapsedInfo = collapsedInfo;
                this._collapsedLines = collapsedLines;
                this._maxFoldedWidth = this.recalculateFoldedWidths();
            }
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    @Override
    protected void revalidateRowMap() {
        super.revalidateRowMap();
    }

    protected int recalculateFoldedWidths() {
        int lastRow = -1;
        int lastWidth = -1;
        int maxWidth = 0;
        for (CollapsedInfo info : this._collapsedInfo) {
            int row = info._row;
            if (row == lastRow) {
                info._width = lastWidth;
                continue;
            }
            int rowEnd = this.getRowEndOffset(row);
            lastWidth = info._width = this._view.getXCoordinateForOffset(row, rowEnd);
            maxWidth = Math.max(maxWidth, lastWidth);
            lastRow = row;
        }
        return maxWidth;
    }

    protected CollapsedInfo[] rebuildCollapsedInfo(FoldedCollapsedBlocks collapsedBlocks) {
        int blockCount = collapsedBlocks._numBlocks;
        ArrayList<CollapsedInfo> infoList = new ArrayList<CollapsedInfo>(blockCount);
        int collapsedLineCount = 0;
        for (int i = 0; i < blockCount; ++i) {
            int blockStart = collapsedBlocks._blockStarts[i];
            int blockEnd = collapsedBlocks._blockEnds[i];
            int blockStartLine = this._view.getLineMap().getLineFromOffset(blockStart);
            int blockEndLine = this._view.getLineMap().getLineFromOffset(blockEnd);
            int span = blockEndLine - blockStartLine + 1;
            CollapsedInfo info = new CollapsedInfo();
            info._line = blockStartLine;
            info._width = -1;
            info._span = span;
            info._row = blockStartLine - collapsedLineCount;
            infoList.add(info);
            collapsedLineCount += span - 1;
        }
        CollapsedInfo[] collapsedInfo = infoList.toArray(new CollapsedInfo[infoList.size()]);
        return collapsedInfo;
    }

    protected int getCollapsedLineCount(CollapsedInfo[] collapsedInfo) {
        int blockCount = collapsedInfo.length;
        if (blockCount == 0) {
            return 0;
        }
        CollapsedInfo lastBlock = collapsedInfo[blockCount - 1];
        int collapsedLineCount = lastBlock._line - lastBlock._row + (lastBlock._span - 1);
        return collapsedLineCount;
    }

    @Override
    protected int getMaxRowWidth() {
        int unfoldedMaxWidth = super.getMaxRowWidth();
        return Math.max(this._maxFoldedWidth, unfoldedMaxWidth);
    }

    protected synchronized int getRowForLine(int line) {
        int numInfo = this._collapsedInfo.length;
        int collapsedLines = 0;
        for (int i = 0; i < numInfo; ++i) {
            CollapsedInfo info = this._collapsedInfo[i];
            if (info._line >= line) break;
            if (line < info._line + info._span) {
                collapsedLines += line - info._line;
                continue;
            }
            collapsedLines += info._span - 1;
        }
        int row = line - collapsedLines;
        return row;
    }

    protected synchronized int getLineForRow(int row) {
        int numInfo = this._collapsedInfo.length;
        int collapsedLines = 0;
        for (int i = 0; i < numInfo; ++i) {
            CollapsedInfo info = this._collapsedInfo[i];
            if (info._row >= row) break;
            collapsedLines += info._span - 1;
        }
        int line = row + collapsedLines;
        return line;
    }

    @Override
    public int getRowCount() {
        int rowCount = super.getRowCount();
        int foldedCount = rowCount - this._collapsedLines;
        return foldedCount;
    }

    @Override
    public int getRowFromOffset(int offset) {
        int line = this._view.getLineMap().getLineFromOffset(offset);
        int row = this.getRowForLine(line);
        return row;
    }

    @Override
    public int getRowStartOffset(int row) {
        int line = this.getRowStartLine(row);
        int offset = this._view.getLineMap().getLineStartOffset(line);
        return offset;
    }

    @Override
    public int getRowEndOffset(int row) {
        int lastRow = this.getRowCount() - 1;
        if (row == lastRow) {
            int lastLine = this._view.getLineMap().getLineCount() - 1;
            return this._view.getLineMap().getLineEndOffset(lastLine);
        }
        int line = this.getRowStartLine(row + 1);
        int offset = this._view.getLineMap().getLineStartOffset(line);
        return offset;
    }

    @Override
    public int getRowStartLine(int row) {
        return this.getLineForRow(row);
    }

    public synchronized boolean isLineCollapsed(int line) {
        for (CollapsedInfo info : this._collapsedInfo) {
            if (line <= info._line) {
                return false;
            }
            if (line >= info._line + info._span) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isRangeCollapsed(int startOffset, int endOffset) {
        int startLine = this._view.getLineMap().getLineFromOffset(startOffset);
        int endLine = this._view.getLineMap().getLineFromOffset(endOffset);
        for (CollapsedInfo info : this._collapsedInfo) {
            if (startLine <= info._line) {
                return false;
            }
            int boundLine = info._line + info._span;
            if (startLine >= boundLine) continue;
            return endLine < boundLine;
        }
        return false;
    }

    static class CollapsedInfo {
        protected int _row;
        protected int _line;
        protected int _span;
        protected int _width;

        CollapsedInfo() {
        }
    }
}

