/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.css.CSSBlockRenderer;
import oracle.javatools.editor.language.css.CSSRuleRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.css.CSSAtRuleLexer;
import oracle.javatools.parser.css.CSSRuleTokens;

public class CSSAtRuleRenderer
extends CSSRuleRenderer
implements CSSRuleTokens {
    private CSSBlockRenderer _mBlockRenderer;

    public CSSAtRuleRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this._mBlockRenderer = new CSSBlockRenderer(textBuffer);
    }

    @Override
    protected Lexer createLexer() {
        return new CSSAtRuleLexer();
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 101: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderCSSBlock(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    @Override
    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 18: {
                return "css-comment-style";
            }
            case 29: 
            case 30: {
                return "css-at-rule-style";
            }
            case 20: {
                return "css-medium-style";
            }
            case 19: {
                return "css-uri-style";
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderCSSBlock(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        this._mBlockRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }
}

