/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import oracle.javatools.editor.language.AbstractLanguageSupport;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.OffsetDescriptionProvider;
import oracle.javatools.editor.language.SmartIndentProvider;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.editor.language.java.JavaDocumentRenderer;
import oracle.javatools.editor.language.java.JavaIndentProvider;
import oracle.javatools.editor.language.java.JavaOffsetDescriptionProvider;

public final class JavaLanguageSupport
extends AbstractLanguageSupport {
    private static boolean _smartIndentEnabled = false;

    @Override
    protected Object getPropertyImpl(String key) {
        if (key.equals("line-comment-start")) {
            return "//";
        }
        return null;
    }

    @Override
    protected DocumentRenderer createDocumentRenderer() {
        return new JavaDocumentRenderer(this);
    }

    @Override
    protected BraceProvider createBraceProvider() {
        return new JavaBraceProvider(this);
    }

    @Override
    protected SmartIndentProvider createSmartIndentProvider() {
        return new JavaIndentProvider(this);
    }

    @Override
    public SmartIndentProvider getSmartIndentProvider() {
        if (_smartIndentEnabled) {
            return super.getSmartIndentProvider();
        }
        return null;
    }

    public static boolean isSmartIndentEnabled() {
        return _smartIndentEnabled;
    }

    public static void setSmartIndentEnabled(boolean smartIndentEnabled) {
        _smartIndentEnabled = smartIndentEnabled;
    }

    @Override
    protected OffsetDescriptionProvider createOffsetDescriptionProvider() {
        return new JavaOffsetDescriptionProvider();
    }
}

