/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.status;

import javax.swing.Icon;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.status.SeverityBundle;

public enum Severity {
    ERROR,
    WARNING,
    INCOMPLETE,
    ADVISORY,
    UNKNOWN,
    OK;


    public boolean isWorseThan(Severity that) {
        return this.compareTo(that) < 0;
    }

    public boolean isBetterThan(Severity that) {
        return this.compareTo(that) > 0;
    }

    public Icon getIcon() {
        switch (this) {
            case UNKNOWN: {
                return OracleIcons.getIcon((String)"unknownstatus.png");
            }
            case ERROR: {
                return OracleIcons.getIcon((String)"error.png");
            }
            case WARNING: {
                return OracleIcons.getIcon((String)"warning.png");
            }
            case INCOMPLETE: {
                return OracleIcons.getIcon((String)"incompletestatus.png");
            }
            case ADVISORY: {
                return OracleIcons.getIcon((String)"info.png");
            }
            case OK: {
                return OracleIcons.getIcon((String)"check.png");
            }
        }
        throw new IllegalStateException("unknown severity");
    }

    public String getLabel() {
        switch (this) {
            case UNKNOWN: {
                return SeverityBundle.get("STATUS_UNKNOWN");
            }
            case ERROR: {
                return SeverityBundle.get("STATUS_ERROR");
            }
            case WARNING: {
                return SeverityBundle.get("STATUS_WARNING");
            }
            case INCOMPLETE: {
                return SeverityBundle.get("STATUS_INCOMPLETE");
            }
            case ADVISORY: {
                return SeverityBundle.get("STATUS_ADVISORY");
            }
            case OK: {
                return SeverityBundle.get("STATUS_OK");
            }
        }
        throw new IllegalStateException("unknown severity");
    }
}

