/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.util.ClassHierarchyVisitor;
import oracle.javatools.util.TypeCollector;

public class ClassHierarchy {
    private static final Map<Class<?>, List<Class<?>>> CLASS_ORDER_BY_TYPE = Collections.synchronizedMap(new HashMap());

    public static List<Class<?>> getClassOrder(Class<?> type) {
        if (null == type) {
            return Collections.emptyList();
        }
        List<Class<?>> classOrder = CLASS_ORDER_BY_TYPE.get(type);
        if (null != classOrder) {
            return classOrder;
        }
        classOrder = ClassHierarchy.computeClassOrder(type);
        CLASS_ORDER_BY_TYPE.put(type, classOrder);
        return classOrder;
    }

    private static List<Class<?>> computeClassOrder(Class<?> type) {
        TypeCollector collector = new TypeCollector();
        new ClassHierarchyVisitor(collector, ClassHierarchyVisitor.VisitOrder.SUPERCLASSES_FIRST_PREORDER).visit(type);
        return collector.getCollectedTypes();
    }
}

