/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.patterns.Operator;

public class ProxyFactory {
    private static final String EXC_LOG_MSG = "Exception when attempting to invoke method '{0}' on {1}";
    private static final Map<Class<?>, Object> DEFAULT_RETURN_VALUES_BY_TYPE = new HashMap();

    public static <P> P newProxy(Class<P> type, P delegate) {
        Object proxy = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new SimpleInvocationHandler<P>(delegate));
        return type.cast(proxy);
    }

    public static <P> P newWeakProxy(Class<P> type, P delegate) {
        return ProxyFactory.newWeakProxy(type, delegate, (Operator)null);
    }

    @Deprecated
    public static <P> P newWeakProxy(Class<P> type, P delegate, Runnable runWhenNull) {
        return ProxyFactory.referenceProxy(type, new WeakReference<P>(delegate), runWhenNull);
    }

    public static <P> P newWeakProxy(Class<P> type, P delegate, Operator runWhenNull) {
        return ProxyFactory.referenceProxy(type, new WeakReference<P>(delegate), runWhenNull);
    }

    public static <P> P newSoftProxy(Class<P> type, P delegate) {
        return ProxyFactory.newSoftProxy(type, delegate, (Operator)null);
    }

    @Deprecated
    public static <P> P newSoftProxy(Class<P> type, P delegate, Runnable runWhenNull) {
        return ProxyFactory.referenceProxy(type, new SoftReference<P>(delegate), runWhenNull);
    }

    public static <P> P newSoftProxy(Class<P> type, P delegate, Operator runWhenNull) {
        return ProxyFactory.referenceProxy(type, new SoftReference<P>(delegate), runWhenNull);
    }

    @Deprecated
    private static <P> P referenceProxy(Class<? extends P> type, Reference<P> ref, final Runnable whenNull) {
        Operator operator = null;
        if (null != whenNull) {
            operator = new Operator<P, Void>(){

                @Override
                public Void operate(Object obj) {
                    whenNull.run();
                    return null;
                }
            };
        }
        return ProxyFactory.referenceProxy(type, ref, operator);
    }

    private static <P> P referenceProxy(Class<? extends P> type, Reference<P> ref, Operator whenNull) {
        Object proxy = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new ReferenceInvocationHandler<P>(ref, whenNull));
        return type.cast(proxy);
    }

    private static Object doInvoke(Object target, Method method, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(EXC_LOG_MSG, method.getName(), target);
            Logger.getAnonymousLogger().log(Level.WARNING, msg, e);
            return null;
        }
    }

    private ProxyFactory() {
    }

    static {
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Character.class, 0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Character.TYPE, 0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Short.class, 0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Short.TYPE, 0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Integer.class, 0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Integer.TYPE, 0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Long.class, 0L);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Long.TYPE, 0L);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Float.class, Float.valueOf(0.0f));
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Double.class, 0.0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Double.TYPE, 0.0);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Boolean.class, false);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(Boolean.TYPE, false);
        DEFAULT_RETURN_VALUES_BY_TYPE.put(String.class, "");
    }

    private static class ReferenceInvocationHandler<R>
    extends SimpleInvocationHandler<Reference<R>> {
        private final Operator runWhenNull;

        public ReferenceInvocationHandler(Reference<R> ref, Operator whenNull) {
            super(ref);
            this.runWhenNull = whenNull;
        }

        @Override
        protected Object invokeImpl(Reference<R> ref, Method method, Object[] args, Object proxy) {
            R delegate = ref.get();
            if (null == delegate) {
                if (null != this.runWhenNull) {
                    this.runWhenNull.operate(proxy);
                }
                Class<?> retType = method.getReturnType();
                Object defRetVal = DEFAULT_RETURN_VALUES_BY_TYPE.get(retType);
                return defRetVal;
            }
            return ProxyFactory.doInvoke(delegate, method, args);
        }

        @Override
        public boolean equals(Object object) {
            if (Proxy.isProxyClass(object.getClass())) {
                object = Proxy.getInvocationHandler(object);
            }
            return super.equals(object);
        }
    }

    private static class SimpleInvocationHandler<P>
    implements InvocationHandler {
        private final P delegate;

        public SimpleInvocationHandler(P delegate) {
            if (null == delegate) {
                throw new IllegalArgumentException("Delegate must not be null");
            }
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if ("equals".equals(method.getName()) || "hashCode".equals(method.getName())) {
                try {
                    return method.invoke((Object)this, args);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, e.getMessage(), e);
                }
            }
            return this.invokeImpl(this.delegate, method, args, proxy);
        }

        protected Object invokeImpl(P delegate, Method method, Object[] args, Object proxy) {
            return ProxyFactory.doInvoke(delegate, method, args);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SimpleInvocationHandler)) {
                return false;
            }
            SimpleInvocationHandler other = (SimpleInvocationHandler)object;
            return this.delegate != null ? this.delegate.equals(other.delegate) : other.delegate == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
            return result;
        }
    }
}

