/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.File;
import java.util.StringTokenizer;
import javax.swing.Action;
import oracle.bali.share.nls.StringUtils;

public final class StringUtil {
    public static final int FILEPATH_MAX_DISPLAY_LENGTH = 80;
    private static final char BEGIN_PARENTHESIS = '(';
    private static final char END_PARENTHESIS = ')';

    private StringUtil() {
    }

    public static String truncateFileNameForMessage(String path) {
        int len = path.length();
        if (len <= 80) {
            return path;
        }
        int sepIdx = path.indexOf(File.separatorChar);
        if (sepIdx != -1) {
            String thisToken;
            int thisTokenLength;
            String[] pathBits = StringUtil.getTokenArray(path, File.separator);
            int nameWidth = pathBits[pathBits.length - 1].length() + 1;
            int remainingSpace = 80 - (nameWidth + 3);
            if (remainingSpace <= 0) {
                return pathBits[pathBits.length - 1].substring(0, 77) + "...";
            }
            StringBuffer fullString = new StringBuffer(80);
            int widthSoFar = 0;
            for (int i = 0; i < pathBits.length - 1 && widthSoFar + (thisTokenLength = (thisToken = pathBits[i] + File.separator).length()) < remainingSpace; ++i) {
                fullString.append(thisToken);
                widthSoFar += thisTokenLength;
            }
            fullString.append("...");
            fullString.append(File.separatorChar);
            fullString.append(pathBits[pathBits.length - 1]);
            return fullString.toString();
        }
        return path.substring(0, 80) + "...";
    }

    public static String[] getTokenArray(String string, String delimiters) {
        StringTokenizer tok = new StringTokenizer(string, delimiters);
        String[] tokens = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            tokens[i++] = tok.nextToken();
        }
        return tokens;
    }

    public static String assembleTokens(String[] tokens, String delimiters) {
        if (tokens == null || tokens.length == 0) {
            throw new IllegalArgumentException("No tokens");
        }
        if (delimiters == null || delimiters.length() == 0) {
            throw new IllegalArgumentException("No delimiters");
        }
        StringBuffer buffer = new StringBuffer();
        for (String token : tokens) {
            buffer.append(token).append(delimiters);
        }
        buffer.setLength(buffer.length() - delimiters.length());
        return buffer.toString();
    }

    public static String stripMnemonic(String string) {
        int amperPosition = StringUtils.getMnemonicIndex((String)string);
        if (amperPosition == -1) {
            return string;
        }
        if (amperPosition > 0 && string.charAt(amperPosition - 1) == '(' && amperPosition < string.length() - 2 && string.charAt(amperPosition + 2) == ')') {
            StringBuffer buf = new StringBuffer(string);
            buf.delete(amperPosition - 1, amperPosition + 3);
            return buf.toString();
        }
        return StringUtils.stripMnemonic((String)string);
    }

    public static String textWithoutMnemonic(Action action) {
        String text = (String)action.getValue("Name");
        Object v = action.getValue("MnemonicKey");
        Character mnemonic = StringUtil.mnemonicFrom(v);
        if (mnemonic == null) {
            return text;
        }
        return StringUtil.removeMnemonic(text, mnemonic.charValue());
    }

    private static Character mnemonicFrom(Object v) {
        if (v instanceof Integer) {
            return Character.valueOf((char)((Integer)v).intValue());
        }
        if (v instanceof Character) {
            return (Character)v;
        }
        return null;
    }

    public static String removeMnemonic(String text, char mnemonic) {
        if (text == null) {
            return text;
        }
        if (mnemonic <= '\u0000') {
            return text;
        }
        String mnemonicText = "(" + mnemonic + ")";
        int mnemonicIndex = text.indexOf(mnemonicText);
        if (mnemonicIndex == -1) {
            return text;
        }
        StringBuilder textBuilder = new StringBuilder(text);
        textBuilder.delete(mnemonicIndex, mnemonicIndex + mnemonicText.length());
        return textBuilder.toString();
    }

    public static String addMnemonicToLabelIfNotPresentAlready(String label, Integer mnemonic) {
        String s = label;
        if (s != null && mnemonic != null && mnemonic > 0) {
            String m = new String(new char[]{(char)mnemonic.intValue()});
            String lm = m.toLowerCase();
            String um = m.toUpperCase();
            if (!s.contains(lm) && !s.contains(um)) {
                String mLabel = "(" + um + ")";
                int idx = s.indexOf("...");
                if (idx != -1) {
                    mLabel = mLabel + "...";
                    s = s.substring(0, idx) + mLabel;
                } else {
                    s = s + mLabel;
                }
            }
        }
        return s;
    }
}

