/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.usages.UsagesPrefs;
import oracle.ideimpl.usages.res.Bundle;
import oracle.javatools.ui.RichHintLabel;

public final class UsagesPrefsPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC_ID = "f1_preferences_usagetracking_html";
    private final JCheckBox _trackUsages = new JCheckBox();
    private final RichHintLabel _label = new RichHintLabel();
    private boolean _isPrefs = true;

    public UsagesPrefsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UsagesPrefsPanel(boolean isPrefsDialog) {
        this();
        this._isPrefs = isPrefsDialog;
    }

    public void onEntry(TraversableContext dataContext) {
        UsagesPrefs prefs = UsagesPrefsPanel.getPrefs(dataContext);
        this._trackUsages.setSelected(prefs.isTrackUsages());
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        UsagesPrefs prefs = UsagesPrefsPanel.getPrefs(dataContext);
        prefs.setTrackUsages(this._trackUsages.isSelected());
    }

    public String getHelpID() {
        return HELP_TOPIC_ID;
    }

    public Component getDefaultFocusComponent() {
        return this._trackUsages;
    }

    private static UsagesPrefs getPrefs(TraversableContext tc) {
        return UsagesPrefs.getInstance(tc.getPropertyStorage());
    }

    private void jbInit() throws Exception {
        ResourceBundle res = Bundle.getBundle();
        ResourceUtils.resButton((AbstractButton)this._trackUsages, (String)res.getString("USAGES_PREFS_OPT_IN_LABEL"));
        this.configureLinkLabel(res);
        this.setLayout(new GridBagLayout());
        int y = -1;
        this.add((Component)this._label, this.gbc(0, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0)));
        this.add(this._trackUsages, this.gbc(0, -1, 1, 1, 0.0, 1.0, 18, 2, new Insets(12, 0, 0, 0)));
        this._trackUsages.setName("AllowUsageReporting");
    }

    private void configureLinkLabel(ResourceBundle res) {
        String actionId = "usages-reporting-link-action";
        StringBuilder builder = new StringBuilder();
        builder.append(res.getString("USAGES_PREFS_HTML_LABEL_PREFIX"));
        builder.append("<a href=\"http:");
        builder.append("usages-reporting-link-action");
        builder.append("\">");
        builder.append(res.getString("USAGES_PREFS_HTML_LABEL_LINK_TEXT"));
        builder.append("</a>");
        builder.append(res.getString("USAGES_PREFS_HTML_LABEL_SUFFIX"));
        if (!this._isPrefs) {
            builder.append(res.getString("USAGES_NOT_PREFS_HTML_LABEL_SUFFIX"));
        }
        this._label.setHtmlText(builder.toString());
        this._label.registerAction("usages-reporting-link-action", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = URLFactory.newURL((String)"http://www.oracle.com/html/privacy-policy.html");
                    if (url != null) {
                        BrowserRunner browserRunner = BrowserRunner.getBrowserRunner();
                        browserRunner.runBrowserOnURL(url, null, null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }
}

