/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.dialogs;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.ButtonActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.OptionalActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.security.SecurityArb;
import oracle.dbtools.security.redaction.dialogs.CoreRedactPolicyAction;
import oracle.dbtools.security.redaction.dialogs.RedactConstants;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ArrayMap;

public abstract class BaseRedactPolicyAction
extends CoreRedactPolicyAction {
    private boolean redactionEnabled = false;
    private String redactionExpression = null;
    private String functionParameters = null;
    private String functionParametersFunctionTypeNone = null;
    private String functionParametersFunctionTypePartial = null;
    private String functionParametersFunctionTypeFull = null;
    private String functionParametersFunctionTypeRandom = null;
    private String regExpPattern = null;
    private String regExpReplaceString = null;
    private Integer regExpPosition = new Integer(1);
    private Integer regExpOccurrence = new Integer(0);
    private String regExpMatchParameter = null;
    protected EditorActionControl expressionEditorCtl = null;
    protected SideBySideActionControl expressionEditorIconCtl = null;
    protected ButtonActionControl expressionIconCtl = null;
    protected ComboBoxActionControl functionTypeCtl = null;
    private String functionType = null;
    protected OptionalActionControl optionalRegexpPatternCtl = null;
    protected TextBoxActionControl regExpPatternCtl = null;
    protected OptionalActionControl optionalRegexpReplaceStringCtl = null;
    protected TextBoxActionControl regExpReplaceStringCtl = null;
    protected SpinnerActionControl regExpPositionCtl = null;
    protected SpinnerActionControl regExpOccurrenceCtl = null;
    protected OptionalActionControl optionalRegexpMatchParameterCtl = null;
    protected TextBoxActionControl regExpMatchParameterCtl = null;
    protected TextBoxActionControl functionParametersFunctionTypeNoneCtl = null;
    protected TextBoxActionControl functionParametersFunctionTypeFullCtl = null;
    protected TextBoxActionControl functionParametersFunctionTypePartialCtl = null;
    protected TextBoxActionControl functionParametersFunctionTypeRandomCtl = null;
    protected CardLayoutActionControl whatFunctionTypeCtl = null;

    protected void initializeControls() {
        String string = this.getArgs();
        if (string.equals("ALTER,TABLE") || string.equals("ALTER,VIEW") || string.equals("ALTER,MATERIALIZED_VIEW") || string.equals("ALTER,COLUMN")) {
            this.redactionExpression = this.redactModel.getExpression();
            this.functionType = this.convertFunctionTypeFromDBMSToSimple(this.redactModel.getFunctionType());
            if (this.functionType.equals(RedactConstants.REDACTION_FUNCTION_TYPE_NONE)) {
                this.functionParametersFunctionTypeNone = this.redactModel.getFunctionParameters();
            }
            if (this.functionType.equals(RedactConstants.REDACTION_FUNCTION_TYPE_FULL)) {
                this.functionParametersFunctionTypeFull = this.redactModel.getFunctionParameters();
            }
            if (this.functionType.equals(RedactConstants.REDACTION_FUNCTION_TYPE_PARTIAL)) {
                this.functionParametersFunctionTypePartial = this.redactModel.getFunctionParameters();
            }
            if (this.functionType.equals(RedactConstants.REDACTION_FUNCTION_TYPE_RANDOM)) {
                this.functionParametersFunctionTypeRandom = this.redactModel.getFunctionParameters();
            }
            if (this.functionType.equals(RedactConstants.REDACTION_FUNCTION_TYPE_REGEXP)) {
                // empty if block
            }
            this.regExpPattern = this.redactModel.getRegexpPattern();
            this.regExpReplaceString = this.redactModel.getRegexpReplaceString();
            this.regExpPosition = new Integer(this.redactModel.getRegexpPosition());
            if (this.regExpPosition < 1) {
                this.regExpPosition = 1;
            }
            this.regExpOccurrence = new Integer(this.redactModel.getRegexpOccurrence());
            this.regExpMatchParameter = this.redactModel.getRegexpMatchParameter();
        } else {
            this.redactionExpression = "1=1";
            this.redactController.setExpression(this.redactionExpression);
            this.functionType = RedactConstants.REDACTION_FUNCTION_TYPES[0];
        }
        this.expressionEditorCtl = new EditorActionControl("redaction_expression", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_LABEL"), this.redactionExpression, "x.pls");
        this.expressionEditorCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.expressionEditorCtl.setEditable(false);
        this.expressionEditorCtl.setSpringVertical(true);
        this.expressionEditorCtl.setFillVertical(true);
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("REDACTION_EXPRESSION_ICON_PANEL", null);
        this.expressionIconCtl = new ButtonActionControl("redaction_expression_icon", "", "", OracleIcons.getIcon((String)"edit.png"), true);
        this.expressionIconCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(BaseRedactPolicyAction.this.expressionIconCtl);
            }
        });
        this.expressionEditorIconCtl = new SideBySideActionControl("redaction_expression_icon_sidebyside", SecurityArb.getString("SECURITY_REDACTION_POLICY_EXPRESSION_LABEL"), (ActionControl)this.expressionEditorCtl, (ActionControl)propertyPanelActionControl, 1);
        this.expressionEditorIconCtl.setSpringVertical(true);
        this.expressionEditorIconCtl.setFillVertical(true);
        this.functionTypeCtl = new ComboBoxActionControl("redaction_function_type", SecurityArb.getString("SECURITY_REDACTION_POLICY_FUNCTION_TYPE_LABEL"), RedactConstants.REDACTION_FUNCTION_TYPES, this.functionType, false);
        this.functionTypeCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        final PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl("redaction_function_type_none_panel", null);
        final PropertyPanelActionControl propertyPanelActionControl3 = new PropertyPanelActionControl("redaction_function_type_partial_panel", null);
        this.functionParametersFunctionTypePartialCtl = new TextBoxActionControl("redaction_function_parameters_partial", SecurityArb.getString("SECURITY_REDACTION_POLICY_FUNCTION_PARAMETERS"), this.functionParametersFunctionTypePartial, null, true);
        propertyPanelActionControl3.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(BaseRedactPolicyAction.this.functionParametersFunctionTypePartialCtl);
            }
        });
        this.functionParametersFunctionTypePartialCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        final PropertyPanelActionControl propertyPanelActionControl4 = new PropertyPanelActionControl("redaction_function_type_full_panel", null);
        final PropertyPanelActionControl propertyPanelActionControl5 = new PropertyPanelActionControl("redaction_function_type_random_panel", null);
        final PropertyPanelActionControl propertyPanelActionControl6 = new PropertyPanelActionControl("redaction_function_type_regexp_panel", null);
        this.regExpPatternCtl = new TextBoxActionControl("redaction_regexp_pattern", SecurityArb.getString("SECURITY_REDACTION_POLICY_REGEXP_PATTERN_LABEL"), this.regExpPattern, null, true);
        this.regExpPatternCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.optionalRegexpPatternCtl = new OptionalActionControl(false, (ActionControl)this.regExpPatternCtl);
        this.regExpReplaceStringCtl = new TextBoxActionControl("redaction_regexp_replace_string", SecurityArb.getString("SECURITY_REDACTION_POLICY_REGEXP_REPLACE_STRING_LABEL"), this.regExpReplaceString, null, true);
        this.regExpReplaceStringCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.optionalRegexpReplaceStringCtl = new OptionalActionControl(false, (ActionControl)this.regExpReplaceStringCtl);
        this.regExpPositionCtl = new SpinnerActionControl("redaction_regexp_position", SecurityArb.getString("SECURITY_REDACTION_POLICY_REGEXP_POSITION_LABEL"), this.regExpPosition, Integer.valueOf(1), Integer.valueOf(100), Integer.valueOf(1), true);
        this.regExpPositionCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.regExpOccurrenceCtl = new SpinnerActionControl("redaction_regexp_occurrence", SecurityArb.getString("SECURITY_REDACTION_POLICY_REGEXP_OCCURENCE_LABEL"), this.regExpOccurrence, Integer.valueOf(0), Integer.valueOf(100), Integer.valueOf(1), true);
        this.regExpOccurrenceCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.regExpMatchParameterCtl = new TextBoxActionControl("redaction_regexp_match_parameter", SecurityArb.getString("SECURITY_REDACTION_POLICY_REGEXP_MATCH_PARAMETER_LABEL"), this.regExpMatchParameter, null, true);
        this.regExpMatchParameterCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.optionalRegexpMatchParameterCtl = new OptionalActionControl(false, (ActionControl)this.regExpMatchParameterCtl);
        propertyPanelActionControl6.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(BaseRedactPolicyAction.this.optionalRegexpPatternCtl);
                this.add(BaseRedactPolicyAction.this.optionalRegexpReplaceStringCtl);
                this.add(BaseRedactPolicyAction.this.regExpPositionCtl);
                this.add(BaseRedactPolicyAction.this.regExpOccurrenceCtl);
                this.add(BaseRedactPolicyAction.this.optionalRegexpMatchParameterCtl);
            }
        });
        ArrayMap<String, ActionControl> arrayMap = new ArrayMap<String, ActionControl>(){
            {
                this.put(RedactConstants.REDACTION_FUNCTION_TYPE_NONE, propertyPanelActionControl2);
                this.put(RedactConstants.REDACTION_FUNCTION_TYPE_FULL, propertyPanelActionControl4);
                this.put(RedactConstants.REDACTION_FUNCTION_TYPE_PARTIAL, propertyPanelActionControl3);
                this.put(RedactConstants.REDACTION_FUNCTION_TYPE_RANDOM, propertyPanelActionControl5);
                this.put(RedactConstants.REDACTION_FUNCTION_TYPE_REGEXP, propertyPanelActionControl6);
            }
        };
        this.whatFunctionTypeCtl = new CardLayoutActionControl("redaction_function_type_card_panel", null, CardLayoutPanel.Type.TITLE_BORDER, SecurityArb.getString("SECURITY_REDACTION_POLICY_FUNCTION_TYPE_PANEL_TITLE"), (Map)arrayMap, true);
        this.whatFunctionTypeCtl.setSelected((Object)this.functionType);
        this.whatFunctionTypeCtl.setSpringVertical(true);
        this.whatFunctionTypeCtl.setFillVertical(true);
        this.whatFunctionTypeCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
    }

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        super.createControls(connection);
        this.initializeControls();
        Vector<ActionControl> vector = new Vector<ActionControl>();
        return vector;
    }

    @Override
    public abstract String getArgs();

    @Override
    public abstract String getOperationalContext();

    private String convertFunctionTypeFromDBMSToSimple(String string) {
        if (string.equals("DBMS_REDACT.NONE")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_NONE;
        }
        if (string.equals("DBMS_REDACT.PARTIAL")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_PARTIAL;
        }
        if (string.equals("DBMS_REDACT.FULL")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_FULL;
        }
        if (string.equals("DBMS_REDACT.RANDOM")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_RANDOM;
        }
        if (string.equals("DBMS_REDACT.REGEXP")) {
            return RedactConstants.REDACTION_FUNCTION_TYPE_REGEXP;
        }
        return null;
    }

    @Override
    public boolean isEnabled(Context context) {
        return super.isEnabled(context);
    }

    public EditorActionControl getExpressionEditorCtl() {
        return this.expressionEditorCtl;
    }
}

